/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;

public class JetAnnotatedExpression
extends JetExpression {
    public JetAnnotatedExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitAnnotatedExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitAnnotatedExpression(this, data);
    }

    @Nullable
    public JetExpression getBaseExpression() {
        return (JetExpression)((Object)this.findChildByClass(JetExpression.class));
    }

    public List<JetAnnotation> getAttributeAnnotations() {
        return this.findChildrenByType(JetNodeTypes.ANNOTATION);
    }

    public List<JetAnnotationEntry> getAttributes() {
        List<JetAnnotationEntry> answer = null;
        for (JetAnnotation annotation : this.getAttributeAnnotations()) {
            if (answer == null) {
                answer = new ArrayList<JetAnnotationEntry>();
            }
            answer.addAll(annotation.getEntries());
        }
        return answer != null ? answer : Collections.emptyList();
    }
}

