/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jet.JetNodeType;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.parsing.AbstractJetParsing;
import org.jetbrains.jet.lang.parsing.AbstractTokenStreamPredicate;
import org.jetbrains.jet.lang.parsing.Consumer;
import org.jetbrains.jet.lang.parsing.JetExpressionParsing;
import org.jetbrains.jet.lang.parsing.LastBefore;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilderForByClause;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetParsing
extends AbstractJetParsing {
    public static final Map<String, IElementType> MODIFIER_KEYWORD_MAP = new HashMap<String, IElementType>();
    private static final TokenSet TOPLEVEL_OBJECT_FIRST;
    private static final TokenSet ENUM_MEMBER_FIRST;
    private static final TokenSet CLASS_NAME_RECOVERY_SET;
    private static final TokenSet TYPE_PARAMETER_GT_RECOVERY_SET;
    private static final TokenSet PARAMETER_NAME_RECOVERY_SET;
    private static final TokenSet NAMESPACE_NAME_RECOVERY_SET;
    static final TokenSet TYPE_REF_FIRST;
    private static final TokenSet RECEIVER_TYPE_TERMINATORS;
    private JetExpressionParsing myExpressionParsing;

    public static JetParsing createForTopLevel(SemanticWhitespaceAwarePsiBuilder builder) {
        JetParsing jetParsing = new JetParsing(builder);
        jetParsing.myExpressionParsing = new JetExpressionParsing(builder, jetParsing);
        return jetParsing;
    }

    public static JetParsing createForByClause(SemanticWhitespaceAwarePsiBuilder builder) {
        final SemanticWhitespaceAwarePsiBuilderForByClause builderForByClause = new SemanticWhitespaceAwarePsiBuilderForByClause(builder);
        JetParsing jetParsing = new JetParsing(builderForByClause);
        jetParsing.myExpressionParsing = new JetExpressionParsing(builderForByClause, jetParsing){

            @Override
            protected boolean parseCallWithClosure() {
                if (builderForByClause.getStackSize() > 0) {
                    return super.parseCallWithClosure();
                }
                return false;
            }

            @Override
            protected JetParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
                return JetParsing.createForByClause(builder);
            }
        };
        return jetParsing;
    }

    private JetParsing(SemanticWhitespaceAwarePsiBuilder builder) {
        super(builder);
    }

    public void parseFile() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        this.parseToplevelDeclarations(false);
        fileMarker.done((IElementType)JetNodeTypes.JET_FILE);
    }

    private void parseToplevelDeclarations(boolean insideBlock) {
        while (!(this.eof() || insideBlock && this.at(JetTokens.RBRACE))) {
            if (this.at(JetTokens.IMPORT_KEYWORD)) {
                this.parseImportDirective();
                continue;
            }
            this.parseTopLevelObject();
        }
    }

    private void parsePreamble() {
        PsiBuilder.Marker namespaceHeader = this.mark();
        PsiBuilder.Marker firstEntry = this.mark();
        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, true);
        if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.parseNamespaceName();
            if (this.at(JetTokens.LBRACE)) {
                firstEntry.rollbackTo();
                namespaceHeader.done((IElementType)JetNodeTypes.NAMESPACE_HEADER);
                return;
            }
            firstEntry.drop();
            this.consumeIf(JetTokens.SEMICOLON);
        } else {
            firstEntry.rollbackTo();
        }
        namespaceHeader.done((IElementType)JetNodeTypes.NAMESPACE_HEADER);
        while (this.at(JetTokens.IMPORT_KEYWORD)) {
            this.parseImportDirective();
        }
    }

    private void parseNamespaceName() {
        block2: {
            PsiBuilder.Marker nsName = this.mark();
            while (true) {
                if (this.myBuilder.newlineBeforeCurrentToken()) {
                    this.errorWithRecovery("Package name must be a '.'-separated identifier list placed on a single line", NAMESPACE_NAME_RECOVERY_SET);
                    nsName.drop();
                    break block2;
                }
                this.expect(JetTokens.IDENTIFIER, "Package name must be a '.'-separated identifier list", NAMESPACE_NAME_RECOVERY_SET);
                if (!this.at(JetTokens.DOT)) break;
                nsName.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
                this.advance();
                nsName = this.mark();
            }
            nsName.drop();
        }
    }

    private void parseImportDirective() {
        assert (this._at(JetTokens.IMPORT_KEYWORD));
        PsiBuilder.Marker importDirective = this.mark();
        this.advance();
        PsiBuilder.Marker qualifiedName = this.mark();
        if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.expect(JetTokens.DOT, "Expecting '.'", TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER, JetTokens.MUL, JetTokens.SEMICOLON}));
        }
        PsiBuilder.Marker reference = this.mark();
        this.expect(JetTokens.IDENTIFIER, "Expecting qualified name");
        reference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
        while (this.at(JetTokens.DOT) && this.lookahead(1) != JetTokens.MUL) {
            this.advance();
            reference = this.mark();
            if (this.expect(JetTokens.IDENTIFIER, "Qualified name must be a '.'-separated identifier list", TokenSet.create((IElementType[])new IElementType[]{JetTokens.AS_KEYWORD, JetTokens.DOT, JetTokens.SEMICOLON}))) {
                reference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
            } else {
                reference.drop();
            }
            PsiBuilder.Marker precede = qualifiedName.precede();
            qualifiedName.done((IElementType)JetNodeTypes.DOT_QUALIFIED_EXPRESSION);
            qualifiedName = precede;
        }
        qualifiedName.drop();
        if (this.at(JetTokens.DOT)) {
            this.advance();
            assert (this._at(JetTokens.MUL));
            this.advance();
            this.handleUselessRename();
        }
        if (this.at(JetTokens.AS_KEYWORD)) {
            this.advance();
            this.expect(JetTokens.IDENTIFIER, "Expecting identifier", TokenSet.create((IElementType[])new IElementType[]{JetTokens.SEMICOLON}));
        }
        this.consumeIf(JetTokens.SEMICOLON);
        importDirective.done((IElementType)JetNodeTypes.IMPORT_DIRECTIVE);
    }

    private void handleUselessRename() {
        if (this.at(JetTokens.AS_KEYWORD)) {
            PsiBuilder.Marker as = this.mark();
            this.advance();
            this.consumeIf(JetTokens.IDENTIFIER);
            as.error("Cannot rename a all imported items to one identifier");
        }
    }

    private void parseTopLevelObject() {
        PsiBuilder.Marker decl = this.mark();
        TokenDetector detector = new TokenDetector(JetTokens.ENUM_KEYWORD);
        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, detector, true);
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == JetTokens.CLASS_KEYWORD || keywordToken == JetTokens.TRAIT_KEYWORD) {
            declType = this.parseClass(detector.isDetected());
        } else if (keywordToken == JetTokens.FUN_KEYWORD) {
            declType = this.parseFunction();
        } else if (keywordToken == JetTokens.VAL_KEYWORD || keywordToken == JetTokens.VAR_KEYWORD) {
            declType = this.parseProperty();
        } else if (keywordToken == JetTokens.TYPE_KEYWORD) {
            declType = this.parseTypeDef();
        } else if (keywordToken == JetTokens.OBJECT_KEYWORD) {
            this.parseObject(true, true);
            declType = JetNodeTypes.OBJECT_DECLARATION;
        }
        if (declType == null) {
            this.errorAndAdvance("Expecting namespace or top level declaration");
            decl.drop();
        } else {
            decl.done(declType);
        }
    }

    public boolean parseModifierList(JetNodeType nodeType, boolean allowShortAnnotations) {
        return this.parseModifierList(nodeType, null, allowShortAnnotations);
    }

    public boolean parseModifierList(JetNodeType nodeType, Consumer<IElementType> tokenConsumer, boolean allowShortAnnotations) {
        PsiBuilder.Marker list = this.mark();
        boolean empty = true;
        while (!this.eof()) {
            if (this.atSet(JetTokens.MODIFIER_KEYWORDS)) {
                if (tokenConsumer != null) {
                    tokenConsumer.consume(this.tt());
                }
                this.advance();
            } else {
                if (!this.at(JetTokens.LBRACKET) && (!allowShortAnnotations || !this.at(JetTokens.IDENTIFIER))) break;
                this.parseAnnotation(allowShortAnnotations);
            }
            empty = false;
        }
        if (empty) {
            list.drop();
        } else {
            list.done((IElementType)nodeType);
        }
        return !empty;
    }

    public void parseAnnotations(boolean allowShortAnnotations) {
        while (this.parseAnnotation(allowShortAnnotations)) {
        }
    }

    private boolean parseAnnotation(boolean allowShortAnnotations) {
        if (this.at(JetTokens.LBRACKET)) {
            PsiBuilder.Marker annotation = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            if (!this.at(JetTokens.IDENTIFIER)) {
                this.error("Expecting a list of attributes");
            } else {
                this.parseAnnotationEntry();
                while (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("No commas needed to separate attributes");
                }
                while (this.at(JetTokens.IDENTIFIER)) {
                    this.parseAnnotationEntry();
                    while (this.at(JetTokens.COMMA)) {
                        this.errorAndAdvance("No commas needed to separate attributes");
                    }
                }
            }
            this.expect(JetTokens.RBRACKET, "Expecting ']' to close an attribute annotation");
            this.myBuilder.restoreNewlinesState();
            annotation.done((IElementType)JetNodeTypes.ANNOTATION);
            return true;
        }
        if (allowShortAnnotations && this.at(JetTokens.IDENTIFIER)) {
            this.parseAnnotationEntry();
            return true;
        }
        return false;
    }

    private void parseAnnotationEntry() {
        assert (this._at(JetTokens.IDENTIFIER));
        PsiBuilder.Marker attribute = this.mark();
        PsiBuilder.Marker reference = this.mark();
        PsiBuilder.Marker typeReference = this.mark();
        this.parseUserType();
        typeReference.done((IElementType)JetNodeTypes.TYPE_REFERENCE);
        reference.done((IElementType)JetNodeTypes.CONSTRUCTOR_CALLEE);
        this.parseTypeArgumentList(-1);
        if (this.at(JetTokens.LPAR)) {
            this.myExpressionParsing.parseValueArgumentList();
        }
        attribute.done((IElementType)JetNodeTypes.ANNOTATION_ENTRY);
    }

    public IElementType parseClass(boolean enumClass) {
        assert (this._atSet(JetTokens.CLASS_KEYWORD, JetTokens.TRAIT_KEYWORD));
        this.advance();
        if (!this.parseIdeTemplate()) {
            this.expect(JetTokens.IDENTIFIER, "Class name expected", CLASS_NAME_RECOVERY_SET);
        }
        boolean typeParametersDeclared = this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET);
        PsiBuilder.Marker beforeConstructorModifiers = this.mark();
        boolean hasConstructorModifiers = this.parseModifierList(JetNodeTypes.PRIMARY_CONSTRUCTOR_MODIFIER_LIST, false);
        if (hasConstructorModifiers && !this.atSet(JetTokens.LPAR, JetTokens.LBRACE, JetTokens.COLON)) {
            beforeConstructorModifiers.rollbackTo();
            return JetNodeTypes.CLASS;
        }
        beforeConstructorModifiers.drop();
        if (this.at(JetTokens.LPAR)) {
            this.parseValueParameterList(false, TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON, JetTokens.LBRACE}));
        } else if (hasConstructorModifiers) {
            this.error("Expecting primary constructor parameter list");
        }
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseDelegationSpecifierList();
        }
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        if (this.at(JetTokens.LBRACE)) {
            if (enumClass) {
                this.parseEnumClassBody();
            } else {
                this.parseClassBody();
            }
        }
        return JetNodeTypes.CLASS;
    }

    private void parseEnumClassBody() {
        if (!this.at(JetTokens.LBRACE)) {
            return;
        }
        PsiBuilder.Marker classBody = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        if (!this.parseIdeTemplate()) {
            while (!this.eof() && !this.at(JetTokens.RBRACE)) {
                JetNodeType type;
                PsiBuilder.Marker entryOrMember = this.mark();
                TokenSet constructorNameFollow = TokenSet.create((IElementType[])new IElementType[]{JetTokens.SEMICOLON, JetTokens.COLON, JetTokens.LPAR, JetTokens.LT, JetTokens.LBRACE});
                int lastId = this.findLastBefore(ENUM_MEMBER_FIRST, constructorNameFollow, false);
                TokenDetector enumDetector = new TokenDetector(JetTokens.ENUM_KEYWORD);
                this.createTruncatedBuilder(lastId).parseModifierList(JetNodeTypes.MODIFIER_LIST, enumDetector, false);
                if (this.at(JetTokens.IDENTIFIER)) {
                    this.parseEnumEntry();
                    type = JetNodeTypes.ENUM_ENTRY;
                } else {
                    type = this.parseMemberDeclarationRest(enumDetector.isDetected());
                }
                if (type == null) {
                    this.errorAndAdvance("Expecting an enum entry or member declaration");
                    entryOrMember.drop();
                    continue;
                }
                entryOrMember.done((IElementType)type);
            }
        }
        this.expect(JetTokens.RBRACE, "Expecting '}' to close enum class body");
        this.myBuilder.restoreNewlinesState();
        classBody.done((IElementType)JetNodeTypes.CLASS_BODY);
    }

    private void parseEnumEntry() {
        assert (this._at(JetTokens.IDENTIFIER));
        PsiBuilder.Marker nameAsDeclaration = this.mark();
        this.advance();
        nameAsDeclaration.done((IElementType)JetNodeTypes.OBJECT_DECLARATION_NAME);
        boolean typeParametersDeclared = this.parseTypeParameterList(TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON, JetTokens.LPAR, JetTokens.SEMICOLON, JetTokens.LBRACE}));
        if (this.at(JetTokens.LPAR)) {
            this.parseValueParameterList(false, TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON, JetTokens.SEMICOLON, JetTokens.LBRACE}));
        }
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseInitializerList();
        }
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        if (this.at(JetTokens.LBRACE)) {
            this.parseClassBody();
        }
        this.consumeIf(JetTokens.SEMICOLON);
    }

    void parseClassBody() {
        PsiBuilder.Marker body = this.mark();
        this.myBuilder.enableNewlines();
        this.expect(JetTokens.LBRACE, "Expecting a class body", TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACE}));
        if (!this.parseIdeTemplate()) {
            while (!this.eof() && !this.at(JetTokens.RBRACE)) {
                this.parseMemberDeclaration();
            }
        }
        this.expect(JetTokens.RBRACE, "Missing '}");
        this.myBuilder.restoreNewlinesState();
        body.done((IElementType)JetNodeTypes.CLASS_BODY);
    }

    private void parseMemberDeclaration() {
        PsiBuilder.Marker decl = this.mark();
        TokenDetector enumDetector = new TokenDetector(JetTokens.ENUM_KEYWORD);
        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, enumDetector, true);
        IElementType declType = this.parseMemberDeclarationRest(enumDetector.isDetected());
        if (declType == null) {
            this.errorWithRecovery("Expecting member declaration", TokenSet.create((IElementType[])new IElementType[]{JetTokens.RBRACE}));
            decl.drop();
        } else {
            decl.done(declType);
        }
    }

    private IElementType parseMemberDeclarationRest(boolean isEnum) {
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == JetTokens.CLASS_KEYWORD) {
            declType = this.lookahead(1) == JetTokens.OBJECT_KEYWORD ? this.parseClassObject() : this.parseClass(isEnum);
        } else if (keywordToken == JetTokens.TRAIT_KEYWORD) {
            declType = this.parseClass(isEnum);
        } else if (keywordToken == JetTokens.FUN_KEYWORD) {
            declType = this.parseFunction();
        } else if (keywordToken == JetTokens.VAL_KEYWORD || keywordToken == JetTokens.VAR_KEYWORD) {
            declType = this.parseProperty();
        } else if (keywordToken == JetTokens.TYPE_KEYWORD) {
            declType = this.parseTypeDef();
        } else if (keywordToken == JetTokens.THIS_KEYWORD) {
            declType = this.parseConstructor();
        } else if (keywordToken == JetTokens.OBJECT_KEYWORD) {
            this.parseObject(true, true);
            declType = JetNodeTypes.OBJECT_DECLARATION;
        } else if (keywordToken == JetTokens.LBRACE) {
            this.parseBlock();
            declType = JetNodeTypes.ANONYMOUS_INITIALIZER;
        }
        return declType;
    }

    public void parseObject(boolean named, boolean optionalBody) {
        assert (this._at(JetTokens.OBJECT_KEYWORD));
        this.advance();
        if (named) {
            PsiBuilder.Marker propertyDeclaration = this.mark();
            if (!this.parseIdeTemplate()) {
                this.expect(JetTokens.IDENTIFIER, "Expecting object name", TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACE}));
            }
            propertyDeclaration.done((IElementType)JetNodeTypes.OBJECT_DECLARATION_NAME);
        } else if (this.at(JetTokens.IDENTIFIER)) {
            this.error("An object expression cannot bind a name");
        }
        if (optionalBody) {
            if (this.at(JetTokens.COLON)) {
                this.advance();
                this.parseDelegationSpecifierList();
            }
            if (this.at(JetTokens.LBRACE)) {
                this.parseClassBody();
            }
        } else if (this.at(JetTokens.LBRACE)) {
            this.parseClassBody();
        } else {
            this.expect(JetTokens.COLON, "Expecting ':'", TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER, JetTokens.PACKAGE_KEYWORD}));
            this.parseDelegationSpecifierList();
            this.parseClassBody();
        }
    }

    private JetNodeType parseConstructor() {
        assert (this._at(JetTokens.THIS_KEYWORD));
        this.advance();
        this.parseValueParameterList(false, TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON, JetTokens.LBRACE, JetTokens.SEMICOLON}));
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseInitializerList();
        }
        if (this.at(JetTokens.LBRACE)) {
            this.parseBlock();
        } else {
            this.consumeIf(JetTokens.SEMICOLON);
        }
        return JetNodeTypes.CONSTRUCTOR;
    }

    private void parseInitializerList() {
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Expecting a this or super constructor call");
            }
            this.parseInitializer();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        list.done((IElementType)JetNodeTypes.INITIALIZER_LIST);
    }

    private void parseInitializer() {
        JetNodeType type;
        PsiBuilder.Marker initializer = this.mark();
        this.parseAnnotations(false);
        if (this.at(JetTokens.THIS_KEYWORD)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done((IElementType)JetNodeTypes.THIS_CONSTRUCTOR_REFERENCE);
            type = JetNodeTypes.THIS_CALL;
        } else if (this.atSet(TYPE_REF_FIRST)) {
            PsiBuilder.Marker reference = this.mark();
            this.parseTypeRef();
            reference.done((IElementType)JetNodeTypes.CONSTRUCTOR_CALLEE);
            type = JetNodeTypes.DELEGATOR_SUPER_CALL;
        } else {
            this.errorWithRecovery("Expecting constructor call (this(...)) or supertype initializer", TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACE, JetTokens.COMMA}));
            initializer.drop();
            return;
        }
        this.myExpressionParsing.parseValueArgumentList();
        initializer.done((IElementType)type);
    }

    private JetNodeType parseClassObject() {
        assert (this._at(JetTokens.CLASS_KEYWORD) && this.lookahead(1) == JetTokens.OBJECT_KEYWORD);
        this.advance();
        PsiBuilder.Marker objectDeclaration = this.mark();
        this.parseObject(false, true);
        objectDeclaration.done((IElementType)JetNodeTypes.OBJECT_DECLARATION);
        return JetNodeTypes.CLASS_OBJECT;
    }

    public JetNodeType parseTypeDef() {
        assert (this._at(JetTokens.TYPE_KEYWORD));
        this.advance();
        this.expect(JetTokens.IDENTIFIER, "Type name expected", TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JetTokens.LT, JetTokens.EQ, JetTokens.SEMICOLON}), TOPLEVEL_OBJECT_FIRST}));
        if (this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET)) {
            this.parseTypeConstraints();
        }
        this.expect(JetTokens.EQ, "Expecting '='", TokenSet.orSet((TokenSet[])new TokenSet[]{TOPLEVEL_OBJECT_FIRST, TokenSet.create((IElementType[])new IElementType[]{JetTokens.SEMICOLON})}));
        this.parseTypeRef();
        this.consumeIf(JetTokens.SEMICOLON);
        return JetNodeTypes.TYPEDEF;
    }

    public JetNodeType parseProperty() {
        return this.parseProperty(false);
    }

    public JetNodeType parseProperty(boolean local) {
        if (this.at(JetTokens.VAL_KEYWORD) || this.at(JetTokens.VAR_KEYWORD)) {
            this.advance();
        } else {
            this.errorAndAdvance("Expecting 'val' or 'var'");
        }
        boolean typeParametersDeclared = this.at(JetTokens.LT) && this.parseTypeParameterList(TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER, JetTokens.EQ, JetTokens.COLON, JetTokens.SEMICOLON}));
        TokenSet propertyNameFollow = TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON, JetTokens.EQ, JetTokens.LBRACE, JetTokens.SEMICOLON, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.CLASS_KEYWORD});
        this.myBuilder.disableJoiningComplexTokens();
        int lastDot = this.matchTokenStreamPredicate(new LastBefore((AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.DOT, JetTokens.SAFE_ACCESS), new AbstractTokenStreamPredicate(){

            @Override
            public boolean matching(boolean topLevel) {
                if (topLevel && (JetParsing.this.at(JetTokens.EQ) || JetParsing.this.at(JetTokens.COLON))) {
                    return true;
                }
                if (topLevel && JetParsing.this.at(JetTokens.IDENTIFIER)) {
                    IElementType lookahead = JetParsing.this.lookahead(1);
                    return lookahead != JetTokens.LT && lookahead != JetTokens.DOT && lookahead != JetTokens.SAFE_ACCESS && lookahead != JetTokens.QUEST;
                }
                return false;
            }
        }));
        this.parseReceiverType("property", propertyNameFollow, lastDot);
        this.myBuilder.restoreJoiningComplexTokensState();
        if (this.at(JetTokens.COLON)) {
            this.advance();
            if (!this.parseIdeTemplate()) {
                this.parseTypeRef();
            }
        }
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        if (local) {
            if (this.at(JetTokens.EQ)) {
                this.advance();
                this.myExpressionParsing.parseExpression();
            }
        } else {
            if (this.at(JetTokens.EQ)) {
                this.advance();
                this.myExpressionParsing.parseExpression();
                this.consumeIf(JetTokens.SEMICOLON);
            }
            if (this.parsePropertyGetterOrSetter()) {
                this.parsePropertyGetterOrSetter();
            }
            if (!this.atSet(JetTokens.EOL_OR_SEMICOLON, JetTokens.RBRACE)) {
                if (this.getLastToken() != JetTokens.SEMICOLON) {
                    this.errorUntil("Property getter or setter expected", TokenSet.create((IElementType[])new IElementType[]{JetTokens.EOL_OR_SEMICOLON}));
                }
            } else {
                this.consumeIf(JetTokens.SEMICOLON);
            }
        }
        return JetNodeTypes.PROPERTY;
    }

    private boolean parsePropertyGetterOrSetter() {
        PsiBuilder.Marker getterOrSetter = this.mark();
        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, false);
        if (!this.at(JetTokens.GET_KEYWORD) && !this.at(JetTokens.SET_KEYWORD)) {
            getterOrSetter.rollbackTo();
            return false;
        }
        boolean setter = this.at(JetTokens.SET_KEYWORD);
        this.advance();
        if (!this.at(JetTokens.LPAR)) {
            TokenSet ACCESSOR_FIRST_OR_PROPERTY_END = TokenSet.orSet((TokenSet[])new TokenSet[]{JetTokens.MODIFIER_KEYWORDS, TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACKET, JetTokens.GET_KEYWORD, JetTokens.SET_KEYWORD, JetTokens.EOL_OR_SEMICOLON, JetTokens.RBRACE})});
            if (!this.atSet(ACCESSOR_FIRST_OR_PROPERTY_END)) {
                this.errorUntil("Accessor body expected", TokenSet.orSet((TokenSet[])new TokenSet[]{ACCESSOR_FIRST_OR_PROPERTY_END, TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACE, JetTokens.LPAR, JetTokens.EQ})}));
            } else {
                getterOrSetter.done((IElementType)JetNodeTypes.PROPERTY_ACCESSOR);
                return true;
            }
        }
        this.myBuilder.disableNewlines();
        this.expect(JetTokens.LPAR, "Expecting '('", TokenSet.create((IElementType[])new IElementType[]{JetTokens.RPAR, JetTokens.IDENTIFIER, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ}));
        if (setter) {
            PsiBuilder.Marker parameterList = this.mark();
            PsiBuilder.Marker setterParameter = this.mark();
            this.parseModifierListWithShortAnnotations(JetNodeTypes.MODIFIER_LIST, TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER}), TokenSet.create((IElementType[])new IElementType[]{JetTokens.RPAR, JetTokens.COMMA, JetTokens.COLON}));
            this.expect(JetTokens.IDENTIFIER, "Expecting parameter name", TokenSet.create((IElementType[])new IElementType[]{JetTokens.RPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ}));
            if (this.at(JetTokens.COLON)) {
                this.advance();
                this.parseTypeRef();
            }
            setterParameter.done((IElementType)JetNodeTypes.VALUE_PARAMETER);
            parameterList.done((IElementType)JetNodeTypes.VALUE_PARAMETER_LIST);
        }
        if (!this.at(JetTokens.RPAR)) {
            this.errorUntil("Expecting ')'", TokenSet.create((IElementType[])new IElementType[]{JetTokens.RPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ, JetTokens.EOL_OR_SEMICOLON}));
        }
        this.expect(JetTokens.RPAR, "Expecting ')'", TokenSet.create((IElementType[])new IElementType[]{JetTokens.RPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ}));
        this.myBuilder.restoreNewlinesState();
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        this.parseFunctionBody();
        getterOrSetter.done((IElementType)JetNodeTypes.PROPERTY_ACCESSOR);
        return true;
    }

    public IElementType parseFunction() {
        assert (this._at(JetTokens.FUN_KEYWORD));
        this.advance();
        if (this.at(JetTokens.RBRACE)) {
            this.error("Function body expected");
            return JetNodeTypes.FUN;
        }
        boolean typeParameterListOccurred = false;
        if (this.at(JetTokens.LT)) {
            this.parseTypeParameterList(TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACKET, JetTokens.LBRACE, JetTokens.LPAR}));
            typeParameterListOccurred = true;
        }
        this.myBuilder.disableJoiningComplexTokens();
        int lastDot = this.findLastBefore(RECEIVER_TYPE_TERMINATORS, TokenSet.create((IElementType[])new IElementType[]{JetTokens.LPAR}), true);
        this.parseReceiverType("function", TokenSet.create((IElementType[])new IElementType[]{JetTokens.LT, JetTokens.LPAR, JetTokens.COLON, JetTokens.EQ}), lastDot);
        this.myBuilder.restoreJoiningComplexTokensState();
        TokenSet valueParametersFollow = TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON, JetTokens.EQ, JetTokens.LBRACE, JetTokens.SEMICOLON, JetTokens.RPAR});
        if (this.at(JetTokens.LT)) {
            PsiBuilder.Marker error = this.mark();
            this.parseTypeParameterList(TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JetTokens.LPAR}), valueParametersFollow}));
            if (typeParameterListOccurred) {
                error.error("Only one type parameter list is allowed for a function");
            } else {
                error.drop();
            }
            typeParameterListOccurred = true;
        }
        this.parseValueParameterList(false, valueParametersFollow);
        if (this.at(JetTokens.COLON)) {
            this.advance();
            if (!this.parseIdeTemplate()) {
                this.parseTypeRef();
            }
        }
        this.parseTypeConstraintsGuarded(typeParameterListOccurred);
        if (this.at(JetTokens.SEMICOLON)) {
            this.advance();
        } else if (this.at(JetTokens.EQ) || this.at(JetTokens.LBRACE)) {
            this.parseFunctionBody();
        }
        return JetNodeTypes.FUN;
    }

    private void parseReceiverType(String title, TokenSet nameFollow, int lastDot) {
        if (lastDot == -1) {
            this.parseAnnotations(false);
            if (!this.parseIdeTemplate()) {
                this.expect(JetTokens.IDENTIFIER, "Expecting " + title + " name or receiver type", nameFollow);
            }
        } else {
            if (this.parseIdeTemplate()) {
                this.expect(JetTokens.DOT, "Expecting '.' after receiver template");
            } else {
                this.createTruncatedBuilder(lastDot).parseTypeRef();
                if (this.atSet(RECEIVER_TYPE_TERMINATORS)) {
                    this.advance();
                } else {
                    this.errorWithRecovery("Expecting '.' before a " + title + " name", nameFollow);
                }
            }
            if (!this.parseIdeTemplate()) {
                this.expect(JetTokens.IDENTIFIER, "Expecting " + title + " name", nameFollow);
            }
        }
    }

    private void parseFunctionBody() {
        if (this.at(JetTokens.LBRACE)) {
            this.parseBlock();
        } else if (this.at(JetTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
            this.consumeIf(JetTokens.SEMICOLON);
        } else {
            this.errorAndAdvance("Expecting function body");
        }
    }

    public void parseBlock() {
        PsiBuilder.Marker block = this.mark();
        this.myBuilder.enableNewlines();
        this.expect(JetTokens.LBRACE, "Expecting '{' to open a block");
        this.myExpressionParsing.parseStatements();
        this.expect(JetTokens.RBRACE, "Expecting '}");
        this.myBuilder.restoreNewlinesState();
        block.done((IElementType)JetNodeTypes.BLOCK);
    }

    void parseDelegationSpecifierList() {
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Expecting a delegation specifier");
                continue;
            }
            this.parseDelegationSpecifier();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        list.done((IElementType)JetNodeTypes.DELEGATION_SPECIFIER_LIST);
    }

    private void parseDelegationSpecifier() {
        PsiBuilder.Marker delegator = this.mark();
        this.parseAnnotations(false);
        PsiBuilder.Marker reference = this.mark();
        this.parseTypeRef();
        if (this.at(JetTokens.BY_KEYWORD)) {
            reference.drop();
            this.advance();
            JetParsing.createForByClause((SemanticWhitespaceAwarePsiBuilder)this.myBuilder).myExpressionParsing.parseExpression();
            delegator.done((IElementType)JetNodeTypes.DELEGATOR_BY);
        } else if (this.at(JetTokens.LPAR)) {
            reference.done((IElementType)JetNodeTypes.CONSTRUCTOR_CALLEE);
            this.myExpressionParsing.parseValueArgumentList();
            delegator.done((IElementType)JetNodeTypes.DELEGATOR_SUPER_CALL);
        } else {
            reference.drop();
            delegator.done((IElementType)JetNodeTypes.DELEGATOR_SUPER_CLASS);
        }
    }

    private boolean parseTypeParameterList(TokenSet recoverySet) {
        PsiBuilder.Marker list = this.mark();
        boolean result = false;
        if (this.at(JetTokens.LT)) {
            this.myBuilder.disableNewlines();
            this.advance();
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting type parameter declaration");
                }
                this.parseTypeParameter();
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
            this.expect(JetTokens.GT, "Missing '>'", recoverySet);
            this.myBuilder.restoreNewlinesState();
            result = true;
        }
        list.done((IElementType)JetNodeTypes.TYPE_PARAMETER_LIST);
        return result;
    }

    private void parseTypeConstraintsGuarded(boolean typeParameterListOccurred) {
        PsiBuilder.Marker error = this.mark();
        boolean constraints = this.parseTypeConstraints();
        if (constraints && !typeParameterListOccurred) {
            error.error("Type constraints are not allowed when no type parameters declared");
        } else {
            error.drop();
        }
    }

    private boolean parseTypeConstraints() {
        if (this.at(JetTokens.WHERE_KEYWORD)) {
            this.parseTypeConstraintList();
            return true;
        }
        return false;
    }

    private void parseTypeConstraintList() {
        assert (this._at(JetTokens.WHERE_KEYWORD));
        this.advance();
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Type constraint expected");
            }
            this.parseTypeConstraint();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        list.done((IElementType)JetNodeTypes.TYPE_CONSTRAINT_LIST);
    }

    private void parseTypeConstraint() {
        PsiBuilder.Marker constraint = this.mark();
        this.parseAnnotations(false);
        if (this.at(JetTokens.CLASS_KEYWORD)) {
            this.advance();
            this.expect(JetTokens.OBJECT_KEYWORD, "Expecting 'object'", TYPE_REF_FIRST);
        }
        PsiBuilder.Marker reference = this.mark();
        if (this.expect(JetTokens.IDENTIFIER, "Expecting type parameter name", TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON, JetTokens.COMMA}), TYPE_REF_FIRST}))) {
            reference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
        } else {
            reference.drop();
        }
        this.expect(JetTokens.COLON, "Expecting ':' before the upper bound", TYPE_REF_FIRST);
        this.parseTypeRef();
        constraint.done((IElementType)JetNodeTypes.TYPE_CONSTRAINT);
    }

    private void parseTypeParameter() {
        if (this.atSet(TYPE_PARAMETER_GT_RECOVERY_SET)) {
            this.error("Type parameter declaration expected");
            return;
        }
        PsiBuilder.Marker mark = this.mark();
        this.parseModifierListWithShortAnnotations(JetNodeTypes.MODIFIER_LIST, TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER}), TokenSet.create((IElementType[])new IElementType[]{JetTokens.COMMA, JetTokens.GT, JetTokens.COLON}));
        this.expect(JetTokens.IDENTIFIER, "Type parameter name expected", TokenSet.EMPTY);
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        mark.done((IElementType)JetNodeTypes.TYPE_PARAMETER);
    }

    public void parseTypeRef() {
        PsiBuilder.Marker typeRefMarker = this.parseTypeRefContents();
        typeRefMarker.done((IElementType)JetNodeTypes.TYPE_REFERENCE);
    }

    private PsiBuilder.Marker parseTypeRefContents() {
        PsiBuilder.Marker precede;
        PsiBuilder.Marker typeRefMarker = this.mark();
        this.parseAnnotations(false);
        if (this.at(JetTokens.IDENTIFIER) || this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.parseUserType();
        } else if (this.at(JetTokens.HASH)) {
            this.parseTupleType();
        } else if (this.at(JetTokens.LPAR)) {
            PsiBuilder.Marker functionOrParenthesizedType = this.mark();
            this.advance();
            this.parseTypeRefContents().drop();
            if (this.at(JetTokens.RPAR)) {
                this.advance();
                if (this.at(JetTokens.ARROW)) {
                    functionOrParenthesizedType.rollbackTo();
                    this.parseFunctionType();
                } else {
                    functionOrParenthesizedType.drop();
                }
            } else {
                functionOrParenthesizedType.rollbackTo();
                this.parseFunctionType();
            }
        } else if (this.at(JetTokens.CAPITALIZED_THIS_KEYWORD)) {
            this.parseSelfType();
        } else {
            this.errorWithRecovery("Type expected", TokenSet.orSet((TokenSet[])new TokenSet[]{TOPLEVEL_OBJECT_FIRST, TokenSet.create((IElementType[])new IElementType[]{JetTokens.EQ, JetTokens.COMMA, JetTokens.GT, JetTokens.RBRACKET, JetTokens.DOT, JetTokens.RPAR, JetTokens.RBRACE, JetTokens.LBRACE, JetTokens.SEMICOLON})}));
        }
        while (this.at(JetTokens.QUEST)) {
            precede = typeRefMarker.precede();
            this.advance();
            typeRefMarker.done((IElementType)JetNodeTypes.NULLABLE_TYPE);
            typeRefMarker = precede;
        }
        if (this.at(JetTokens.DOT)) {
            precede = typeRefMarker.precede();
            typeRefMarker.done((IElementType)JetNodeTypes.TYPE_REFERENCE);
            this.advance();
            if (this.at(JetTokens.LPAR)) {
                this.parseFunctionTypeContents().drop();
            } else {
                this.error("Expecting function type");
            }
            typeRefMarker = precede.precede();
            precede.done((IElementType)JetNodeTypes.FUNCTION_TYPE);
        }
        return typeRefMarker;
    }

    private void parseUserType() {
        PsiBuilder.Marker userType = this.mark();
        if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.expect(JetTokens.DOT, "Expecting '.'", TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER}));
        }
        PsiBuilder.Marker reference = this.mark();
        while (true) {
            if (!this.expect(JetTokens.IDENTIFIER, "Expecting type name", TokenSet.orSet((TokenSet[])new TokenSet[]{JetExpressionParsing.EXPRESSION_FIRST, JetExpressionParsing.EXPRESSION_FOLLOW}))) {
                reference.drop();
                break;
            }
            reference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
            this.parseTypeArgumentList(-1);
            if (!this.at(JetTokens.DOT) || this.lookahead(1) == JetTokens.LPAR) break;
            PsiBuilder.Marker precede = userType.precede();
            userType.done((IElementType)JetNodeTypes.USER_TYPE);
            userType = precede;
            this.advance();
            reference = this.mark();
        }
        userType.done((IElementType)JetNodeTypes.USER_TYPE);
    }

    private void parseSelfType() {
        assert (this._at(JetTokens.CAPITALIZED_THIS_KEYWORD));
        PsiBuilder.Marker type = this.mark();
        this.advance();
        type.done((IElementType)JetNodeTypes.SELF_TYPE);
    }

    public PsiBuilder.Marker parseTypeArgumentList(int expectedGtOffset) {
        if (!this.at(JetTokens.LT)) {
            return null;
        }
        PsiBuilder.Marker list = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        while (true) {
            PsiBuilder.Marker projection = this.mark();
            this.parseModifierList(JetNodeTypes.MODIFIER_LIST, false);
            if (this.at(JetTokens.MUL)) {
                this.advance();
            } else {
                this.parseTypeRef();
            }
            projection.done((IElementType)JetNodeTypes.TYPE_PROJECTION);
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        if (expectedGtOffset >= 0 && this.myBuilder.getCurrentOffset() < expectedGtOffset) {
            PsiBuilder.Marker error = this.mark();
            while (this.myBuilder.getCurrentOffset() < expectedGtOffset) {
                this.advance();
            }
            error.error("Expecting a '>'");
        }
        this.expect(JetTokens.GT, "Expecting a '>'");
        this.myBuilder.restoreNewlinesState();
        list.done((IElementType)JetNodeTypes.TYPE_ARGUMENT_LIST);
        return list;
    }

    private void parseModifierListWithShortAnnotations(JetNodeType modifierList, TokenSet lookFor, TokenSet stopAt) {
        int lastId = this.findLastBefore(lookFor, stopAt, false);
        this.createTruncatedBuilder(lastId).parseModifierList(modifierList, true);
    }

    private void parseTupleType() {
        assert (this._at(JetTokens.HASH));
        PsiBuilder.Marker tuple = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        this.expect(JetTokens.LPAR, "Expecting a tuple type in the form of '#(...)");
        if (!this.at(JetTokens.RPAR)) {
            while (true) {
                if (this.at(JetTokens.COLON)) {
                    this.errorAndAdvance("Expecting a name for tuple entry");
                }
                if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.COLON) {
                    PsiBuilder.Marker labeledEntry = this.mark();
                    this.advance();
                    this.advance();
                    this.parseTypeRef();
                    labeledEntry.done((IElementType)JetNodeTypes.LABELED_TUPLE_TYPE_ENTRY);
                } else if (TYPE_REF_FIRST.contains(this.tt())) {
                    this.parseTypeRef();
                } else {
                    this.error("Type expected");
                    break;
                }
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')");
        this.myBuilder.restoreNewlinesState();
        tuple.done((IElementType)JetNodeTypes.TUPLE_TYPE);
    }

    private void parseFunctionType() {
        this.parseFunctionTypeContents().done((IElementType)JetNodeTypes.FUNCTION_TYPE);
    }

    private PsiBuilder.Marker parseFunctionTypeContents() {
        if (!this._at(JetTokens.LPAR)) {
            System.out.println(this.myBuilder.getTokenText());
        }
        PsiBuilder.Marker functionType = this.mark();
        this.parseValueParameterList(true, TokenSet.EMPTY);
        this.expect(JetTokens.ARROW, "Expecting '->' to specify return type of a function type", TYPE_REF_FIRST);
        this.parseTypeRef();
        return functionType;
    }

    public void parseValueParameterList(boolean isFunctionTypeContents, TokenSet recoverySet) {
        PsiBuilder.Marker parameters = this.mark();
        this.myBuilder.disableNewlines();
        this.expect(JetTokens.LPAR, "Expecting '(", recoverySet);
        if (!(this.parseIdeTemplate() || this.at(JetTokens.RPAR) || this.atSet(recoverySet))) {
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a parameter declaration");
                } else if (this.at(JetTokens.RPAR)) {
                    this.error("Expecting a parameter declaration");
                    break;
                }
                if (isFunctionTypeContents) {
                    if (!this.tryParseValueParameter()) {
                        PsiBuilder.Marker valueParameter = this.mark();
                        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, false);
                        this.parseTypeRef();
                        valueParameter.done((IElementType)JetNodeTypes.VALUE_PARAMETER);
                    }
                } else {
                    this.parseValueParameter();
                }
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')'", recoverySet);
        this.myBuilder.restoreNewlinesState();
        parameters.done((IElementType)JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    private boolean tryParseValueParameter() {
        return this.parseValueParameter(true);
    }

    private void parseValueParameter() {
        this.parseValueParameter(false);
    }

    private boolean parseValueParameter(boolean rollbackOnFailure) {
        PsiBuilder.Marker parameter = this.mark();
        this.parseModifierListWithShortAnnotations(JetNodeTypes.MODIFIER_LIST, TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER}), TokenSet.create((IElementType[])new IElementType[]{JetTokens.COMMA, JetTokens.RPAR, JetTokens.COLON}));
        if (this.at(JetTokens.VAR_KEYWORD) || this.at(JetTokens.VAL_KEYWORD)) {
            this.advance();
        }
        if (!this.parseFunctionParameterRest() && rollbackOnFailure) {
            parameter.rollbackTo();
            return false;
        }
        parameter.done((IElementType)JetNodeTypes.VALUE_PARAMETER);
        return true;
    }

    private boolean parseFunctionParameterRest() {
        this.expect(JetTokens.IDENTIFIER, "Parameter name expected", PARAMETER_NAME_RECOVERY_SET);
        if (!this.at(JetTokens.COLON)) {
            this.error("Parameters must have type annotation");
            return false;
        }
        this.advance();
        this.parseTypeRef();
        if (this.at(JetTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
        }
        return true;
    }

    boolean parseIdeTemplate() {
        JetNodeType nodeType = JetNodeTypes.IDE_TEMPLATE_EXPRESSION;
        if (this.at(JetTokens.IDE_TEMPLATE_START)) {
            PsiBuilder.Marker mark = null;
            if (nodeType != null) {
                mark = this.mark();
            }
            this.advance();
            this.expect(JetTokens.IDENTIFIER, "Expecting identifier inside template");
            this.expect(JetTokens.IDE_TEMPLATE_END, "Expecting IDE template end after identifier");
            if (nodeType != null) {
                mark.done((IElementType)nodeType);
            }
            return true;
        }
        return false;
    }

    @Override
    protected JetParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
        return JetParsing.createForTopLevel(builder);
    }

    static {
        for (IElementType softKeyword : JetTokens.MODIFIER_KEYWORDS.getTypes()) {
            MODIFIER_KEYWORD_MAP.put(((JetKeywordToken)softKeyword).getValue(), softKeyword);
        }
        TOPLEVEL_OBJECT_FIRST = TokenSet.create((IElementType[])new IElementType[]{JetTokens.TYPE_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.PACKAGE_KEYWORD});
        ENUM_MEMBER_FIRST = TokenSet.create((IElementType[])new IElementType[]{JetTokens.TYPE_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.IDENTIFIER});
        CLASS_NAME_RECOVERY_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JetTokens.LT, JetTokens.LPAR, JetTokens.COLON, JetTokens.LBRACE}), TOPLEVEL_OBJECT_FIRST});
        TYPE_PARAMETER_GT_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{JetTokens.WHERE_KEYWORD, JetTokens.LPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.GT});
        PARAMETER_NAME_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON, JetTokens.EQ, JetTokens.COMMA, JetTokens.RPAR});
        NAMESPACE_NAME_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{JetTokens.DOT, JetTokens.EOL_OR_SEMICOLON});
        TYPE_REF_FIRST = TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACKET, JetTokens.IDENTIFIER, JetTokens.FUN_KEYWORD, JetTokens.LPAR, JetTokens.CAPITALIZED_THIS_KEYWORD, JetTokens.HASH});
        RECEIVER_TYPE_TERMINATORS = TokenSet.create((IElementType[])new IElementType[]{JetTokens.DOT, JetTokens.SAFE_ACCESS});
    }

    static class TokenDetector
    implements Consumer<IElementType> {
        private boolean detected = false;
        private final TokenSet tokens;

        public TokenDetector(JetKeywordToken token) {
            this.tokens = TokenSet.create((IElementType[])new IElementType[]{token});
        }

        public TokenDetector(TokenSet tokens) {
            this.tokens = tokens;
        }

        @Override
        public void consume(IElementType item) {
            if (this.tokens.contains(item)) {
                this.detected = true;
            }
        }

        public boolean isDetected() {
            return this.detected;
        }
    }
}

