/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.jet.JetNodeType;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.parsing.AbstractJetParsing;
import org.jetbrains.jet.lang.parsing.FirstBefore;
import org.jetbrains.jet.lang.parsing.JetParsing;
import org.jetbrains.jet.lang.parsing.LastBefore;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetExpressionParsing
extends AbstractJetParsing {
    private static final TokenSet WHEN_CONDITION_RECOVERY_SET;
    private static final TokenSet WHEN_CONDITION_RECOVERY_SET_WITH_ARROW;
    private static final ImmutableMap<String, JetToken> KEYWORD_TEXTS;
    private static final TokenSet TYPE_ARGUMENT_LIST_STOPPERS;
    static final TokenSet EXPRESSION_FIRST;
    private static final TokenSet STATEMENT_FIRST;
    static final TokenSet EXPRESSION_FOLLOW;
    public static final TokenSet ALLOW_NEWLINE_OPERATIONS;
    public static final TokenSet ALL_OPERATIONS;
    private final JetParsing myJetParsing;
    private TokenSet decomposerExpressionFollow = null;

    private static ImmutableMap<String, JetToken> tokenSetToMap(TokenSet tokens) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IElementType token : tokens.getTypes()) {
            builder.put((Object)token.toString(), (Object)((JetToken)token));
        }
        return builder.build();
    }

    public JetExpressionParsing(SemanticWhitespaceAwarePsiBuilder builder, JetParsing jetParsing) {
        super(builder);
        this.myJetParsing = jetParsing;
    }

    private TokenSet getDecomposerExpressionFollow() {
        if (this.decomposerExpressionFollow == null) {
            ArrayList elvisFollow = new ArrayList();
            Precedence precedence = Precedence.ELVIS;
            while (precedence != null) {
                IElementType[] types = precedence.getOperations().getTypes();
                Collections.addAll(elvisFollow, types);
                precedence = precedence.higher;
            }
            this.decomposerExpressionFollow = TokenSet.orSet((TokenSet[])new TokenSet[]{EXPRESSION_FOLLOW, TokenSet.create((IElementType[])elvisFollow.toArray(new IElementType[elvisFollow.size()]))});
        }
        return this.decomposerExpressionFollow;
    }

    public void parseExpression() {
        if (!this.atSet(EXPRESSION_FIRST)) {
            this.error("Expecting an expression");
            return;
        }
        this.parseBinaryExpression(Precedence.ASSIGNMENT);
    }

    private void parseBinaryExpression(Precedence precedence) {
        PsiBuilder.Marker expression = this.mark();
        precedence.parseHigherPrecedence(this);
        while (!this.interruptedWithNewLine() && this.atSet(precedence.getOperations())) {
            IElementType operation = this.tt();
            this.parseOperationReference();
            JetNodeType resultType = precedence.parseRightHandSide(operation, this);
            expression.done((IElementType)resultType);
            expression = expression.precede();
        }
        expression.drop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePrefixExpression() {
        if (this.at(JetTokens.LBRACKET)) {
            if (this.parseLocalDeclaration()) return;
            PsiBuilder.Marker expression = this.mark();
            this.myJetParsing.parseAnnotations(false);
            this.parsePrefixExpression();
            expression.done((IElementType)JetNodeTypes.ANNOTATED_EXPRESSION);
            return;
        } else if (this.atSet(Precedence.PREFIX.getOperations())) {
            PsiBuilder.Marker expression = this.mark();
            this.parseOperationReference();
            this.parsePrefixExpression();
            expression.done((IElementType)JetNodeTypes.PREFIX_EXPRESSION);
            return;
        } else {
            this.parsePostfixExpression();
        }
    }

    private void parsePostfixExpression() {
        PsiBuilder.Marker expression = this.mark();
        this.parseAtomicExpression();
        while (!this.interruptedWithNewLine()) {
            if (this.at(JetTokens.LBRACKET)) {
                this.parseArrayAccess();
                expression.done((IElementType)JetNodeTypes.ARRAY_ACCESS_EXPRESSION);
            } else if (this.parseCallSuffix()) {
                expression.done((IElementType)JetNodeTypes.CALL_EXPRESSION);
            } else if (this.at(JetTokens.DOT)) {
                this.advance();
                this.parseCallExpression();
                expression.done((IElementType)JetNodeTypes.DOT_QUALIFIED_EXPRESSION);
            } else if (this.at(JetTokens.SAFE_ACCESS)) {
                this.advance();
                this.parseCallExpression();
                expression.done((IElementType)JetNodeTypes.SAFE_ACCESS_EXPRESSION);
            } else {
                if (!this.atSet(Precedence.POSTFIX.getOperations())) break;
                this.parseOperationReference();
                expression.done((IElementType)JetNodeTypes.POSTFIX_EXPRESSION);
            }
            expression = expression.precede();
        }
        expression.drop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseCallSuffix() {
        if (this.parseCallWithClosure()) {
            this.parseCallWithClosure();
            return true;
        } else if (this.at(JetTokens.LPAR)) {
            this.parseValueArgumentList();
            this.parseCallWithClosure();
            return true;
        } else {
            if (!this.at(JetTokens.LT)) return false;
            int gtPos = this.matchTokenStreamPredicate(new FirstBefore(new AbstractJetParsing.At(JetTokens.GT), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(TYPE_ARGUMENT_LIST_STOPPERS, TokenSet.create((IElementType[])new IElementType[]{JetTokens.RPAR, JetTokens.RBRACE, JetTokens.RBRACKET})).or(new AbstractJetParsing.AtFirstTokenOfTokens(JetTokens.IDENTIFIER, JetTokens.LPAR))){

                @Override
                public boolean isTopLevel(int openAngleBrackets, int openBrackets, int openBraces, int openParentheses) {
                    return openAngleBrackets == 1 && openBrackets == 0 && openBraces == 0 && openParentheses == 0;
                }

                @Override
                public boolean handleUnmatchedClosing(IElementType token) {
                    this.fail();
                    return true;
                }
            });
            if (gtPos < 0) return false;
            this.myJetParsing.parseTypeArgumentList(gtPos);
            if (!this.myBuilder.newlineBeforeCurrentToken() && this.at(JetTokens.LPAR)) {
                this.parseValueArgumentList();
            }
            this.parseCallWithClosure();
        }
        return true;
    }

    private void parseCallExpression() {
        PsiBuilder.Marker mark = this.mark();
        this.parseAtomicExpression();
        if (!this.myBuilder.newlineBeforeCurrentToken() && this.parseCallSuffix()) {
            mark.done((IElementType)JetNodeTypes.CALL_EXPRESSION);
        } else {
            mark.drop();
        }
    }

    private void parseOperationReference() {
        PsiBuilder.Marker operationReference = this.mark();
        this.advance();
        operationReference.done((IElementType)JetNodeTypes.OPERATION_REFERENCE);
    }

    protected boolean parseCallWithClosure() {
        boolean success = false;
        while (this.at(JetTokens.LBRACE) || this.atSet(JetTokens.LABELS) && this.lookahead(1) == JetTokens.LBRACE) {
            if (!this.at(JetTokens.LBRACE)) {
                assert (this._atSet(JetTokens.LABELS));
                this.parsePrefixExpression();
            } else {
                this.parseFunctionLiteral();
            }
            success = true;
        }
        return success;
    }

    private void parseAtomicExpression() {
        if (this.at(JetTokens.LPAR)) {
            this.parseParenthesizedExpression();
        } else if (this.at(JetTokens.IDE_TEMPLATE_START)) {
            this.myJetParsing.parseIdeTemplate();
        } else if (this.at(JetTokens.HASH)) {
            this.parseTupleExpression();
        } else if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.parseOneTokenExpression(JetNodeTypes.ROOT_NAMESPACE);
        } else if (this.at(JetTokens.THIS_KEYWORD)) {
            this.parseThisExpression();
        } else if (this.at(JetTokens.SUPER_KEYWORD)) {
            this.parseSuperExpression();
        } else if (this.at(JetTokens.OBJECT_KEYWORD)) {
            this.parseObjectLiteral();
        } else if (this.at(JetTokens.THROW_KEYWORD)) {
            this.parseThrow();
        } else if (this.at(JetTokens.RETURN_KEYWORD)) {
            this.parseReturn();
        } else if (this.at(JetTokens.CONTINUE_KEYWORD)) {
            this.parseJump(JetNodeTypes.CONTINUE);
        } else if (this.at(JetTokens.BREAK_KEYWORD)) {
            this.parseJump(JetNodeTypes.BREAK);
        } else if (this.at(JetTokens.IF_KEYWORD)) {
            this.parseIf();
        } else if (this.at(JetTokens.WHEN_KEYWORD)) {
            this.parseWhen();
        } else if (this.at(JetTokens.TRY_KEYWORD)) {
            this.parseTry();
        } else if (this.at(JetTokens.FOR_KEYWORD)) {
            this.parseFor();
        } else if (this.at(JetTokens.WHILE_KEYWORD)) {
            this.parseWhile();
        } else if (this.at(JetTokens.DO_KEYWORD)) {
            this.parseDoWhile();
        } else if (this.atSet(JetTokens.CLASS_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.TYPE_KEYWORD)) {
            this.parseLocalDeclaration();
        } else if (this.at(JetTokens.FIELD_IDENTIFIER)) {
            this.parseSimpleNameExpression();
        } else if (this.at(JetTokens.IDENTIFIER)) {
            this.parseSimpleNameExpression();
        } else if (this.at(JetTokens.LBRACE)) {
            this.parseFunctionLiteral();
        } else if (this.at(JetTokens.OPEN_QUOTE)) {
            this.parseStringTemplate();
        } else if (!this.parseLiteralConstant()) {
            this.errorWithRecovery("Expecting an element", EXPRESSION_FOLLOW);
        }
    }

    private void parseStringTemplate() {
        assert (this._at(JetTokens.OPEN_QUOTE));
        PsiBuilder.Marker template = this.mark();
        this.advance();
        while (!(this.eof() || this.at(JetTokens.CLOSING_QUOTE) || this.at(JetTokens.DANGLING_NEWLINE))) {
            this.parseStringTemplateElement();
        }
        if (this.at(JetTokens.DANGLING_NEWLINE)) {
            this.errorAndAdvance("Expecting '\"'");
        } else {
            this.expect(JetTokens.CLOSING_QUOTE, "Expecting '\"'");
        }
        template.done((IElementType)JetNodeTypes.STRING_TEMPLATE);
    }

    private void parseStringTemplateElement() {
        if (this.at(JetTokens.REGULAR_STRING_PART)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done((IElementType)JetNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY);
        } else if (this.at(JetTokens.ESCAPE_SEQUENCE)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done((IElementType)JetNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY);
        } else if (this.at(JetTokens.SHORT_TEMPLATE_ENTRY_START)) {
            PsiBuilder.Marker entry = this.mark();
            this.advance();
            if (this.at(JetTokens.THIS_KEYWORD)) {
                PsiBuilder.Marker thisExpression = this.mark();
                PsiBuilder.Marker reference = this.mark();
                this.advance();
                reference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
                thisExpression.done((IElementType)JetNodeTypes.THIS_EXPRESSION);
            } else {
                JetToken keyword = (JetToken)((Object)KEYWORD_TEXTS.get((Object)this.myBuilder.getTokenText()));
                if (keyword != null) {
                    this.myBuilder.remapCurrentToken(keyword);
                    this.errorAndAdvance("Keyword cannot be used as a reference");
                } else {
                    PsiBuilder.Marker reference = this.mark();
                    this.expect(JetTokens.IDENTIFIER, "Expecting a name");
                    reference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
                }
            }
            entry.done((IElementType)JetNodeTypes.SHORT_STRING_TEMPLATE_ENTRY);
        } else if (this.at(JetTokens.LONG_TEMPLATE_ENTRY_START)) {
            PsiBuilder.Marker longTemplateEntry = this.mark();
            this.advance();
            this.parseExpression();
            this.expect(JetTokens.LONG_TEMPLATE_ENTRY_END, "Expecting '}'", TokenSet.create((IElementType[])new IElementType[]{JetTokens.CLOSING_QUOTE, JetTokens.DANGLING_NEWLINE, JetTokens.REGULAR_STRING_PART, JetTokens.ESCAPE_SEQUENCE, JetTokens.SHORT_TEMPLATE_ENTRY_START}));
            longTemplateEntry.done((IElementType)JetNodeTypes.LONG_STRING_TEMPLATE_ENTRY);
        } else {
            this.errorAndAdvance("Unexpected token in a string template");
        }
    }

    private boolean parseLiteralConstant() {
        if (this.at(JetTokens.TRUE_KEYWORD) || this.at(JetTokens.FALSE_KEYWORD)) {
            this.parseOneTokenExpression(JetNodeTypes.BOOLEAN_CONSTANT);
        } else if (this.at(JetTokens.INTEGER_LITERAL)) {
            this.parseOneTokenExpression(JetNodeTypes.INTEGER_CONSTANT);
        } else if (this.at(JetTokens.CHARACTER_LITERAL)) {
            this.parseOneTokenExpression(JetNodeTypes.CHARACTER_CONSTANT);
        } else if (this.at(JetTokens.FLOAT_LITERAL)) {
            this.parseOneTokenExpression(JetNodeTypes.FLOAT_CONSTANT);
        } else if (this.at(JetTokens.NULL_KEYWORD)) {
            this.parseOneTokenExpression(JetNodeTypes.NULL);
        } else {
            return false;
        }
        return true;
    }

    private void parseWhen() {
        assert (this._at(JetTokens.WHEN_KEYWORD));
        PsiBuilder.Marker when = this.mark();
        this.advance();
        this.myBuilder.disableNewlines();
        if (this.at(JetTokens.LPAR)) {
            this.advanceAt(JetTokens.LPAR);
            int valPos = this.matchTokenStreamPredicate(new FirstBefore(new AbstractJetParsing.At(JetTokens.VAL_KEYWORD), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.RPAR, JetTokens.LBRACE, JetTokens.RBRACE, JetTokens.SEMICOLON, JetTokens.EQ)));
            if (valPos >= 0) {
                PsiBuilder.Marker property = this.mark();
                this.myJetParsing.parseModifierList(JetNodeTypes.MODIFIER_LIST, true);
                this.myJetParsing.parseProperty(true);
                property.done((IElementType)JetNodeTypes.PROPERTY);
            } else {
                this.parseExpression();
            }
            this.expect(JetTokens.RPAR, "Expecting ')'");
        }
        this.myBuilder.restoreNewlinesState();
        this.myBuilder.enableNewlines();
        this.expect(JetTokens.LBRACE, "Expecting '{'");
        while (!this.eof() && !this.at(JetTokens.RBRACE)) {
            this.parseWhenEntry();
        }
        this.expect(JetTokens.RBRACE, "Expecting '}'");
        this.myBuilder.restoreNewlinesState();
        when.done((IElementType)JetNodeTypes.WHEN);
    }

    private void parseWhenEntry() {
        PsiBuilder.Marker entry = this.mark();
        if (this.at(JetTokens.ELSE_KEYWORD)) {
            this.advance();
            if (!this.at(JetTokens.ARROW)) {
                this.errorUntil("Expecting '=>'", TokenSet.create((IElementType[])new IElementType[]{JetTokens.ARROW, JetTokens.RBRACE, JetTokens.EOL_OR_SEMICOLON}));
            }
            if (this.at(JetTokens.ARROW)) {
                this.advance();
                if (this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
                    this.error("Expecting an element");
                } else {
                    this.parseExpressionPreferringBlocks();
                }
            } else if (!this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
                this.errorAndAdvance("Expecting '=>'");
            }
        } else {
            this.parseWhenEntryNotElse();
        }
        entry.done((IElementType)JetNodeTypes.WHEN_ENTRY);
        this.consumeIf(JetTokens.SEMICOLON);
    }

    private void parseWhenEntryNotElse() {
        if (!this.myJetParsing.parseIdeTemplate()) {
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a when-condition");
                    continue;
                }
                this.parseWhenCondition();
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
        }
        this.expect(JetTokens.ARROW, "Expecting '->' or 'when'", WHEN_CONDITION_RECOVERY_SET);
        if (this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
            this.error("Expecting an element");
        } else {
            this.parseExpressionPreferringBlocks();
        }
    }

    private void parseWhenCondition() {
        PsiBuilder.Marker condition = this.mark();
        this.myBuilder.disableNewlines();
        if (this.at(JetTokens.IN_KEYWORD) || this.at(JetTokens.NOT_IN)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done((IElementType)JetNodeTypes.OPERATION_REFERENCE);
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting an element");
            } else {
                this.parseExpression();
            }
            condition.done((IElementType)JetNodeTypes.WHEN_CONDITION_IN_RANGE);
        } else if (this.at(JetTokens.IS_KEYWORD) || this.at(JetTokens.NOT_IS)) {
            this.advance();
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting a type or a decomposer pattern");
            } else {
                this.parsePattern();
            }
            condition.done((IElementType)JetNodeTypes.WHEN_CONDITION_IS_PATTERN);
        } else {
            PsiBuilder.Marker expressionPattern = this.mark();
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting an expression, is-condition or in-condition");
            } else {
                this.parseExpression();
            }
            expressionPattern.done((IElementType)JetNodeTypes.EXPRESSION_PATTERN);
            condition.done((IElementType)JetNodeTypes.WHEN_CONDITION_EXPRESSION);
        }
        this.myBuilder.restoreNewlinesState();
    }

    private void parsePattern() {
        PsiBuilder.Marker pattern = this.mark();
        this.myJetParsing.parseAnnotations(false);
        if (this.at(JetTokens.PACKAGE_KEYWORD) || this.at(JetTokens.IDENTIFIER) || this.at(JetTokens.FUN_KEYWORD) || this.at(JetTokens.THIS_KEYWORD)) {
            PsiBuilder.Marker rollbackMarker = this.mark();
            this.parseBinaryExpression(Precedence.ELVIS);
            if (this.at(JetTokens.HASH)) {
                rollbackMarker.drop();
                PsiBuilder.Marker list = this.mark();
                this.parseTuplePattern(JetNodeTypes.DECOMPOSER_ARGUMENT);
                list.done((IElementType)JetNodeTypes.DECOMPOSER_ARGUMENT_LIST);
                pattern.done((IElementType)JetNodeTypes.DECOMPOSER_PATTERN);
            } else {
                int expressionEndOffset = this.myBuilder.getCurrentOffset();
                rollbackMarker.rollbackTo();
                rollbackMarker = this.mark();
                this.myJetParsing.parseTypeRef();
                if (this.myBuilder.getCurrentOffset() < expressionEndOffset) {
                    rollbackMarker.rollbackTo();
                    this.parseBinaryExpression(Precedence.ELVIS);
                    pattern.done((IElementType)JetNodeTypes.DECOMPOSER_PATTERN);
                } else {
                    rollbackMarker.drop();
                    pattern.done((IElementType)JetNodeTypes.TYPE_PATTERN);
                }
            }
        } else if (this.at(JetTokens.HASH)) {
            this.parseTuplePattern(JetNodeTypes.TUPLE_PATTERN_ENTRY);
            pattern.done((IElementType)JetNodeTypes.TUPLE_PATTERN);
        } else if (this.at(JetTokens.MUL)) {
            this.advance();
            pattern.done((IElementType)JetNodeTypes.WILDCARD_PATTERN);
        } else if (this.at(JetTokens.VAL_KEYWORD)) {
            this.parseBindingPattern();
            pattern.done((IElementType)JetNodeTypes.BINDING_PATTERN);
        } else if (this.at(JetTokens.OPEN_QUOTE)) {
            this.parseStringTemplate();
            pattern.done((IElementType)JetNodeTypes.EXPRESSION_PATTERN);
        } else if (this.parseLiteralConstant()) {
            pattern.done((IElementType)JetNodeTypes.EXPRESSION_PATTERN);
        } else {
            this.errorUntil("Pattern expected", TokenSet.create((IElementType[])new IElementType[]{JetTokens.RBRACE, JetTokens.ARROW}));
            pattern.drop();
        }
    }

    private void parseTuplePattern(JetNodeType entryType) {
        this.myBuilder.disableNewlines();
        this.expect(JetTokens.HASH, "Expecting a tuple pattern of the form '#(...)'", this.getDecomposerExpressionFollow());
        this.expect(JetTokens.LPAR, "Expecting a tuple pattern of the form '#(...)'", this.getDecomposerExpressionFollow());
        if (!this.at(JetTokens.RPAR)) {
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a pattern");
                    continue;
                }
                if (this.at(JetTokens.RPAR)) {
                    this.error("Expecting a pattern");
                    break;
                }
                PsiBuilder.Marker entry = this.mark();
                if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.EQ) {
                    this.advance();
                    this.advance();
                }
                this.parsePattern();
                entry.done((IElementType)entryType);
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')'");
        this.myBuilder.restoreNewlinesState();
    }

    private void parseBindingPattern() {
        assert (this._at(JetTokens.VAL_KEYWORD));
        PsiBuilder.Marker declaration = this.mark();
        this.advance();
        this.expect(JetTokens.IDENTIFIER, "Expecting an identifier");
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.myJetParsing.parseTypeRef();
            declaration.done((IElementType)JetNodeTypes.PROPERTY);
        } else {
            declaration.done((IElementType)JetNodeTypes.PROPERTY);
            PsiBuilder.Marker subCondition = this.mark();
            if (this.at(JetTokens.IS_KEYWORD) || this.at(JetTokens.NOT_IS)) {
                this.advance();
                this.parsePattern();
                subCondition.done((IElementType)JetNodeTypes.WHEN_CONDITION_IS_PATTERN);
            } else if (this.at(JetTokens.IN_KEYWORD) || this.at(JetTokens.NOT_IN)) {
                PsiBuilder.Marker mark = this.mark();
                this.advance();
                mark.done((IElementType)JetNodeTypes.OPERATION_REFERENCE);
                this.parseExpression();
                subCondition.done((IElementType)JetNodeTypes.WHEN_CONDITION_IN_RANGE);
            } else {
                subCondition.drop();
            }
        }
    }

    private void parseArrayAccess() {
        assert (this._at(JetTokens.LBRACKET));
        PsiBuilder.Marker indices = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Expecting an index element");
            }
            if (this.at(JetTokens.RBRACKET)) {
                this.error("Expecting an index element");
                break;
            }
            this.parseExpression();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        this.expect(JetTokens.RBRACKET, "Expecting ']'");
        this.myBuilder.restoreNewlinesState();
        indices.done((IElementType)JetNodeTypes.INDICES);
    }

    public void parseSimpleNameExpression() {
        PsiBuilder.Marker simpleName = this.mark();
        if (this.at(JetTokens.FIELD_IDENTIFIER)) {
            this.advance();
        } else {
            this.expect(JetTokens.IDENTIFIER, "Expecting an identifier");
        }
        simpleName.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
    }

    private boolean parseLocalDeclaration() {
        PsiBuilder.Marker decl = this.mark();
        JetParsing.TokenDetector enumDetector = new JetParsing.TokenDetector(JetTokens.ENUM_KEYWORD);
        this.myJetParsing.parseModifierList(JetNodeTypes.MODIFIER_LIST, enumDetector, false);
        IElementType declType = this.parseLocalDeclarationRest(enumDetector.isDetected());
        if (declType != null) {
            decl.done(declType);
            return true;
        }
        decl.rollbackTo();
        return false;
    }

    private void parseFunctionLiteral() {
        this.parseFunctionLiteral(false);
    }

    private void parseFunctionLiteral(boolean preferBlock) {
        PsiBuilder.Marker rollbackMarker;
        assert (this._at(JetTokens.LBRACE));
        PsiBuilder.Marker literalExpression = this.mark();
        PsiBuilder.Marker literal = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        boolean paramsFound = false;
        if (this.at(JetTokens.ARROW)) {
            this.advance();
            this.mark().done((IElementType)JetNodeTypes.VALUE_PARAMETER_LIST);
            paramsFound = true;
        } else if (this.at(JetTokens.LPAR)) {
            rollbackMarker = this.mark();
            this.parseFunctionLiteralParametersAndType();
            paramsFound = this.rollbackOrDropAt(rollbackMarker, JetTokens.ARROW);
            if (!paramsFound) {
                rollbackMarker = this.mark();
                int lastDot = this.matchTokenStreamPredicate(new LastBefore(new AbstractJetParsing.At(JetTokens.DOT), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.ARROW, JetTokens.RPAR)));
                if (lastDot >= 0) {
                    this.createTruncatedBuilder(lastDot).parseTypeRef();
                    if (this.at(JetTokens.DOT)) {
                        this.advance();
                        this.parseFunctionLiteralParametersAndType();
                    }
                }
                paramsFound = this.rollbackOrDropAt(rollbackMarker, JetTokens.ARROW);
            }
        } else {
            if (this.at(JetTokens.IDENTIFIER)) {
                rollbackMarker = this.mark();
                this.parseFunctionLiteralShorthandParameterList();
                this.parseOptionalFunctionLiteralType();
                paramsFound = this.rollbackOrDropAt(rollbackMarker, JetTokens.ARROW);
            }
            if (!paramsFound && this.atSet(JetParsing.TYPE_REF_FIRST)) {
                rollbackMarker = this.mark();
                int lastDot = this.matchTokenStreamPredicate(new LastBefore(new AbstractJetParsing.At(JetTokens.DOT), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.ARROW, JetTokens.RBRACE)));
                if (lastDot >= 0) {
                    this.createTruncatedBuilder(lastDot).parseTypeRef();
                }
                if (this.at(JetTokens.DOT)) {
                    this.advance();
                    this.parseFunctionLiteralParametersAndType();
                    paramsFound = this.rollbackOrDropAt(rollbackMarker, JetTokens.ARROW);
                } else {
                    rollbackMarker.rollbackTo();
                }
            }
        }
        if (!paramsFound && preferBlock) {
            literal.drop();
            this.parseStatements();
            this.expect(JetTokens.RBRACE, "Expecting '}'");
            literalExpression.done((IElementType)JetNodeTypes.BLOCK);
            this.myBuilder.restoreNewlinesState();
            return;
        }
        PsiBuilder.Marker body = this.mark();
        this.parseStatements();
        body.done((IElementType)JetNodeTypes.BLOCK);
        this.expect(JetTokens.RBRACE, "Expecting '}'");
        this.myBuilder.restoreNewlinesState();
        literal.done((IElementType)JetNodeTypes.FUNCTION_LITERAL);
        literalExpression.done((IElementType)JetNodeTypes.FUNCTION_LITERAL_EXPRESSION);
    }

    private boolean rollbackOrDropAt(PsiBuilder.Marker rollbackMarker, IElementType dropAt) {
        if (this.at(dropAt)) {
            this.advance();
            rollbackMarker.drop();
            return true;
        }
        rollbackMarker.rollbackTo();
        return false;
    }

    private void parseFunctionLiteralShorthandParameterList() {
        PsiBuilder.Marker parameterList = this.mark();
        while (!this.eof()) {
            PsiBuilder.Marker parameter = this.mark();
            this.expect(JetTokens.IDENTIFIER, "Expecting parameter name", TokenSet.create((IElementType[])new IElementType[]{JetTokens.ARROW}));
            parameter.done((IElementType)JetNodeTypes.VALUE_PARAMETER);
            if (this.at(JetTokens.COLON)) {
                PsiBuilder.Marker errorMarker = this.mark();
                this.advance();
                this.myJetParsing.parseTypeRef();
                errorMarker.error("To specify a type of a parameter or a return type, use the full notation: {(parameter : Type) : ReturnType => ...}");
                continue;
            }
            if (this.at(JetTokens.ARROW)) break;
            if (this.at(JetTokens.COMMA)) {
                this.advance();
                continue;
            }
            this.error("Expecting '->' or ','");
            break;
        }
        parameterList.done((IElementType)JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    private void parseFunctionLiteralParametersAndType() {
        this.parseFunctionLiteralParameterList();
        this.parseOptionalFunctionLiteralType();
    }

    private void parseOptionalFunctionLiteralType() {
        if (this.at(JetTokens.COLON)) {
            this.advance();
            if (this.at(JetTokens.ARROW)) {
                this.error("Expecting a type");
            } else {
                this.myJetParsing.parseTypeRef();
            }
        }
    }

    private void parseFunctionLiteralParameterList() {
        PsiBuilder.Marker list;
        block4: {
            list = this.mark();
            this.expect(JetTokens.LPAR, "Expecting a parameter list in parentheses (...)", TokenSet.create((IElementType[])new IElementType[]{JetTokens.ARROW, JetTokens.COLON}));
            this.myBuilder.disableNewlines();
            if (!this.at(JetTokens.RPAR)) {
                do {
                    if (this.at(JetTokens.COMMA)) {
                        this.errorAndAdvance("Expecting a parameter declaration");
                    }
                    PsiBuilder.Marker parameter = this.mark();
                    int parameterNamePos = this.matchTokenStreamPredicate(new LastBefore(new AbstractJetParsing.At(JetTokens.IDENTIFIER), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.COMMA, JetTokens.RPAR, JetTokens.COLON, JetTokens.ARROW)));
                    this.createTruncatedBuilder(parameterNamePos).parseModifierList(JetNodeTypes.MODIFIER_LIST, false);
                    this.expect(JetTokens.IDENTIFIER, "Expecting parameter declaration");
                    if (this.at(JetTokens.COLON)) {
                        this.advance();
                        this.myJetParsing.parseTypeRef();
                    }
                    parameter.done((IElementType)JetNodeTypes.VALUE_PARAMETER);
                    if (!this.at(JetTokens.COMMA)) break block4;
                    this.advance();
                } while (!this.at(JetTokens.RPAR));
                this.error("Expecting a parameter declaration");
            }
        }
        this.myBuilder.restoreNewlinesState();
        this.expect(JetTokens.RPAR, "Expecting ')", TokenSet.create((IElementType[])new IElementType[]{JetTokens.ARROW, JetTokens.COLON}));
        list.done((IElementType)JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    public void parseStatements() {
        while (this.at(JetTokens.SEMICOLON)) {
            this.advance();
        }
        while (!this.eof() && !this.at(JetTokens.RBRACE)) {
            if (!this.atSet(STATEMENT_FIRST)) {
                this.errorAndAdvance("Expecting an element");
            }
            if (this.atSet(STATEMENT_FIRST)) {
                this.parseStatement();
            }
            if (this.at(JetTokens.SEMICOLON)) {
                while (this.at(JetTokens.SEMICOLON)) {
                    this.advance();
                }
                continue;
            }
            if (this.at(JetTokens.RBRACE)) break;
            if (this.myBuilder.newlineBeforeCurrentToken()) continue;
            this.errorUntil("Unexpected tokens (use ';' to separate expressions on the same line)", TokenSet.create((IElementType[])new IElementType[]{JetTokens.EOL_OR_SEMICOLON}));
        }
    }

    private void parseStatement() {
        if (!this.parseLocalDeclaration()) {
            if (!this.atSet(EXPRESSION_FIRST)) {
                this.errorAndAdvance("Expecting a statement");
            } else {
                this.parseExpression();
            }
        }
    }

    private IElementType parseLocalDeclarationRest(boolean isEnum) {
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == JetTokens.CLASS_KEYWORD || keywordToken == JetTokens.TRAIT_KEYWORD) {
            declType = this.myJetParsing.parseClass(isEnum);
        } else if (keywordToken == JetTokens.FUN_KEYWORD) {
            declType = this.myJetParsing.parseFunction();
        } else if (keywordToken == JetTokens.VAL_KEYWORD || keywordToken == JetTokens.VAR_KEYWORD) {
            declType = this.myJetParsing.parseProperty(true);
        } else if (keywordToken == JetTokens.TYPE_KEYWORD) {
            declType = this.myJetParsing.parseTypeDef();
        } else if (keywordToken == JetTokens.OBJECT_KEYWORD) {
            IElementType lookahead = this.lookahead(1);
            if (lookahead == JetTokens.COLON || lookahead == JetTokens.LBRACE) {
                return null;
            }
            this.myJetParsing.parseObject(true, true);
            declType = JetNodeTypes.OBJECT_DECLARATION;
        }
        return declType;
    }

    private void parseDoWhile() {
        assert (this._at(JetTokens.DO_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        if (!this.at(JetTokens.WHILE_KEYWORD)) {
            this.parseControlStructureBody();
        }
        if (this.expect(JetTokens.WHILE_KEYWORD, "Expecting 'while' followed by a post-condition")) {
            this.parseCondition();
        }
        loop.done((IElementType)JetNodeTypes.DO_WHILE);
    }

    private void parseWhile() {
        assert (this._at(JetTokens.WHILE_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        this.parseCondition();
        this.parseControlStructureBody();
        loop.done((IElementType)JetNodeTypes.WHILE);
    }

    private void parseFor() {
        assert (this._at(JetTokens.FOR_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        this.myBuilder.disableNewlines();
        this.expect(JetTokens.LPAR, "Expecting '(' to open a loop range", TokenSet.create((IElementType[])new IElementType[]{JetTokens.RPAR, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.IDENTIFIER}));
        PsiBuilder.Marker parameter = this.mark();
        if (this.at(JetTokens.VAL_KEYWORD) || this.at(JetTokens.VAR_KEYWORD)) {
            this.advance();
        }
        if (!this.myJetParsing.parseIdeTemplate()) {
            this.expect(JetTokens.IDENTIFIER, "Expecting a variable name", TokenSet.create((IElementType[])new IElementType[]{JetTokens.COLON}));
        }
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.myJetParsing.parseTypeRef();
        }
        parameter.done((IElementType)JetNodeTypes.LOOP_PARAMETER);
        this.expect(JetTokens.IN_KEYWORD, "Expecting 'in'");
        PsiBuilder.Marker range = this.mark();
        this.parseExpression();
        range.done((IElementType)JetNodeTypes.LOOP_RANGE);
        this.expectNoAdvance(JetTokens.RPAR, "Expecting ')'");
        this.myBuilder.restoreNewlinesState();
        this.parseControlStructureBody();
        loop.done((IElementType)JetNodeTypes.FOR);
    }

    private void parseExpressionPreferringBlocks() {
        if (this.at(JetTokens.LBRACE)) {
            this.parseFunctionLiteral(true);
        } else if (this.atSet(JetTokens.LABELS) && this.lookahead(1) == JetTokens.LBRACE) {
            PsiBuilder.Marker mark = this.mark();
            this.parseOperationReference();
            this.parseFunctionLiteral(true);
            mark.done((IElementType)JetNodeTypes.PREFIX_EXPRESSION);
        } else {
            this.parseExpression();
        }
    }

    private void parseControlStructureBody() {
        PsiBuilder.Marker body = this.mark();
        if (!this.at(JetTokens.SEMICOLON)) {
            this.parseExpressionPreferringBlocks();
        }
        body.done((IElementType)JetNodeTypes.BODY);
    }

    private void parseTry() {
        assert (this._at(JetTokens.TRY_KEYWORD));
        PsiBuilder.Marker tryExpression = this.mark();
        this.advance();
        this.myJetParsing.parseBlock();
        boolean catchOrFinally = false;
        while (this.at(JetTokens.CATCH_KEYWORD)) {
            catchOrFinally = true;
            PsiBuilder.Marker catchBlock = this.mark();
            this.advance();
            this.myJetParsing.parseValueParameterList(false, TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACE, JetTokens.FINALLY_KEYWORD, JetTokens.CATCH_KEYWORD}));
            this.myJetParsing.parseBlock();
            catchBlock.done((IElementType)JetNodeTypes.CATCH);
        }
        if (this.at(JetTokens.FINALLY_KEYWORD)) {
            catchOrFinally = true;
            PsiBuilder.Marker finallyBlock = this.mark();
            this.advance();
            this.myJetParsing.parseBlock();
            finallyBlock.done((IElementType)JetNodeTypes.FINALLY);
        }
        if (!catchOrFinally) {
            this.error("Expecting 'catch' or 'finally'");
        }
        tryExpression.done((IElementType)JetNodeTypes.TRY);
    }

    private void parseIf() {
        assert (this._at(JetTokens.IF_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseCondition();
        PsiBuilder.Marker thenBranch = this.mark();
        if (!this.at(JetTokens.ELSE_KEYWORD) && !this.at(JetTokens.SEMICOLON)) {
            this.parseExpressionPreferringBlocks();
        }
        if (this.at(JetTokens.SEMICOLON) && this.lookahead(1) == JetTokens.ELSE_KEYWORD) {
            this.advance();
        }
        thenBranch.done((IElementType)JetNodeTypes.THEN);
        if (this.at(JetTokens.ELSE_KEYWORD)) {
            this.advance();
            PsiBuilder.Marker elseBranch = this.mark();
            if (!this.at(JetTokens.SEMICOLON)) {
                this.parseExpressionPreferringBlocks();
            }
            elseBranch.done((IElementType)JetNodeTypes.ELSE);
        }
        marker.done((IElementType)JetNodeTypes.IF);
    }

    private void parseCondition() {
        this.myBuilder.disableNewlines();
        this.expect(JetTokens.LPAR, "Expecting a condition in parentheses '(...)'");
        PsiBuilder.Marker condition = this.mark();
        this.parseExpression();
        condition.done((IElementType)JetNodeTypes.CONDITION);
        this.expect(JetTokens.RPAR, "Expecting ')");
        this.myBuilder.restoreNewlinesState();
    }

    private void parseJump(JetNodeType type) {
        assert (this._at(JetTokens.BREAK_KEYWORD) || this._at(JetTokens.CONTINUE_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseLabel();
        marker.done((IElementType)type);
    }

    private void parseReturn() {
        assert (this._at(JetTokens.RETURN_KEYWORD));
        PsiBuilder.Marker returnExpression = this.mark();
        this.advance();
        this.parseLabel();
        if (this.atSet(EXPRESSION_FIRST) && !this.at(JetTokens.EOL_OR_SEMICOLON)) {
            this.parseExpression();
        }
        returnExpression.done((IElementType)JetNodeTypes.RETURN);
    }

    private void parseLabel() {
        if (!this.eol() && this.atSet(JetTokens.LABELS)) {
            PsiBuilder.Marker labelWrap = this.mark();
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done((IElementType)JetNodeTypes.LABEL_REFERENCE);
            labelWrap.done((IElementType)JetNodeTypes.LABEL_QUALIFIER);
        }
    }

    private void parseThrow() {
        assert (this._at(JetTokens.THROW_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseExpression();
        marker.done((IElementType)JetNodeTypes.THROW);
    }

    private void parseParenthesizedExpression() {
        assert (this._at(JetTokens.LPAR));
        PsiBuilder.Marker mark = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (this.at(JetTokens.RPAR)) {
            this.error("Expecting an expression");
        } else {
            this.parseExpression();
        }
        this.expect(JetTokens.RPAR, "Expecting ')'");
        this.myBuilder.restoreNewlinesState();
        mark.done((IElementType)JetNodeTypes.PARENTHESIZED);
    }

    private void parseTupleExpression() {
        PsiBuilder.Marker mark;
        block6: {
            assert (this._at(JetTokens.HASH));
            mark = this.mark();
            this.advance();
            this.advance();
            this.myBuilder.disableNewlines();
            if (!this.at(JetTokens.RPAR)) {
                while (true) {
                    if (this.at(JetTokens.COMMA)) {
                        this.errorAndAdvance("Expecting a tuple entry (element)");
                        continue;
                    }
                    if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.EQ) {
                        PsiBuilder.Marker entry = this.mark();
                        this.advance();
                        this.advance();
                        this.parseExpression();
                        entry.done((IElementType)JetNodeTypes.LABELED_TUPLE_ENTRY);
                    } else {
                        this.parseExpression();
                    }
                    if (!this.at(JetTokens.COMMA)) break block6;
                    this.advance();
                    if (this.at(JetTokens.RPAR)) break;
                }
                this.error("Expecting a tuple entry (element)");
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')'");
        this.myBuilder.restoreNewlinesState();
        mark.done((IElementType)JetNodeTypes.TUPLE);
    }

    private void parseThisExpression() {
        assert (this._at(JetTokens.THIS_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        PsiBuilder.Marker thisReference = this.mark();
        this.advance();
        thisReference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
        this.parseLabel();
        mark.done((IElementType)JetNodeTypes.THIS_EXPRESSION);
    }

    private void parseSuperExpression() {
        assert (this._at(JetTokens.SUPER_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        PsiBuilder.Marker superReference = this.mark();
        this.advance();
        superReference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
        if (this.at(JetTokens.LT)) {
            PsiBuilder.Marker supertype = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            this.myJetParsing.parseTypeRef();
            if (this.at(JetTokens.GT)) {
                this.advance();
                supertype.drop();
            } else {
                supertype.rollbackTo();
            }
            this.myBuilder.restoreNewlinesState();
        }
        this.parseLabel();
        mark.done((IElementType)JetNodeTypes.SUPER_EXPRESSION);
    }

    public void parseValueArgumentList() {
        PsiBuilder.Marker list;
        block3: {
            list = this.mark();
            this.myBuilder.disableNewlines();
            this.expect(JetTokens.LPAR, "Expecting an argument list", EXPRESSION_FOLLOW);
            if (!this.at(JetTokens.RPAR)) {
                while (true) {
                    if (this.at(JetTokens.COMMA)) {
                        this.errorAndAdvance("Expecting an argument");
                        continue;
                    }
                    this.parseValueArgument();
                    if (!this.at(JetTokens.COMMA)) break block3;
                    this.advance();
                    if (this.at(JetTokens.RPAR)) break;
                }
                this.error("Expecting an argument");
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')'", EXPRESSION_FOLLOW);
        this.myBuilder.restoreNewlinesState();
        list.done((IElementType)JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    private void parseValueArgument() {
        PsiBuilder.Marker argument = this.mark();
        if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.EQ) {
            PsiBuilder.Marker argName = this.mark();
            PsiBuilder.Marker reference = this.mark();
            this.advance();
            reference.done((IElementType)JetNodeTypes.REFERENCE_EXPRESSION);
            argName.done((IElementType)JetNodeTypes.VALUE_ARGUMENT_NAME);
            this.advance();
        }
        this.parseExpression();
        argument.done((IElementType)JetNodeTypes.VALUE_ARGUMENT);
    }

    public void parseObjectLiteral() {
        PsiBuilder.Marker literal = this.mark();
        PsiBuilder.Marker declaration = this.mark();
        this.myJetParsing.parseObject(false, false);
        declaration.done((IElementType)JetNodeTypes.OBJECT_DECLARATION);
        literal.done((IElementType)JetNodeTypes.OBJECT_LITERAL);
    }

    private void parseOneTokenExpression(JetNodeType type) {
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        mark.done((IElementType)type);
    }

    @Override
    protected JetParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
        return this.myJetParsing.create(builder);
    }

    private boolean interruptedWithNewLine() {
        return !ALLOW_NEWLINE_OPERATIONS.contains(this.tt()) && this.myBuilder.newlineBeforeCurrentToken();
    }

    static {
        Precedence[] values;
        WHEN_CONDITION_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{JetTokens.RBRACE, JetTokens.IN_KEYWORD, JetTokens.NOT_IN, JetTokens.IS_KEYWORD, JetTokens.NOT_IS, JetTokens.ELSE_KEYWORD});
        WHEN_CONDITION_RECOVERY_SET_WITH_ARROW = TokenSet.create((IElementType[])new IElementType[]{JetTokens.RBRACE, JetTokens.IN_KEYWORD, JetTokens.NOT_IN, JetTokens.IS_KEYWORD, JetTokens.NOT_IS, JetTokens.ELSE_KEYWORD, JetTokens.ARROW, JetTokens.DOT});
        KEYWORD_TEXTS = JetExpressionParsing.tokenSetToMap(JetTokens.KEYWORDS);
        TYPE_ARGUMENT_LIST_STOPPERS = TokenSet.create((IElementType[])new IElementType[]{JetTokens.INTEGER_LITERAL, JetTokens.FLOAT_LITERAL, JetTokens.CHARACTER_LITERAL, JetTokens.OPEN_QUOTE, JetTokens.PACKAGE_KEYWORD, JetTokens.AS_KEYWORD, JetTokens.TYPE_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.THIS_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.FOR_KEYWORD, JetTokens.NULL_KEYWORD, JetTokens.TRUE_KEYWORD, JetTokens.FALSE_KEYWORD, JetTokens.IS_KEYWORD, JetTokens.THROW_KEYWORD, JetTokens.RETURN_KEYWORD, JetTokens.BREAK_KEYWORD, JetTokens.CONTINUE_KEYWORD, JetTokens.OBJECT_KEYWORD, JetTokens.IF_KEYWORD, JetTokens.TRY_KEYWORD, JetTokens.ELSE_KEYWORD, JetTokens.WHILE_KEYWORD, JetTokens.DO_KEYWORD, JetTokens.WHEN_KEYWORD, JetTokens.RBRACKET, JetTokens.RBRACE, JetTokens.RPAR, JetTokens.PLUSPLUS, JetTokens.MINUSMINUS, JetTokens.MUL, JetTokens.PLUS, JetTokens.MINUS, JetTokens.EXCL, JetTokens.DIV, JetTokens.PERC, JetTokens.LTEQ, JetTokens.EQEQEQ, JetTokens.EXCLEQEQEQ, JetTokens.EQEQ, JetTokens.EXCLEQ, JetTokens.ANDAND, JetTokens.OROR, JetTokens.SAFE_ACCESS, JetTokens.ELVIS, JetTokens.SEMICOLON, JetTokens.RANGE, JetTokens.EQ, JetTokens.MULTEQ, JetTokens.DIVEQ, JetTokens.PERCEQ, JetTokens.PLUSEQ, JetTokens.MINUSEQ, JetTokens.NOT_IN, JetTokens.NOT_IS, JetTokens.COLON});
        EXPRESSION_FIRST = TokenSet.create((IElementType[])new IElementType[]{JetTokens.MINUS, JetTokens.PLUS, JetTokens.MINUSMINUS, JetTokens.PLUSPLUS, JetTokens.EXCL, JetTokens.LBRACKET, JetTokens.LABEL_IDENTIFIER, JetTokens.AT, JetTokens.ATAT, JetTokens.LPAR, JetTokens.HASH, JetTokens.TRUE_KEYWORD, JetTokens.FALSE_KEYWORD, JetTokens.OPEN_QUOTE, JetTokens.INTEGER_LITERAL, JetTokens.CHARACTER_LITERAL, JetTokens.FLOAT_LITERAL, JetTokens.NULL_KEYWORD, JetTokens.LBRACE, JetTokens.LPAR, JetTokens.THIS_KEYWORD, JetTokens.SUPER_KEYWORD, JetTokens.IF_KEYWORD, JetTokens.WHEN_KEYWORD, JetTokens.TRY_KEYWORD, JetTokens.OBJECT_KEYWORD, JetTokens.THROW_KEYWORD, JetTokens.RETURN_KEYWORD, JetTokens.CONTINUE_KEYWORD, JetTokens.BREAK_KEYWORD, JetTokens.FOR_KEYWORD, JetTokens.WHILE_KEYWORD, JetTokens.DO_KEYWORD, JetTokens.IDENTIFIER, JetTokens.FIELD_IDENTIFIER, JetTokens.PACKAGE_KEYWORD, JetTokens.IDE_TEMPLATE_START});
        STATEMENT_FIRST = TokenSet.orSet((TokenSet[])new TokenSet[]{EXPRESSION_FIRST, TokenSet.create((IElementType[])new IElementType[]{JetTokens.LBRACKET, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.TYPE_KEYWORD}), JetTokens.MODIFIER_KEYWORDS});
        EXPRESSION_FOLLOW = TokenSet.create((IElementType[])new IElementType[]{JetTokens.SEMICOLON, JetTokens.ARROW, JetTokens.COMMA, JetTokens.RBRACE, JetTokens.RPAR, JetTokens.RBRACKET, JetTokens.IDE_TEMPLATE_END});
        ALLOW_NEWLINE_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{JetTokens.DOT, JetTokens.SAFE_ACCESS});
        IElementType[] operations = new HashSet();
        for (Precedence precedence : values = Precedence.values()) {
            operations.addAll(Arrays.asList(precedence.getOperations().getTypes()));
        }
        ALL_OPERATIONS = TokenSet.create((IElementType[])operations.toArray(new IElementType[operations.size()]));
        operations = JetTokens.OPERATIONS.getTypes();
        HashSet<IElementType> opSet = new HashSet<IElementType>(Arrays.asList(operations));
        IElementType[] usedOperations = ALL_OPERATIONS.getTypes();
        HashSet<IElementType> usedSet = new HashSet<IElementType>(Arrays.asList(usedOperations));
        if (opSet.size() > usedSet.size()) {
            opSet.removeAll(usedSet);
            assert (false) : opSet;
        }
        assert (usedSet.size() == opSet.size());
        usedSet.removeAll(opSet);
        assert (usedSet.isEmpty()) : ((Object)usedSet).toString();
    }

    private static class Precedence
    extends Enum<Precedence> {
        public static final /* enum */ Precedence POSTFIX;
        public static final /* enum */ Precedence PREFIX;
        public static final /* enum */ Precedence COLON_AS;
        public static final /* enum */ Precedence MULTIPLICATIVE;
        public static final /* enum */ Precedence ADDITIVE;
        public static final /* enum */ Precedence RANGE;
        public static final /* enum */ Precedence SIMPLE_NAME;
        public static final /* enum */ Precedence ELVIS;
        public static final /* enum */ Precedence IN_OR_IS;
        public static final /* enum */ Precedence COMPARISON;
        public static final /* enum */ Precedence EQUALITY;
        public static final /* enum */ Precedence CONJUNCTION;
        public static final /* enum */ Precedence DISJUNCTION;
        public static final /* enum */ Precedence ASSIGNMENT;
        private Precedence higher;
        private final TokenSet operations;
        private static final /* synthetic */ Precedence[] $VALUES;

        public static Precedence[] values() {
            return (Precedence[])$VALUES.clone();
        }

        public static Precedence valueOf(String name) {
            return Enum.valueOf(Precedence.class, name);
        }

        private Precedence(IElementType ... operations) {
            this.operations = TokenSet.create((IElementType[])operations);
        }

        public void parseHigherPrecedence(JetExpressionParsing parser) {
            assert (this.higher != null);
            parser.parseBinaryExpression(this.higher);
        }

        public JetNodeType parseRightHandSide(IElementType operation, JetExpressionParsing parser) {
            this.parseHigherPrecedence(parser);
            return JetNodeTypes.BINARY_EXPRESSION;
        }

        public final TokenSet getOperations() {
            return this.operations;
        }

        static {
            Precedence[] values;
            POSTFIX = new Precedence(JetTokens.PLUSPLUS, JetTokens.MINUSMINUS, JetTokens.DOT, JetTokens.SAFE_ACCESS, JetTokens.QUEST);
            PREFIX = new Precedence(new IElementType[]{JetTokens.MINUS, JetTokens.PLUS, JetTokens.MINUSMINUS, JetTokens.PLUSPLUS, JetTokens.EXCL, JetTokens.LABEL_IDENTIFIER, JetTokens.AT, JetTokens.ATAT}){

                @Override
                public void parseHigherPrecedence(JetExpressionParsing parser) {
                    throw new IllegalStateException("Don't call this method");
                }
            };
            COLON_AS = new Precedence(new IElementType[]{JetTokens.COLON, JetTokens.AS_KEYWORD, JetTokens.AS_SAFE}){

                @Override
                public JetNodeType parseRightHandSide(IElementType operation, JetExpressionParsing parser) {
                    parser.myJetParsing.parseTypeRef();
                    return JetNodeTypes.BINARY_WITH_TYPE;
                }

                @Override
                public void parseHigherPrecedence(JetExpressionParsing parser) {
                    parser.parsePrefixExpression();
                }
            };
            MULTIPLICATIVE = new Precedence(JetTokens.MUL, JetTokens.DIV, JetTokens.PERC);
            ADDITIVE = new Precedence(JetTokens.PLUS, JetTokens.MINUS);
            RANGE = new Precedence(JetTokens.RANGE);
            SIMPLE_NAME = new Precedence(JetTokens.IDENTIFIER);
            ELVIS = new Precedence(JetTokens.ELVIS);
            IN_OR_IS = new Precedence(new IElementType[]{JetTokens.IN_KEYWORD, JetTokens.NOT_IN, JetTokens.IS_KEYWORD, JetTokens.NOT_IS}){

                @Override
                public JetNodeType parseRightHandSide(IElementType operation, JetExpressionParsing parser) {
                    if (operation == JetTokens.IS_KEYWORD || operation == JetTokens.NOT_IS) {
                        parser.parsePattern();
                        return JetNodeTypes.BINARY_WITH_PATTERN;
                    }
                    return super.parseRightHandSide(operation, parser);
                }
            };
            COMPARISON = new Precedence(JetTokens.LT, JetTokens.GT, JetTokens.LTEQ, JetTokens.GTEQ);
            EQUALITY = new Precedence(JetTokens.EQEQ, JetTokens.EXCLEQ, JetTokens.EQEQEQ, JetTokens.EXCLEQEQEQ);
            CONJUNCTION = new Precedence(JetTokens.ANDAND);
            DISJUNCTION = new Precedence(JetTokens.OROR);
            ASSIGNMENT = new Precedence(JetTokens.EQ, JetTokens.PLUSEQ, JetTokens.MINUSEQ, JetTokens.MULTEQ, JetTokens.DIVEQ, JetTokens.PERCEQ);
            $VALUES = new Precedence[]{POSTFIX, PREFIX, COLON_AS, MULTIPLICATIVE, ADDITIVE, RANGE, SIMPLE_NAME, ELVIS, IN_OR_IS, COMPARISON, EQUALITY, CONJUNCTION, DISJUNCTION, ASSIGNMENT};
            for (Precedence precedence : values = Precedence.values()) {
                int ordinal = precedence.ordinal();
                precedence.higher = ordinal > 0 ? values[ordinal - 1] : null;
            }
        }
    }
}

