/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.diagnostics.Renderer;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;

public class Renderers {
    public static final Renderer<Object> TO_STRING = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@Nullable Object element) {
            return element == null ? "null" : element.toString();
        }

        public String toString() {
            return "TO_STRING";
        }
    };
    public static final Renderer<Object> NAME = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@Nullable Object element) {
            if (element == null) {
                return "null";
            }
            if (element instanceof Named) {
                return ((Named)element).getName();
            }
            return element.toString();
        }
    };
    public static final Renderer<PsiElement> ELEMENT_TEXT = new Renderer<PsiElement>(){

        @Override
        @NotNull
        public String render(@Nullable PsiElement element) {
            if (element == null) {
                return "null";
            }
            return element.getText();
        }
    };
    public static final Renderer<JetClassOrObject> RENDER_CLASS_OR_OBJECT = new Renderer<JetClassOrObject>(){

        @Override
        @NotNull
        public String render(@Nullable JetClassOrObject classOrObject) {
            String name;
            assert (classOrObject != null);
            String string = name = classOrObject.getName() != null ? " '" + classOrObject.getName() + "'" : "";
            if (classOrObject instanceof JetClass) {
                return "Class" + name;
            }
            return "Object" + name;
        }
    };
}

