/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.AbstractDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.RedeclarationDiagnostic;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.resolve.BindingContext;

public class RedeclarationDiagnosticFactory
extends AbstractDiagnosticFactory {
    private final String name;
    final Severity severity;
    private final String messagePrefix;
    public static final RedeclarationDiagnosticFactory REDECLARATION = new RedeclarationDiagnosticFactory("REDECLARATION", Severity.ERROR, "Redeclaration: ");
    public static final RedeclarationDiagnosticFactory NAME_SHADOWING = new RedeclarationDiagnosticFactory("NAME_SHADOWING", Severity.WARNING, "Name shadowed: ");

    public RedeclarationDiagnosticFactory(String name, Severity severity, String messagePrefix) {
        this.name = name;
        this.severity = severity;
        this.messagePrefix = messagePrefix;
    }

    public RedeclarationDiagnostic on(@NotNull PsiElement duplicatingElement, @NotNull String name) {
        return new RedeclarationDiagnostic.SimpleRedeclarationDiagnostic(duplicatingElement, name, this);
    }

    public Diagnostic on(DeclarationDescriptor duplicatingDescriptor, BindingContext contextToResolveToDeclaration) {
        return new RedeclarationDiagnostic.RedeclarationDiagnosticWithDeferredResolution(duplicatingDescriptor, contextToResolveToDeclaration, this);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public String makeMessage(String identifier) {
        return this.messagePrefix + identifier;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

