/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.AbstractDiagnostic;
import org.jetbrains.jet.lang.diagnostics.AbstractDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.RedeclarationDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContext;

public interface RedeclarationDiagnostic
extends Diagnostic<PsiElement> {
    public static final PositioningStrategy<PsiElement> POSITION_REDECLARATION = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            JetFile file;
            PsiElement nameIdentifier;
            if (element instanceof JetNamedDeclaration) {
                PsiElement nameIdentifier2 = ((JetNamedDeclaration)element).getNameIdentifier();
                if (nameIdentifier2 != null) {
                    return 1.markElement(nameIdentifier2);
                }
            } else if (element instanceof JetFile && (nameIdentifier = (file = (JetFile)element).getNamespaceHeader().getNameIdentifier()) != null) {
                return 1.markElement(nameIdentifier);
            }
            return 1.markElement(element);
        }
    };

    public static class RedeclarationDiagnosticWithDeferredResolution
    implements RedeclarationDiagnostic {
        private final DeclarationDescriptor duplicatingDescriptor;
        private final BindingContext contextToResolveToDeclaration;
        private final RedeclarationDiagnosticFactory factory;
        private PsiElement element;

        public RedeclarationDiagnosticWithDeferredResolution(@NotNull DeclarationDescriptor duplicatingDescriptor, @NotNull BindingContext contextToResolveToDeclaration, RedeclarationDiagnosticFactory factory) {
            this.duplicatingDescriptor = duplicatingDescriptor;
            this.contextToResolveToDeclaration = contextToResolveToDeclaration;
            this.factory = factory;
        }

        private PsiElement resolve() {
            if (this.element == null) {
                this.element = this.contextToResolveToDeclaration.get(BindingContext.DESCRIPTOR_TO_DECLARATION, this.duplicatingDescriptor);
                assert (this.element != null) : "No element for descriptor: " + this.duplicatingDescriptor;
            }
            return this.element;
        }

        @Override
        @NotNull
        public PsiElement getPsiElement() {
            return this.resolve();
        }

        @Override
        @NotNull
        public List<TextRange> getTextRanges() {
            return POSITION_REDECLARATION.mark(this.getPsiElement());
        }

        @Override
        @NotNull
        public PsiFile getPsiFile() {
            return this.resolve().getContainingFile();
        }

        @Override
        @NotNull
        public AbstractDiagnosticFactory getFactory() {
            return this.factory;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.factory.makeMessage(this.duplicatingDescriptor.getName());
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.factory.severity;
        }
    }

    public static class SimpleRedeclarationDiagnostic
    extends AbstractDiagnostic<PsiElement>
    implements RedeclarationDiagnostic {
        public SimpleRedeclarationDiagnostic(@NotNull PsiElement psiElement, @NotNull String name, RedeclarationDiagnosticFactory factory) {
            super(psiElement, factory, factory.severity, factory.makeMessage(name));
        }

        @Override
        @NotNull
        public List<TextRange> getTextRanges() {
            return POSITION_REDECLARATION.mark(this.getPsiElement());
        }
    }
}

