/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class PositioningStrategies {
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy();
    public static final PositioningStrategy<JetFunction> MARK_FUNCTION = new PositioningStrategy<JetFunction>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetFunction function) {
            PsiElement nameIdentifier = function.getNameIdentifier();
            JetTypeReference returnTypeRef = function.getReturnTypeRef();
            JetParameterList valueParameterList = function.getValueParameterList();
            TextRange textRange = nameIdentifier == null ? TextRange.from((int)function.getTextRange().getEndOffset(), (int)0) : (returnTypeRef != null ? TextRange.from((int)returnTypeRef.getTextRange().getEndOffset(), (int)1) : (valueParameterList != null ? TextRange.from((int)valueParameterList.getTextRange().getEndOffset(), (int)1) : TextRange.from((int)nameIdentifier.getTextRange().getEndOffset(), (int)1)));
            return 1.markRange(textRange);
        }
    };
    public static final PositioningStrategy<JetDeclaration> POSITION_DECLARATION = new PositioningStrategy<JetDeclaration>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclaration declaration) {
            JetTypeReference returnTypeRef = null;
            ASTNode nameNode = null;
            if (declaration instanceof JetNamedFunction) {
                JetNamedFunction function = (JetNamedFunction)declaration;
                returnTypeRef = function.getReturnTypeRef();
                nameNode = this.getNameNode(function);
            } else if (declaration instanceof JetProperty) {
                JetProperty property = (JetProperty)declaration;
                returnTypeRef = property.getPropertyTypeRef();
                nameNode = this.getNameNode(property);
            } else if (declaration instanceof JetPropertyAccessor) {
                JetPropertyAccessor accessor = (JetPropertyAccessor)declaration;
                returnTypeRef = accessor.getReturnTypeReference();
                nameNode = accessor.getNamePlaceholder().getNode();
            }
            if (returnTypeRef != null) {
                return Collections.singletonList(returnTypeRef.getTextRange());
            }
            if (nameNode != null) {
                return Collections.singletonList(nameNode.getTextRange());
            }
            return super.mark(declaration);
        }

        private ASTNode getNameNode(JetNamedDeclaration function) {
            PsiElement nameIdentifier = function.getNameIdentifier();
            return nameIdentifier == null ? null : nameIdentifier.getNode();
        }
    };
    public static final PositioningStrategy<PsiNameIdentifierOwner> POSITION_NAME_IDENTIFIER = new PositioningStrategy<PsiNameIdentifierOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiNameIdentifierOwner element) {
            PsiElement nameIdentifier = element.getNameIdentifier();
            if (nameIdentifier != null) {
                return 3.markElement(nameIdentifier);
            }
            return Collections.emptyList();
        }
    };
    public static final PositioningStrategy<JetModifierListOwner> POSITION_ABSTRACT_MODIFIER = PositioningStrategies.positionModifier(JetTokens.ABSTRACT_KEYWORD);

    public static PositioningStrategy<JetModifierListOwner> positionModifier(final JetKeywordToken token) {
        return new PositioningStrategy<JetModifierListOwner>(){

            @Override
            @NotNull
            public List<TextRange> mark(@NotNull JetModifierListOwner modifierListOwner) {
                if (modifierListOwner.hasModifier(token)) {
                    JetModifierList modifierList = modifierListOwner.getModifierList();
                    assert (modifierList != null);
                    ASTNode node = modifierList.getModifierNode(token);
                    assert (node != null);
                    return Collections.singletonList(node.getTextRange());
                }
                return Collections.emptyList();
            }
        };
    }
}

