/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.AbstractDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.AmbiguousDescriptorDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory2;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory3;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategies;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.RedeclarationDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Renderer;
import org.jetbrains.jet.lang.diagnostics.Renderers;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.diagnostics.UnresolvedReferenceDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.UnusedElementDiagnosticFactory;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperClass;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIdeTemplateExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetRootNamespaceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetTuplePattern;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.calls.inference.SolutionStatus;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.resolve.DescriptorRenderer;

public interface Errors {
    public static final DiagnosticFactory1<JetFile, Throwable> EXCEPTION_WHILE_ANALYZING = DiagnosticFactory1.create(Severity.ERROR, "{0}", new Renderer<Throwable>(){

        @Override
        @NotNull
        public String render(@Nullable Throwable e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
    });
    public static final UnresolvedReferenceDiagnosticFactory UNRESOLVED_REFERENCE = UnresolvedReferenceDiagnosticFactory.create("Unresolved reference");
    public static final RedeclarationDiagnosticFactory REDECLARATION = RedeclarationDiagnosticFactory.REDECLARATION;
    public static final RedeclarationDiagnosticFactory NAME_SHADOWING = RedeclarationDiagnosticFactory.NAME_SHADOWING;
    public static final DiagnosticFactory2<PsiElement, JetType, JetType> TYPE_MISMATCH = DiagnosticFactory2.create(Severity.ERROR, "Type mismatch: inferred type is {1} but {0} was expected");
    public static final DiagnosticFactory1<PsiElement, Collection<JetKeywordToken>> INCOMPATIBLE_MODIFIERS = DiagnosticFactory1.create(Severity.ERROR, "Incompatible modifiers: ''{0}''", new Renderer<Collection<JetKeywordToken>>(){

        @Override
        @NotNull
        public String render(@Nullable Collection<JetKeywordToken> element) {
            assert (element != null);
            StringBuilder sb = new StringBuilder();
            Iterator<JetKeywordToken> iterator = element.iterator();
            while (iterator.hasNext()) {
                JetKeywordToken modifier = iterator.next();
                sb.append(modifier.getValue());
                if (!iterator.hasNext()) continue;
                sb.append(" ");
            }
            return sb.toString();
        }
    });
    public static final DiagnosticFactory1<PsiElement, JetKeywordToken> ILLEGAL_MODIFIER = DiagnosticFactory1.create(Severity.ERROR, "Illegal modifier ''{0}''");
    public static final DiagnosticFactory2<PsiElement, JetKeywordToken, JetKeywordToken> REDUNDANT_MODIFIER = DiagnosticFactory2.create(Severity.WARNING, "Modifier {0} is redundant because {1} is present");
    public static final DiagnosticFactory<JetModifierListOwner> ABSTRACT_MODIFIER_IN_TRAIT = DiagnosticFactory.create(Severity.WARNING, "Modifier ''{0}'' is redundant in trait", PositioningStrategies.POSITION_ABSTRACT_MODIFIER);
    public static final DiagnosticFactory<JetModifierListOwner> OPEN_MODIFIER_IN_TRAIT = DiagnosticFactory.create(Severity.WARNING, "Modifier ''{0}'' is redundant in trait", PositioningStrategies.positionModifier(JetTokens.OPEN_KEYWORD));
    public static final DiagnosticFactory<PsiElement> REDUNDANT_MODIFIER_IN_GETTER = DiagnosticFactory.create(Severity.WARNING, "Visibility modifiers are redundant in getter");
    public static final DiagnosticFactory<PsiElement> TRAIT_CAN_NOT_BE_FINAL = DiagnosticFactory.create(Severity.ERROR, "Trait can not be final");
    public static final DiagnosticFactory<JetExpression> TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM = DiagnosticFactory.create(Severity.ERROR, "Type checking has run into a recursive problem. Easiest workaround: specify types of your declarations explicitly");
    public static final DiagnosticFactory<JetReturnExpression> RETURN_NOT_ALLOWED = DiagnosticFactory.create(Severity.ERROR, "'return' is not allowed here");
    public static final DiagnosticFactory<JetTypeProjection> PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE = DiagnosticFactory.create(Severity.ERROR, "Projections are not allowed for immediate arguments of a supertype", new PositioningStrategy<JetTypeProjection>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetTypeProjection element) {
            return 3.markNode(element.getProjectionNode());
        }
    });
    public static final DiagnosticFactory<JetSimpleNameExpression> LABEL_NAME_CLASH = DiagnosticFactory.create(Severity.WARNING, "There is more than one label with such a name in this scope");
    public static final DiagnosticFactory<JetSimpleNameExpression> EXPRESSION_EXPECTED_NAMESPACE_FOUND = DiagnosticFactory.create(Severity.ERROR, "Expression expected, but a namespace name found");
    public static final DiagnosticFactory1<JetSimpleNameExpression, DeclarationDescriptor> CANNOT_IMPORT_FROM_ELEMENT = DiagnosticFactory1.create(Severity.ERROR, "Cannot import from ''{0}''", Renderers.NAME);
    public static final DiagnosticFactory1<JetSimpleNameExpression, DeclarationDescriptor> CANNOT_BE_IMPORTED = DiagnosticFactory1.create(Severity.ERROR, "Cannot import ''{0}'', functions and properties can be imported only from packages", Renderers.NAME);
    public static final DiagnosticFactory<JetExpression> USELESS_HIDDEN_IMPORT = DiagnosticFactory.create(Severity.WARNING, "Useless import, it is hidden further");
    public static final DiagnosticFactory<JetExpression> USELESS_SIMPLE_IMPORT = DiagnosticFactory.create(Severity.WARNING, "Useless import, does nothing");
    public static final DiagnosticFactory<JetParameter> CANNOT_INFER_PARAMETER_TYPE = DiagnosticFactory.create(Severity.ERROR, "Cannot infer a type for this parameter. To specify it explicitly use the {(p : Type) => ...} notation");
    public static final DiagnosticFactory<JetElement> NO_BACKING_FIELD_ABSTRACT_PROPERTY = DiagnosticFactory.create(Severity.ERROR, "This property doesn't have a backing field, because it's abstract");
    public static final DiagnosticFactory<JetElement> NO_BACKING_FIELD_CUSTOM_ACCESSORS = DiagnosticFactory.create(Severity.ERROR, "This property doesn't have a backing field, because it has custom accessors without reference to the backing field");
    public static final DiagnosticFactory<JetElement> INACCESSIBLE_BACKING_FIELD = DiagnosticFactory.create(Severity.ERROR, "The backing field is not accessible here");
    public static final DiagnosticFactory<JetElement> NOT_PROPERTY_BACKING_FIELD = DiagnosticFactory.create(Severity.ERROR, "The referenced variable is not a property and doesn't have backing field");
    public static final DiagnosticFactory<PsiElement> MIXING_NAMED_AND_POSITIONED_ARGUMENTS = DiagnosticFactory.create(Severity.ERROR, "Mixing named and positioned arguments in not allowed");
    public static final DiagnosticFactory<JetReferenceExpression> ARGUMENT_PASSED_TWICE = DiagnosticFactory.create(Severity.ERROR, "An argument is already passed for this parameter");
    public static final UnresolvedReferenceDiagnosticFactory NAMED_PARAMETER_NOT_FOUND = UnresolvedReferenceDiagnosticFactory.create("Cannot find a parameter with this name");
    public static final DiagnosticFactory<JetExpression> VARARG_OUTSIDE_PARENTHESES = DiagnosticFactory.create(Severity.ERROR, "Passing value as a vararg is only allowed inside a parenthesized argument list");
    public static final DiagnosticFactory<JetExpression> MANY_FUNCTION_LITERAL_ARGUMENTS = DiagnosticFactory.create(Severity.ERROR, "Only one function literal is allowed outside a parenthesized argument list");
    public static final DiagnosticFactory<PsiElement> PROPERTY_WITH_NO_TYPE_NO_INITIALIZER = DiagnosticFactory.create(Severity.ERROR, "This property must either have a type annotation or be initialized");
    public static final DiagnosticFactory<JetElement> FUNCTION_WITH_NO_TYPE_NO_BODY = DiagnosticFactory.create(Severity.ERROR, "This function must either declare a return type or have a body element");
    public static final DiagnosticFactory<JetModifierListOwner> ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS = DiagnosticFactory.create(Severity.ERROR, "This property cannot be declared abstract", PositioningStrategies.POSITION_ABSTRACT_MODIFIER);
    public static final DiagnosticFactory<JetProperty> ABSTRACT_PROPERTY_NOT_IN_CLASS = DiagnosticFactory.create(Severity.ERROR, "A property may be abstract only when defined in a class or trait", PositioningStrategies.POSITION_ABSTRACT_MODIFIER);
    public static final DiagnosticFactory<JetExpression> ABSTRACT_PROPERTY_WITH_INITIALIZER = DiagnosticFactory.create(Severity.ERROR, "Property with initializer cannot be abstract");
    public static final DiagnosticFactory<JetPropertyAccessor> ABSTRACT_PROPERTY_WITH_GETTER = DiagnosticFactory.create(Severity.ERROR, "Property with getter implementation cannot be abstract");
    public static final DiagnosticFactory<JetPropertyAccessor> ABSTRACT_PROPERTY_WITH_SETTER = DiagnosticFactory.create(Severity.ERROR, "Property with setter implementation cannot be abstract");
    public static final DiagnosticFactory<PsiElement> GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY = DiagnosticFactory.create(Severity.ERROR, "Getter visibility must be the same as property visibility");
    public static final DiagnosticFactory BACKING_FIELD_IN_TRAIT = DiagnosticFactory.create(Severity.ERROR, "Property in a trait cannot have a backing field");
    public static final DiagnosticFactory MUST_BE_INITIALIZED = DiagnosticFactory.create(Severity.ERROR, "Property must be initialized");
    public static final DiagnosticFactory<PsiElement> MUST_BE_INITIALIZED_OR_BE_ABSTRACT = DiagnosticFactory.create(Severity.ERROR, "Property must be initialized or be abstract");
    public static final DiagnosticFactory<JetExpression> PROPERTY_INITIALIZER_IN_TRAIT = DiagnosticFactory.create(Severity.ERROR, "Property initializers are not allowed in traits");
    public static final DiagnosticFactory PROPERTY_INITIALIZER_NO_BACKING_FIELD = DiagnosticFactory.create(Severity.ERROR, "Initializer is not allowed here because this property has no backing field");
    public static final DiagnosticFactory3<JetModifierListOwner, String, ClassDescriptor, JetClass> ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS = DiagnosticFactory3.create(Severity.ERROR, "Abstract property {0} in non-abstract class {1}", PositioningStrategies.POSITION_ABSTRACT_MODIFIER);
    public static final DiagnosticFactory3<JetFunction, String, ClassDescriptor, JetClass> ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS = DiagnosticFactory3.create(Severity.ERROR, "Abstract function {0} in non-abstract class {1}", PositioningStrategies.POSITION_ABSTRACT_MODIFIER);
    public static final DiagnosticFactory1<PsiElement, SimpleFunctionDescriptor> ABSTRACT_FUNCTION_WITH_BODY = DiagnosticFactory1.create(Severity.ERROR, "A function {0} with body cannot be abstract");
    public static final DiagnosticFactory1<JetFunction, SimpleFunctionDescriptor> NON_ABSTRACT_FUNCTION_WITH_NO_BODY = DiagnosticFactory1.create(Severity.ERROR, "Method {0} without a body must be abstract", PositioningStrategies.POSITION_NAME_IDENTIFIER);
    public static final DiagnosticFactory1<JetModifierListOwner, SimpleFunctionDescriptor> NON_MEMBER_ABSTRACT_FUNCTION = DiagnosticFactory1.create(Severity.ERROR, "Function {0} is not a class or trait member and cannot be abstract", PositioningStrategies.POSITION_ABSTRACT_MODIFIER);
    public static final DiagnosticFactory1<JetFunction, SimpleFunctionDescriptor> NON_MEMBER_FUNCTION_NO_BODY = DiagnosticFactory1.create(Severity.ERROR, "Function {0} must have a body", PositioningStrategies.POSITION_NAME_IDENTIFIER);
    public static final DiagnosticFactory<PsiElement> NON_FINAL_MEMBER_IN_FINAL_CLASS = DiagnosticFactory.create(Severity.ERROR, "Non final member in a final class");
    public static final DiagnosticFactory<PsiElement> PUBLIC_MEMBER_SHOULD_SPECIFY_TYPE = DiagnosticFactory.create(Severity.ERROR, "Public or protected member should specify a type");
    public static final DiagnosticFactory<JetTypeProjection> PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT = DiagnosticFactory.create(Severity.ERROR, "Projections are not allowed on type arguments of functions and properties");
    public static final DiagnosticFactory<JetDelegatorToSuperClass> SUPERTYPE_NOT_INITIALIZED = DiagnosticFactory.create(Severity.ERROR, "This type has a constructor, and thus must be initialized here");
    public static final DiagnosticFactory<JetDelegatorToSuperClass> SUPERTYPE_NOT_INITIALIZED_DEFAULT = DiagnosticFactory.create(Severity.ERROR, "Constructor invocation should be explicitly specified");
    public static final DiagnosticFactory<PsiElement> SECONDARY_CONSTRUCTOR_BUT_NO_PRIMARY = DiagnosticFactory.create(Severity.ERROR, "A secondary constructor may appear only in a class that has a primary constructor");
    public static final DiagnosticFactory<PsiElement> SECONDARY_CONSTRUCTOR_NO_INITIALIZER_LIST = DiagnosticFactory.create(Severity.ERROR, "Secondary constructors must have an initializer list");
    public static final DiagnosticFactory<JetDelegatorByExpressionSpecifier> BY_IN_SECONDARY_CONSTRUCTOR = DiagnosticFactory.create(Severity.ERROR, "'by'-clause is only supported for primary constructors");
    public static final DiagnosticFactory<JetDelegatorToSuperClass> INITIALIZER_WITH_NO_ARGUMENTS = DiagnosticFactory.create(Severity.ERROR, "Constructor arguments required");
    public static final DiagnosticFactory<JetDelegationSpecifier> MANY_CALLS_TO_THIS = DiagnosticFactory.create(Severity.ERROR, "Only one call to 'this(...)' is allowed");
    public static final DiagnosticFactory1<JetModifierListOwner, CallableMemberDescriptor> NOTHING_TO_OVERRIDE = DiagnosticFactory1.create(Severity.ERROR, "{0} overrides nothing", PositioningStrategies.positionModifier(JetTokens.OVERRIDE_KEYWORD), DescriptorRenderer.TEXT);
    public static final DiagnosticFactory3<PsiNameIdentifierOwner, CallableMemberDescriptor, CallableMemberDescriptor, DeclarationDescriptor> VIRTUAL_MEMBER_HIDDEN = DiagnosticFactory3.create(Severity.ERROR, "''{0}'' hides ''{1}'' in class {2} and needs 'override' modifier", PositioningStrategies.POSITION_NAME_IDENTIFIER, DescriptorRenderer.TEXT, DescriptorRenderer.TEXT, DescriptorRenderer.TEXT);
    public static final DiagnosticFactory1<JetClass, ClassDescriptor> ENUM_ENTRY_SHOULD_BE_INITIALIZED = DiagnosticFactory1.create(Severity.ERROR, "Missing delegation specifier ''{0}''", PositioningStrategies.POSITION_NAME_IDENTIFIER, Renderers.NAME);
    public static final DiagnosticFactory1<JetTypeReference, ClassDescriptor> ENUM_ENTRY_ILLEGAL_TYPE = DiagnosticFactory1.create(Severity.ERROR, "The type constructor of enum entry should be ''{0}''", Renderers.NAME);
    public static final DiagnosticFactory1<JetSimpleNameExpression, VariableDescriptor> UNINITIALIZED_VARIABLE = DiagnosticFactory1.create(Severity.ERROR, "Variable ''{0}'' must be initialized", Renderers.NAME);
    public static final DiagnosticFactory1<JetSimpleNameExpression, ValueParameterDescriptor> UNINITIALIZED_PARAMETER = DiagnosticFactory1.create(Severity.ERROR, "Parameter ''{0}'' is uninitialized here", Renderers.NAME);
    public static final UnusedElementDiagnosticFactory<JetProperty, VariableDescriptor> UNUSED_VARIABLE = UnusedElementDiagnosticFactory.create(Severity.WARNING, "Variable ''{0}'' is never used", PositioningStrategies.POSITION_NAME_IDENTIFIER, Renderers.NAME);
    public static final UnusedElementDiagnosticFactory<JetParameter, VariableDescriptor> UNUSED_PARAMETER = UnusedElementDiagnosticFactory.create(Severity.WARNING, "Parameter ''{0}'' is never used", PositioningStrategies.POSITION_NAME_IDENTIFIER, Renderers.NAME);
    public static final UnusedElementDiagnosticFactory<JetNamedDeclaration, DeclarationDescriptor> ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE = UnusedElementDiagnosticFactory.create(Severity.WARNING, "Variable ''{0}'' is assigned but never accessed", PositioningStrategies.POSITION_NAME_IDENTIFIER, Renderers.NAME);
    public static final DiagnosticFactory1<JetExpression, DeclarationDescriptor> VARIABLE_WITH_REDUNDANT_INITIALIZER = DiagnosticFactory1.create(Severity.WARNING, "Variable ''{0}'' initializer is redundant", Renderers.NAME);
    public static final DiagnosticFactory2<JetElement, JetElement, DeclarationDescriptor> UNUSED_VALUE = DiagnosticFactory2.create(Severity.WARNING, "The value ''{0}'' assigned to ''{1}'' is never used", Renderers.ELEMENT_TEXT, Renderers.TO_STRING);
    public static final DiagnosticFactory1<JetElement, JetElement> UNUSED_CHANGED_VALUE = DiagnosticFactory1.create(Severity.WARNING, "The value changed at ''{0}'' is never used", Renderers.ELEMENT_TEXT);
    public static final DiagnosticFactory<JetElement> UNUSED_EXPRESSION = DiagnosticFactory.create(Severity.WARNING, "The expression is unused");
    public static final DiagnosticFactory<JetFunctionLiteralExpression> UNUSED_FUNCTION_LITERAL = DiagnosticFactory.create(Severity.WARNING, "The function literal is unused. If you mean block, you can use 'run { ... }'");
    public static final DiagnosticFactory1<JetExpression, DeclarationDescriptor> VAL_REASSIGNMENT = DiagnosticFactory1.create(Severity.ERROR, "Val can not be reassigned", Renderers.NAME);
    public static final DiagnosticFactory1<JetExpression, DeclarationDescriptor> INITIALIZATION_BEFORE_DECLARATION = DiagnosticFactory1.create(Severity.ERROR, "Variable cannot be initialized before declaration", Renderers.NAME);
    public static final DiagnosticFactory<JetExpression> VARIABLE_EXPECTED = DiagnosticFactory.create(Severity.ERROR, "Variable expected");
    public static final DiagnosticFactory1<JetExpression, DeclarationDescriptor> INITIALIZATION_USING_BACKING_FIELD_CUSTOM_SETTER = DiagnosticFactory1.create(Severity.ERROR, "This property has a custom setter, so initialization using backing field required", Renderers.NAME);
    public static final DiagnosticFactory1<JetExpression, DeclarationDescriptor> INITIALIZATION_USING_BACKING_FIELD_OPEN_SETTER = DiagnosticFactory1.create(Severity.ERROR, "Setter of this property can be overridden, so initialization using backing field required", Renderers.NAME);
    public static final DiagnosticFactory1<JetSimpleNameExpression, DeclarationDescriptor> FUNCTION_PARAMETERS_OF_INLINE_FUNCTION = DiagnosticFactory1.create(Severity.ERROR, "Function parameters of inline function can only be invoked", Renderers.NAME);
    public static final DiagnosticFactory<JetElement> UNREACHABLE_CODE = DiagnosticFactory.create(Severity.ERROR, "Unreachable code");
    public static final DiagnosticFactory<JetClassObject> MANY_CLASS_OBJECTS = DiagnosticFactory.create(Severity.ERROR, "Only one class object is allowed per class");
    public static final DiagnosticFactory<JetClassObject> CLASS_OBJECT_NOT_ALLOWED = DiagnosticFactory.create(Severity.ERROR, "A class object is not allowed here");
    public static final DiagnosticFactory<JetDelegatorByExpressionSpecifier> DELEGATION_IN_TRAIT = DiagnosticFactory.create(Severity.ERROR, "Traits cannot use delegation");
    public static final DiagnosticFactory<JetTypeReference> DELEGATION_NOT_TO_TRAIT = DiagnosticFactory.create(Severity.ERROR, "Only traits can be delegated to");
    public static final DiagnosticFactory<PsiElement> NO_CONSTRUCTOR = DiagnosticFactory.create(Severity.ERROR, "This class does not have a constructor");
    public static final DiagnosticFactory<JetExpression> NOT_A_CLASS = DiagnosticFactory.create(Severity.ERROR, "Not a class");
    public static final DiagnosticFactory<JetEscapeStringTemplateEntry> ILLEGAL_ESCAPE_SEQUENCE = DiagnosticFactory.create(Severity.ERROR, "Illegal escape sequence");
    public static final DiagnosticFactory<JetTypeReference> LOCAL_EXTENSION_PROPERTY = DiagnosticFactory.create(Severity.ERROR, "Local extension properties are not allowed");
    public static final DiagnosticFactory<JetPropertyAccessor> LOCAL_VARIABLE_WITH_GETTER = DiagnosticFactory.create(Severity.ERROR, "Local variables are not allowed to have getters");
    public static final DiagnosticFactory<JetPropertyAccessor> LOCAL_VARIABLE_WITH_SETTER = DiagnosticFactory.create(Severity.ERROR, "Local variables are not allowed to have setters");
    public static final DiagnosticFactory<JetPropertyAccessor> VAL_WITH_SETTER = DiagnosticFactory.create(Severity.ERROR, "A 'val'-property cannot have a setter");
    public static final DiagnosticFactory<JetArrayAccessExpression> NO_GET_METHOD = DiagnosticFactory.create(Severity.ERROR, "No get method providing array access", new PositioningStrategy<JetArrayAccessExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetArrayAccessExpression element) {
            return 4.markElement((PsiElement)element.getIndicesNode());
        }
    });
    public static final DiagnosticFactory<JetArrayAccessExpression> NO_SET_METHOD = DiagnosticFactory.create(Severity.ERROR, "No set method providing array access", new PositioningStrategy<JetArrayAccessExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetArrayAccessExpression element) {
            return 5.markElement((PsiElement)element.getIndicesNode());
        }
    });
    public static final DiagnosticFactory<JetSimpleNameExpression> INC_DEC_SHOULD_NOT_RETURN_UNIT = DiagnosticFactory.create(Severity.ERROR, "Functions inc(), dec() shouldn't return Unit to be used by operators ++, --");
    public static final DiagnosticFactory2<JetSimpleNameExpression, DeclarationDescriptor, JetSimpleNameExpression> ASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT = DiagnosticFactory2.create(Severity.ERROR, "Function ''{0}'' should return Unit to be used by corresponding operator ''{1}''", Renderers.NAME, Renderers.ELEMENT_TEXT);
    public static final AmbiguousDescriptorDiagnosticFactory ASSIGN_OPERATOR_AMBIGUITY = AmbiguousDescriptorDiagnosticFactory.create("Assignment operators ambiguity: {0}");
    public static final DiagnosticFactory<JetSimpleNameExpression> EQUALS_MISSING = DiagnosticFactory.create(Severity.ERROR, "No method 'equals(Any?) : Boolean' available");
    public static final DiagnosticFactory<JetBinaryExpression> ASSIGNMENT_IN_EXPRESSION_CONTEXT = DiagnosticFactory.create(Severity.ERROR, "Assignments are not expressions, and only expressions are allowed in this context");
    public static final DiagnosticFactory<JetRootNamespaceExpression> NAMESPACE_IS_NOT_AN_EXPRESSION = DiagnosticFactory.create(Severity.ERROR, "'namespace' is not an expression, it can only be used on the left-hand side of a dot ('.')");
    public static final DiagnosticFactory1<JetSuperExpression, String> SUPER_IS_NOT_AN_EXPRESSION = DiagnosticFactory1.create(Severity.ERROR, "{0} is not an expression, it can only be used on the left-hand side of a dot ('.')");
    public static final DiagnosticFactory<JetDeclaration> DECLARATION_IN_ILLEGAL_CONTEXT = DiagnosticFactory.create(Severity.ERROR, "Declarations are not allowed in this position");
    public static final DiagnosticFactory<JetExpression> SETTER_PARAMETER_WITH_DEFAULT_VALUE = DiagnosticFactory.create(Severity.ERROR, "Setter parameters can not have default values");
    public static final DiagnosticFactory<JetThisExpression> NO_THIS = DiagnosticFactory.create(Severity.ERROR, "'this' is not defined in this context");
    public static final DiagnosticFactory<JetSuperExpression> SUPER_NOT_AVAILABLE = DiagnosticFactory.create(Severity.ERROR, "No supertypes are accessible in this context");
    public static final DiagnosticFactory<JetSuperExpression> AMBIGUOUS_SUPER = DiagnosticFactory.create(Severity.ERROR, "Many supertypes available, please specify the one you mean in angle brackets, e.g. 'super<Foo>'");
    public static final DiagnosticFactory<JetExpression> ABSTRACT_SUPER_CALL = DiagnosticFactory.create(Severity.ERROR, "Abstarct member cannot be accessed directly");
    public static final DiagnosticFactory<JetTypeReference> NOT_A_SUPERTYPE = DiagnosticFactory.create(Severity.ERROR, "Not a supertype");
    public static final DiagnosticFactory<PsiElement> TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER = DiagnosticFactory.create(Severity.WARNING, "Type arguments do not need to be specified in a 'super' qualifier");
    public static final DiagnosticFactory<JetWhenExpression> NO_WHEN_ENTRIES = DiagnosticFactory.create(Severity.ERROR, "Entries are required for when-expression");
    public static final DiagnosticFactory<JetSimpleNameExpression> USELESS_CAST_STATIC_ASSERT_IS_FINE = DiagnosticFactory.create(Severity.WARNING, "No cast needed, use ':' instead");
    public static final DiagnosticFactory<JetSimpleNameExpression> USELESS_CAST = DiagnosticFactory.create(Severity.WARNING, "No cast needed");
    public static final DiagnosticFactory<JetSimpleNameExpression> CAST_NEVER_SUCCEEDS = DiagnosticFactory.create(Severity.WARNING, "This cast can never succeed");
    public static final DiagnosticFactory1<JetTypeReference, JetType> WRONG_SETTER_PARAMETER_TYPE = DiagnosticFactory1.create(Severity.ERROR, "Setter parameter type must be equal to the type of the property, i.e. {0}");
    public static final DiagnosticFactory1<JetTypeReference, JetType> WRONG_GETTER_RETURN_TYPE = DiagnosticFactory1.create(Severity.ERROR, "Getter return type must be equal to the type of the property, i.e. {0}");
    public static final DiagnosticFactory1<JetSimpleNameExpression, ClassifierDescriptor> NO_CLASS_OBJECT = DiagnosticFactory1.create(Severity.ERROR, "Please specify constructor invocation; classifier {0} does not have a class object", Renderers.NAME);
    public static final DiagnosticFactory<PsiElement> NO_GENERICS_IN_SUPERTYPE_SPECIFIER = DiagnosticFactory.create(Severity.ERROR, "Generic arguments of the base type must be specified");
    public static final DiagnosticFactory<JetExpression> HAS_NEXT_PROPERTY_AND_FUNCTION_AMBIGUITY = DiagnosticFactory.create(Severity.ERROR, "An ambiguity between 'iterator().hasNext()' function and 'iterator().hasNext' property");
    public static final DiagnosticFactory<JetExpression> HAS_NEXT_MISSING = DiagnosticFactory.create(Severity.ERROR, "Loop range must have an 'iterator().hasNext()' function or an 'iterator().hasNext' property");
    public static final DiagnosticFactory<JetExpression> HAS_NEXT_FUNCTION_AMBIGUITY = DiagnosticFactory.create(Severity.ERROR, "Function 'iterator().hasNext()' is ambiguous for this expression");
    public static final DiagnosticFactory<JetExpression> HAS_NEXT_MUST_BE_READABLE = DiagnosticFactory.create(Severity.ERROR, "The 'iterator().hasNext' property of the loop range must be readable");
    public static final DiagnosticFactory1<JetExpression, JetType> HAS_NEXT_PROPERTY_TYPE_MISMATCH = DiagnosticFactory1.create(Severity.ERROR, "The 'iterator().hasNext' property of the loop range must return Boolean, but returns {0}");
    public static final DiagnosticFactory1<JetExpression, JetType> HAS_NEXT_FUNCTION_TYPE_MISMATCH = DiagnosticFactory1.create(Severity.ERROR, "The 'iterator().hasNext()' function of the loop range must return Boolean, but returns {0}");
    public static final DiagnosticFactory<JetExpression> NEXT_AMBIGUITY = DiagnosticFactory.create(Severity.ERROR, "Function 'iterator().next()' is ambiguous for this expression");
    public static final DiagnosticFactory<JetExpression> NEXT_MISSING = DiagnosticFactory.create(Severity.ERROR, "Loop range must have an 'iterator().next()' function");
    public static final DiagnosticFactory<JetExpression> ITERATOR_MISSING = DiagnosticFactory.create(Severity.ERROR, "For-loop range must have an iterator() method");
    public static final AmbiguousDescriptorDiagnosticFactory ITERATOR_AMBIGUITY = AmbiguousDescriptorDiagnosticFactory.create("Method 'iterator()' is ambiguous for this expression: {0}");
    public static final DiagnosticFactory1<JetSimpleNameExpression, JetType> COMPARE_TO_TYPE_MISMATCH = DiagnosticFactory1.create(Severity.ERROR, "compareTo() must return Int, but returns {0}");
    public static final DiagnosticFactory1<JetExpression, JetType> CALLEE_NOT_A_FUNCTION = DiagnosticFactory1.create(Severity.ERROR, "Expecting a function type, but found {0}");
    public static final DiagnosticFactory<JetReturnExpression> RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY = DiagnosticFactory.create(Severity.ERROR, "Returns are not allowed for functions with expression body. Use block body in '{...}'");
    public static final DiagnosticFactory<JetExpression> NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY = DiagnosticFactory.create(Severity.ERROR, "A 'return' expression required in a function with a block body ('{...}')");
    public static final DiagnosticFactory1<JetExpression, JetType> RETURN_TYPE_MISMATCH = DiagnosticFactory1.create(Severity.ERROR, "This function must return a value of type {0}");
    public static final DiagnosticFactory1<JetExpression, JetType> EXPECTED_TYPE_MISMATCH = DiagnosticFactory1.create(Severity.ERROR, "Expected a value of type {0}");
    public static final DiagnosticFactory1<JetBinaryExpression, JetType> ASSIGNMENT_TYPE_MISMATCH = DiagnosticFactory1.create(Severity.ERROR, "Expected a value of type {0}. Assignment operation is not an expression, so it does not return any value");
    public static final DiagnosticFactory1<JetExpression, JetType> IMPLICIT_CAST_TO_UNIT_OR_ANY = DiagnosticFactory1.create(Severity.WARNING, "Type was casted to ''{0}''. Please specify ''{0}'' as expected type, if you mean such cast");
    public static final DiagnosticFactory1<JetExpression, JetExpression> EXPRESSION_EXPECTED = DiagnosticFactory1.create(Severity.ERROR, "{0} is not an expression, and only expression are allowed here", new Renderer<JetExpression>(){

        @Override
        @NotNull
        public String render(@Nullable JetExpression expression) {
            assert (expression != null);
            String expressionType = expression.toString();
            return expressionType.substring(0, 1) + expressionType.substring(1).toLowerCase();
        }
    });
    public static final DiagnosticFactory1<JetTypeReference, JetType> UPPER_BOUND_VIOLATED = DiagnosticFactory1.create(Severity.ERROR, "An upper bound {0} is violated");
    public static final DiagnosticFactory1<JetTypeReference, JetType> FINAL_CLASS_OBJECT_UPPER_BOUND = DiagnosticFactory1.create(Severity.ERROR, "{0} is a final type, and thus a class object cannot extend it");
    public static final DiagnosticFactory1<JetTypeReference, JetType> FINAL_UPPER_BOUND = DiagnosticFactory1.create(Severity.WARNING, "{0} is a final type, and thus a value of the type parameter is predetermined");
    public static final DiagnosticFactory1<JetExpression, JetType> USELESS_ELVIS = DiagnosticFactory1.create(Severity.WARNING, "Elvis operator (?:) always returns the left operand of non-nullable type {0}");
    public static final DiagnosticFactory1<PsiElement, TypeParameterDescriptor> CONFLICTING_UPPER_BOUNDS = DiagnosticFactory1.create(Severity.ERROR, "Upper bounds of {0} have empty intersection", Renderers.NAME);
    public static final DiagnosticFactory1<PsiElement, TypeParameterDescriptor> CONFLICTING_CLASS_OBJECT_UPPER_BOUNDS = DiagnosticFactory1.create(Severity.ERROR, "Class object upper bounds of {0} have empty intersection", Renderers.NAME);
    public static final DiagnosticFactory1<PsiElement, CallableDescriptor> TOO_MANY_ARGUMENTS = DiagnosticFactory1.create(Severity.ERROR, "Too many arguments for {0}");
    public static final DiagnosticFactory1<PsiElement, String> ERROR_COMPILE_TIME_VALUE = DiagnosticFactory1.create(Severity.ERROR, "{0}");
    public static final DiagnosticFactory<JetWhenEntry> ELSE_MISPLACED_IN_WHEN = DiagnosticFactory.create(Severity.ERROR, "'else' entry must be the last one in a when-expression", new PositioningStrategy<JetWhenEntry>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenEntry entry) {
            PsiElement elseKeywordElement = entry.getElseKeywordElement();
            assert (elseKeywordElement != null);
            return 7.markElement(elseKeywordElement);
        }
    });
    public static final DiagnosticFactory<JetWhenExpression> NO_ELSE_IN_WHEN = new DiagnosticFactory<JetWhenExpression>(Severity.ERROR, "'when' expression must contain 'else' branch", new PositioningStrategy<JetWhenExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenExpression element) {
            return 8.markElement(element.getWhenKeywordElement());
        }
    });
    public static final DiagnosticFactory<JetWhenConditionInRange> TYPE_MISMATCH_IN_RANGE = new DiagnosticFactory<JetWhenConditionInRange>(Severity.ERROR, "Type mismatch: incompatible types of range and element checked in it", new PositioningStrategy<JetWhenConditionInRange>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenConditionInRange condition) {
            return 9.markElement((PsiElement)condition.getOperationReference());
        }
    });
    public static final DiagnosticFactory<PsiElement> CYCLIC_INHERITANCE_HIERARCHY = DiagnosticFactory.create(Severity.ERROR, "There's a cycle in the inheritance hierarchy for this type");
    public static final DiagnosticFactory<JetTypeReference> MANY_CLASSES_IN_SUPERTYPE_LIST = DiagnosticFactory.create(Severity.ERROR, "Only one class may appear in a supertype list");
    public static final DiagnosticFactory<JetTypeReference> SUPERTYPE_NOT_A_CLASS_OR_TRAIT = DiagnosticFactory.create(Severity.ERROR, "Only classes and traits may serve as supertypes");
    public static final DiagnosticFactory<PsiElement> SUPERTYPE_INITIALIZED_IN_TRAIT = DiagnosticFactory.create(Severity.ERROR, "Traits cannot initialize supertypes");
    public static final DiagnosticFactory<PsiElement> CONSTRUCTOR_IN_TRAIT = DiagnosticFactory.create(Severity.ERROR, "A trait may not have a constructor");
    public static final DiagnosticFactory<JetTypeReference> SUPERTYPE_APPEARS_TWICE = DiagnosticFactory.create(Severity.ERROR, "A supertype appears twice");
    public static final DiagnosticFactory<JetTypeReference> FINAL_SUPERTYPE = DiagnosticFactory.create(Severity.ERROR, "This type is final, so it cannot be inherited from");
    public static final DiagnosticFactory1<JetExpression, String> ILLEGAL_SELECTOR = DiagnosticFactory1.create(Severity.ERROR, "Expression ''{0}'' cannot be a selector (occur after a dot)");
    public static final DiagnosticFactory<JetParameter> VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION = DiagnosticFactory.create(Severity.ERROR, "A type annotation is required on a value parameter");
    public static final DiagnosticFactory<JetLabelQualifiedExpression> BREAK_OR_CONTINUE_OUTSIDE_A_LOOP = DiagnosticFactory.create(Severity.ERROR, "'break' and 'continue' are only allowed inside a loop");
    public static final DiagnosticFactory1<JetLabelQualifiedExpression, String> NOT_A_LOOP_LABEL = DiagnosticFactory1.create(Severity.ERROR, "The label ''{0}'' does not denote a loop");
    public static final DiagnosticFactory1<JetReturnExpression, String> NOT_A_RETURN_LABEL = DiagnosticFactory1.create(Severity.ERROR, "The label ''{0}'' does not reference to a context from which we can return");
    public static final DiagnosticFactory<JetClassInitializer> ANONYMOUS_INITIALIZER_WITHOUT_CONSTRUCTOR = DiagnosticFactory.create(Severity.ERROR, "Anonymous initializers are only allowed in the presence of a primary constructor");
    public static final DiagnosticFactory<JetNullableType> NULLABLE_SUPERTYPE = DiagnosticFactory.create(Severity.ERROR, "A supertype cannot be nullable", new PositioningStrategy<JetNullableType>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetNullableType element) {
            return 10.markNode(element.getQuestionMarkNode());
        }
    });
    public static final DiagnosticFactory1<PsiElement, JetType> UNSAFE_CALL = DiagnosticFactory1.create(Severity.ERROR, "Only safe calls (?.) are allowed on a nullable receiver of type {0}");
    public static final DiagnosticFactory<JetSimpleNameExpression> AMBIGUOUS_LABEL = DiagnosticFactory.create(Severity.ERROR, "Ambiguous label");
    public static final DiagnosticFactory1<PsiElement, String> UNSUPPORTED = DiagnosticFactory1.create(Severity.ERROR, "Unsupported [{0}]");
    public static final DiagnosticFactory1<PsiElement, JetType> UNNECESSARY_SAFE_CALL = DiagnosticFactory1.create(Severity.WARNING, "Unnecessary safe call on a non-null receiver of type {0}");
    public static final DiagnosticFactory2<JetSimpleNameExpression, JetTypeConstraint, JetTypeParameterListOwner> NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER = DiagnosticFactory2.create(Severity.ERROR, "{0} does not refer to a type parameter of {1}", new Renderer<JetTypeConstraint>(){

        @Override
        @NotNull
        public String render(@Nullable JetTypeConstraint typeConstraint) {
            assert (typeConstraint != null);
            return typeConstraint.getSubjectTypeParameterName().getReferencedName();
        }
    }, Renderers.NAME);
    public static final DiagnosticFactory2<JetExpression, JetType, String> AUTOCAST_IMPOSSIBLE = DiagnosticFactory2.create(Severity.ERROR, "Automatic cast to {0} is impossible, because {1} could have changed since the is-check");
    public static final DiagnosticFactory2<JetTypeReference, JetType, JetType> TYPE_MISMATCH_IN_FOR_LOOP = DiagnosticFactory2.create(Severity.ERROR, "The loop iterates over values of type {0} but the parameter is declared to be {1}");
    public static final DiagnosticFactory1<JetElement, JetType> TYPE_MISMATCH_IN_CONDITION = DiagnosticFactory1.create(Severity.ERROR, "Condition must be of type Boolean, but was of type {0}");
    public static final DiagnosticFactory2<JetTuplePattern, JetType, Integer> TYPE_MISMATCH_IN_TUPLE_PATTERN = DiagnosticFactory2.create(Severity.ERROR, "Type mismatch: subject is of type {0} but the pattern is of type Tuple{1}");
    public static final DiagnosticFactory2<JetTypeReference, JetType, JetType> TYPE_MISMATCH_IN_BINDING_PATTERN = DiagnosticFactory2.create(Severity.ERROR, "{0} must be a supertype of {1}. Use 'is' to match against {0}");
    public static final DiagnosticFactory2<JetElement, JetType, JetType> INCOMPATIBLE_TYPES = DiagnosticFactory2.create(Severity.ERROR, "Incompatible types: {0} and {1}");
    public static final DiagnosticFactory<JetWhenCondition> EXPECTED_CONDITION = DiagnosticFactory.create(Severity.ERROR, "Expected condition of Boolean type");
    public static final DiagnosticFactory1<JetElement, JetType> CANNOT_CHECK_FOR_ERASED = DiagnosticFactory1.create(Severity.ERROR, "Cannot check for instance of erased type: {0}");
    public static final DiagnosticFactory2<JetBinaryExpressionWithTypeRHS, JetType, JetType> UNCHECKED_CAST = DiagnosticFactory2.create(Severity.WARNING, "Unchecked cast: {0} to {1}");
    public static final DiagnosticFactory3<JetDelegationSpecifierList, TypeParameterDescriptor, ClassDescriptor, Collection<JetType>> INCONSISTENT_TYPE_PARAMETER_VALUES = DiagnosticFactory3.create(Severity.ERROR, "Type parameter {0} of {1} has inconsistent values: {2}", Renderers.NAME, DescriptorRenderer.TEXT, new Renderer<Collection<JetType>>(){

        @Override
        @NotNull
        public String render(@Nullable Collection<JetType> types) {
            StringBuilder builder = new StringBuilder();
            Iterator<JetType> iterator = types.iterator();
            while (iterator.hasNext()) {
                JetType jetType = iterator.next();
                builder.append(jetType);
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
    });
    public static final DiagnosticFactory3<JetBinaryExpression, JetSimpleNameExpression, JetType, JetType> EQUALITY_NOT_APPLICABLE = DiagnosticFactory3.create(Severity.ERROR, "Operator {0} cannot be applied to {1} and {2}", new Renderer<JetSimpleNameExpression>(){

        @Override
        @NotNull
        public String render(@Nullable JetSimpleNameExpression nameExpression) {
            return nameExpression.getReferencedName();
        }
    }, Renderers.TO_STRING, Renderers.TO_STRING);
    public static final DiagnosticFactory2<PsiElement, CallableMemberDescriptor, DeclarationDescriptor> OVERRIDING_FINAL_MEMBER = DiagnosticFactory2.create(Severity.ERROR, "{0} in {1} is final and cannot be overridden", Renderers.NAME, Renderers.NAME);
    public static final DiagnosticFactory2<JetNamedDeclaration, CallableMemberDescriptor, CallableMemberDescriptor> RETURN_TYPE_MISMATCH_ON_OVERRIDE = DiagnosticFactory2.create(Severity.ERROR, "Return type of {0} is not a subtype of the return type overridden member {1}", PositioningStrategies.POSITION_DECLARATION, DescriptorRenderer.TEXT, DescriptorRenderer.TEXT);
    public static final DiagnosticFactory2<JetProperty, PropertyDescriptor, PropertyDescriptor> VAR_OVERRIDDEN_BY_VAL = DiagnosticFactory2.create(Severity.ERROR, "Var-property {0} cannot be overridden by val-property {1}", new PositioningStrategy<JetProperty>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetProperty property) {
            return 14.markNode(property.getValOrVarNode());
        }
    }, DescriptorRenderer.TEXT, DescriptorRenderer.TEXT);
    public static final DiagnosticFactory2<PsiElement, JetClassOrObject, CallableMemberDescriptor> ABSTRACT_MEMBER_NOT_IMPLEMENTED = DiagnosticFactory2.create(Severity.ERROR, "{0} must be declared abstract or implement abstract member {1}", Renderers.RENDER_CLASS_OR_OBJECT, DescriptorRenderer.TEXT);
    public static final DiagnosticFactory2<PsiElement, JetClassOrObject, CallableMemberDescriptor> MANY_IMPL_MEMBER_NOT_IMPLEMENTED = DiagnosticFactory2.create(Severity.ERROR, "{0} must override {1} because it inherits many implementations of it", Renderers.RENDER_CLASS_OR_OBJECT, DescriptorRenderer.TEXT);
    public static final DiagnosticFactory2<JetDeclaration, CallableMemberDescriptor, String> CONFLICTING_OVERLOADS = DiagnosticFactory2.create(Severity.ERROR, "{1} is already defined in ''{0}''", new PositioningStrategy<JetDeclaration>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclaration jetDeclaration) {
            if (jetDeclaration instanceof JetNamedFunction) {
                JetNamedFunction functionElement = (JetNamedFunction)jetDeclaration;
                return 15.markRange(new TextRange(functionElement.getStartOfSignatureElement().getTextRange().getStartOffset(), functionElement.getEndOfSignatureElement().getTextRange().getEndOffset()));
            }
            if (jetDeclaration instanceof JetClass) {
                JetClass klass = (JetClass)jetDeclaration;
                PsiElement nameAsDeclaration = klass.getNameIdentifier();
                if (nameAsDeclaration == null) {
                    return 15.markRange(klass.getTextRange());
                }
                JetParameterList primaryConstructorParameterList = klass.getPrimaryConstructorParameterList();
                if (primaryConstructorParameterList == null) {
                    return 15.markRange(nameAsDeclaration.getTextRange());
                }
                return 15.markRange(new TextRange(nameAsDeclaration.getTextRange().getStartOffset(), primaryConstructorParameterList.getTextRange().getEndOffset()));
            }
            return 15.markRange(jetDeclaration.getTextRange());
        }
    }, DescriptorRenderer.TEXT, Renderers.TO_STRING);
    public static final DiagnosticFactory3<JetExpression, String, JetType, JetType> RESULT_TYPE_MISMATCH = DiagnosticFactory3.create(Severity.ERROR, "{0} must return {1} but returns {2}");
    public static final DiagnosticFactory3<JetReferenceExpression, String, String, String> UNSAFE_INFIX_CALL = DiagnosticFactory3.create(Severity.ERROR, "Infix call corresponds to a dot-qualified call ''{0}.{1}({2})'' which is not allowed on a nullable receiver ''{0}''. Use '?.'-qualified call instead");
    public static final AmbiguousDescriptorDiagnosticFactory OVERLOAD_RESOLUTION_AMBIGUITY = new AmbiguousDescriptorDiagnosticFactory("Overload resolution ambiguity: {0}");
    public static final AmbiguousDescriptorDiagnosticFactory NONE_APPLICABLE = new AmbiguousDescriptorDiagnosticFactory("None of the following functions can be called with the arguments supplied: {0}");
    public static final DiagnosticFactory1<PsiElement, ValueParameterDescriptor> NO_VALUE_FOR_PARAMETER = DiagnosticFactory1.create(Severity.ERROR, "No value passed for parameter {0}", DescriptorRenderer.TEXT);
    public static final DiagnosticFactory1<JetReferenceExpression, JetType> MISSING_RECEIVER = DiagnosticFactory1.create(Severity.ERROR, "A receiver of type {0} is required");
    public static final DiagnosticFactory<JetReferenceExpression> NO_RECEIVER_ADMITTED = DiagnosticFactory.create(Severity.ERROR, "No receiver can be passed to this function or property");
    public static final DiagnosticFactory<PsiElement> CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS = DiagnosticFactory.create(Severity.ERROR, "Can not create an instance of an abstract class");
    public static final DiagnosticFactory1<PsiElement, SolutionStatus> TYPE_INFERENCE_FAILED = DiagnosticFactory1.create(Severity.ERROR, "Type inference failed: {0}");
    public static final DiagnosticFactory1<JetElement, Integer> WRONG_NUMBER_OF_TYPE_ARGUMENTS = DiagnosticFactory1.create(Severity.ERROR, "{0} type arguments expected", new Renderer<Integer>(){

        @Override
        @NotNull
        public String render(@Nullable Integer argument) {
            assert (argument != null);
            return argument == 0 ? "No" : argument.toString();
        }
    });
    public static final DiagnosticFactory1<JetIdeTemplateExpression, String> UNRESOLVED_IDE_TEMPLATE = DiagnosticFactory1.create(Severity.ERROR, "Unresolved IDE template: {0}");
    public static final DiagnosticFactory<JetExpression> DANGLING_FUNCTION_LITERAL_ARGUMENT_SUSPECTED = DiagnosticFactory.create(Severity.WARNING, "This expression is treated as an argument to the function call on the previous line. Separate it with a semicolon (;) if it is not intended to be an argument.");
    public static final Initializer __initializer = Initializer.access$000();

    public static class Initializer {
        private static final Initializer INSTANCE;

        private Initializer() {
        }

        static /* synthetic */ Initializer access$000() {
            return INSTANCE;
        }

        static {
            for (Field field : Errors.class.getFields()) {
                if ((field.getModifiers() & 8) == 0) continue;
                try {
                    Object value = field.get(null);
                    if (!(value instanceof AbstractDiagnosticFactory)) continue;
                    AbstractDiagnosticFactory factory = (AbstractDiagnosticFactory)value;
                    factory.setName(field.getName());
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
            INSTANCE = new Initializer();
        }
    }
}

