/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactoryWithMessageFormat;
import org.jetbrains.jet.lang.diagnostics.DiagnosticWithPsiElement;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategies;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.Renderer;
import org.jetbrains.jet.lang.diagnostics.Renderers;
import org.jetbrains.jet.lang.diagnostics.Severity;

public class DiagnosticFactory3<P extends PsiElement, A, B, C>
extends DiagnosticFactoryWithMessageFormat<P> {
    private final Renderer<? super A> rendererForA;
    private final Renderer<? super B> rendererForB;
    private final Renderer<? super C> rendererForC;

    protected DiagnosticFactory3(Severity severity, String messageStub, PositioningStrategy<? super P> positioningStrategy, Renderer<? super A> rendererForA, Renderer<? super B> rendererForB, Renderer<? super C> rendererForC) {
        super(severity, messageStub, positioningStrategy);
        this.rendererForA = rendererForA;
        this.rendererForB = rendererForB;
        this.rendererForC = rendererForC;
    }

    public static <T extends PsiElement, A, B, C> DiagnosticFactory3<T, A, B, C> create(Severity severity, String messageStub) {
        return DiagnosticFactory3.create(severity, messageStub, PositioningStrategies.DEFAULT);
    }

    public static <T extends PsiElement, A, B, C> DiagnosticFactory3<T, A, B, C> create(Severity severity, String messageStub, PositioningStrategy<? super T> positioningStrategy) {
        return DiagnosticFactory3.create(severity, messageStub, positioningStrategy, Renderers.TO_STRING, Renderers.TO_STRING, Renderers.TO_STRING);
    }

    public static <T extends PsiElement, A, B, C> DiagnosticFactory3<T, A, B, C> create(Severity severity, String messageStub, Renderer<? super A> rendererForA, Renderer<? super B> rendererForB, Renderer<? super C> rendererForC) {
        return DiagnosticFactory3.create(severity, messageStub, PositioningStrategies.DEFAULT, rendererForA, rendererForB, rendererForC);
    }

    public static <T extends PsiElement, A, B, C> DiagnosticFactory3<T, A, B, C> create(Severity severity, String messageStub, PositioningStrategy<? super T> positioningStrategy, Renderer<? super A> rendererForA, Renderer<? super B> rendererForB, Renderer<? super C> rendererForC) {
        return new DiagnosticFactory3<T, A, B, C>(severity, messageStub, positioningStrategy, rendererForA, rendererForB, rendererForC);
    }

    private String makeMessage(@NotNull A a, @NotNull B b, @NotNull C c) {
        return this.messageFormat.format(new Object[]{this.makeMessageForA(a), this.makeMessageForB(b), this.makeMessageForC(c)});
    }

    private String makeMessageForA(@NotNull A a) {
        return this.rendererForA.render(a);
    }

    private String makeMessageForB(@NotNull B b) {
        return this.rendererForB.render(b);
    }

    private String makeMessageForC(@NotNull C c) {
        return this.rendererForC.render(c);
    }

    @NotNull
    public DiagnosticWithPsiElement<P> on(@NotNull P element, @NotNull A a, @NotNull B b, @NotNull C c) {
        return new DiagnosticWithPsiElement<P>(element, this, this.severity, this.makeMessage(a, b, c));
    }
}

