/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactoryWithMessageFormat;
import org.jetbrains.jet.lang.diagnostics.DiagnosticWithPsiElement;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategies;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.Renderer;
import org.jetbrains.jet.lang.diagnostics.Renderers;
import org.jetbrains.jet.lang.diagnostics.Severity;

public class DiagnosticFactory2<P extends PsiElement, A, B>
extends DiagnosticFactoryWithMessageFormat<P> {
    private final Renderer<? super A> rendererForA;
    private final Renderer<? super B> rendererForB;

    private String makeMessage(@NotNull A a, @NotNull B b) {
        return this.messageFormat.format(new Object[]{this.makeMessageForA(a), this.makeMessageForB(b)});
    }

    private String makeMessageForA(@NotNull A a) {
        return this.rendererForA.render(a);
    }

    private String makeMessageForB(@NotNull B b) {
        return this.rendererForB.render(b);
    }

    @NotNull
    public Diagnostic<P> on(@NotNull P element, @NotNull A a, @NotNull B b) {
        return new DiagnosticWithPsiElement<P>(element, this, this.severity, this.makeMessage(a, b));
    }

    private DiagnosticFactory2(Severity severity, String message, PositioningStrategy<? super P> positioningStrategy, Renderer<? super A> rendererForA, Renderer<? super B> rendererForB) {
        super(severity, message, positioningStrategy);
        this.rendererForA = rendererForA;
        this.rendererForB = rendererForB;
    }

    public static <T extends PsiElement, A, B> DiagnosticFactory2<T, A, B> create(Severity severity, String messageStub, PositioningStrategy<? super T> positioningStrategy, Renderer<? super A> rendererForA, Renderer<? super B> rendererForB) {
        return new DiagnosticFactory2<T, A, B>(severity, messageStub, positioningStrategy, rendererForA, rendererForB);
    }

    public static <T extends PsiElement, A, B> DiagnosticFactory2<T, A, B> create(Severity severity, String messageStub, PositioningStrategy<? super T> positioningStrategy) {
        return new DiagnosticFactory2<T, Object, Object>(severity, messageStub, positioningStrategy, Renderers.TO_STRING, Renderers.TO_STRING);
    }

    public static <T extends PsiElement, A, B> DiagnosticFactory2<T, A, B> create(Severity severity, String messageStub, Renderer<? super A> rendererForA, Renderer<? super B> rendererForB) {
        return new DiagnosticFactory2<PsiElement, A, B>(severity, messageStub, PositioningStrategies.DEFAULT, rendererForA, rendererForB);
    }

    public static <T extends PsiElement, A, B> DiagnosticFactory2<T, A, B> create(Severity severity, String messageStub) {
        return new DiagnosticFactory2<PsiElement, Object, Object>(severity, messageStub, PositioningStrategies.DEFAULT, Renderers.TO_STRING, Renderers.TO_STRING);
    }
}

