/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactoryWithMessageFormat;
import org.jetbrains.jet.lang.diagnostics.DiagnosticWithPsiElement;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategies;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.Renderer;
import org.jetbrains.jet.lang.diagnostics.Renderers;
import org.jetbrains.jet.lang.diagnostics.Severity;

public class DiagnosticFactory1<P extends PsiElement, A>
extends DiagnosticFactoryWithMessageFormat<P> {
    private final Renderer<? super A> renderer;

    protected String makeMessage(@NotNull A argument) {
        return this.messageFormat.format(new Object[]{this.makeMessageFor(argument)});
    }

    protected String makeMessageFor(@NotNull A argument) {
        return this.renderer.render(argument);
    }

    @NotNull
    public DiagnosticWithPsiElement<P> on(@NotNull P element, @NotNull A argument) {
        return new DiagnosticWithPsiElement<P>(element, this, this.severity, this.makeMessage(argument));
    }

    protected DiagnosticFactory1(Severity severity, String message, PositioningStrategy<? super P> positioningStrategy, Renderer<? super A> renderer) {
        super(severity, message, positioningStrategy);
        this.renderer = renderer;
    }

    public static <T extends PsiElement, A> DiagnosticFactory1<T, A> create(Severity severity, String message, PositioningStrategy<? super T> positioningStrategy, Renderer<? super A> renderer) {
        return new DiagnosticFactory1<T, A>(severity, message, positioningStrategy, renderer);
    }

    public static <T extends PsiElement, A> DiagnosticFactory1<T, A> create(Severity severity, String message, PositioningStrategy<? super T> positioningStrategy) {
        return DiagnosticFactory1.create(severity, message, positioningStrategy, Renderers.TO_STRING);
    }

    public static <T extends PsiElement, A> DiagnosticFactory1<T, A> create(Severity severity, String message, Renderer<? super A> renderer) {
        return DiagnosticFactory1.create(severity, message, PositioningStrategies.DEFAULT, renderer);
    }

    public static <T extends PsiElement, A> DiagnosticFactory1<T, A> create(Severity severity, String message) {
        return DiagnosticFactory1.create(severity, message, PositioningStrategies.DEFAULT, Renderers.TO_STRING);
    }
}

