/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.jet.lang.diagnostics.DiagnosticWithPsiElement;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategies;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.Severity;

public class DiagnosticFactory<P extends PsiElement>
extends DiagnosticFactoryWithPsiElement<P> {
    protected final String message;

    protected DiagnosticFactory(Severity severity, String message, PositioningStrategy<? super P> positioningStrategy) {
        super(severity, positioningStrategy);
        this.message = message;
    }

    public static <T extends PsiElement> DiagnosticFactory<T> create(Severity severity, String message) {
        return DiagnosticFactory.create(severity, message, PositioningStrategies.DEFAULT);
    }

    public static <T extends PsiElement> DiagnosticFactory<T> create(Severity severity, String message, PositioningStrategy<? super T> positioningStrategy) {
        return new DiagnosticFactory<T>(severity, message, positioningStrategy);
    }

    @NotNull
    public Diagnostic<P> on(@NotNull P element) {
        return new DiagnosticWithPsiElement<P>(element, this, this.severity, this.message);
    }
}

