/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategies;
import org.jetbrains.jet.lang.diagnostics.Renderer;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.resolve.DescriptorRenderer;

public class AmbiguousDescriptorDiagnosticFactory
extends DiagnosticFactory1<PsiElement, Collection<? extends ResolvedCall<? extends CallableDescriptor>>> {
    private static Renderer<Collection<? extends ResolvedCall<? extends CallableDescriptor>>> AMBIGUOUS_DESCRIPTOR_RENDERER = new Renderer<Collection<? extends ResolvedCall<? extends CallableDescriptor>>>(){

        @Override
        @NotNull
        public String render(@Nullable Collection<? extends ResolvedCall<? extends CallableDescriptor>> argument) {
            StringBuilder stringBuilder = new StringBuilder("\n");
            for (ResolvedCall<? extends CallableDescriptor> resolvedCall : argument) {
                stringBuilder.append(DescriptorRenderer.TEXT.render(resolvedCall.getResultingDescriptor())).append("\n");
            }
            return stringBuilder.toString();
        }
    };

    public static AmbiguousDescriptorDiagnosticFactory create(String messageTemplate) {
        return new AmbiguousDescriptorDiagnosticFactory(messageTemplate);
    }

    public AmbiguousDescriptorDiagnosticFactory(String messageTemplate) {
        super(Severity.ERROR, messageTemplate, PositioningStrategies.DEFAULT, AMBIGUOUS_DESCRIPTOR_RENDERER);
    }
}

