/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.types.JetType;

public class VariableAsFunctionDescriptor
extends FunctionDescriptorImpl {
    private final VariableDescriptor variableDescriptor;

    public static VariableAsFunctionDescriptor create(@NotNull VariableDescriptor variableDescriptor) {
        JetType outType = variableDescriptor.getType();
        assert (outType != null);
        VariableAsFunctionDescriptor result = new VariableAsFunctionDescriptor(variableDescriptor);
        FunctionDescriptorUtil.initializeFromFunctionType(result, outType, variableDescriptor.getExpectedThisObject());
        return result;
    }

    private VariableAsFunctionDescriptor(VariableDescriptor variableDescriptor) {
        super(variableDescriptor.getContainingDeclaration(), Collections.<AnnotationDescriptor>emptyList(), variableDescriptor.getName(), CallableMemberDescriptor.Kind.DECLARATION);
        this.variableDescriptor = variableDescriptor;
    }

    public VariableDescriptor getVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Override
    @NotNull
    public VariableAsFunctionDescriptor copy(DeclarationDescriptor newOwner, boolean makeNonAbstract, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        throw new UnsupportedOperationException("Should not be copied for overriding");
    }

    @Override
    protected FunctionDescriptorImpl createSubstitutedCopy(DeclarationDescriptor newOwner, boolean preserveOriginal, CallableMemberDescriptor.Kind kind) {
        throw new IllegalStateException();
    }
}

