/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.MutableValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements MutableValueParameterDescriptor {
    private final boolean hasDefaultValue;
    private final JetType varargElementType;
    private final boolean isVar;
    private final int index;
    private final ValueParameterDescriptor original;

    public ValueParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, int index, @NotNull List<AnnotationDescriptor> annotations, @NotNull String name, boolean isVar, @NotNull JetType outType, boolean hasDefaultValue, @Nullable JetType varargElementType) {
        super(containingDeclaration, annotations, name, outType);
        this.original = this;
        this.index = index;
        this.hasDefaultValue = hasDefaultValue;
        this.varargElementType = varargElementType;
        this.isVar = isVar;
    }

    public ValueParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull ValueParameterDescriptor original, @NotNull List<AnnotationDescriptor> annotations, boolean isVar, @NotNull JetType outType, @Nullable JetType varargElementType) {
        super(containingDeclaration, annotations, original.getName(), outType);
        this.original = original;
        this.index = original.getIndex();
        this.hasDefaultValue = original.hasDefaultValue();
        this.varargElementType = varargElementType;
        this.isVar = isVar;
    }

    @Override
    public void setType(@NotNull JetType type) {
        this.setOutType(type);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    @Override
    public boolean isRef() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public JetType getVarargElementType() {
        return this.varargElementType;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor getOriginal() {
        return this.original == this ? this : this.original.getOriginal();
    }

    @Override
    @NotNull
    public ValueParameterDescriptor substitute(TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitValueParameterDescriptor(this, data);
    }

    @Override
    public boolean isVar() {
        return this.isVar;
    }

    @Override
    public boolean isObjectDeclaration() {
        return false;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor copy(@NotNull DeclarationDescriptor newOwner) {
        return new ValueParameterDescriptorImpl(newOwner, this.index, Lists.newArrayList(this.getAnnotations()), this.getName(), this.isVar, this.getType(), this.hasDefaultValue, this.varargElementType);
    }
}

