/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public abstract class PropertyAccessorDescriptor
extends DeclarationDescriptorImpl
implements FunctionDescriptor,
MemberDescriptor {
    private final boolean hasBody;
    private final boolean isDefault;
    private final Modality modality;
    private final Visibility visibility;
    private final PropertyDescriptor correspondingProperty;
    private final CallableMemberDescriptor.Kind kind;

    public PropertyAccessorDescriptor(@NotNull Modality modality, @NotNull Visibility visibility, @NotNull PropertyDescriptor correspondingProperty, @NotNull List<AnnotationDescriptor> annotations, @NotNull String name, boolean hasBody, boolean isDefault, CallableMemberDescriptor.Kind kind) {
        super(correspondingProperty.getContainingDeclaration(), annotations, name);
        this.modality = modality;
        this.visibility = visibility;
        this.correspondingProperty = correspondingProperty;
        this.hasBody = hasBody;
        this.isDefault = isDefault;
        this.kind = kind;
    }

    public boolean hasBody() {
        return this.hasBody;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public CallableMemberDescriptor.Kind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public PropertyAccessorDescriptor getOriginal() {
        return (PropertyAccessorDescriptor)super.getOriginal();
    }

    @Override
    @NotNull
    public FunctionDescriptor substitute(TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @NotNull
    public PropertyDescriptor getCorrespondingProperty() {
        return this.correspondingProperty;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getReceiverParameter() {
        return this.getCorrespondingProperty().getReceiverParameter();
    }

    @Override
    @NotNull
    public ReceiverDescriptor getExpectedThisObject() {
        return this.getCorrespondingProperty().getExpectedThisObject();
    }

    @Override
    @NotNull
    public PropertyAccessorDescriptor copy(DeclarationDescriptor newOwner, boolean makeNonAbstract, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        throw new UnsupportedOperationException("Accessors must be copied by the corresponding property");
    }

    protected Set<PropertyAccessorDescriptor> getOverriddenDescriptors(boolean isGetter) {
        Set<? extends PropertyDescriptor> overriddenProperties = this.getCorrespondingProperty().getOverriddenDescriptors();
        HashSet overriddenAccessors = Sets.newHashSet();
        for (PropertyDescriptor propertyDescriptor : overriddenProperties) {
            PropertyAccessorDescriptor accessorDescriptor = isGetter ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            if (accessorDescriptor == null) continue;
            overriddenAccessors.add(accessorDescriptor);
        }
        return overriddenAccessors;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overridden) {
        throw new IllegalStateException();
    }
}

