/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.LazySubstitutingClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableDeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceLike;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.resolve.DescriptorRenderer;

public class MutableClassDescriptorLite
extends MutableDeclarationDescriptor
implements ClassDescriptor,
NamespaceLike {
    private ConstructorDescriptor primaryConstructor;
    private final Set<ConstructorDescriptor> constructors = Sets.newLinkedHashSet();
    private List<AnnotationDescriptor> annotations = Lists.newArrayList();
    private Map<String, ClassDescriptor> innerClassesAndObjects = Maps.newHashMap();
    private List<TypeParameterDescriptor> typeParameters;
    private Collection<JetType> supertypes = Lists.newArrayList();
    private TypeConstructor typeConstructor;
    private Modality modality;
    private Visibility visibility;
    private MutableClassDescriptorLite classObjectDescriptor;
    private JetType classObjectType;
    private JetType defaultType;
    private final ClassKind kind;
    private JetScope scopeForMemberLookup;
    private ClassReceiver implicitReceiver;

    public MutableClassDescriptorLite(DeclarationDescriptor containingDeclaration, ClassKind kind) {
        super(containingDeclaration);
        this.kind = kind;
    }

    private static boolean isStatic(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor instanceof NamespaceDescriptor) {
            return true;
        }
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            return classDescriptor.getKind() == ClassKind.OBJECT || classDescriptor.getKind() == ClassKind.ENUM_CLASS;
        }
        return false;
    }

    @Override
    public NamespaceLike.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
        if (this.classObjectDescriptor != null) {
            return NamespaceLike.ClassObjectStatus.DUPLICATE;
        }
        if (!MutableClassDescriptorLite.isStatic(this.getContainingDeclaration())) {
            return NamespaceLike.ClassObjectStatus.NOT_ALLOWED;
        }
        assert (classObjectDescriptor.getKind() == ClassKind.OBJECT);
        this.classObjectDescriptor = classObjectDescriptor;
        return NamespaceLike.ClassObjectStatus.OK;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    public void setScopeForMemberLookup(JetScope scopeForMemberLookup) {
        this.scopeForMemberLookup = scopeForMemberLookup;
    }

    public void createTypeConstructor() {
        assert (this.typeConstructor == null) : this.typeConstructor;
        this.typeConstructor = new TypeConstructorImpl(this, Collections.<AnnotationDescriptor>emptyList(), !this.modality.isOverridable(), this.getName(), this.typeParameters, this.supertypes);
        for (ConstructorDescriptor functionDescriptor : this.constructors) {
            ((ConstructorDescriptorImpl)functionDescriptor).setReturnType(this.getDefaultType());
        }
    }

    public WritableScope getScopeForMemberLookupAsWritableScope() {
        return (WritableScope)this.scopeForMemberLookup;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(List<TypeProjection> typeArguments) {
        assert (typeArguments.size() == this.typeConstructor.getParameters().size());
        if (typeArguments.isEmpty()) {
            return this.scopeForMemberLookup;
        }
        List<TypeParameterDescriptor> typeParameters = this.getTypeConstructor().getParameters();
        Map<TypeConstructor, TypeProjection> substitutionContext = TypeUtils.buildSubstitutionContext(typeParameters, typeArguments);
        return new SubstitutingScope(this.scopeForMemberLookup, TypeSubstitutor.create(substitutionContext));
    }

    @Override
    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        return this.constructors;
    }

    @NotNull
    public JetScope getScopeForMemberLookup() {
        return this.scopeForMemberLookup;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(TypeSubstitutor substitutor) {
        if (substitutor.isEmpty()) {
            return this;
        }
        return new LazySubstitutingClassDescriptor(this, substitutor);
    }

    @Override
    public JetType getClassObjectType() {
        if (this.classObjectType == null && this.classObjectDescriptor != null) {
            this.classObjectType = this.classObjectDescriptor.getDefaultType();
        }
        return this.classObjectType;
    }

    @Override
    public boolean isClassObjectAValue() {
        return true;
    }

    @Override
    public boolean hasConstructors() {
        return !this.constructors.isEmpty();
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.kind;
    }

    public void setModality(Modality modality) {
        this.modality = modality;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    public Collection<JetType> getSupertypes() {
        return this.supertypes;
    }

    public void setSupertypes(@NotNull Collection<JetType> supertypes) {
        this.supertypes = supertypes;
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor constructorDescriptor, BindingTrace trace) {
        assert (this.primaryConstructor == null) : "Primary constructor assigned twice " + this;
        this.primaryConstructor = constructorDescriptor;
        this.addConstructor(constructorDescriptor, trace);
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    public void addConstructor(@NotNull ConstructorDescriptor constructorDescriptor, @Nullable BindingTrace trace) {
        assert (constructorDescriptor.getContainingDeclaration() == this);
        this.constructors.add(constructorDescriptor);
        if (this.defaultType != null) {
            ((ConstructorDescriptorImpl)constructorDescriptor).setReturnType(this.getDefaultType());
        }
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        if (this.defaultType == null) {
            this.defaultType = TypeUtils.makeUnsubstitutedType(this, this.scopeForMemberLookup);
        }
        return this.defaultType;
    }

    @Override
    @Nullable
    public MutableClassDescriptorLite getClassObjectDescriptor() {
        return this.classObjectDescriptor;
    }

    @Override
    public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
        this.getScopeForMemberLookupAsWritableScope().addPropertyDescriptor(propertyDescriptor);
    }

    @Override
    public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
        this.getScopeForMemberLookupAsWritableScope().addFunctionDescriptor(functionDescriptor);
    }

    @Override
    public void addNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        throw new UnsupportedOperationException("Classes do not define namespaces");
    }

    @Override
    public NamespaceDescriptorImpl getNamespace(String name) {
        throw new UnsupportedOperationException("Classes do not define namespaces");
    }

    @Override
    public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
        this.getScopeForMemberLookupAsWritableScope().addClassifierDescriptor(classDescriptor);
        this.innerClassesAndObjects.put(classDescriptor.getName(), classDescriptor);
    }

    @Override
    @Nullable
    public ClassDescriptor getInnerClassOrObject(String name) {
        return this.innerClassesAndObjects.get(name);
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getInnerClassesAndObjects() {
        return this.innerClassesAndObjects.values();
    }

    @Override
    public void addObjectDescriptor(@NotNull MutableClassDescriptorLite objectDescriptor) {
        this.getScopeForMemberLookupAsWritableScope().addObjectDescriptor(objectDescriptor);
        this.innerClassesAndObjects.put(objectDescriptor.getName(), objectDescriptor);
    }

    public void addSupertype(@NotNull JetType supertype) {
        if (!ErrorUtils.isErrorType(supertype)) {
            if (!(supertype.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
                throw new IllegalStateException();
            }
            this.supertypes.add(supertype);
        }
    }

    public void setTypeParameterDescriptors(List<TypeParameterDescriptor> typeParameters) {
        if (this.typeParameters != null) {
            throw new IllegalStateException();
        }
        this.typeParameters = new ArrayList<TypeParameterDescriptor>();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.typeParameters.add(typeParameterDescriptor);
        }
    }

    public void lockScopes() {
        this.getScopeForMemberLookupAsWritableScope().changeLockLevel(WritableScope.LockLevel.READING);
        if (this.classObjectDescriptor != null) {
            this.classObjectDescriptor.lockScopes();
        }
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        if (this.implicitReceiver == null) {
            this.implicitReceiver = new ClassReceiver(this);
        }
        return this.implicitReceiver;
    }

    public String toString() {
        return DescriptorRenderer.TEXT.render(this) + "[" + this.getClass().getCanonicalName() + "@" + System.identityHashCode(this) + "]";
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitClassDescriptor(this, data);
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationDescriptor> annotations) {
        this.annotations = annotations;
    }
}

