/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceLike;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.AbstractScopeAdapter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class MutableClassDescriptor
extends MutableClassDescriptorLite {
    private final Set<CallableMemberDescriptor> callableMembers = Sets.newHashSet();
    private final Set<PropertyDescriptor> properties = Sets.newHashSet();
    private final Set<SimpleFunctionDescriptor> functions = Sets.newHashSet();
    private final WritableScope scopeForMemberResolution;
    private final WritableScope scopeForSupertypeResolution;
    private final WritableScope scopeForInitializers;

    public MutableClassDescriptor(@NotNull BindingTrace trace, @NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope outerScope, ClassKind kind) {
        super(containingDeclaration, kind);
        if (!(containingDeclaration instanceof ClassDescriptor || containingDeclaration instanceof NamespaceLike || containingDeclaration instanceof ModuleDescriptor || containingDeclaration instanceof FunctionDescriptor)) {
            throw new IllegalStateException();
        }
        RedeclarationHandler redeclarationHandler = RedeclarationHandler.DO_NOTHING;
        this.setScopeForMemberLookup(new WritableScopeImpl(JetScope.EMPTY, this, redeclarationHandler).setDebugName("MemberLookup").changeLockLevel(WritableScope.LockLevel.BOTH));
        this.scopeForSupertypeResolution = new WritableScopeImpl(outerScope, this, redeclarationHandler).setDebugName("SupertypeResolution").changeLockLevel(WritableScope.LockLevel.BOTH);
        this.scopeForMemberResolution = new WritableScopeImpl(this.scopeForSupertypeResolution, this, redeclarationHandler).setDebugName("MemberResolution").changeLockLevel(WritableScope.LockLevel.BOTH);
        this.scopeForInitializers = new WritableScopeImpl(this.scopeForMemberResolution, this, redeclarationHandler).setDebugName("Initializers").changeLockLevel(WritableScope.LockLevel.BOTH);
    }

    @Override
    public NamespaceLike.ClassObjectStatus setClassObjectDescriptor(final @NotNull MutableClassDescriptorLite classObjectDescriptor) {
        NamespaceLike.ClassObjectStatus r = super.setClassObjectDescriptor(classObjectDescriptor);
        if (r != NamespaceLike.ClassObjectStatus.OK) {
            return r;
        }
        this.scopeForMemberResolution.importScope(new AbstractScopeAdapter(){

            @Override
            @NotNull
            protected JetScope getWorkerScope() {
                return classObjectDescriptor.getDefaultType().getMemberScope();
            }

            @Override
            @NotNull
            public ReceiverDescriptor getImplicitReceiver() {
                return classObjectDescriptor.getImplicitReceiver();
            }
        });
        return NamespaceLike.ClassObjectStatus.OK;
    }

    @Override
    public void addConstructor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull BindingTrace trace) {
        super.addConstructor(constructorDescriptor, trace);
        if (constructorDescriptor.isPrimary()) {
            for (ValueParameterDescriptor valueParameterDescriptor : constructorDescriptor.getValueParameters()) {
                JetParameter parameter = (JetParameter)trace.getBindingContext().get(BindingContext.DESCRIPTOR_TO_DECLARATION, valueParameterDescriptor);
                assert (parameter != null);
                if (parameter.getValOrVarNode() != null && constructorDescriptor.isPrimary()) continue;
                this.scopeForInitializers.addVariableDescriptor(valueParameterDescriptor);
            }
        }
    }

    @Override
    public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
        super.addPropertyDescriptor(propertyDescriptor);
        this.properties.add(propertyDescriptor);
        this.callableMembers.add(propertyDescriptor);
        this.scopeForMemberResolution.addPropertyDescriptor(propertyDescriptor);
    }

    @Override
    public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
        super.addFunctionDescriptor(functionDescriptor);
        this.functions.add(functionDescriptor);
        this.callableMembers.add(functionDescriptor);
        this.scopeForMemberResolution.addFunctionDescriptor(functionDescriptor);
    }

    @NotNull
    public Set<SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    @NotNull
    public Set<PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @NotNull
    public Set<CallableMemberDescriptor> getCallableMembers() {
        return this.callableMembers;
    }

    @Override
    public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
        super.addClassifierDescriptor(classDescriptor);
        this.scopeForMemberResolution.addClassifierDescriptor(classDescriptor);
    }

    @Override
    public void setTypeParameterDescriptors(List<TypeParameterDescriptor> typeParameters) {
        super.setTypeParameterDescriptors(typeParameters);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.scopeForSupertypeResolution.addTypeParameterDescriptor(typeParameterDescriptor);
        }
        this.scopeForSupertypeResolution.changeLockLevel(WritableScope.LockLevel.READING);
    }

    @Override
    public void setName(@NotNull String name) {
        super.setName(name);
        this.scopeForMemberResolution.addLabeledDeclaration(this);
    }

    @Override
    public void createTypeConstructor() {
        super.createTypeConstructor();
        this.scopeForMemberResolution.setImplicitReceiver(new ClassReceiver(this));
    }

    @NotNull
    public JetScope getScopeForSupertypeResolution() {
        return this.scopeForSupertypeResolution;
    }

    @NotNull
    public JetScope getScopeForMemberResolution() {
        return this.scopeForMemberResolution;
    }

    @NotNull
    public JetScope getScopeForInitializers() {
        return this.scopeForInitializers;
    }

    @Override
    public void lockScopes() {
        super.lockScopes();
        this.scopeForSupertypeResolution.changeLockLevel(WritableScope.LockLevel.READING);
        this.scopeForMemberResolution.changeLockLevel(WritableScope.LockLevel.READING);
        this.scopeForInitializers.changeLockLevel(WritableScope.LockLevel.READING);
    }
}

