/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class ConstructorDescriptorImpl
extends FunctionDescriptorImpl
implements ConstructorDescriptor {
    private final boolean isPrimary;

    public ConstructorDescriptorImpl(@NotNull ClassDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, boolean isPrimary) {
        super(containingDeclaration, annotations, "<init>", CallableMemberDescriptor.Kind.DECLARATION);
        this.isPrimary = isPrimary;
    }

    public ConstructorDescriptorImpl(@NotNull ClassDescriptor containingDeclaration, @NotNull ConstructorDescriptor original, @NotNull List<AnnotationDescriptor> annotations, boolean isPrimary) {
        super(containingDeclaration, original, annotations, "<init>", CallableMemberDescriptor.Kind.DECLARATION);
        this.isPrimary = isPrimary;
    }

    public ConstructorDescriptorImpl initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, Visibility visibility) {
        super.initialize(null, ConstructorDescriptorImpl.getExpectedThisObject(this.getContainingDeclaration()), typeParameters, unsubstitutedValueParameters, null, Modality.FINAL, visibility);
        return this;
    }

    @NotNull
    private static ReceiverDescriptor getExpectedThisObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor instanceof ConstructorDescriptor) {
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)descriptor;
            ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
            return ConstructorDescriptorImpl.getExpectedThisObject(classDescriptor);
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        return DescriptorUtils.getExpectedThisObjectIfNeeded(containingDeclaration);
    }

    @Override
    @NotNull
    public ClassDescriptor getContainingDeclaration() {
        return (ClassDescriptor)super.getContainingDeclaration();
    }

    @Override
    @NotNull
    public ConstructorDescriptor getOriginal() {
        return (ConstructorDescriptor)super.getOriginal();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitConstructorDescriptor(this, data);
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    @NotNull
    public Set<? extends FunctionDescriptor> getOverriddenDescriptors() {
        return Collections.emptySet();
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overriddenFunction) {
        throw new UnsupportedOperationException("Constructors cannot override anything");
    }

    @Override
    protected FunctionDescriptorImpl createSubstitutedCopy(DeclarationDescriptor newOwner, boolean preserveOriginal, CallableMemberDescriptor.Kind kind) {
        if (kind != CallableMemberDescriptor.Kind.DECLARATION) {
            throw new IllegalStateException();
        }
        return new ConstructorDescriptorImpl((ClassDescriptor)newOwner, this, Collections.<AnnotationDescriptor>emptyList(), this.isPrimary);
    }

    @Override
    @NotNull
    public ConstructorDescriptor copy(DeclarationDescriptor newOwner, boolean makeNonAbstract, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        throw new UnsupportedOperationException("Constructors should not be copied for overriding");
    }
}

