/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;

public class ClassDescriptorImpl
extends DeclarationDescriptorImpl
implements ClassDescriptor {
    private TypeConstructor typeConstructor;
    private JetScope memberDeclarations;
    private Set<ConstructorDescriptor> constructors;
    private ConstructorDescriptor primaryConstructor;
    private ReceiverDescriptor implicitReceiver;

    public ClassDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull String name) {
        super(containingDeclaration, annotations, name);
    }

    public final ClassDescriptorImpl initialize(boolean sealed, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull Collection<JetType> supertypes, @NotNull JetScope memberDeclarations, @NotNull Set<ConstructorDescriptor> constructors, @Nullable ConstructorDescriptor primaryConstructor) {
        return this.initialize(sealed, typeParameters, supertypes, memberDeclarations, constructors, primaryConstructor, this.getClassType(supertypes));
    }

    public final ClassDescriptorImpl initialize(boolean sealed, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull Collection<JetType> supertypes, @NotNull JetScope memberDeclarations, @NotNull Set<ConstructorDescriptor> constructors, @Nullable ConstructorDescriptor primaryConstructor, @Nullable JetType superclassType) {
        this.typeConstructor = new TypeConstructorImpl(this, this.getAnnotations(), sealed, this.getName(), typeParameters, supertypes);
        this.memberDeclarations = memberDeclarations;
        this.constructors = constructors;
        this.primaryConstructor = primaryConstructor;
        return this;
    }

    @NotNull
    private JetType getClassType(@NotNull Collection<JetType> types) {
        for (JetType type : types) {
            ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type);
            if (classDescriptor == null) continue;
            return type;
        }
        return JetStandardClasses.getAnyType();
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor primaryConstructor) {
        this.primaryConstructor = primaryConstructor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(List<TypeProjection> typeArguments) {
        assert (typeArguments.size() == this.typeConstructor.getParameters().size()) : typeArguments;
        if (this.typeConstructor.getParameters().isEmpty()) {
            return this.memberDeclarations;
        }
        Map<TypeConstructor, TypeProjection> substitutionContext = TypeUtils.buildSubstitutionContext(this.typeConstructor.getParameters(), typeArguments);
        return new SubstitutingScope(this.memberDeclarations, TypeSubstitutor.create(substitutionContext));
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        return TypeUtils.makeUnsubstitutedType(this, this.memberDeclarations);
    }

    @Override
    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        return this.constructors;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JetType getClassObjectType() {
        return null;
    }

    @Override
    public ClassDescriptor getClassObjectDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return ClassKind.CLASS;
    }

    @Override
    public boolean isClassObjectAValue() {
        return true;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitClassDescriptor(this, data);
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @Override
    public boolean hasConstructors() {
        return !this.constructors.isEmpty();
    }

    @Override
    @NotNull
    public Modality getModality() {
        return Modality.FINAL;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibility.PUBLIC;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        if (this.implicitReceiver == null) {
            this.implicitReceiver = new ClassReceiver(this);
        }
        return this.implicitReceiver;
    }

    @Override
    public ClassDescriptor getInnerClassOrObject(String name) {
        return null;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getInnerClassesAndObjects() {
        return Collections.emptyList();
    }
}

