/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ConditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionWithNext;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.NondeterministicJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineEnterInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineExitInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.psi.JetElement;

public class Pseudocode {
    private final List<Instruction> mutableInstructionList = new ArrayList<Instruction>();
    private final List<Instruction> instructions = new ArrayList<Instruction>();
    private List<Instruction> deadInstructions;
    private final List<PseudocodeLabel> labels = new ArrayList<PseudocodeLabel>();
    private final List<PseudocodeLabel> allowedDeadLabels = new ArrayList<PseudocodeLabel>();
    private final List<PseudocodeLabel> stopAllowDeadLabels = new ArrayList<PseudocodeLabel>();
    private final JetElement correspondingElement;
    private SubroutineExitInstruction exitInstruction;
    private SubroutineSinkInstruction sinkInstruction;
    private SubroutineExitInstruction errorInstruction;
    private boolean postPrecessed = false;

    public Pseudocode(JetElement correspondingElement) {
        this.correspondingElement = correspondingElement;
    }

    public JetElement getCorrespondingElement() {
        return this.correspondingElement;
    }

    public PseudocodeLabel createLabel(String name) {
        PseudocodeLabel label = new PseudocodeLabel(name);
        this.labels.add(label);
        return label;
    }

    public void allowDead(Label label) {
        this.allowedDeadLabels.add((PseudocodeLabel)label);
    }

    public void stopAllowDead(Label label) {
        this.stopAllowDeadLabels.add((PseudocodeLabel)label);
    }

    @NotNull
    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    @Deprecated
    @NotNull
    public List<Instruction> getMutableInstructionList() {
        return this.mutableInstructionList;
    }

    @NotNull
    public List<Instruction> getDeadInstructions() {
        if (this.deadInstructions != null) {
            return this.deadInstructions;
        }
        this.deadInstructions = Lists.newArrayList();
        Collection<Instruction> allowedDeadInstructions = this.collectAllowedDeadInstructions();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!((InstructionImpl)instruction).isDead() || allowedDeadInstructions.contains(instruction)) continue;
            this.deadInstructions.add(instruction);
        }
        return this.deadInstructions;
    }

    @Deprecated
    @NotNull
    public List<PseudocodeLabel> getLabels() {
        return this.labels;
    }

    public void addExitInstruction(SubroutineExitInstruction exitInstruction) {
        this.addInstruction(exitInstruction);
        assert (this.exitInstruction == null);
        this.exitInstruction = exitInstruction;
    }

    public void addSinkInstruction(SubroutineSinkInstruction sinkInstruction) {
        this.addInstruction(sinkInstruction);
        assert (this.sinkInstruction == null);
        this.sinkInstruction = sinkInstruction;
    }

    public void addErrorInstruction(SubroutineExitInstruction errorInstruction) {
        this.addInstruction(errorInstruction);
        assert (this.errorInstruction == null);
        this.errorInstruction = errorInstruction;
    }

    public void addInstruction(Instruction instruction) {
        this.mutableInstructionList.add(instruction);
        instruction.setOwner(this);
    }

    @NotNull
    public SubroutineExitInstruction getExitInstruction() {
        return this.exitInstruction;
    }

    @NotNull
    public SubroutineSinkInstruction getSinkInstruction() {
        return this.sinkInstruction;
    }

    @NotNull
    public SubroutineEnterInstruction getEnterInstruction() {
        return (SubroutineEnterInstruction)this.mutableInstructionList.get(0);
    }

    public void bindLabel(Label label) {
        ((PseudocodeLabel)label).setTargetInstructionIndex(this.mutableInstructionList.size());
    }

    public void postProcess() {
        if (this.postPrecessed) {
            return;
        }
        this.postPrecessed = true;
        int instructionsSize = this.mutableInstructionList.size();
        for (int i = 0; i < instructionsSize; ++i) {
            this.processInstruction(this.mutableInstructionList.get(i), i);
        }
        this.getExitInstruction().setSink(this.getSinkInstruction());
        Set<Instruction> reachableInstructions = this.collectReachableInstructions();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!reachableInstructions.contains(instruction)) continue;
            this.instructions.add(instruction);
        }
        this.markDeadInstructions();
    }

    private void processInstruction(Instruction instruction, final int currentPosition) {
        instruction.accept(new InstructionVisitor(){

            @Override
            public void visitInstructionWithNext(InstructionWithNext instruction) {
                instruction.setNext(Pseudocode.this.getNextPosition(currentPosition));
            }

            @Override
            public void visitJump(AbstractJumpInstruction instruction) {
                instruction.setResolvedTarget(Pseudocode.this.getJumpTarget(instruction.getTargetLabel()));
            }

            @Override
            public void visitNondeterministicJump(NondeterministicJumpInstruction instruction) {
                instruction.setNext(Pseudocode.this.getNextPosition(currentPosition));
                List<Label> targetLabels = instruction.getTargetLabels();
                for (Label targetLabel : targetLabels) {
                    instruction.setResolvedTarget(targetLabel, Pseudocode.this.getJumpTarget(targetLabel));
                }
            }

            @Override
            public void visitConditionalJump(ConditionalJumpInstruction instruction) {
                Instruction nextInstruction = Pseudocode.this.getNextPosition(currentPosition);
                Instruction jumpTarget = Pseudocode.this.getJumpTarget(instruction.getTargetLabel());
                if (instruction.onTrue()) {
                    instruction.setNextOnFalse(nextInstruction);
                    instruction.setNextOnTrue(jumpTarget);
                } else {
                    instruction.setNextOnFalse(jumpTarget);
                    instruction.setNextOnTrue(nextInstruction);
                }
                this.visitJump(instruction);
            }

            @Override
            public void visitLocalDeclarationInstruction(LocalDeclarationInstruction instruction) {
                instruction.getBody().postProcess();
                instruction.setNext(Pseudocode.this.getSinkInstruction());
            }

            @Override
            public void visitSubroutineExit(SubroutineExitInstruction instruction) {
            }

            @Override
            public void visitSubroutineSink(SubroutineSinkInstruction instruction) {
            }

            @Override
            public void visitInstruction(Instruction instruction) {
                throw new UnsupportedOperationException(instruction.toString());
            }
        });
    }

    private Set<Instruction> collectReachableInstructions() {
        HashSet visited = Sets.newHashSet();
        this.traverseNextInstructions(this.getEnterInstruction(), visited);
        if (!visited.contains(this.getExitInstruction())) {
            visited.add(this.getExitInstruction());
        }
        if (!visited.contains(this.errorInstruction)) {
            visited.add(this.errorInstruction);
        }
        if (!visited.contains(this.getSinkInstruction())) {
            visited.add(this.getSinkInstruction());
        }
        return visited;
    }

    private void traverseNextInstructions(Instruction instruction, Set<Instruction> visited) {
        if (visited.contains(instruction)) {
            return;
        }
        visited.add(instruction);
        for (Instruction nextInstruction : instruction.getNextInstructions()) {
            this.traverseNextInstructions(nextInstruction, visited);
        }
    }

    private void markDeadInstructions() {
        HashSet instructionSet = Sets.newHashSet(this.instructions);
        for (Instruction instruction : this.mutableInstructionList) {
            if (instructionSet.contains(instruction)) continue;
            ((InstructionImpl)instruction).die();
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                nextInstruction.getPreviousInstructions().remove(instruction);
            }
        }
    }

    @NotNull
    private Set<Instruction> prepareAllowedDeadInstructions() {
        HashSet allowedDeadStartInstructions = Sets.newHashSet();
        for (PseudocodeLabel allowedDeadLabel : this.allowedDeadLabels) {
            Instruction allowedDeadInstruction = this.getJumpTarget(allowedDeadLabel);
            if (!((InstructionImpl)allowedDeadInstruction).isDead()) continue;
            allowedDeadStartInstructions.add(allowedDeadInstruction);
        }
        return allowedDeadStartInstructions;
    }

    @NotNull
    private Set<Instruction> prepareStopAllowedDeadInstructions() {
        HashSet stopAllowedDeadInstructions = Sets.newHashSet();
        for (PseudocodeLabel stopAllowedDeadLabel : this.stopAllowDeadLabels) {
            Instruction stopAllowDeadInsruction = this.getJumpTarget(stopAllowedDeadLabel);
            if (!((InstructionImpl)stopAllowDeadInsruction).isDead()) continue;
            stopAllowedDeadInstructions.add(stopAllowDeadInsruction);
        }
        return stopAllowedDeadInstructions;
    }

    @NotNull
    private Collection<Instruction> collectAllowedDeadInstructions() {
        Set<Instruction> allowedDeadStartInstructions = this.prepareAllowedDeadInstructions();
        Set<Instruction> stopAllowDeadInstructions = this.prepareStopAllowedDeadInstructions();
        HashSet allowedDeadInstructions = Sets.newHashSet();
        for (Instruction allowedDeadStartInstruction : allowedDeadStartInstructions) {
            this.collectAllowedDeadInstructions(allowedDeadStartInstruction, allowedDeadInstructions, stopAllowDeadInstructions);
        }
        return allowedDeadInstructions;
    }

    private void collectAllowedDeadInstructions(Instruction allowedDeadInstruction, Set<Instruction> instructionSet, Set<Instruction> stopAllowDeadInstructions) {
        if (instructionSet.contains(allowedDeadInstruction) || stopAllowDeadInstructions.contains(allowedDeadInstruction)) {
            return;
        }
        if (((InstructionImpl)allowedDeadInstruction).isDead()) {
            instructionSet.add(allowedDeadInstruction);
            for (Instruction instruction : allowedDeadInstruction.getNextInstructions()) {
                this.collectAllowedDeadInstructions(instruction, instructionSet, stopAllowDeadInstructions);
            }
        }
    }

    @NotNull
    private Instruction getJumpTarget(@NotNull Label targetLabel) {
        return ((PseudocodeLabel)targetLabel).resolveToInstruction();
    }

    @NotNull
    private Instruction getNextPosition(int currentPosition) {
        int targetPosition = currentPosition + 1;
        assert (targetPosition < this.mutableInstructionList.size()) : currentPosition;
        return this.mutableInstructionList.get(targetPosition);
    }

    public class PseudocodeLabel
    implements Label {
        private final String name;
        private Integer targetInstructionIndex;

        private PseudocodeLabel(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public Integer getTargetInstructionIndex() {
            return this.targetInstructionIndex;
        }

        public void setTargetInstructionIndex(int targetInstructionIndex) {
            this.targetInstructionIndex = targetInstructionIndex;
        }

        @Nullable
        private List<Instruction> resolve() {
            assert (this.targetInstructionIndex != null);
            return Pseudocode.this.mutableInstructionList.subList(this.getTargetInstructionIndex(), Pseudocode.this.mutableInstructionList.size());
        }

        public Instruction resolveToInstruction() {
            assert (this.targetInstructionIndex != null);
            return (Instruction)Pseudocode.this.mutableInstructionList.get(this.targetInstructionIndex);
        }
    }
}

