/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;

public class NondeterministicJumpInstruction
extends InstructionImpl {
    private Instruction next;
    private final List<Label> targetLabels;
    private final Map<Label, Instruction> resolvedTargets;

    public NondeterministicJumpInstruction(List<Label> targetLabels) {
        this.targetLabels = Lists.newArrayList(targetLabels);
        this.resolvedTargets = Maps.newLinkedHashMap();
    }

    public NondeterministicJumpInstruction(Label targetLabel) {
        this(Lists.newArrayList((Object[])new Label[]{targetLabel}));
    }

    public List<Label> getTargetLabels() {
        return this.targetLabels;
    }

    public Map<Label, Instruction> getResolvedTargets() {
        return this.resolvedTargets;
    }

    public void setResolvedTarget(Label label, Instruction resolvedTarget) {
        Instruction target = this.outgoingEdgeTo(resolvedTarget);
        this.resolvedTargets.put(label, target);
    }

    public Instruction getNext() {
        return this.next;
    }

    public void setNext(Instruction next) {
        this.next = this.outgoingEdgeTo(next);
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitNondeterministicJump(this);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        ArrayList targetInstructions = Lists.newArrayList(this.getResolvedTargets().values());
        targetInstructions.add(this.getNext());
        return targetInstructions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("jmp?(");
        Iterator<Label> iterator = this.targetLabels.iterator();
        while (iterator.hasNext()) {
            Label targetLabel = iterator.next();
            sb.append(targetLabel.getName());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

