/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionPattern;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;

public class WhenChecker {
    public static boolean isWhenExhaust(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        JetExpression subjectExpression = expression.getSubjectExpression();
        if (subjectExpression == null) {
            return false;
        }
        JetType type = trace.get(BindingContext.EXPRESSION_TYPE, subjectExpression);
        if (type == null) {
            return false;
        }
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor.getKind() != ClassKind.ENUM_CLASS || classDescriptor.getModality().isOverridable()) {
            return false;
        }
        ClassDescriptor classObjectDescriptor = classDescriptor.getClassObjectDescriptor();
        assert (classObjectDescriptor != null);
        JetScope memberScope = classObjectDescriptor.getMemberScope(Collections.<TypeProjection>emptyList());
        Set<ClassDescriptor> objectDescriptors = memberScope.getObjectDescriptors();
        boolean isExhaust = true;
        boolean notEmpty = false;
        for (ClassDescriptor descriptor : objectDescriptors) {
            if (descriptor.getKind() != ClassKind.ENUM_ENTRY) continue;
            notEmpty = true;
            if (WhenChecker.containsEnumEntryCase(expression, descriptor, trace)) continue;
            isExhaust = false;
        }
        return isExhaust && notEmpty;
    }

    private static boolean containsEnumEntryCase(@NotNull JetWhenExpression whenExpression, @NotNull ClassDescriptor enumEntry, @NotNull BindingTrace trace) {
        assert (enumEntry.getKind() == ClassKind.ENUM_ENTRY);
        for (JetWhenEntry whenEntry : whenExpression.getEntries()) {
            for (JetWhenCondition condition : whenEntry.getConditions()) {
                JetExpression patternExpression;
                JetType type;
                JetExpressionPattern pattern;
                if (!(condition instanceof JetWhenConditionWithExpression) || (pattern = ((JetWhenConditionWithExpression)condition).getPattern()) == null || (type = trace.get(BindingContext.EXPRESSION_TYPE, patternExpression = pattern.getExpression())) == null || type.getConstructor().getDeclarationDescriptor() != enumEntry) continue;
                return true;
            }
        }
        return false;
    }
}

