/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.JetControlFlowGraphTraverser;
import org.jetbrains.jet.lang.cfg.JetControlFlowProcessor;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowDataTraceFactory;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowInstructionsGenerator;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.JetPseudocodeTrace;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.NondeterministicJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadUnitValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnNoValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineExitInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.UnconditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.VariableDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.WriteValueInstruction;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.plugin.JetMainDetector;

public class JetFlowInformationProvider {
    private final Map<JetElement, Pseudocode> pseudocodeMap;
    private BindingTrace trace;

    public JetFlowInformationProvider(@NotNull JetDeclaration declaration, @NotNull JetExpression bodyExpression, @NotNull JetControlFlowDataTraceFactory flowDataTraceFactory, @NotNull BindingTrace trace) {
        this.trace = trace;
        final JetPseudocodeTrace pseudocodeTrace = flowDataTraceFactory.createTrace(declaration);
        this.pseudocodeMap = new HashMap<JetElement, Pseudocode>();
        final HashMap representativeInstructions = new HashMap();
        final HashMap loopInfo = Maps.newHashMap();
        JetPseudocodeTrace wrappedTrace = new JetPseudocodeTrace(){

            @Override
            public void recordControlFlowData(@NotNull JetElement element, @NotNull Pseudocode pseudocode) {
                pseudocodeTrace.recordControlFlowData(element, pseudocode);
                JetFlowInformationProvider.this.pseudocodeMap.put(element, pseudocode);
            }

            @Override
            public void recordRepresentativeInstruction(@NotNull JetElement element, @NotNull Instruction instruction) {
                Instruction oldValue = representativeInstructions.put(element, instruction);
                pseudocodeTrace.recordRepresentativeInstruction(element, instruction);
            }

            @Override
            public void recordLoopInfo(JetExpression expression, LoopInfo blockInfo) {
                loopInfo.put(expression, blockInfo);
                pseudocodeTrace.recordLoopInfo(expression, blockInfo);
            }

            @Override
            public void close() {
                pseudocodeTrace.close();
                for (Pseudocode pseudocode : JetFlowInformationProvider.this.pseudocodeMap.values()) {
                    pseudocode.postProcess();
                }
            }
        };
        JetControlFlowInstructionsGenerator instructionsGenerator = new JetControlFlowInstructionsGenerator(wrappedTrace);
        new JetControlFlowProcessor(trace, instructionsGenerator).generate(declaration);
        wrappedTrace.close();
    }

    private void collectReturnExpressions(@NotNull JetElement subroutine, final @NotNull Collection<JetElement> returnedExpressions) {
        Pseudocode pseudocode = this.pseudocodeMap.get((Object)subroutine);
        assert (pseudocode != null);
        final HashSet instructions = Sets.newHashSet(pseudocode.getInstructions());
        SubroutineExitInstruction exitInstruction = pseudocode.getExitInstruction();
        for (Instruction previousInstruction : exitInstruction.getPreviousInstructions()) {
            previousInstruction.accept(new InstructionVisitor(){

                @Override
                public void visitReturnValue(ReturnValueInstruction instruction) {
                    if (instructions.contains(instruction)) {
                        returnedExpressions.add(instruction.getElement());
                    }
                }

                @Override
                public void visitReturnNoValue(ReturnNoValueInstruction instruction) {
                    if (instructions.contains(instruction)) {
                        returnedExpressions.add(instruction.getElement());
                    }
                }

                @Override
                public void visitJump(AbstractJumpInstruction instruction) {
                }

                @Override
                public void visitUnconditionalJump(UnconditionalJumpInstruction instruction) {
                    this.redirectToPrevInstructions(instruction);
                }

                private void redirectToPrevInstructions(Instruction instruction) {
                    for (Instruction previousInstruction : instruction.getPreviousInstructions()) {
                        previousInstruction.accept(this);
                    }
                }

                @Override
                public void visitNondeterministicJump(NondeterministicJumpInstruction instruction) {
                    this.redirectToPrevInstructions(instruction);
                }

                @Override
                public void visitInstruction(Instruction instruction) {
                    if (!(instruction instanceof JetElementInstruction)) {
                        throw new IllegalStateException(instruction + " precedes the exit point");
                    }
                    JetElementInstruction elementInstruction = (JetElementInstruction)instruction;
                    returnedExpressions.add(elementInstruction.getElement());
                }
            });
        }
    }

    public void checkDefiniteReturn(@NotNull JetDeclarationWithBody function, final @NotNull JetType expectedReturnType) {
        assert (function instanceof JetDeclaration);
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        ArrayList returnedExpressions = Lists.newArrayList();
        this.collectReturnExpressions(function.asElement(), returnedExpressions);
        boolean nothingReturned = returnedExpressions.isEmpty();
        returnedExpressions.remove(function);
        if (expectedReturnType != TypeUtils.NO_EXPECTED_TYPE && !JetStandardClasses.isUnit(expectedReturnType) && returnedExpressions.isEmpty() && !nothingReturned) {
            this.trace.report(Errors.RETURN_TYPE_MISMATCH.on(bodyExpression, expectedReturnType));
        }
        final boolean blockBody = function.hasBlockBody();
        final Set<JetElement> rootUnreachableElements = this.collectUnreachableCode(function.asElement());
        for (JetElement element : rootUnreachableElements) {
            this.trace.report(Errors.UNREACHABLE_CODE.on(element));
        }
        for (JetElement returnedExpression : returnedExpressions) {
            returnedExpression.accept(new JetVisitorVoid(){

                @Override
                public void visitReturnExpression(JetReturnExpression expression) {
                    if (!blockBody) {
                        JetFlowInformationProvider.this.trace.report(Errors.RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY.on(expression));
                    }
                }

                @Override
                public void visitExpression(JetExpression expression) {
                    if (blockBody && expectedReturnType != TypeUtils.NO_EXPECTED_TYPE && !JetStandardClasses.isUnit(expectedReturnType) && !rootUnreachableElements.contains((Object)expression)) {
                        JetFlowInformationProvider.this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY.on(expression));
                    }
                }
            });
        }
    }

    private Set<JetElement> collectUnreachableCode(@NotNull JetElement subroutine) {
        Pseudocode pseudocode = this.pseudocodeMap.get((Object)subroutine);
        assert (pseudocode != null);
        ArrayList unreachableElements = Lists.newArrayList();
        for (Instruction deadInstruction : pseudocode.getDeadInstructions()) {
            if (!(deadInstruction instanceof JetElementInstruction) || deadInstruction instanceof ReadUnitValueInstruction) continue;
            unreachableElements.add(((JetElementInstruction)deadInstruction).getElement());
        }
        return JetPsiUtil.findRootExpressions(unreachableElements);
    }

    public void markUninitializedVariables(@NotNull JetElement subroutine, final boolean processLocalDeclaration) {
        Pseudocode pseudocode = this.pseudocodeMap.get((Object)subroutine);
        assert (pseudocode != null);
        JetControlFlowGraphTraverser<Map<VariableDescriptor, VariableInitializers>> traverser = JetControlFlowGraphTraverser.create(pseudocode, false, true);
        Collection<VariableDescriptor> usedVariables = this.collectUsedVariables(pseudocode);
        final Collection<VariableDescriptor> declaredVariables = this.collectDeclaredVariables(subroutine);
        Map<VariableDescriptor, VariableInitializers> initialMapForStartInstruction = this.prepareInitialMapForStartInstruction(usedVariables, declaredVariables);
        traverser.collectInformationFromInstructionGraph(Collections.emptyMap(), initialMapForStartInstruction, new JetControlFlowGraphTraverser.InstructionDataMergeStrategy<Map<VariableDescriptor, VariableInitializers>>(){

            @Override
            public Pair<Map<VariableDescriptor, VariableInitializers>, Map<VariableDescriptor, VariableInitializers>> execute(@NotNull Instruction instruction, @NotNull Collection<Map<VariableDescriptor, VariableInitializers>> incomingEdgesData) {
                Map enterInstructionData = JetFlowInformationProvider.this.mergeIncomingEdgesData(incomingEdgesData);
                Map exitInstructionData = JetFlowInformationProvider.this.addVariableInitializerFromCurrentInstructionIfAny(instruction, enterInstructionData);
                return Pair.create((Object)enterInstructionData, (Object)exitInstructionData);
            }
        });
        final HashSet varWithUninitializedErrorGenerated = Sets.newHashSet();
        final HashSet varWithValReassignErrorGenerated = Sets.newHashSet();
        final boolean processClassOrObject = subroutine instanceof JetClassOrObject;
        traverser.traverseAndAnalyzeInstructionGraph(new JetControlFlowGraphTraverser.InstructionDataAnalyzeStrategy<Map<VariableDescriptor, VariableInitializers>>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Map<VariableDescriptor, VariableInitializers> enterData, @Nullable Map<VariableDescriptor, VariableInitializers> exitData) {
                assert (enterData != null && exitData != null);
                VariableDescriptor variableDescriptor = JetFlowInformationProvider.this.extractVariableDescriptorIfAny(instruction, true);
                if (variableDescriptor == null) {
                    return;
                }
                if (instruction instanceof ReadValueInstruction) {
                    JetElement element = ((ReadValueInstruction)instruction).getElement();
                    boolean error = JetFlowInformationProvider.this.checkBackingField(variableDescriptor, element);
                    if (!error && declaredVariables.contains(variableDescriptor)) {
                        JetFlowInformationProvider.this.checkIsInitialized(variableDescriptor, element, exitData.get(variableDescriptor), varWithUninitializedErrorGenerated);
                    }
                } else if (instruction instanceof WriteValueInstruction) {
                    JetElement element = ((WriteValueInstruction)instruction).getlValue();
                    boolean error = JetFlowInformationProvider.this.checkBackingField(variableDescriptor, element);
                    if (!(element instanceof JetExpression)) {
                        return;
                    }
                    if (!error && !processLocalDeclaration) {
                        error = JetFlowInformationProvider.this.checkValReassignment(variableDescriptor, (JetExpression)element, enterData.get(variableDescriptor), varWithValReassignErrorGenerated);
                    }
                    if (!error && processClassOrObject) {
                        error = JetFlowInformationProvider.this.checkAssignmentBeforeDeclaration(variableDescriptor, (JetExpression)element, enterData.get(variableDescriptor), exitData.get(variableDescriptor));
                    }
                    if (!error && processClassOrObject) {
                        JetFlowInformationProvider.this.checkInitializationUsingBackingField(variableDescriptor, (JetExpression)element, enterData.get(variableDescriptor), exitData.get(variableDescriptor));
                    }
                }
            }
        });
        this.recordInitializedVariables(declaredVariables, (Map)traverser.getResultInfo());
        this.analyzeLocalDeclarations(pseudocode, processLocalDeclaration);
    }

    private void checkIsInitialized(@NotNull VariableDescriptor variableDescriptor, @NotNull JetElement element, @NotNull VariableInitializers variableInitializers, @NotNull Collection<VariableDescriptor> varWithUninitializedErrorGenerated) {
        if (!(element instanceof JetSimpleNameExpression)) {
            return;
        }
        boolean isInitialized = variableInitializers.isInitialized();
        if (variableDescriptor instanceof PropertyDescriptor && !this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue()) {
            isInitialized = true;
        }
        if (!isInitialized && !varWithUninitializedErrorGenerated.contains(variableDescriptor)) {
            varWithUninitializedErrorGenerated.add(variableDescriptor);
            if (variableDescriptor instanceof ValueParameterDescriptor) {
                this.trace.report(Errors.UNINITIALIZED_PARAMETER.on((JetSimpleNameExpression)element, (ValueParameterDescriptor)variableDescriptor));
            } else {
                this.trace.report(Errors.UNINITIALIZED_VARIABLE.on((JetSimpleNameExpression)element, variableDescriptor));
            }
        }
    }

    private boolean checkValReassignment(@NotNull VariableDescriptor variableDescriptor, @NotNull JetExpression expression, @NotNull VariableInitializers enterInitializers, @NotNull Collection<VariableDescriptor> varWithValReassignErrorGenerated) {
        JetElement initializer;
        boolean isInitializedNotHere = enterInitializers.isInitialized();
        Set<JetElement> possibleLocalInitializers = enterInitializers.getPossibleLocalInitializers();
        if (possibleLocalInitializers.size() == 1 && (initializer = possibleLocalInitializers.iterator().next()) instanceof JetProperty && initializer == expression.getParent()) {
            isInitializedNotHere = false;
        }
        boolean hasBackingField = true;
        if (variableDescriptor instanceof PropertyDescriptor) {
            hasBackingField = this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor);
        }
        if (!(!isInitializedNotHere && hasBackingField || variableDescriptor.isVar() || varWithValReassignErrorGenerated.contains(variableDescriptor))) {
            varWithValReassignErrorGenerated.add(variableDescriptor);
            boolean hasReassignMethodReturningUnit = false;
            JetSimpleNameExpression operationReference = null;
            PsiElement parent = expression.getParent();
            if (parent instanceof JetBinaryExpression) {
                operationReference = ((JetBinaryExpression)parent).getOperationReference();
            } else if (parent instanceof JetUnaryExpression) {
                operationReference = ((JetUnaryExpression)parent).getOperationReference();
            }
            if (operationReference != null) {
                Collection<? extends DeclarationDescriptor> descriptors;
                DeclarationDescriptor descriptor = this.trace.get(BindingContext.REFERENCE_TARGET, operationReference);
                if (descriptor instanceof FunctionDescriptor && JetStandardClasses.isUnit(((FunctionDescriptor)descriptor).getReturnType())) {
                    hasReassignMethodReturningUnit = true;
                }
                if (descriptor == null && (descriptors = this.trace.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationReference)) != null) {
                    for (DeclarationDescriptor declarationDescriptor : descriptors) {
                        if (!JetStandardClasses.isUnit(((FunctionDescriptor)declarationDescriptor).getReturnType())) continue;
                        hasReassignMethodReturningUnit = true;
                    }
                }
            }
            if (!hasReassignMethodReturningUnit) {
                this.trace.report(Errors.VAL_REASSIGNMENT.on(expression, variableDescriptor));
                return true;
            }
        }
        return false;
    }

    private boolean checkAssignmentBeforeDeclaration(@NotNull VariableDescriptor variableDescriptor, @NotNull JetExpression expression, @NotNull VariableInitializers enterInitializers, @NotNull VariableInitializers exitInitializers) {
        if (!enterInitializers.isDeclared() && !exitInitializers.isDeclared() && !enterInitializers.isInitialized() && exitInitializers.isInitialized()) {
            this.trace.report(Errors.INITIALIZATION_BEFORE_DECLARATION.on(expression, variableDescriptor));
            return true;
        }
        return false;
    }

    private boolean checkInitializationUsingBackingField(@NotNull VariableDescriptor variableDescriptor, @NotNull JetExpression expression, @NotNull VariableInitializers enterInitializers, @NotNull VariableInitializers exitInitializers) {
        if (variableDescriptor instanceof PropertyDescriptor && !enterInitializers.isInitialized() && exitInitializers.isInitialized()) {
            JetSimpleNameExpression simpleNameExpression;
            if (!variableDescriptor.isVar()) {
                return false;
            }
            if (!this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue()) {
                return false;
            }
            PsiElement property = this.trace.get(BindingContext.DESCRIPTOR_TO_DECLARATION, variableDescriptor);
            assert (property instanceof JetProperty);
            if (((PropertyDescriptor)variableDescriptor).getModality() == Modality.FINAL && ((JetProperty)property).getSetter() == null) {
                return false;
            }
            JetExpression variable = expression;
            if (expression instanceof JetDotQualifiedExpression && ((JetDotQualifiedExpression)expression).getReceiverExpression() instanceof JetThisExpression) {
                variable = ((JetDotQualifiedExpression)expression).getSelectorExpression();
            }
            if (variable instanceof JetSimpleNameExpression && (simpleNameExpression = (JetSimpleNameExpression)variable).getReferencedNameElementType() != JetTokens.FIELD_IDENTIFIER) {
                if (((PropertyDescriptor)variableDescriptor).getModality() != Modality.FINAL) {
                    this.trace.report(Errors.INITIALIZATION_USING_BACKING_FIELD_OPEN_SETTER.on(expression, variableDescriptor));
                } else {
                    this.trace.report(Errors.INITIALIZATION_USING_BACKING_FIELD_CUSTOM_SETTER.on(expression, variableDescriptor));
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkBackingField(@NotNull VariableDescriptor variableDescriptor, @NotNull JetElement element) {
        boolean[] error = new boolean[1];
        if (this.isBackingFieldReference((JetElement)element.getParent(), error, false)) {
            return false;
        }
        if (!this.isBackingFieldReference(element, error, true)) {
            return false;
        }
        if (error[0]) {
            return true;
        }
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            this.trace.report(Errors.NOT_PROPERTY_BACKING_FIELD.on(element));
            return true;
        }
        PsiElement property = this.trace.get(BindingContext.DESCRIPTOR_TO_DECLARATION, variableDescriptor);
        boolean insideSelfAccessors = PsiTreeUtil.isAncestor((PsiElement)property, (PsiElement)element, (boolean)false);
        if (!this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)variableDescriptor).booleanValue() && !insideSelfAccessors) {
            if (((PropertyDescriptor)variableDescriptor).getModality() == Modality.ABSTRACT) {
                this.trace.report(Errors.NO_BACKING_FIELD_ABSTRACT_PROPERTY.on(element));
            } else {
                this.trace.report(Errors.NO_BACKING_FIELD_CUSTOM_ACCESSORS.on(element));
            }
            return true;
        }
        if (insideSelfAccessors) {
            return false;
        }
        JetNamedDeclaration parentDeclaration = (JetNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, JetNamedDeclaration.class);
        DeclarationDescriptor declarationDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
        assert (declarationDescriptor != null);
        DeclarationDescriptor containingDeclaration = variableDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor && DescriptorUtils.isAncestor(containingDeclaration, declarationDescriptor, false)) {
            return false;
        }
        this.trace.report(Errors.INACCESSIBLE_BACKING_FIELD.on(element));
        return true;
    }

    private boolean isBackingFieldReference(@Nullable JetElement element, boolean[] error, boolean reportError) {
        error[0] = false;
        if (element instanceof JetSimpleNameExpression && ((JetSimpleNameExpression)element).getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            return true;
        }
        if (element instanceof JetDotQualifiedExpression && this.isBackingFieldReference(((JetDotQualifiedExpression)element).getSelectorExpression(), error, false)) {
            if (((JetDotQualifiedExpression)element).getReceiverExpression() instanceof JetThisExpression) {
                return true;
            }
            error[0] = true;
            if (reportError) {
                this.trace.report(Errors.INACCESSIBLE_BACKING_FIELD.on(element));
            }
        }
        return false;
    }

    private void recordInitializedVariables(Collection<VariableDescriptor> declaredVariables, Map<VariableDescriptor, VariableInitializers> resultInfo) {
        for (Map.Entry<VariableDescriptor, VariableInitializers> entry : resultInfo.entrySet()) {
            VariableDescriptor variable = entry.getKey();
            if (!(variable instanceof PropertyDescriptor) || !declaredVariables.contains(variable)) continue;
            VariableInitializers initializers = entry.getValue();
            this.trace.record(BindingContext.IS_INITIALIZED, (PropertyDescriptor)variable, initializers.isInitialized());
        }
    }

    private void analyzeLocalDeclarations(Pseudocode pseudocode, boolean processLocalDeclaration) {
        for (Instruction instruction : pseudocode.getInstructions()) {
            if (!(instruction instanceof LocalDeclarationInstruction)) continue;
            JetElement element = ((LocalDeclarationInstruction)instruction).getElement();
            this.markUninitializedVariables(element, processLocalDeclaration);
        }
    }

    private Map<VariableDescriptor, VariableInitializers> addVariableInitializerFromCurrentInstructionIfAny(Instruction instruction, Map<VariableDescriptor, VariableInitializers> enterInstructionData) {
        JetProperty property;
        JetElement element;
        VariableDescriptor variable;
        VariableInitializers enterInitializers;
        HashMap exitInstructionData = Maps.newHashMap(enterInstructionData);
        if (instruction instanceof WriteValueInstruction) {
            VariableDescriptor variable2 = this.extractVariableDescriptorIfAny(instruction, false);
            VariableInitializers enterInitializers2 = enterInstructionData.get(variable2);
            VariableInitializers initializationAtThisElement = new VariableInitializers(((WriteValueInstruction)instruction).getElement(), enterInitializers2);
            exitInstructionData.put(variable2, initializationAtThisElement);
        } else if (instruction instanceof VariableDeclarationInstruction && ((enterInitializers = enterInstructionData.get(variable = this.extractVariableDescriptorIfAny(instruction, false))) == null || !enterInitializers.isInitialized() || !enterInitializers.isDeclared()) && (element = ((VariableDeclarationInstruction)instruction).getElement()) instanceof JetProperty && (property = (JetProperty)element).getInitializer() == null) {
            boolean isInitialized = enterInitializers != null && enterInitializers.isInitialized();
            VariableInitializers variableDeclarationInfo = new VariableInitializers(isInitialized, true);
            exitInstructionData.put(variable, variableDeclarationInfo);
        }
        return exitInstructionData;
    }

    private Map<VariableDescriptor, VariableInitializers> mergeIncomingEdgesData(Collection<Map<VariableDescriptor, VariableInitializers>> incomingEdgesData) {
        HashSet variablesInScope = Sets.newHashSet();
        for (Map<VariableDescriptor, VariableInitializers> edgeData : incomingEdgesData) {
            variablesInScope.addAll(edgeData.keySet());
        }
        HashMap enterInstructionData = Maps.newHashMap();
        for (VariableDescriptor variable : variablesInScope) {
            HashSet edgesDataForVariable = Sets.newHashSet();
            for (Map<VariableDescriptor, VariableInitializers> edgeData : incomingEdgesData) {
                VariableInitializers initializers = edgeData.get(variable);
                if (initializers == null) continue;
                edgesDataForVariable.add(initializers);
            }
            enterInstructionData.put(variable, new VariableInitializers(edgesDataForVariable));
        }
        return enterInstructionData;
    }

    private Map<VariableDescriptor, VariableInitializers> prepareInitialMapForStartInstruction(Collection<VariableDescriptor> usedVariables, Collection<VariableDescriptor> declaredVariables) {
        HashMap initialMapForStartInstruction = Maps.newHashMap();
        VariableInitializers isInitializedForExternalVariable = new VariableInitializers(true);
        VariableInitializers isNotInitializedForDeclaredVariable = new VariableInitializers(false);
        for (VariableDescriptor variable : usedVariables) {
            if (declaredVariables.contains(variable)) {
                initialMapForStartInstruction.put(variable, isNotInitializedForDeclaredVariable);
                continue;
            }
            initialMapForStartInstruction.put(variable, isInitializedForExternalVariable);
        }
        return initialMapForStartInstruction;
    }

    public void markNotOnlyInvokedFunctionVariables(@NotNull JetElement subroutine, List<? extends VariableDescriptor> variables) {
        final ArrayList functionVariables = Lists.newArrayList();
        for (VariableDescriptor variableDescriptor : variables) {
            if (!JetStandardClasses.isFunctionType(variableDescriptor.getReturnType())) continue;
            functionVariables.add(variableDescriptor);
        }
        Pseudocode pseudocode = this.pseudocodeMap.get((Object)subroutine);
        assert (pseudocode != null);
        JetControlFlowGraphTraverser.create(pseudocode, true, true).traverseAndAnalyzeInstructionGraph(new JetControlFlowGraphTraverser.InstructionDataAnalyzeStrategy<Void>(){

            @Override
            public void execute(@NotNull Instruction instruction, Void enterData, Void exitData) {
                JetElement element;
                VariableDescriptor variableDescriptor;
                if (instruction instanceof ReadValueInstruction && (variableDescriptor = JetFlowInformationProvider.this.extractVariableDescriptorIfAny(instruction, false)) != null && functionVariables.contains(variableDescriptor) && (element = ((ReadValueInstruction)instruction).getElement()) instanceof JetSimpleNameExpression && !(element.getParent() instanceof JetCallExpression)) {
                    JetFlowInformationProvider.this.trace.report(Errors.FUNCTION_PARAMETERS_OF_INLINE_FUNCTION.on((JetSimpleNameExpression)element, variableDescriptor));
                }
            }
        });
    }

    public void markUnusedVariables(@NotNull JetElement subroutine) {
        Pseudocode pseudocode = this.pseudocodeMap.get((Object)subroutine);
        assert (pseudocode != null);
        JetControlFlowGraphTraverser<Map<VariableDescriptor, VariableStatus>> traverser = JetControlFlowGraphTraverser.create(pseudocode, true, false);
        final Collection<VariableDescriptor> declaredVariables = this.collectDeclaredVariables(subroutine);
        HashMap sinkInstructionData = Maps.newHashMap();
        traverser.collectInformationFromInstructionGraph(Collections.emptyMap(), sinkInstructionData, new JetControlFlowGraphTraverser.InstructionDataMergeStrategy<Map<VariableDescriptor, VariableStatus>>(){

            @Override
            public Pair<Map<VariableDescriptor, VariableStatus>, Map<VariableDescriptor, VariableStatus>> execute(@NotNull Instruction instruction, @NotNull Collection<Map<VariableDescriptor, VariableStatus>> incomingEdgesData) {
                HashMap enterResult = Maps.newHashMap();
                for (Map<VariableDescriptor, VariableStatus> edgeData : incomingEdgesData) {
                    for (Map.Entry<VariableDescriptor, VariableStatus> entry : edgeData.entrySet()) {
                        VariableDescriptor variableDescriptor = entry.getKey();
                        VariableStatus variableStatus = entry.getValue();
                        enterResult.put(variableDescriptor, variableStatus.merge((VariableStatus)((Object)enterResult.get(variableDescriptor))));
                    }
                }
                HashMap exitResult = Maps.newHashMap((Map)enterResult);
                VariableDescriptor variableDescriptor = JetFlowInformationProvider.this.extractVariableDescriptorIfAny(instruction, true);
                if (variableDescriptor != null) {
                    if (instruction instanceof ReadValueInstruction) {
                        exitResult.put(variableDescriptor, VariableStatus.READ);
                    } else if (instruction instanceof WriteValueInstruction) {
                        VariableStatus variableStatus = (VariableStatus)((Object)enterResult.get(variableDescriptor));
                        if (variableStatus == null) {
                            variableStatus = VariableStatus.UNUSED;
                        }
                        switch (variableStatus) {
                            case UNUSED: 
                            case ONLY_WRITTEN: {
                                exitResult.put(variableDescriptor, VariableStatus.ONLY_WRITTEN);
                                break;
                            }
                            case WRITTEN: 
                            case READ: {
                                exitResult.put(variableDescriptor, VariableStatus.WRITTEN);
                            }
                        }
                    }
                }
                return new Pair((Object)enterResult, (Object)exitResult);
            }
        });
        traverser.traverseAndAnalyzeInstructionGraph(new JetControlFlowGraphTraverser.InstructionDataAnalyzeStrategy<Map<VariableDescriptor, VariableStatus>>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Map<VariableDescriptor, VariableStatus> enterData, @Nullable Map<VariableDescriptor, VariableStatus> exitData) {
                JetDeclaration element;
                assert (enterData != null && exitData != null);
                VariableDescriptor variableDescriptor = JetFlowInformationProvider.this.extractVariableDescriptorIfAny(instruction, false);
                if (variableDescriptor == null || !declaredVariables.contains(variableDescriptor) || !DescriptorUtils.isLocal(variableDescriptor.getContainingDeclaration(), variableDescriptor)) {
                    return;
                }
                VariableStatus variableStatus = enterData.get(variableDescriptor);
                if (instruction instanceof WriteValueInstruction) {
                    if (JetFlowInformationProvider.this.trace.get(BindingContext.MUST_BE_WRAPPED_IN_A_REF, variableDescriptor).booleanValue()) {
                        return;
                    }
                    JetElement element2 = ((WriteValueInstruction)instruction).getElement();
                    if (variableStatus != VariableStatus.READ) {
                        IElementType operationToken;
                        if (element2 instanceof JetBinaryExpression && ((JetBinaryExpression)element2).getOperationToken() == JetTokens.EQ) {
                            JetExpression right = ((JetBinaryExpression)element2).getRight();
                            if (right != null) {
                                JetFlowInformationProvider.this.trace.report(Errors.UNUSED_VALUE.on(right, right, variableDescriptor));
                            }
                        } else if (element2 instanceof JetPostfixExpression && ((operationToken = ((JetPostfixExpression)element2).getOperationReference().getReferencedNameElementType()) == JetTokens.PLUSPLUS || operationToken == JetTokens.MINUSMINUS)) {
                            JetFlowInformationProvider.this.trace.report(Errors.UNUSED_CHANGED_VALUE.on(element2, element2));
                        }
                    }
                } else if (instruction instanceof VariableDeclarationInstruction && (element = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement()) instanceof JetNamedDeclaration) {
                    JetExpression initializer;
                    PsiElement nameIdentifier = ((JetNamedDeclaration)element).getNameIdentifier();
                    if (nameIdentifier == null) {
                        return;
                    }
                    if (variableStatus == null || variableStatus == VariableStatus.UNUSED) {
                        PsiElement psiElement;
                        if (element instanceof JetProperty) {
                            JetFlowInformationProvider.this.trace.report(Errors.UNUSED_VARIABLE.on((JetProperty)element, variableDescriptor));
                        } else if (element instanceof JetParameter && (psiElement = element.getParent().getParent()) instanceof JetFunction) {
                            boolean isMain = psiElement instanceof JetNamedFunction && JetMainDetector.isMain((JetNamedFunction)psiElement);
                            DeclarationDescriptor descriptor = JetFlowInformationProvider.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, psiElement);
                            assert (descriptor instanceof FunctionDescriptor);
                            FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
                            if (!isMain && !functionDescriptor.getModality().isOverridable() && functionDescriptor.getOverriddenDescriptors().isEmpty()) {
                                JetFlowInformationProvider.this.trace.report(Errors.UNUSED_PARAMETER.on((JetParameter)element, variableDescriptor));
                            }
                        }
                    } else if (variableStatus == VariableStatus.ONLY_WRITTEN && element instanceof JetProperty) {
                        JetFlowInformationProvider.this.trace.report(Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE.on((JetNamedDeclaration)element, variableDescriptor));
                    } else if (variableStatus == VariableStatus.WRITTEN && element instanceof JetProperty && (initializer = ((JetProperty)element).getInitializer()) != null) {
                        JetFlowInformationProvider.this.trace.report(Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on(initializer, variableDescriptor));
                    }
                }
            }
        });
    }

    public void markUnusedLiteralsInBlock(@NotNull JetElement subroutine) {
        Pseudocode pseudocode = this.pseudocodeMap.get((Object)subroutine);
        assert (pseudocode != null);
        JetControlFlowGraphTraverser<Void> traverser = JetControlFlowGraphTraverser.create(pseudocode, true, true);
        traverser.traverseAndAnalyzeInstructionGraph(new JetControlFlowGraphTraverser.InstructionDataAnalyzeStrategy<Void>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Void enterData, @Nullable Void exitData) {
                if (!(instruction instanceof ReadValueInstruction)) {
                    return;
                }
                JetElement element = ((ReadValueInstruction)instruction).getElement();
                if (!(element instanceof JetFunctionLiteralExpression || element instanceof JetConstantExpression || element instanceof JetStringTemplateExpression || element instanceof JetSimpleNameExpression)) {
                    return;
                }
                PsiElement parent = element.getParent();
                if (parent instanceof JetBlockExpression && !JetPsiUtil.isImplicitlyUsed(element)) {
                    if (element instanceof JetFunctionLiteralExpression) {
                        JetFlowInformationProvider.this.trace.report(Errors.UNUSED_FUNCTION_LITERAL.on((JetFunctionLiteralExpression)element));
                    } else {
                        JetFlowInformationProvider.this.trace.report(Errors.UNUSED_EXPRESSION.on(element));
                    }
                }
            }
        });
    }

    @Nullable
    private VariableDescriptor extractVariableDescriptorIfAny(Instruction instruction, boolean onlyReference) {
        JetElement element = null;
        if (instruction instanceof ReadValueInstruction) {
            element = ((ReadValueInstruction)instruction).getElement();
        } else if (instruction instanceof WriteValueInstruction) {
            element = ((WriteValueInstruction)instruction).getlValue();
        } else if (instruction instanceof VariableDeclarationInstruction) {
            element = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
        }
        return BindingContextUtils.extractVariableDescriptorIfAny(this.trace.getBindingContext(), element, onlyReference);
    }

    private Collection<VariableDescriptor> collectUsedVariables(Pseudocode pseudocode) {
        final HashSet usedVariables = Sets.newHashSet();
        JetControlFlowGraphTraverser.create(pseudocode, true, true).traverseAndAnalyzeInstructionGraph(new JetControlFlowGraphTraverser.InstructionDataAnalyzeStrategy<Void>(){

            @Override
            public void execute(@NotNull Instruction instruction, Void enterData, Void exitData) {
                VariableDescriptor variableDescriptor = JetFlowInformationProvider.this.extractVariableDescriptorIfAny(instruction, false);
                if (variableDescriptor != null) {
                    usedVariables.add(variableDescriptor);
                }
            }
        });
        return usedVariables;
    }

    private Collection<VariableDescriptor> collectDeclaredVariables(JetElement element) {
        Pseudocode pseudocode = this.pseudocodeMap.get((Object)element);
        assert (pseudocode != null);
        final HashSet declaredVariables = Sets.newHashSet();
        JetControlFlowGraphTraverser.create(pseudocode, false, true).traverseAndAnalyzeInstructionGraph(new JetControlFlowGraphTraverser.InstructionDataAnalyzeStrategy<Void>(){

            @Override
            public void execute(@NotNull Instruction instruction, @Nullable Void enterData, @Nullable Void exitData) {
                if (instruction instanceof VariableDeclarationInstruction) {
                    JetDeclaration variableDeclarationElement = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
                    DeclarationDescriptor descriptor = JetFlowInformationProvider.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, variableDeclarationElement);
                    if (descriptor != null) {
                        assert (descriptor instanceof VariableDescriptor);
                        declaredVariables.add((VariableDescriptor)descriptor);
                    }
                }
            }
        });
        return declaredVariables;
    }

    private static class VariableInitializers {
        private Set<JetElement> possibleLocalInitializers = Sets.newHashSet();
        private boolean isInitialized;
        private boolean isDeclared;

        public VariableInitializers(boolean isInitialized) {
            this(isInitialized, false);
        }

        public VariableInitializers(boolean isInitialized, boolean isDeclared) {
            this.isInitialized = isInitialized;
            this.isDeclared = isDeclared;
        }

        public VariableInitializers(JetElement element, @Nullable VariableInitializers previous) {
            this.isInitialized = true;
            this.isDeclared = element instanceof JetProperty || previous != null && previous.isDeclared();
            this.possibleLocalInitializers.add(element);
        }

        public VariableInitializers(Set<VariableInitializers> edgesData) {
            this.isInitialized = true;
            this.isDeclared = true;
            for (VariableInitializers edgeData : edgesData) {
                if (!edgeData.isInitialized) {
                    this.isInitialized = false;
                }
                if (!edgeData.isDeclared) {
                    this.isDeclared = false;
                }
                this.possibleLocalInitializers.addAll(edgeData.possibleLocalInitializers);
            }
        }

        public Set<JetElement> getPossibleLocalInitializers() {
            return this.possibleLocalInitializers;
        }

        public boolean isInitialized() {
            return this.isInitialized;
        }

        public boolean isDeclared() {
            return this.isDeclared;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VariableInitializers)) {
                return false;
            }
            VariableInitializers that = (VariableInitializers)o;
            if (this.isDeclared != that.isDeclared) {
                return false;
            }
            if (this.isInitialized != that.isInitialized) {
                return false;
            }
            return !(this.possibleLocalInitializers != null ? !((Object)this.possibleLocalInitializers).equals(that.possibleLocalInitializers) : that.possibleLocalInitializers != null);
        }

        public int hashCode() {
            int result = this.possibleLocalInitializers != null ? ((Object)this.possibleLocalInitializers).hashCode() : 0;
            result = 31 * result + (this.isInitialized ? 1 : 0);
            result = 31 * result + (this.isDeclared ? 1 : 0);
            return result;
        }
    }

    private static enum VariableStatus {
        READ(3),
        WRITTEN(2),
        ONLY_WRITTEN(1),
        UNUSED(0);

        private int importance;

        private VariableStatus(int importance) {
            this.importance = importance;
        }

        public VariableStatus merge(@Nullable VariableStatus variableStatus) {
            if (variableStatus == null || this.importance > variableStatus.importance) {
                return this;
            }
            return variableStatus;
        }
    }
}

