/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineEnterInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;

public class JetControlFlowGraphTraverser<D> {
    private final Pseudocode pseudocode;
    private final boolean lookInside;
    private final boolean straightDirection;
    private final Map<Instruction, Pair<D, D>> dataMap = Maps.newLinkedHashMap();

    public static <D> JetControlFlowGraphTraverser<D> create(@NotNull Pseudocode pseudocode, boolean lookInside, boolean straightDirection) {
        return new JetControlFlowGraphTraverser<D>(pseudocode, lookInside, straightDirection);
    }

    private JetControlFlowGraphTraverser(@NotNull Pseudocode pseudocode, boolean lookInside, boolean straightDirection) {
        this.pseudocode = pseudocode;
        this.lookInside = lookInside;
        this.straightDirection = straightDirection;
    }

    @NotNull
    private Instruction getStartInstruction(@NotNull Pseudocode pseudocode) {
        return this.straightDirection ? pseudocode.getEnterInstruction() : pseudocode.getSinkInstruction();
    }

    public void collectInformationFromInstructionGraph(@NotNull D initialDataValue, @NotNull D initialDataValueForEnterInstruction, @NotNull InstructionDataMergeStrategy<D> instructionDataMergeStrategy) {
        this.initializeDataMap(this.pseudocode, initialDataValue);
        this.dataMap.put(this.getStartInstruction(this.pseudocode), Pair.create(initialDataValueForEnterInstruction, initialDataValueForEnterInstruction));
        boolean[] changed = new boolean[]{true};
        while (changed[0]) {
            changed[0] = false;
            this.traverseSubGraph(this.pseudocode, instructionDataMergeStrategy, Collections.<Instruction>emptyList(), changed, false);
        }
    }

    private void initializeDataMap(@NotNull Pseudocode pseudocode, @NotNull D initialDataValue) {
        List<Instruction> instructions = pseudocode.getInstructions();
        Pair initialPair = Pair.create(initialDataValue, initialDataValue);
        for (Instruction instruction : instructions) {
            this.dataMap.put(instruction, initialPair);
            if (!this.lookInside || !(instruction instanceof LocalDeclarationInstruction)) continue;
            this.initializeDataMap(((LocalDeclarationInstruction)instruction).getBody(), initialDataValue);
        }
    }

    private void traverseSubGraph(@NotNull Pseudocode pseudocode, @NotNull InstructionDataMergeStrategy<D> instructionDataMergeStrategy, @NotNull Collection<Instruction> previousSubGraphInstructions, boolean[] changed, boolean isLocal) {
        ArrayList instructions = pseudocode.getInstructions();
        Instruction startInstruction = this.getStartInstruction(pseudocode);
        if (!this.straightDirection) {
            instructions = Lists.newArrayList(instructions);
            Collections.reverse(instructions);
        }
        for (Instruction instruction : instructions) {
            ArrayList allPreviousInstructions;
            ArrayList previousInstructions;
            boolean isStart;
            boolean bl = isStart = this.straightDirection ? instruction instanceof SubroutineEnterInstruction : instruction instanceof SubroutineSinkInstruction;
            if (!isLocal && isStart) continue;
            Collection<Object> collection = previousInstructions = this.straightDirection ? instruction.getPreviousInstructions() : instruction.getNextInstructions();
            if (instruction == startInstruction && !previousSubGraphInstructions.isEmpty()) {
                allPreviousInstructions = Lists.newArrayList(previousInstructions);
                allPreviousInstructions.addAll(previousSubGraphInstructions);
            } else {
                allPreviousInstructions = previousInstructions;
            }
            if (this.lookInside && instruction instanceof LocalDeclarationInstruction) {
                Pair<D, D> newValue;
                InstructionImpl lastInstruction;
                Pseudocode subroutinePseudocode = ((LocalDeclarationInstruction)instruction).getBody();
                this.traverseSubGraph(subroutinePseudocode, instructionDataMergeStrategy, previousInstructions, changed, true);
                InstructionImpl instructionImpl = lastInstruction = this.straightDirection ? subroutinePseudocode.getSinkInstruction() : subroutinePseudocode.getEnterInstruction();
                Pair<D, D> previousValue = this.dataMap.get(instruction);
                if (previousValue.equals(newValue = this.dataMap.get(lastInstruction))) continue;
                changed[0] = true;
                this.dataMap.put(instruction, newValue);
                continue;
            }
            Pair<D, D> previousDataValue = this.dataMap.get(instruction);
            HashSet incomingEdgesData = Sets.newHashSet();
            for (Instruction previousInstruction : allPreviousInstructions) {
                Pair<D, D> previousData = this.dataMap.get(previousInstruction);
                if (previousData == null) continue;
                incomingEdgesData.add(previousData.getSecond());
            }
            Pair<D, D> mergedData = instructionDataMergeStrategy.execute(instruction, incomingEdgesData);
            if (mergedData.equals(previousDataValue)) continue;
            changed[0] = true;
            this.dataMap.put(instruction, mergedData);
        }
    }

    public void traverseAndAnalyzeInstructionGraph(@NotNull InstructionDataAnalyzeStrategy<D> instructionDataAnalyzeStrategy) {
        this.traverseAndAnalyzeInstructionGraph(this.pseudocode, instructionDataAnalyzeStrategy);
    }

    private void traverseAndAnalyzeInstructionGraph(@NotNull Pseudocode pseudocode, @NotNull InstructionDataAnalyzeStrategy<D> instructionDataAnalyzeStrategy) {
        ArrayList instructions = pseudocode.getInstructions();
        if (!this.straightDirection) {
            instructions = Lists.newArrayList(instructions);
            Collections.reverse(instructions);
        }
        for (Instruction instruction : instructions) {
            Pair<D, D> pair;
            if (this.lookInside && instruction instanceof LocalDeclarationInstruction) {
                this.traverseAndAnalyzeInstructionGraph(((LocalDeclarationInstruction)instruction).getBody(), instructionDataAnalyzeStrategy);
            }
            instructionDataAnalyzeStrategy.execute(instruction, (pair = this.dataMap.get(instruction)) != null ? pair.getFirst() : null, pair != null ? pair.getSecond() : null);
        }
    }

    public D getResultInfo() {
        return (D)this.dataMap.get(this.pseudocode.getExitInstruction()).getFirst();
    }

    static interface InstructionDataAnalyzeStrategy<D> {
        public void execute(@NotNull Instruction var1, @Nullable D var2, @Nullable D var3);
    }

    static interface InstructionDataMergeStrategy<D> {
        public Pair<D, D> execute(@NotNull Instruction var1, @NotNull Collection<D> var2);
    }
}

