/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.compiler;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintType;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;

public final class TipsManager {
    private TipsManager() {
    }

    @NotNull
    public static Collection<DeclarationDescriptor> getReferenceVariants(JetSimpleNameExpression expression, BindingContext context) {
        JetExpression receiverExpression = expression.getReceiverExpression();
        if (receiverExpression != null) {
            JetScope resolutionScope = context.get(BindingContext.RESOLUTION_SCOPE, receiverExpression);
            JetType expressionType = context.get(BindingContext.EXPRESSION_TYPE, receiverExpression);
            if (expressionType != null && resolutionScope != null) {
                return TipsManager.includeExternalCallableExtensions(TipsManager.excludePrivateDescriptors(expressionType.getMemberScope().getAllDescriptors()), resolutionScope, new ExpressionReceiver(receiverExpression, expressionType));
            }
            return Collections.emptyList();
        }
        return TipsManager.getVariantsNoReceiver(expression, context);
    }

    public static Collection<DeclarationDescriptor> getVariantsNoReceiver(JetExpression expression, BindingContext context) {
        JetScope resolutionScope = context.get(BindingContext.RESOLUTION_SCOPE, expression);
        if (resolutionScope != null) {
            if (expression.getParent() instanceof JetImportDirective || expression.getParent() instanceof JetNamespaceHeader) {
                return TipsManager.excludeNonPackageDescriptors(resolutionScope.getAllDescriptors());
            }
            HashSet descriptorsSet = Sets.newHashSet();
            ArrayList<ReceiverDescriptor> result = new ArrayList<ReceiverDescriptor>();
            resolutionScope.getImplicitReceiversHierarchy(result);
            for (ReceiverDescriptor receiverDescriptor : result) {
                JetType receiverType = receiverDescriptor.getType();
                descriptorsSet.addAll(receiverType.getMemberScope().getAllDescriptors());
            }
            descriptorsSet.addAll(resolutionScope.getAllDescriptors());
            return TipsManager.excludeNotCallableExtensions(TipsManager.excludePrivateDescriptors(descriptorsSet), resolutionScope);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Collection<DeclarationDescriptor> getReferenceVariants(JetNamespaceHeader expression, BindingContext context) {
        JetScope resolutionScope = context.get(BindingContext.RESOLUTION_SCOPE, expression);
        if (resolutionScope != null) {
            return TipsManager.excludeNonPackageDescriptors(resolutionScope.getAllDescriptors());
        }
        return Collections.emptyList();
    }

    public static Collection<DeclarationDescriptor> excludePrivateDescriptors(@NotNull Collection<DeclarationDescriptor> descriptors) {
        return Collections2.filter(descriptors, (Predicate)new Predicate<DeclarationDescriptor>(){

            public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                NamespaceDescriptor namespaceDescriptor;
                if (descriptor == null) {
                    return false;
                }
                return !(descriptor instanceof NamespaceDescriptor) || !(namespaceDescriptor = (NamespaceDescriptor)descriptor).getName().isEmpty();
            }
        });
    }

    public static Collection<DeclarationDescriptor> excludeNotCallableExtensions(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull JetScope scope) {
        HashSet descriptorsSet = Sets.newHashSet(descriptors);
        final ArrayList<ReceiverDescriptor> result = new ArrayList<ReceiverDescriptor>();
        scope.getImplicitReceiversHierarchy(result);
        descriptorsSet.removeAll(Collections2.filter(JetScopeUtils.getAllExtensions(scope), (Predicate)new Predicate<CallableDescriptor>(){

            public boolean apply(CallableDescriptor callableDescriptor) {
                if (!callableDescriptor.getReceiverParameter().exists()) {
                    return false;
                }
                for (ReceiverDescriptor receiverDescriptor : result) {
                    if (!TipsManager.checkReceiverResolution(receiverDescriptor, callableDescriptor)) continue;
                    return false;
                }
                return true;
            }
        }));
        return Lists.newArrayList((Iterable)descriptorsSet);
    }

    private static Collection<DeclarationDescriptor> excludeNonPackageDescriptors(@NotNull Collection<DeclarationDescriptor> descriptors) {
        return Collections2.filter(descriptors, (Predicate)new Predicate<DeclarationDescriptor>(){

            public boolean apply(DeclarationDescriptor declarationDescriptor) {
                return declarationDescriptor instanceof NamespaceDescriptor;
            }
        });
    }

    private static Collection<DeclarationDescriptor> includeExternalCallableExtensions(@NotNull Collection<DeclarationDescriptor> descriptors, @NotNull JetScope externalScope, final @NotNull ReceiverDescriptor receiverDescriptor) {
        JetType receiverType = receiverDescriptor.getType();
        if (receiverType instanceof NamespaceType) {
            return descriptors;
        }
        HashSet descriptorsSet = Sets.newHashSet(descriptors);
        descriptorsSet.addAll(Collections2.filter(JetScopeUtils.getAllExtensions(externalScope), (Predicate)new Predicate<CallableDescriptor>(){

            public boolean apply(CallableDescriptor callableDescriptor) {
                return TipsManager.checkReceiverResolution(receiverDescriptor, callableDescriptor);
            }
        }));
        return descriptorsSet;
    }

    private static boolean checkReceiverResolution(@NotNull ReceiverDescriptor expectedReceiver, @NotNull CallableDescriptor receiverArgument) {
        JetType notNullableType;
        JetType type = expectedReceiver.getType();
        if (TipsManager.checkReceiverResolution(expectedReceiver, type, receiverArgument)) {
            return true;
        }
        return type.isNullable() && TipsManager.checkReceiverResolution(expectedReceiver, notNullableType = TypeUtils.makeNotNullable(type), receiverArgument);
    }

    private static boolean checkReceiverResolution(@NotNull ReceiverDescriptor expectedReceiver, @NotNull JetType receiverType, @NotNull CallableDescriptor receiverArgument) {
        ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl(ConstraintResolutionListener.DO_NOTHING);
        for (TypeParameterDescriptor typeParameterDescriptor : receiverArgument.getTypeParameters()) {
            constraintSystem.registerTypeVariable(typeParameterDescriptor, Variance.INVARIANT);
        }
        ReceiverDescriptor receiverParameter = receiverArgument.getReceiverParameter();
        if (expectedReceiver.exists() && receiverParameter.exists()) {
            constraintSystem.addSubtypingConstraint(ConstraintType.RECEIVER.assertSubtyping(receiverType, receiverParameter.getType()));
        } else if (expectedReceiver.exists() || receiverParameter.exists()) {
            return false;
        }
        ConstraintSystemSolution solution = constraintSystem.solve();
        return solution.getStatus().isSuccessful();
    }
}

