/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.compiler;

import com.intellij.core.JavaCoreEnvironment;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jet.compiler.CompilerPlugin;
import org.jetbrains.jet.lang.parsing.JetParserDefinition;
import org.jetbrains.jet.lang.types.JetStandardLibrary;
import org.jetbrains.jet.plugin.JetFileType;
import org.jetbrains.jet.plugin.compiler.PathUtil;

public class JetCoreEnvironment
extends JavaCoreEnvironment {
    private List<CompilerPlugin> compilerPlugins = new ArrayList<CompilerPlugin>();

    public JetCoreEnvironment(Disposable parentDisposable) {
        super(parentDisposable);
        this.registerFileType((FileType)JetFileType.INSTANCE, "kt");
        this.registerFileType((FileType)JetFileType.INSTANCE, "kts");
        this.registerFileType((FileType)JetFileType.INSTANCE, "ktm");
        this.registerFileType((FileType)JetFileType.INSTANCE, "jet");
        this.registerParserDefinition((ParserDefinition)new JavaParserDefinition());
        this.registerParserDefinition(new JetParserDefinition());
        for (VirtualFile root : PathUtil.getAltHeadersRoots()) {
            this.addLibraryRoot(root);
        }
        JetStandardLibrary.initialize(this.getProject());
    }

    public MockApplication getApplication() {
        return this.myApplication;
    }

    public List<CompilerPlugin> getCompilerPlugins() {
        return this.compilerPlugins;
    }

    public void setCompilerPlugins(List<CompilerPlugin> compilerPlugins) {
        this.compilerPlugins = compilerPlugins;
    }

    public void addToClasspathFromClassLoader(ClassLoader loader) {
        ClassLoader parent = loader.getParent();
        if (parent != null) {
            this.addToClasspathFromClassLoader(parent);
        }
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                File file = new File(url.getPath());
                if (!file.exists() || file.isFile() && !file.getPath().endsWith(".jar")) continue;
                this.addToClasspath(file);
            }
        }
    }
}

