/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.compiler;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiFile;
import java.io.PrintStream;
import java.util.Collection;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.diagnostics.Severity;

class ErrorCollector {
    private final Multimap<PsiFile, Diagnostic> maps = LinkedHashMultimap.create();
    private boolean hasErrors;

    public void report(Diagnostic diagnostic) {
        this.hasErrors |= diagnostic.getSeverity() == Severity.ERROR;
        this.maps.put((Object)diagnostic.getPsiFile(), (Object)diagnostic);
    }

    public void flushTo(PrintStream out) {
        if (!this.maps.isEmpty()) {
            for (PsiFile psiFile : this.maps.keySet()) {
                String path = psiFile.getVirtualFile().getPath();
                Collection diagnostics = this.maps.get((Object)psiFile);
                for (Diagnostic diagnostic : diagnostics) {
                    String position = DiagnosticUtils.formatPosition(diagnostic);
                    out.println(diagnostic.getSeverity().toString() + ": " + path + ":" + position + " " + diagnostic.getMessage());
                }
            }
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }
}

