/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.compiler;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.compiler.CompilerPlugin;
import org.jetbrains.jet.compiler.ErrorCollector;
import org.jetbrains.jet.compiler.FileNameTransformer;
import org.jetbrains.jet.compiler.JetCoreEnvironment;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowDataTraceFactory;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacade;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.plugin.JetFileType;

public class CompileSession {
    private final JetCoreEnvironment myEnvironment;
    private final List<JetFile> mySourceFiles = new ArrayList<JetFile>();
    private final FileNameTransformer myFileNameTransformer;
    private List<String> myErrors = new ArrayList<String>();
    private boolean stubs = false;
    private BindingContext myBindingContext;

    public BindingContext getMyBindingContext() {
        return this.myBindingContext;
    }

    public CompileSession(JetCoreEnvironment environment) {
        this(environment, FileNameTransformer.IDENTITY);
    }

    public CompileSession(JetCoreEnvironment environment, FileNameTransformer fileNameTransformer) {
        this.myEnvironment = environment;
        this.myFileNameTransformer = fileNameTransformer;
    }

    public void setStubs(boolean stubs) {
        this.stubs = stubs;
    }

    public void addSources(String path) {
        if (path == null) {
            return;
        }
        VirtualFile vFile = this.myEnvironment.getLocalFileSystem().findFileByPath(path);
        if (vFile == null) {
            this.myErrors.add("ERROR: File/directory not found: " + path);
            return;
        }
        if (!vFile.isDirectory() && vFile.getFileType() != JetFileType.INSTANCE) {
            this.myErrors.add("ERROR: Not a Kotlin file: " + path);
            return;
        }
        this.addSources(new File(path));
    }

    private void addSources(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.addSources(child);
                }
            }
        } else {
            PsiFile psiFile;
            VirtualFile fileByPath = this.myEnvironment.getLocalFileSystem().findFileByPath(file.getAbsolutePath());
            if (fileByPath != null && (psiFile = PsiManager.getInstance((Project)this.myEnvironment.getProject()).findFile(fileByPath)) instanceof JetFile) {
                this.mySourceFiles.add((JetFile)psiFile);
            }
        }
    }

    public void addSources(VirtualFile vFile) {
        PsiFile psiFile;
        if (vFile.isDirectory()) {
            for (VirtualFile virtualFile : vFile.getChildren()) {
                this.addSources(virtualFile);
            }
        } else if (vFile.getFileType() == JetFileType.INSTANCE && (psiFile = PsiManager.getInstance((Project)this.myEnvironment.getProject()).findFile(vFile)) instanceof JetFile) {
            this.mySourceFiles.add((JetFile)psiFile);
        }
    }

    public List<JetFile> getSourceFileNamespaces() {
        return this.mySourceFiles;
    }

    public boolean analyze(PrintStream out) {
        boolean hasIncompleteHierarchyErrors;
        if (!this.myErrors.isEmpty()) {
            for (String error : this.myErrors) {
                out.println(error);
            }
            return false;
        }
        ErrorCollector errorCollector = new ErrorCollector();
        this.reportSyntaxErrors(errorCollector);
        this.analyzeAndReportSemanticErrors(errorCollector);
        Collection<ClassDescriptor> incompletes = this.myBindingContext.getKeys(BindingContext.INCOMPLETE_HIERARCHY);
        if (!incompletes.isEmpty()) {
            out.println((Object)((Object)Severity.ERROR) + ":: The following classes have incomplete hierarchies:");
            for (ClassDescriptor incomplete : incompletes) {
                out.println((Object)((Object)Severity.ERROR) + "::    " + this.fqName(incomplete));
            }
            hasIncompleteHierarchyErrors = true;
        } else {
            hasIncompleteHierarchyErrors = false;
        }
        errorCollector.flushTo(out);
        return !errorCollector.hasErrors() && !hasIncompleteHierarchyErrors;
    }

    private String fqName(ClassOrNamespaceDescriptor descriptor) {
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration == null || containingDeclaration instanceof ModuleDescriptor || containingDeclaration.getName().equals(JavaDescriptorResolver.JAVA_ROOT)) {
            return descriptor.getName();
        }
        return this.fqName((ClassOrNamespaceDescriptor)containingDeclaration) + "." + descriptor.getName();
    }

    private void analyzeAndReportSemanticErrors(ErrorCollector errorCollector) {
        Predicate filesToAnalyzeCompletely = this.stubs ? Predicates.alwaysFalse() : Predicates.alwaysTrue();
        this.myBindingContext = AnalyzerFacade.analyzeFilesWithJavaIntegration(this.myEnvironment.getProject(), this.mySourceFiles, (Predicate<PsiFile>)filesToAnalyzeCompletely, JetControlFlowDataTraceFactory.EMPTY);
        for (Diagnostic diagnostic : this.myBindingContext.getDiagnostics()) {
            errorCollector.report(diagnostic);
        }
    }

    private void reportSyntaxErrors(final ErrorCollector errorCollector) {
        for (JetFile file : this.mySourceFiles) {
            file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitErrorElement(PsiErrorElement element) {
                    String description = element.getErrorDescription();
                    String message = StringUtil.isEmpty((String)description) ? "Syntax error" : description;
                    Diagnostic<PsiErrorElement> diagnostic = DiagnosticFactory.create(Severity.ERROR, message).on(element);
                    errorCollector.report(diagnostic);
                }
            });
        }
    }

    @NotNull
    public ClassFileFactory generate() {
        Project project = this.myEnvironment.getProject();
        GenerationState generationState = new GenerationState(project, ClassBuilderFactories.binaries(this.stubs), this.myFileNameTransformer);
        generationState.compileCorrectFiles(this.myBindingContext, this.mySourceFiles, CompilationErrorHandler.THROW_EXCEPTION, true);
        ClassFileFactory answer = generationState.getFactory();
        List<CompilerPlugin> fileProcessors = this.myEnvironment.getCompilerPlugins();
        if (fileProcessors != null) {
            for (CompilerPlugin processor : fileProcessors) {
                processor.processFiles(this.myBindingContext, this.getSourceFileNamespaces());
            }
        }
        return answer;
    }
}

