/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.compiler;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import jet.modules.AllModules;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.GeneratedClassLoader;
import org.jetbrains.jet.compiler.CompileEnvironmentException;
import org.jetbrains.jet.compiler.CompileSession;
import org.jetbrains.jet.compiler.FileNameTransformer;
import org.jetbrains.jet.compiler.JetCoreEnvironment;
import org.jetbrains.jet.compiler.ModuleExecutionException;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.plugin.JetLanguage;
import org.jetbrains.jet.plugin.JetMainDetector;
import org.jetbrains.jet.plugin.compiler.PathUtil;

public class CompileEnvironment {
    private JetCoreEnvironment myEnvironment;
    private final Disposable myRootDisposable;
    private PrintStream myErrorStream = System.out;
    private final FileNameTransformer myFileNameTransformer;
    private URL myStdlib;
    private boolean ignoreErrors = false;
    private boolean stubs = false;

    public CompileEnvironment() {
        this(FileNameTransformer.IDENTITY);
    }

    public CompileEnvironment(FileNameTransformer fileNameTransformer) {
        this.myRootDisposable = new Disposable(){

            public void dispose() {
            }
        };
        this.myEnvironment = new JetCoreEnvironment(this.myRootDisposable);
        this.myFileNameTransformer = fileNameTransformer;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.myErrorStream = errorStream;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public void setStubs(boolean stubs) {
        this.stubs = stubs;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myRootDisposable);
    }

    @Nullable
    public static File getUnpackedRuntimePath() {
        URL url = CompileEnvironment.class.getClassLoader().getResource("jet/JetObject.class");
        if (url != null && url.getProtocol().equals("file")) {
            return new File(url.getPath()).getParentFile().getParentFile();
        }
        return null;
    }

    @Nullable
    public static File getRuntimeJarPath() {
        URL url = CompileEnvironment.class.getClassLoader().getResource("jet/JetObject.class");
        if (url != null && url.getProtocol().equals("jar")) {
            String path = url.getPath();
            return new File(path.substring(path.indexOf(":") + 1, path.indexOf("!/")));
        }
        return null;
    }

    public void ensureRuntime() {
        CompileEnvironment.ensureRuntime(this.myEnvironment);
    }

    public static void ensureRuntime(@NotNull JetCoreEnvironment env) {
        Project project = env.getProject();
        if (JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", GlobalSearchScope.allScope((Project)project)) == null) {
            env.addToClasspath(CompileEnvironment.findRtJar());
        }
        if (JavaPsiFacade.getInstance((Project)project).findClass("jet.JetObject", GlobalSearchScope.allScope((Project)project)) == null) {
            File kotlin = PathUtil.getDefaultRuntimePath();
            if (!(kotlin != null && kotlin.exists() || (kotlin = CompileEnvironment.getUnpackedRuntimePath()) != null)) {
                kotlin = CompileEnvironment.getRuntimeJarPath();
            }
            if (kotlin == null) {
                throw new IllegalStateException("kotlin runtime not found");
            }
            env.addToClasspath(kotlin);
        }
    }

    public static File findRtJar() {
        File rtJar;
        String javaHome = System.getProperty("java.home");
        if ("jre".equals(new File(javaHome).getName())) {
            javaHome = new File(javaHome).getParent();
        }
        if ((rtJar = CompileEnvironment.findRtJar(javaHome)) == null || !rtJar.exists()) {
            throw new CompileEnvironmentException("No JDK rt.jar found under" + javaHome);
        }
        return rtJar;
    }

    private static File findRtJar(String javaHome) {
        File rtJar = new File(javaHome, "jre/lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        File classesJar = new File(new File(javaHome).getParentFile().getAbsolutePath(), "Classes/classes.jar");
        if (classesJar.exists()) {
            return classesJar;
        }
        return null;
    }

    public void compileModuleScript(String moduleFile, @Nullable String jarPath, @Nullable String outputDir, boolean jarRuntime) {
        List<Module> modules = this.loadModuleScript(moduleFile);
        if (modules == null) {
            throw new CompileEnvironmentException("Module script " + moduleFile + " compilation failed");
        }
        if (modules.isEmpty()) {
            throw new CompileEnvironmentException("No modules where defined by " + moduleFile);
        }
        String directory = new File(moduleFile).getParent();
        for (Module moduleBuilder : modules) {
            ClassFileFactory moduleFactory = this.compileModule(moduleBuilder, directory);
            if (moduleFactory == null) continue;
            if (outputDir != null) {
                CompileEnvironment.writeToOutputDirectory(moduleFactory, outputDir);
                continue;
            }
            String path = jarPath != null ? jarPath : new File(directory, moduleBuilder.getModuleName() + ".jar").getPath();
            try {
                CompileEnvironment.writeToJar(moduleFactory, new FileOutputStream(path), null, jarRuntime);
            }
            catch (FileNotFoundException e) {
                throw new CompileEnvironmentException("Invalid jar path " + path, e);
            }
        }
    }

    public List<Module> loadModuleScript(String moduleFile) {
        CompileSession scriptCompileSession = new CompileSession(this.myEnvironment, this.myFileNameTransformer);
        scriptCompileSession.addSources(moduleFile);
        this.ensureRuntime();
        if (!scriptCompileSession.analyze(this.myErrorStream)) {
            return null;
        }
        ClassFileFactory factory = scriptCompileSession.generate();
        return this.runDefineModules(moduleFile, factory);
    }

    private List<Module> runDefineModules(String moduleFile, ClassFileFactory factory) {
        GeneratedClassLoader loader = this.myStdlib != null ? new GeneratedClassLoader(factory, (ClassLoader)new URLClassLoader(new URL[]{this.myStdlib}, AllModules.class.getClassLoader())) : new GeneratedClassLoader(factory, CompileEnvironment.class.getClassLoader());
        try {
            Class<?> namespaceClass = loader.loadClass("namespace");
            Method method = namespaceClass.getDeclaredMethod("project", new Class[0]);
            if (method == null) {
                throw new CompileEnvironmentException("Module script " + moduleFile + " must define project() function");
            }
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            ArrayList<Module> answer = new ArrayList<Module>((Collection)AllModules.modules.get());
            ((ArrayList)AllModules.modules.get()).clear();
            ArrayList<Module> arrayList = answer;
            return arrayList;
        }
        catch (Exception e) {
            throw new ModuleExecutionException(e);
        }
        finally {
            loader.dispose();
        }
    }

    public ClassFileFactory compileModule(Module moduleBuilder, String directory) {
        CompileSession moduleCompileSession = new CompileSession(this.myEnvironment);
        moduleCompileSession.setStubs(this.stubs);
        if (moduleBuilder.getSourceFiles().isEmpty()) {
            throw new CompileEnvironmentException("No source files where defined");
        }
        for (String sourceFile : moduleBuilder.getSourceFiles()) {
            File source = new File(sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, sourceFile);
            }
            if (!source.exists()) {
                throw new CompileEnvironmentException("'" + source + "' does not exist");
            }
            moduleCompileSession.addSources(source.getPath());
        }
        for (String classpathRoot : moduleBuilder.getClasspathRoots()) {
            this.myEnvironment.addToClasspath(new File(classpathRoot));
        }
        this.ensureRuntime();
        if (!moduleCompileSession.analyze(this.myErrorStream) && !this.ignoreErrors) {
            return null;
        }
        return moduleCompileSession.generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToJar(ClassFileFactory factory, OutputStream fos, @Nullable String mainClass, boolean includeRuntime) {
        try {
            Manifest manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass);
            }
            JarOutputStream stream = new JarOutputStream(fos, manifest);
            try {
                for (String file : factory.files()) {
                    stream.putNextEntry(new JarEntry(file));
                    stream.write(factory.asBytes(file));
                }
                if (includeRuntime) {
                    CompileEnvironment.writeRuntimeToJar(stream);
                }
            }
            finally {
                stream.close();
                fos.close();
            }
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRuntimeToJar(final JarOutputStream stream) throws IOException {
        block8: {
            final File unpackedRuntimePath = CompileEnvironment.getUnpackedRuntimePath();
            if (unpackedRuntimePath != null) {
                FileUtil.processFilesRecursively((File)unpackedRuntimePath, (Processor)new Processor<File>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean process(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String relativePath = FileUtil.getRelativePath((File)unpackedRuntimePath, (File)file);
                        try {
                            stream.putNextEntry(new JarEntry(FileUtil.toSystemIndependentName((String)relativePath)));
                            FileInputStream fis = new FileInputStream(file);
                            try {
                                FileUtil.copy((InputStream)fis, (OutputStream)stream);
                            }
                            finally {
                                fis.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return true;
                    }
                });
            } else {
                File runtimeJarPath = CompileEnvironment.getRuntimeJarPath();
                if (runtimeJarPath != null) {
                    JarInputStream jis = new JarInputStream(new FileInputStream(runtimeJarPath));
                    try {
                        while (true) {
                            JarEntry e;
                            if ((e = jis.getNextJarEntry()) == null) {
                                break block8;
                            }
                            if (!FileUtil.getExtension((String)e.getName()).equals("class")) continue;
                            stream.putNextEntry(e);
                            FileUtil.copy((InputStream)jis, (OutputStream)stream);
                        }
                    }
                    finally {
                        jis.close();
                    }
                }
                throw new CompileEnvironmentException("Couldn't find runtime library");
            }
        }
    }

    public ClassLoader compileText(String code) {
        CompileSession session = new CompileSession(this.myEnvironment, this.myFileNameTransformer);
        session.addSources((VirtualFile)new LightVirtualFile("script" + LocalTimeCounter.currentTime() + ".kt", (Language)JetLanguage.INSTANCE, (CharSequence)code));
        if (!session.analyze(this.myErrorStream) && !this.ignoreErrors) {
            return null;
        }
        ClassFileFactory factory = session.generate();
        return new GeneratedClassLoader(factory);
    }

    public boolean compileBunchOfSources(String sourceFileOrDir, String jar, String outputDir, boolean includeRuntime) {
        CompileSession session = new CompileSession(this.myEnvironment, this.myFileNameTransformer);
        session.setStubs(this.stubs);
        session.addSources(sourceFileOrDir);
        String mainClass = null;
        for (JetFile file : session.getSourceFileNamespaces()) {
            if (!JetMainDetector.hasMain(file.getDeclarations())) continue;
            String fqName = JetPsiUtil.getFQName(file);
            mainClass = fqName.length() > 0 ? fqName + "." + "namespace" : "namespace";
            break;
        }
        this.ensureRuntime();
        if (!session.analyze(this.myErrorStream) && !this.ignoreErrors) {
            return false;
        }
        ClassFileFactory factory = session.generate();
        if (jar != null) {
            try {
                CompileEnvironment.writeToJar(factory, new FileOutputStream(jar), mainClass, includeRuntime);
            }
            catch (FileNotFoundException e) {
                throw new CompileEnvironmentException("Invalid jar path " + jar, e);
            }
        } else if (outputDir != null) {
            CompileEnvironment.writeToOutputDirectory(factory, outputDir);
        } else {
            throw new CompileEnvironmentException("Output directory or jar file is not specified - no files will be saved to the disk");
        }
        return true;
    }

    public static void writeToOutputDirectory(ClassFileFactory factory, String outputDir) {
        List<String> files = factory.files();
        for (String file : files) {
            File target = new File(outputDir, file);
            try {
                FileUtil.writeToFile((File)target, (byte[])factory.asBytes(file));
            }
            catch (IOException e) {
                throw new CompileEnvironmentException(e);
            }
        }
    }

    public void addToClasspath(File ... paths) {
        for (File path : paths) {
            if (!path.exists()) {
                throw new CompileEnvironmentException("'" + path + "' does not exist");
            }
            this.myEnvironment.addToClasspath(path);
        }
    }

    public void addToClasspath(String ... paths) {
        for (String path : paths) {
            this.addToClasspath(new File(path));
        }
    }

    public void setStdlib(String stdlib) {
        File file = new File(stdlib);
        this.addToClasspath(file);
        try {
            this.myStdlib = file.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public JetCoreEnvironment getMyEnvironment() {
        return this.myEnvironment;
    }
}

