/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class UpTo
implements IntrinsicMethod {
    private boolean forward;

    public UpTo(boolean forward) {
        this.forward = forward;
    }

    @Override
    public StackValue generate(ExpressionCodegen codegen, InstructionAdapter v, Type expectedType, PsiElement element, List<JetExpression> arguments, StackValue receiver) {
        if (arguments.size() == 1) {
            Type leftType = receiver.type;
            Type rightType = codegen.expressionType(arguments.get(0));
            receiver.put(Type.INT_TYPE, v);
            codegen.gen(arguments.get(0), rightType);
            v.invokestatic("jet/runtime/Ranges", this.forward ? "upTo" : "downTo", "(" + receiver.type.getDescriptor() + leftType.getDescriptor() + ")" + expectedType.getDescriptor());
            return StackValue.onStack(expectedType);
        }
        JetBinaryExpression expression = (JetBinaryExpression)element;
        Type leftType = codegen.expressionType(expression.getLeft());
        Type rightType = codegen.expressionType(expression.getRight());
        codegen.gen(expression.getLeft(), leftType);
        codegen.gen(expression.getRight(), rightType);
        v.invokestatic("jet/runtime/Ranges", this.forward ? "upTo" : "downTo", "(" + leftType.getDescriptor() + rightType.getDescriptor() + ")" + expectedType.getDescriptor());
        return StackValue.onStack(expectedType);
    }
}

