/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.codegen.intrinsics.ArrayGet;
import org.jetbrains.jet.codegen.intrinsics.ArrayIndices;
import org.jetbrains.jet.codegen.intrinsics.ArrayIterator;
import org.jetbrains.jet.codegen.intrinsics.ArraySet;
import org.jetbrains.jet.codegen.intrinsics.ArraySize;
import org.jetbrains.jet.codegen.intrinsics.BinaryOp;
import org.jetbrains.jet.codegen.intrinsics.CompareTo;
import org.jetbrains.jet.codegen.intrinsics.Concat;
import org.jetbrains.jet.codegen.intrinsics.Equals;
import org.jetbrains.jet.codegen.intrinsics.Increment;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.intrinsics.Inv;
import org.jetbrains.jet.codegen.intrinsics.IteratorIterator;
import org.jetbrains.jet.codegen.intrinsics.IteratorNext;
import org.jetbrains.jet.codegen.intrinsics.JavaClassFunction;
import org.jetbrains.jet.codegen.intrinsics.NewArray;
import org.jetbrains.jet.codegen.intrinsics.Not;
import org.jetbrains.jet.codegen.intrinsics.NumberCast;
import org.jetbrains.jet.codegen.intrinsics.PsiMethodCall;
import org.jetbrains.jet.codegen.intrinsics.StringGetChar;
import org.jetbrains.jet.codegen.intrinsics.StringLength;
import org.jetbrains.jet.codegen.intrinsics.StringPlus;
import org.jetbrains.jet.codegen.intrinsics.StupidSync;
import org.jetbrains.jet.codegen.intrinsics.Sure;
import org.jetbrains.jet.codegen.intrinsics.ToString;
import org.jetbrains.jet.codegen.intrinsics.UnaryMinus;
import org.jetbrains.jet.codegen.intrinsics.UnaryPlus;
import org.jetbrains.jet.codegen.intrinsics.UpTo;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetStandardLibrary;
import org.jetbrains.jet.lang.types.PrimitiveType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.plugin.JetFileType;

public class IntrinsicMethods {
    private static final IntrinsicMethod UNARY_MINUS = new UnaryMinus();
    private static final IntrinsicMethod UNARY_PLUS = new UnaryPlus();
    private static final IntrinsicMethod NUMBER_CAST = new NumberCast();
    private static final IntrinsicMethod INV = new Inv();
    private static final IntrinsicMethod UP_TO = new UpTo(true);
    private static final IntrinsicMethod DOWN_TO = new UpTo(false);
    private static final IntrinsicMethod INC = new Increment(1);
    private static final IntrinsicMethod DEC = new Increment(-1);
    private static final List<String> PRIMITIVE_TYPES = ImmutableList.of((Object)"Boolean", (Object)"Byte", (Object)"Char", (Object)"Short", (Object)"Int", (Object)"Float", (Object)"Long", (Object)"Double");
    private static final List<String> PRIMITIVE_NUMBER_TYPES = ImmutableList.of((Object)"Byte", (Object)"Char", (Object)"Short", (Object)"Int", (Object)"Float", (Object)"Long", (Object)"Double");
    public static final IntrinsicMethod ARRAY_SIZE = new ArraySize();
    public static final IntrinsicMethod ARRAY_INDICES = new ArrayIndices();
    public static final Equals EQUALS = new Equals();
    public static final IteratorNext ITERATOR_NEXT = new IteratorNext();
    public static final ArraySet ARRAY_SET = new ArraySet();
    public static final ArrayGet ARRAY_GET = new ArrayGet();
    public static final StringPlus STRING_PLUS = new StringPlus();
    private final Project myProject;
    private final JetStandardLibrary myStdLib;
    private final Map<DeclarationDescriptor, IntrinsicMethod> myMethods = new HashMap<DeclarationDescriptor, IntrinsicMethod>();
    private final Map<String, IntrinsicMethod> namedMethods = new HashMap<String, IntrinsicMethod>();
    private static final IntrinsicMethod ARRAY_ITERATOR = new ArrayIterator();

    public IntrinsicMethods(Project project, JetStandardLibrary stdlib) {
        this.myProject = project;
        this.myStdLib = stdlib;
        this.namedMethods.put("\"std.javaClass.function\"", new JavaClassFunction());
        ImmutableList primitiveCastMethods = OperatorConventions.NUMBER_CONVERSIONS.asList();
        for (String method : primitiveCastMethods) {
            this.declareIntrinsicFunction("Number", method, 0, NUMBER_CAST, true);
            for (String type : PRIMITIVE_NUMBER_TYPES) {
                this.declareIntrinsicFunction(type, method, 0, NUMBER_CAST, true);
            }
        }
        for (String type : PRIMITIVE_NUMBER_TYPES) {
            this.declareIntrinsicFunction(type, "plus", 0, UNARY_PLUS, false);
            this.declareIntrinsicFunction(type, "minus", 0, UNARY_MINUS, false);
            this.declareIntrinsicFunction(type, "inv", 0, INV, false);
            this.declareIntrinsicFunction(type, "rangeTo", 1, UP_TO, false);
            this.declareIntrinsicFunction(type, "upto", 1, UP_TO, false);
            this.declareIntrinsicFunction(type, "downto", 1, DOWN_TO, false);
            this.declareIntrinsicFunction(type, "inc", 0, INC, false);
            this.declareIntrinsicFunction(type, "dec", 0, DEC, false);
        }
        Set<FunctionDescriptor> typeInfoFunctionGroup = stdlib.getTypeInfoFunctions();
        this.declareBinaryOp("plus", 96);
        this.declareBinaryOp("minus", 100);
        this.declareBinaryOp("times", 104);
        this.declareBinaryOp("div", 108);
        this.declareBinaryOp("mod", 112);
        this.declareBinaryOp("shl", 120);
        this.declareBinaryOp("shr", 122);
        this.declareBinaryOp("ushr", 124);
        this.declareBinaryOp("and", 126);
        this.declareBinaryOp("or", 128);
        this.declareBinaryOp("xor", 130);
        this.declareIntrinsicFunction("Boolean", "not", 0, new Not(), true);
        this.declareIntrinsicFunction("String", "plus", 1, new Concat(), true);
        this.declareIntrinsicFunction("CharSequence", "get", 1, new StringGetChar(), true);
        this.declareIntrinsicFunction("String", "get", 1, new StringGetChar(), true);
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions("toString"), 0, new ToString());
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions("equals"), 1, EQUALS);
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions("identityEquals"), 1, EQUALS);
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions("plus"), 1, STRING_PLUS);
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions("Array"), 1, new NewArray());
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions("sure"), 0, new Sure());
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions("synchronized"), 2, new StupidSync());
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions("iterator"), 0, new IteratorIterator());
        this.declareIntrinsicFunction("ByteIterator", "next", 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction("ShortIterator", "next", 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction("IntIterator", "next", 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction("LongIterator", "next", 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction("CharIterator", "next", 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction("BooleanIterator", "next", 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction("FloatIterator", "next", 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction("DoubleIterator", "next", 0, ITERATOR_NEXT, false);
        for (String type : PRIMITIVE_TYPES) {
            this.declareIntrinsicFunction(type, "compareTo", 1, new CompareTo(), false);
        }
        this.declareIntrinsicStringMethods();
        this.declareIntrinsicProperty("CharSequence", "length", new StringLength());
        this.declareIntrinsicProperty("String", "length", new StringLength());
        this.declareArrayMethods();
    }

    private void declareArrayMethods() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            this.declareArrayMethodsForPrimitive(jvmPrimitiveType);
        }
        this.declareIntrinsicProperty("Array", "size", ARRAY_SIZE);
        this.declareIntrinsicProperty("Array", "indices", ARRAY_INDICES);
        this.declareIntrinsicFunction("Array", "set", 2, ARRAY_SET, true);
        this.declareIntrinsicFunction("Array", "get", 1, ARRAY_GET, true);
        this.declareIterator(this.myStdLib.getArray());
    }

    private void declareArrayMethodsForPrimitive(JvmPrimitiveType jvmPrimitiveType) {
        PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
        this.declareIntrinsicProperty(primitiveType.getArrayTypeName(), "size", ARRAY_SIZE);
        this.declareIntrinsicProperty(primitiveType.getArrayTypeName(), "indices", ARRAY_INDICES);
        this.declareIntrinsicFunction(primitiveType.getArrayTypeName(), "set", 2, ARRAY_SET, true);
        this.declareIntrinsicFunction(primitiveType.getArrayTypeName(), "get", 1, ARRAY_GET, true);
        this.declareIterator(this.myStdLib.getPrimitiveArrayClassDescriptor(primitiveType));
    }

    private void declareIterator(ClassDescriptor classDescriptor) {
        this.declareOverload(classDescriptor.getDefaultType().getMemberScope().getFunctions("iterator"), 0, ARRAY_ITERATOR);
    }

    private void declareIntrinsicStringMethods() {
        ClassDescriptor stringClass = this.myStdLib.getString();
        Collection<DeclarationDescriptor> stringMembers = stringClass.getMemberScope(Collections.<TypeProjection>emptyList()).getAllDescriptors();
        PsiClass stringPsiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("java.lang.String", (GlobalSearchScope)new DelegatingGlobalSearchScope(ProjectScope.getLibrariesScope((Project)this.myProject)){

            public boolean contains(VirtualFile file) {
                return this.myBaseScope.contains(file) && file.getFileType() != JetFileType.INSTANCE;
            }
        });
        for (DeclarationDescriptor stringMember : stringMembers) {
            PsiMethod[] methods;
            if (!(stringMember instanceof SimpleFunctionDescriptor)) continue;
            SimpleFunctionDescriptor stringMethod = (SimpleFunctionDescriptor)stringMember;
            for (PsiMethod method : methods = stringPsiClass != null ? stringPsiClass.findMethodsByName(stringMember.getName(), false) : new PsiMethod[]{}) {
                if (method.getParameterList().getParametersCount() != stringMethod.getValueParameters().size()) continue;
                this.myMethods.put(stringMethod, new PsiMethodCall(stringMethod));
            }
        }
    }

    private void declareBinaryOp(String methodName, int opcode) {
        BinaryOp op = new BinaryOp(opcode);
        for (String type : PRIMITIVE_TYPES) {
            this.declareIntrinsicFunction(type, methodName, 1, op, false);
        }
    }

    private void declareIntrinsicProperty(String className, String methodName, IntrinsicMethod implementation) {
        JetScope numberScope = this.getClassMemberScope(className);
        Set<VariableDescriptor> properties = numberScope.getProperties(methodName);
        assert (properties.size() == 1);
        VariableDescriptor property = properties.iterator().next();
        this.myMethods.put(property.getOriginal(), implementation);
    }

    private void declareIntrinsicFunction(String className, String functionName, int arity, IntrinsicMethod implementation, boolean original) {
        JetScope memberScope = this.getClassMemberScope(className);
        Set<FunctionDescriptor> group = memberScope.getFunctions(functionName);
        for (FunctionDescriptor descriptor : group) {
            if (!className.equals(descriptor.getContainingDeclaration().getName()) || descriptor.getValueParameters().size() != arity) continue;
            this.myMethods.put(original ? descriptor.getOriginal() : descriptor, implementation);
        }
    }

    private void declareOverload(Set<FunctionDescriptor> group, int arity, IntrinsicMethod implementation) {
        for (FunctionDescriptor descriptor : group) {
            if (descriptor.getValueParameters().size() != arity) continue;
            this.myMethods.put(descriptor.getOriginal(), implementation);
        }
    }

    private JetScope getClassMemberScope(String className) {
        ClassDescriptor descriptor = (ClassDescriptor)this.myStdLib.getLibraryScope().getClassifier(className);
        List<TypeParameterDescriptor> typeParameterDescriptors = descriptor.getTypeConstructor().getParameters();
        ArrayList<TypeProjection> typeParameters = new ArrayList<TypeProjection>();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
            typeParameters.add(new TypeProjection(JetStandardClasses.getAnyType()));
        }
        return descriptor.getMemberScope(typeParameters);
    }

    public IntrinsicMethod getIntrinsic(DeclarationDescriptor descriptor) {
        List<AnnotationDescriptor> annotations;
        IntrinsicMethod intrinsicMethod = this.myMethods.get(descriptor.getOriginal());
        if (intrinsicMethod == null && (annotations = descriptor.getAnnotations()) != null) {
            for (AnnotationDescriptor annotation : annotations) {
                if (!"Intrinsic".equals(annotation.getType().getConstructor().getDeclarationDescriptor().getName())) continue;
                intrinsicMethod = this.namedMethods.get(annotation.getValueArguments().get(0).getValue());
            }
        }
        return intrinsicMethod;
    }
}

