/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassCodegen;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class NamespaceCodegen {
    private final ClassBuilder v;
    private final GenerationState state;

    public NamespaceCodegen(ClassBuilder v, String fqName, GenerationState state, PsiFile sourceFile) {
        this.v = v;
        this.state = state;
        v.defineClass((PsiElement)sourceFile, 50, 1, NamespaceCodegen.getJVMClassName(fqName, true), null, "java/lang/Object", new String[0]);
        v.visitSource(state.transformFileName(sourceFile.getName()), null);
    }

    public void generate(JetFile file) {
        NamespaceDescriptor descriptor = this.state.getBindingContext().get(BindingContext.NAMESPACE, file);
        CodegenContext context = CodegenContext.STATIC.intoNamespace(descriptor);
        FunctionCodegen functionCodegen = new FunctionCodegen(context, this.v, this.state);
        PropertyCodegen propertyCodegen = new PropertyCodegen(context, this.v, functionCodegen, this.state);
        ClassCodegen classCodegen = this.state.forClass();
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (declaration instanceof JetProperty) {
                propertyCodegen.gen((JetProperty)declaration);
                continue;
            }
            if (declaration instanceof JetNamedFunction) {
                try {
                    functionCodegen.gen((JetNamedFunction)declaration);
                    continue;
                }
                catch (CompilationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CompilationException("Failed to generate function " + declaration.getName(), e, declaration);
                }
            }
            if (!(declaration instanceof JetClassOrObject)) continue;
            classCodegen.generate(context, (JetClassOrObject)((Object)declaration));
        }
        if (NamespaceCodegen.hasNonConstantPropertyInitializers(file)) {
            this.generateStaticInitializers(file);
        }
    }

    private void generateStaticInitializers(JetFile namespace) {
        MethodVisitor mv = this.v.newMethod((PsiElement)namespace, 9, "<clinit>", "()V", null, null);
        if (this.v.generateCode() == ClassBuilder.Mode.FULL) {
            mv.visitCode();
            FrameMap frameMap = new FrameMap();
            ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, CodegenContext.STATIC, this.state);
            for (JetDeclaration declaration : namespace.getDeclarations()) {
                JetExpression initializer;
                if (!(declaration instanceof JetProperty) || (initializer = ((JetProperty)declaration).getInitializer()) == null || initializer instanceof JetConstantExpression) continue;
                PropertyDescriptor descriptor = (PropertyDescriptor)this.state.getBindingContext().get(BindingContext.VARIABLE, declaration);
                assert (descriptor != null);
                if (descriptor.getReceiverParameter().exists()) continue;
                codegen.genToJVMStack(initializer);
                codegen.intermediateValueForProperty(descriptor, true, null).store(new InstructionAdapter(mv));
            }
            mv.visitInsn(177);
            FunctionCodegen.endVisit(mv, "static initializer for namespace", (PsiElement)namespace);
            mv.visitEnd();
        }
    }

    private static boolean hasNonConstantPropertyInitializers(JetFile namespace) {
        for (JetDeclaration declaration : namespace.getDeclarations()) {
            JetExpression initializer;
            if (!(declaration instanceof JetProperty) || (initializer = ((JetProperty)declaration).getInitializer()) == null || initializer instanceof JetConstantExpression) continue;
            return true;
        }
        return false;
    }

    public void done() {
        this.v.done();
    }

    public static String getJVMClassName(String fqName, boolean namespace) {
        if (fqName.length() == 0) {
            return "namespace";
        }
        String name = fqName.replace('.', '/');
        if (name.startsWith("<java_root>")) {
            name = name.substring("<java_root>".length() + 1, name.length());
        }
        if (namespace) {
            name = name + "/namespace";
        }
        return name;
    }
}

