/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.BothSignatureWriter;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClosureAnnotator;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.JvmMethodSignature;
import org.jetbrains.jet.codegen.JvmPropertyAccessorSignature;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.TraitImplBodyCodegen;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetStandardLibrary;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.PrimitiveType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.objectweb.asm.Type;

public class JetTypeMapper {
    public static final Type TYPE_OBJECT = Type.getObjectType((String)"java/lang/Object");
    public static final Type TYPE_THROWABLE = Type.getObjectType((String)"java/lang/Throwable");
    public static final Type TYPE_NOTHING = Type.getObjectType((String)"jet/Nothing");
    public static final Type JL_NUMBER_TYPE = Type.getObjectType((String)"java/lang/Number");
    public static final Type JL_STRING_BUILDER = Type.getObjectType((String)"java/lang/StringBuilder");
    public static final Type JL_STRING_TYPE = Type.getObjectType((String)"java/lang/String");
    public static final Type JL_CHAR_SEQUENCE_TYPE = Type.getObjectType((String)"java/lang/CharSequence");
    private static final Type JL_COMPARABLE_TYPE = Type.getObjectType((String)"java/lang/Comparable");
    public static final Type ARRAY_GENERIC_TYPE = Type.getType(Object[].class);
    private final JetStandardLibrary standardLibrary;
    public final BindingContext bindingContext;
    private final ClosureAnnotator closureAnnotator;
    private final HashMap<JetType, String> knowTypeNames = new HashMap();
    private final HashMap<JetType, Type> knowTypes = new HashMap();
    public static final Type TYPE_ITERATOR = Type.getObjectType((String)"jet/Iterator");
    public static final Type TYPE_INT_RANGE = Type.getObjectType((String)"jet/IntRange");
    public static final Type TYPE_SHARED_VAR = Type.getObjectType((String)"jet/runtime/SharedVar$Object");
    public static final Type TYPE_SHARED_INT = Type.getObjectType((String)"jet/runtime/SharedVar$Int");
    public static final Type TYPE_SHARED_DOUBLE = Type.getObjectType((String)"jet/runtime/SharedVar$Double");
    public static final Type TYPE_SHARED_FLOAT = Type.getObjectType((String)"jet/runtime/SharedVar$Float");
    public static final Type TYPE_SHARED_BYTE = Type.getObjectType((String)"jet/runtime/SharedVar$Byte");
    public static final Type TYPE_SHARED_SHORT = Type.getObjectType((String)"jet/runtime/SharedVar$Short");
    public static final Type TYPE_SHARED_CHAR = Type.getObjectType((String)"jet/runtime/SharedVar$Char");
    public static final Type TYPE_SHARED_LONG = Type.getObjectType((String)"jet/runtime/SharedVar$Long");
    public static final Type TYPE_SHARED_BOOLEAN = Type.getObjectType((String)"jet/runtime/SharedVar$Boolean");
    public static final Type TYPE_FUNCTION0 = Type.getObjectType((String)"jet/Function0");
    public static final Type TYPE_FUNCTION1 = Type.getObjectType((String)"jet/Function1");

    public boolean hasThis0(ClassDescriptor classDescriptor) {
        return this.closureAnnotator.hasThis0(classDescriptor);
    }

    public ClosureAnnotator getClosureAnnotator() {
        return this.closureAnnotator;
    }

    public JetTypeMapper(JetStandardLibrary standardLibrary, BindingContext bindingContext, ClosureAnnotator closureAnnotator) {
        this.standardLibrary = standardLibrary;
        this.bindingContext = bindingContext;
        this.closureAnnotator = closureAnnotator;
        this.initKnownTypes();
        this.initKnownTypeNames();
    }

    public static boolean isIntPrimitive(Type type) {
        return type == Type.INT_TYPE || type == Type.SHORT_TYPE || type == Type.BYTE_TYPE || type == Type.CHAR_TYPE;
    }

    public static boolean isPrimitive(Type type) {
        return type.getSort() != 10 && type.getSort() != 9;
    }

    public static Type correctElementType(Type type) {
        String internalName = type.getInternalName();
        assert (internalName.charAt(0) == '[');
        return Type.getType((String)internalName.substring(1));
    }

    public String getOwner(DeclarationDescriptor descriptor, OwnerKind kind) {
        String owner;
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof JavaNamespaceDescriptor) {
            JavaNamespaceDescriptor javaNamespaceDescriptor = (JavaNamespaceDescriptor)containingDeclaration;
            owner = NamespaceCodegen.getJVMClassName(DescriptorUtils.getFQName(containingDeclaration), javaNamespaceDescriptor.isNamespace());
        } else if (containingDeclaration instanceof NamespaceDescriptor) {
            owner = NamespaceCodegen.getJVMClassName(DescriptorUtils.getFQName(containingDeclaration), true);
        } else if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (kind instanceof OwnerKind.DelegateKind) {
                kind = OwnerKind.IMPLEMENTATION;
            } else if (classDescriptor.getKind() == ClassKind.OBJECT) {
                kind = OwnerKind.IMPLEMENTATION;
            }
            Type asmType = this.mapType(classDescriptor.getDefaultType(), kind);
            if (asmType.getSort() != 10) {
                throw new IllegalStateException();
            }
            owner = asmType.getInternalName();
        } else {
            throw new UnsupportedOperationException("don't know how to generate owner for parent " + containingDeclaration);
        }
        return owner;
    }

    @NotNull
    public Type mapReturnType(@NotNull JetType jetType) {
        return this.mapReturnType(jetType, null);
    }

    @NotNull
    private Type mapReturnType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (((Object)jetType).equals(JetStandardClasses.getUnitType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(Type.VOID_TYPE, false);
            }
            return Type.VOID_TYPE;
        }
        if (((Object)jetType).equals(JetStandardClasses.getNothingType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeNothing(false);
            }
            return Type.VOID_TYPE;
        }
        if (((Object)jetType).equals(JetStandardClasses.getNullableNothingType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeNothing(true);
            }
            return TYPE_OBJECT;
        }
        return this.mapType(jetType, OwnerKind.IMPLEMENTATION, signatureVisitor);
    }

    private String getStableNameForObject(JetObjectDeclaration object, DeclarationDescriptor descriptor) {
        String local = JetTypeMapper.getLocalNameForObject(object);
        if (local == null) {
            return null;
        }
        ClassDescriptor containingClass = JetTypeMapper.getContainingClass(descriptor);
        if (containingClass != null) {
            return this.getFQName(containingClass) + "$" + local;
        }
        return this.getFQName(JetTypeMapper.getContainingNamespace(descriptor)) + "/" + local;
    }

    public static String getLocalNameForObject(JetObjectDeclaration object) {
        PsiElement parent = object.getParent();
        if (parent instanceof JetClassObject) {
            return "ClassObject$";
        }
        return null;
    }

    public JvmClassName getClassFQName(ClassDescriptor classDescriptor) {
        return JvmClassName.byInternalName(this.getFQName(classDescriptor));
    }

    public String getFQName(DeclarationDescriptor descriptor) {
        if ((descriptor = descriptor.getOriginal()) instanceof FunctionDescriptor) {
            return this.getFQName(descriptor.getContainingDeclaration());
        }
        DeclarationDescriptor container = descriptor.getContainingDeclaration();
        String name = descriptor.getName();
        if ("<no name provided>".equals(name)) {
            return this.closureAnnotator.classNameForAnonymousClass((JetElement)this.bindingContext.get(BindingContext.DESCRIPTOR_TO_DECLARATION, descriptor));
        }
        if (name.contains("/")) {
            return name;
        }
        if (container != null) {
            if (container instanceof ModuleDescriptor) {
                return name;
            }
            if (container instanceof JavaNamespaceDescriptor && JavaDescriptorResolver.JAVA_ROOT.equals(container.getName())) {
                return name;
            }
            String baseName = this.getFQName(container);
            if (!baseName.isEmpty()) {
                return baseName + (container instanceof JavaNamespaceDescriptor || container instanceof NamespaceDescriptor ? "/" : "$") + name;
            }
        }
        return name;
    }

    private static ClassDescriptor getContainingClass(DeclarationDescriptor descriptor) {
        DeclarationDescriptor parent = descriptor.getContainingDeclaration();
        if (parent == null || parent instanceof ClassDescriptor) {
            return (ClassDescriptor)parent;
        }
        return JetTypeMapper.getContainingClass(parent);
    }

    private static NamespaceDescriptor getContainingNamespace(DeclarationDescriptor descriptor) {
        DeclarationDescriptor parent = descriptor.getContainingDeclaration();
        if (parent == null || parent instanceof NamespaceDescriptor) {
            return (NamespaceDescriptor)parent;
        }
        return JetTypeMapper.getContainingNamespace(parent);
    }

    @NotNull
    public Type mapType(JetType jetType) {
        return this.mapType(jetType, (BothSignatureWriter)null);
    }

    @NotNull
    private Type mapType(JetType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        return this.mapType(jetType, OwnerKind.IMPLEMENTATION, signatureVisitor);
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType, OwnerKind kind) {
        return this.mapType(jetType, kind, null);
    }

    @NotNull
    private Type mapType(JetType jetType, OwnerKind kind, @Nullable BothSignatureWriter signatureVisitor) {
        return this.mapType(jetType, kind, signatureVisitor, false);
    }

    @NotNull
    public Type mapType(JetType jetType, OwnerKind kind, @Nullable BothSignatureWriter signatureVisitor, boolean boxPrimitive) {
        Type known = this.knowTypes.get(jetType);
        if (known != null) {
            return this.mapKnownAsmType(jetType, known, signatureVisitor, boxPrimitive);
        }
        ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
        if (ErrorUtils.isError(descriptor)) {
            Type asmType = Type.getObjectType((String)"error/NonExistentClass");
            if (signatureVisitor != null) {
                JetTypeMapper.visitAsmType(signatureVisitor, asmType, true);
            }
            return asmType;
        }
        if (this.standardLibrary.getArray().equals(descriptor)) {
            if (jetType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            JetType memberType = jetType.getArguments().get(0).getType();
            if (signatureVisitor != null) {
                signatureVisitor.writeArrayType(jetType.isNullable());
                this.mapType(memberType, kind, signatureVisitor, true);
                signatureVisitor.writeArrayEnd();
            }
            if (!this.isGenericsArray(jetType)) {
                return Type.getType((String)("[" + JetTypeMapper.boxType(this.mapType(memberType, kind)).getDescriptor()));
            }
            return ARRAY_GENERIC_TYPE;
        }
        if (JetStandardClasses.getAny().equals(descriptor)) {
            if (signatureVisitor != null) {
                JetTypeMapper.visitAsmType(signatureVisitor, TYPE_OBJECT, jetType.isNullable());
            }
            return TYPE_OBJECT;
        }
        if (descriptor instanceof ClassDescriptor) {
            boolean forceReal;
            Type asmType;
            if (this.standardLibrary.getComparable().equals(descriptor)) {
                if (jetType.getArguments().size() != 1) {
                    throw new UnsupportedOperationException("Comparable must have one type argument");
                }
                asmType = JL_COMPARABLE_TYPE;
                forceReal = false;
            } else {
                JvmClassName name = this.getClassFQName((ClassDescriptor)descriptor);
                asmType = Type.getObjectType((String)(name.getInternalName() + (kind == OwnerKind.TRAIT_IMPL ? "$$TImpl" : "")));
                forceReal = this.isForceReal(name);
            }
            if (signatureVisitor != null) {
                signatureVisitor.writeClassBegin(asmType.getInternalName(), jetType.isNullable(), forceReal);
                for (TypeProjection proj : jetType.getArguments()) {
                    signatureVisitor.writeTypeArgument(proj.getProjectionKind());
                    this.mapType(proj.getType(), kind, signatureVisitor, true);
                    signatureVisitor.writeTypeArgumentEnd();
                }
                signatureVisitor.writeClassEnd();
            }
            return asmType;
        }
        if (descriptor instanceof TypeParameterDescriptor) {
            Type type = this.mapType(((TypeParameterDescriptor)descriptor).getUpperBoundsAsType(), kind);
            if (signatureVisitor != null) {
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)jetType.getConstructor().getDeclarationDescriptor();
                signatureVisitor.writeTypeVariable(typeParameterDescriptor.getName(), jetType.isNullable(), type);
            }
            return type;
        }
        throw new UnsupportedOperationException("Unknown type " + jetType);
    }

    private Type mapKnownAsmType(JetType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, boolean genericTypeParameter) {
        if (signatureVisitor != null) {
            if (genericTypeParameter) {
                JetTypeMapper.visitAsmType(signatureVisitor, JetTypeMapper.boxType(asmType), jetType.isNullable());
            } else {
                JetTypeMapper.visitAsmType(signatureVisitor, asmType, jetType.isNullable());
            }
        }
        return asmType;
    }

    public static void visitAsmType(BothSignatureWriter visitor, Type asmType, boolean nullable) {
        visitor.writeAsmType(asmType, nullable);
    }

    public static Type unboxType(Type type) {
        JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.getByWrapperAsmType(type);
        if (jvmPrimitiveType != null) {
            return jvmPrimitiveType.getAsmType();
        }
        throw new UnsupportedOperationException("Unboxing: " + type);
    }

    public static Type boxType(Type asmType) {
        JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.getByAsmType(asmType);
        if (jvmPrimitiveType != null) {
            return jvmPrimitiveType.getWrapper().getAsmType();
        }
        return asmType;
    }

    public CallableMethod mapToCallableMethod(FunctionDescriptor functionDescriptor, boolean superCall, OwnerKind kind) {
        ClassDescriptor thisClass;
        int invokeOpcode;
        String ownerForDefaultImpl;
        String owner;
        String ownerForDefaultParam;
        if (functionDescriptor == null) {
            return null;
        }
        DeclarationDescriptor functionParent = functionDescriptor.getOriginal().getContainingDeclaration();
        JvmMethodSignature descriptor = this.mapSignature(functionDescriptor.getOriginal(), true, kind);
        if (functionParent instanceof NamespaceDescriptor) {
            assert (!superCall);
            boolean namespace = true;
            if (functionParent instanceof JavaNamespaceDescriptor) {
                namespace = ((JavaNamespaceDescriptor)functionParent).isNamespace();
            }
            ownerForDefaultImpl = ownerForDefaultParam = (owner = NamespaceCodegen.getJVMClassName(DescriptorUtils.getFQName(functionParent), namespace));
            invokeOpcode = 184;
            thisClass = null;
        } else if (functionDescriptor instanceof ConstructorDescriptor) {
            assert (!superCall);
            ClassDescriptor containingClass = (ClassDescriptor)functionParent;
            ownerForDefaultImpl = ownerForDefaultParam = (owner = this.mapType(containingClass.getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName());
            invokeOpcode = 183;
            thisClass = null;
        } else if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = JetTypeMapper.findAnyDeclaration(functionDescriptor);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = CodegenUtil.isInterface(declarationOwner);
            boolean currentIsInterface = CodegenUtil.isInterface(currentOwner);
            ClassDescriptor receiver = currentIsInterface && !originalIsInterface ? declarationOwner : currentOwner;
            ClassDescriptor containingClass = (ClassDescriptor)functionParent;
            boolean isInterface = originalIsInterface && currentIsInterface;
            OwnerKind kind1 = isInterface && superCall ? OwnerKind.TRAIT_IMPL : OwnerKind.IMPLEMENTATION;
            Type type = this.mapType(receiver.getDefaultType(), OwnerKind.IMPLEMENTATION);
            owner = type.getInternalName();
            ownerForDefaultParam = this.mapType(declarationOwner.getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName();
            ownerForDefaultImpl = ownerForDefaultParam + (originalIsInterface ? "$$TImpl" : "");
            int n = isInterface ? (superCall ? 184 : 185) : (invokeOpcode = superCall ? 183 : 182);
            if (isInterface && superCall) {
                descriptor = this.mapSignature(functionDescriptor, false, OwnerKind.TRAIT_IMPL);
                owner = owner + "$$TImpl";
            }
            thisClass = receiver;
        } else {
            throw new UnsupportedOperationException("unknown function parent");
        }
        CallableMethod result = new CallableMethod(owner, ownerForDefaultImpl, ownerForDefaultParam, descriptor, invokeOpcode);
        result.setNeedsThis(thisClass);
        if (functionDescriptor.getReceiverParameter().exists()) {
            result.setNeedsReceiver(functionDescriptor);
        }
        return result;
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function) {
        if (function.getOverriddenDescriptors().isEmpty()) {
            return function;
        }
        return JetTypeMapper.findAnyDeclaration(function.getOverriddenDescriptors().iterator().next());
    }

    private JvmMethodSignature mapSignature(FunctionDescriptor f, boolean needGenericSignature, OwnerKind kind) {
        if (kind == OwnerKind.TRAIT_IMPL) {
            needGenericSignature = false;
        }
        BothSignatureWriter signatureVisitor = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, needGenericSignature);
        this.writeFormalTypeParameters(f.getTypeParameters(), signatureVisitor);
        ReceiverDescriptor receiverTypeRef = f.getReceiverParameter();
        JetType receiverType = !receiverTypeRef.exists() ? null : receiverTypeRef.getType();
        List<ValueParameterDescriptor> parameters = f.getValueParameters();
        signatureVisitor.writeParametersStart();
        if (kind == OwnerKind.TRAIT_IMPL) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)f.getContainingDeclaration();
            JetType jetType = TraitImplBodyCodegen.getSuperClass(containingDeclaration, this.bindingContext);
            Type type = this.mapType(jetType);
            if (type.getInternalName().equals("java/lang/Object")) {
                jetType = containingDeclaration.getDefaultType();
                type = this.mapType(jetType);
            }
            signatureVisitor.writeParameterType(JvmMethodParameterKind.THIS);
            signatureVisitor.writeAsmType(type, jetType.isNullable());
            signatureVisitor.writeParameterTypeEnd();
        }
        if (receiverType != null) {
            signatureVisitor.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(receiverType, signatureVisitor);
            signatureVisitor.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor parameter : parameters) {
            signatureVisitor.writeParameterType(JvmMethodParameterKind.VALUE);
            this.mapType(parameter.getType(), signatureVisitor);
            signatureVisitor.writeParameterTypeEnd();
        }
        signatureVisitor.writeParametersEnd();
        if (f instanceof ConstructorDescriptor) {
            signatureVisitor.writeVoidReturn();
        } else {
            signatureVisitor.writeReturnType();
            this.mapReturnType(f.getReturnType(), signatureVisitor);
            signatureVisitor.writeReturnTypeEnd();
        }
        return signatureVisitor.makeJvmMethodSignature(f.getName());
    }

    public void writeFormalTypeParameters(List<TypeParameterDescriptor> typeParameters, BothSignatureWriter signatureVisitor) {
        if (signatureVisitor == null) {
            return;
        }
        signatureVisitor.writeFormalTypeParametersStart();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.writeFormalTypeParameter(typeParameterDescriptor, signatureVisitor);
        }
        signatureVisitor.writeFormalTypeParametersEnd();
    }

    private void writeFormalTypeParameter(TypeParameterDescriptor typeParameterDescriptor, BothSignatureWriter signatureVisitor) {
        signatureVisitor.writeFormalTypeParameter(typeParameterDescriptor.getName(), typeParameterDescriptor.getVariance(), typeParameterDescriptor.isReified());
        signatureVisitor.writeClassBound();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || CodegenUtil.isInterface(jetType)) continue;
            this.mapType(jetType, signatureVisitor);
            break;
        }
        signatureVisitor.writeClassBoundEnd();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor && CodegenUtil.isInterface(jetType)) {
                signatureVisitor.writeInterfaceBound();
                this.mapType(jetType, signatureVisitor);
                signatureVisitor.writeInterfaceBoundEnd();
            }
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor)) continue;
            signatureVisitor.writeInterfaceBound();
            this.mapType(jetType, signatureVisitor);
            signatureVisitor.writeInterfaceBoundEnd();
        }
        signatureVisitor.writeFormalTypeParameterEnd();
    }

    public JvmMethodSignature mapSignature(String name, FunctionDescriptor f) {
        ReceiverDescriptor receiver = f.getReceiverParameter();
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        this.writeFormalTypeParameters(f.getTypeParameters(), signatureWriter);
        signatureWriter.writeParametersStart();
        List<ValueParameterDescriptor> parameters = f.getValueParameters();
        if (receiver.exists()) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(receiver.getType(), signatureWriter);
            signatureWriter.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor parameter : parameters) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            this.mapType(parameter.getType(), signatureWriter);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeReturnType();
        this.mapReturnType(f.getReturnType(), signatureWriter);
        signatureWriter.writeReturnTypeEnd();
        return signatureWriter.makeJvmMethodSignature(name);
    }

    public JvmPropertyAccessorSignature mapGetterSignature(PropertyDescriptor descriptor, OwnerKind kind) {
        String name = PropertyCodegen.getterName(descriptor.getName());
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(descriptor.getTypeParameters(), signatureWriter);
        signatureWriter.writeParametersStart();
        if (kind == OwnerKind.TRAIT_IMPL) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)descriptor.getContainingDeclaration();
            assert (containingDeclaration != null);
            signatureWriter.writeParameterType(JvmMethodParameterKind.THIS);
            this.mapType(containingDeclaration.getDefaultType(), signatureWriter);
            signatureWriter.writeParameterTypeEnd();
        }
        if (descriptor.getReceiverParameter().exists()) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(descriptor.getReceiverParameter().getType(), signatureWriter);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeReturnType();
        this.mapType(descriptor.getType(), signatureWriter);
        signatureWriter.writeReturnTypeEnd();
        JvmMethodSignature jvmMethodSignature = signatureWriter.makeJvmMethodSignature(name);
        return new JvmPropertyAccessorSignature(jvmMethodSignature, jvmMethodSignature.getKotlinReturnType());
    }

    @Nullable
    public JvmPropertyAccessorSignature mapSetterSignature(PropertyDescriptor descriptor, OwnerKind kind) {
        if (!descriptor.isVar()) {
            return null;
        }
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(descriptor.getTypeParameters(), signatureWriter);
        JetType outType = descriptor.getType();
        signatureWriter.writeParametersStart();
        String name = PropertyCodegen.setterName(descriptor.getName());
        if (kind == OwnerKind.TRAIT_IMPL) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)descriptor.getContainingDeclaration();
            assert (containingDeclaration != null);
            signatureWriter.writeParameterType(JvmMethodParameterKind.THIS);
            this.mapType(containingDeclaration.getDefaultType(), signatureWriter);
            signatureWriter.writeParameterTypeEnd();
        }
        if (descriptor.getReceiverParameter().exists()) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(descriptor.getReceiverParameter().getType(), signatureWriter);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
        this.mapType(outType, signatureWriter);
        signatureWriter.writeParameterTypeEnd();
        signatureWriter.writeParametersEnd();
        signatureWriter.writeVoidReturn();
        JvmMethodSignature jvmMethodSignature = signatureWriter.makeJvmMethodSignature(name);
        return new JvmPropertyAccessorSignature(jvmMethodSignature, jvmMethodSignature.getKotlinParameterType(jvmMethodSignature.getParameterCount() - 1));
    }

    private JvmMethodSignature mapConstructorSignature(ConstructorDescriptor descriptor, boolean hasThis0) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        List<ValueParameterDescriptor> parameters = descriptor.getOriginal().getValueParameters();
        this.writeFormalTypeParameters(Collections.<TypeParameterDescriptor>emptyList(), signatureWriter);
        signatureWriter.writeParametersStart();
        if (hasThis0) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.THIS0);
            this.mapType(this.closureAnnotator.getEclosingClassDescriptor(descriptor.getContainingDeclaration()).getDefaultType(), OwnerKind.IMPLEMENTATION, signatureWriter);
            signatureWriter.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor parameter : parameters) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            this.mapType(parameter.getType(), signatureWriter);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeVoidReturn();
        return signatureWriter.makeJvmMethodSignature("<init>");
    }

    public CallableMethod mapToCallableMethod(ConstructorDescriptor descriptor, OwnerKind kind, boolean hasThis0) {
        JvmMethodSignature method = this.mapConstructorSignature(descriptor, hasThis0);
        String owner = this.mapType(descriptor.getContainingDeclaration().getDefaultType(), kind).getInternalName();
        return new CallableMethod(owner, owner, owner, method, 183);
    }

    public static int getAccessModifiers(DeclarationDescriptorWithVisibility p, int defaultFlags) {
        DeclarationDescriptor declaration = p.getContainingDeclaration();
        if (CodegenUtil.isInterface(declaration)) {
            return 1;
        }
        if (p.getVisibility() == Visibility.PUBLIC) {
            return 1;
        }
        if (p.getVisibility() == Visibility.PROTECTED) {
            return 4;
        }
        if (p.getVisibility() == Visibility.PRIVATE) {
            if (CodegenUtil.isClassObject(declaration)) {
                return defaultFlags;
            }
            return 2;
        }
        return defaultFlags;
    }

    public Collection<String> allJvmNames(JetClassOrObject jetClass) {
        HashSet<String> result = new HashSet<String>();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, jetClass);
        if (classDescriptor != null) {
            result.add(this.mapType(classDescriptor.getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName());
        }
        return result;
    }

    private void initKnownTypeNames() {
        this.knowTypeNames.put(JetStandardClasses.getAnyType(), "ANY_TYPE_INFO");
        this.knowTypeNames.put(JetStandardClasses.getNullableAnyType(), "NULLABLE_ANY_TYPE_INFO");
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.knowTypeNames.put(this.standardLibrary.getPrimitiveJetType(primitiveType), jvmPrimitiveType.name() + "_TYPE_INFO");
            this.knowTypeNames.put(this.standardLibrary.getNullablePrimitiveJetType(primitiveType), "NULLABLE_" + jvmPrimitiveType.name() + "_TYPE_INFO");
            this.knowTypeNames.put(this.standardLibrary.getPrimitiveArrayJetType(primitiveType), jvmPrimitiveType.name() + "_ARRAY_TYPE_INFO");
            this.knowTypeNames.put(this.standardLibrary.getNullablePrimitiveArrayJetType(primitiveType), jvmPrimitiveType.name() + "_ARRAY_TYPE_INFO");
        }
        this.knowTypeNames.put(this.standardLibrary.getStringType(), "STRING_TYPE_INFO");
        this.knowTypeNames.put(this.standardLibrary.getNullableStringType(), "NULLABLE_STRING_TYPE_INFO");
        this.knowTypeNames.put(this.standardLibrary.getTuple0Type(), "TUPLE0_TYPE_INFO");
        this.knowTypeNames.put(this.standardLibrary.getNullableTuple0Type(), "NULLABLE_TUPLE0_TYPE_INFO");
    }

    private void initKnownTypes() {
        PrimitiveType primitiveType;
        this.knowTypes.put(JetStandardClasses.getNothingType(), TYPE_NOTHING);
        this.knowTypes.put(JetStandardClasses.getNullableNothingType(), TYPE_NOTHING);
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.knowTypes.put(this.standardLibrary.getPrimitiveJetType(primitiveType), jvmPrimitiveType.getAsmType());
            this.knowTypes.put(this.standardLibrary.getNullablePrimitiveJetType(primitiveType), jvmPrimitiveType.getWrapper().getAsmType());
        }
        this.knowTypes.put(this.standardLibrary.getStringType(), JL_STRING_TYPE);
        this.knowTypes.put(this.standardLibrary.getNullableStringType(), JL_STRING_TYPE);
        this.knowTypes.put(this.standardLibrary.getCharSequenceType(), JL_CHAR_SEQUENCE_TYPE);
        this.knowTypes.put(this.standardLibrary.getNullableCharSequenceType(), JL_CHAR_SEQUENCE_TYPE);
        this.knowTypes.put(this.standardLibrary.getThrowableType(), TYPE_THROWABLE);
        this.knowTypes.put(this.standardLibrary.getNullableThrowableType(), TYPE_THROWABLE);
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.knowTypes.put(this.standardLibrary.getPrimitiveArrayJetType(primitiveType), jvmPrimitiveType.getAsmArrayType());
            this.knowTypes.put(this.standardLibrary.getNullablePrimitiveArrayJetType(primitiveType), jvmPrimitiveType.getAsmArrayType());
        }
    }

    private boolean isForceReal(JvmClassName className) {
        return JvmPrimitiveType.getByWrapperClass(className) != null || className.getFqName().equals("java.lang.String") || className.getFqName().equals("java.lang.Object");
    }

    public String isKnownTypeInfo(JetType jetType) {
        return this.knowTypeNames.get(jetType);
    }

    public boolean isGenericsArray(JetType type) {
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            return true;
        }
        if (this.standardLibrary.getArray().equals(declarationDescriptor)) {
            return this.isGenericsArray(type.getArguments().get(0).getType());
        }
        return false;
    }

    public JetType getGenericsElementType(JetType arrayType) {
        JetType type = arrayType.getArguments().get(0).getType();
        return this.isGenericsArray(type) ? type : null;
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor) {
        if (descriptor instanceof PropertyDescriptor) {
            return StackValue.sharedTypeForType(this.mapType(((PropertyDescriptor)descriptor).getReceiverParameter().getType()));
        }
        if (descriptor instanceof SimpleFunctionDescriptor && descriptor.getContainingDeclaration() instanceof FunctionDescriptor) {
            PsiElement psiElement = this.bindingContext.get(BindingContext.DESCRIPTOR_TO_DECLARATION, descriptor);
            return Type.getObjectType((String)this.closureAnnotator.classNameForAnonymousClass((JetElement)psiElement));
        }
        if (descriptor instanceof FunctionDescriptor) {
            return StackValue.sharedTypeForType(this.mapType(((FunctionDescriptor)descriptor).getReceiverParameter().getType()));
        }
        if (descriptor instanceof VariableDescriptor) {
            Boolean aBoolean = this.bindingContext.get(BindingContext.MUST_BE_WRAPPED_IN_A_REF, (VariableDescriptor)descriptor);
            if (aBoolean != null && aBoolean.booleanValue()) {
                JetType outType = ((VariableDescriptor)descriptor).getType();
                return StackValue.sharedTypeForType(this.mapType(outType));
            }
            return null;
        }
        return null;
    }
}

