/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;

public class JetMethodAnnotationWriter {
    private final AnnotationVisitor av;

    private JetMethodAnnotationWriter(AnnotationVisitor av) {
        this.av = av;
    }

    public void writeKind(int kind) {
        if (kind != 0) {
            this.av.visit("kind", (Object)kind);
        }
    }

    public void writeTypeParameters(@NotNull String typeParameters) {
        if (typeParameters.length() > 0) {
            this.av.visit("typeParameters", (Object)typeParameters);
        }
    }

    public void writeReturnType(@NotNull String returnType) {
        if (returnType.length() > 0) {
            this.av.visit("returnType", (Object)returnType);
        }
    }

    public void writePropertyType(@NotNull String propertyType) {
        if (propertyType.length() > 0) {
            this.av.visit("propertyType", (Object)propertyType);
        }
    }

    public void writeNullableReturnType(boolean nullableReturnType) {
        if (nullableReturnType) {
            this.av.visit("nullableReturnType", (Object)nullableReturnType);
        }
    }

    public void visitEnd() {
        this.av.visitEnd();
    }

    public static JetMethodAnnotationWriter visitAnnotation(MethodVisitor mv) {
        return new JetMethodAnnotationWriter(mv.visitAnnotation(JvmStdlibNames.JET_METHOD.getDescriptor(), true));
    }
}

