/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassCodegen;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.ClosureAnnotator;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.GeneratedAnonymousClassDescriptor;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.ObjectOrClosureCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.jet.compiler.FileNameTransformer;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowDataTraceFactory;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacade;
import org.jetbrains.jet.lang.types.JetStandardLibrary;

public class GenerationState {
    @NotNull
    private final ClassFileFactory factory;
    private final Project project;
    private JetTypeMapper typeMapper;
    private final Stack<BindingContext> bindingContexts = new Stack();
    private final JetStandardLibrary standardLibrary;
    private final IntrinsicMethods intrinsics;
    private final FileNameTransformer fileNameTransformer;

    public GenerationState(Project project, ClassBuilderFactory builderFactory) {
        this(project, builderFactory, FileNameTransformer.IDENTITY);
    }

    public GenerationState(Project project, ClassBuilderFactory builderFactory, FileNameTransformer fileNameTransformer) {
        this.project = project;
        this.standardLibrary = JetStandardLibrary.getInstance();
        this.factory = new ClassFileFactory(builderFactory, this);
        this.intrinsics = new IntrinsicMethods(project, this.standardLibrary);
        this.fileNameTransformer = fileNameTransformer;
    }

    @NotNull
    public ClassFileFactory getFactory() {
        return this.factory;
    }

    public Project getProject() {
        return this.project;
    }

    public JetTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public BindingContext getBindingContext() {
        return (BindingContext)this.bindingContexts.peek();
    }

    public JetStandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    public IntrinsicMethods getIntrinsics() {
        return this.intrinsics;
    }

    public ClassCodegen forClass() {
        return new ClassCodegen(this);
    }

    public ClassBuilder forClassImplementation(ClassDescriptor aClass) {
        return this.factory.newVisitor(this.typeMapper.mapType(aClass.getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName() + ".class");
    }

    public ClassBuilder forTraitImplementation(ClassDescriptor aClass) {
        return this.factory.newVisitor(this.typeMapper.mapType(aClass.getDefaultType(), OwnerKind.TRAIT_IMPL).getInternalName() + ".class");
    }

    public Pair<String, ClassBuilder> forAnonymousSubclass(JetExpression expression) {
        String className = this.typeMapper.getClosureAnnotator().classNameForAnonymousClass(expression);
        return Pair.create((Object)className, (Object)this.factory.forAnonymousSubclass(className));
    }

    public NamespaceCodegen forNamespace(JetFile namespace) {
        return this.factory.forNamespace(namespace);
    }

    public BindingContext compile(JetFile file) {
        BindingContext bindingContext = AnalyzerFacade.analyzeOneFileWithJavaIntegration(file, JetControlFlowDataTraceFactory.EMPTY);
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        this.compileCorrectFiles(bindingContext, Collections.singletonList(file), CompilationErrorHandler.THROW_EXCEPTION, true);
        return bindingContext;
    }

    public void compileCorrectFiles(BindingContext bindingContext, List<JetFile> files, boolean annotate) {
        this.compileCorrectFiles(bindingContext, files, CompilationErrorHandler.THROW_EXCEPTION, annotate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileCorrectFiles(BindingContext bindingContext, List<JetFile> files, CompilationErrorHandler errorHandler, boolean annotate) {
        ClosureAnnotator closureAnnotator = !annotate ? null : new ClosureAnnotator(bindingContext, files);
        this.typeMapper = new JetTypeMapper(this.standardLibrary, bindingContext, closureAnnotator);
        this.bindingContexts.push((Object)bindingContext);
        try {
            for (JetFile namespace : files) {
                try {
                    this.generateNamespace(namespace);
                }
                catch (Throwable e) {
                    errorHandler.reportException(e, namespace.getContainingFile().getVirtualFile().getUrl());
                    DiagnosticUtils.throwIfRunningOnServer(e);
                    if (!ApplicationManager.getApplication().isInternal()) continue;
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.bindingContexts.pop();
            this.typeMapper = null;
        }
    }

    protected void generateNamespace(JetFile namespace) {
        NamespaceCodegen codegen = this.forNamespace(namespace);
        codegen.generate(namespace);
    }

    public GeneratedAnonymousClassDescriptor generateObjectLiteral(JetObjectLiteralExpression literal, ObjectOrClosureCodegen closure) {
        JetObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        Pair<String, ClassBuilder> nameAndVisitor = this.forAnonymousSubclass(objectDeclaration);
        closure.cv = (ClassBuilder)nameAndVisitor.getSecond();
        closure.name = (String)nameAndVisitor.getFirst();
        CodegenContext objectContext = closure.context.intoAnonymousClass(closure, this.getBindingContext().get(BindingContext.CLASS, objectDeclaration), OwnerKind.IMPLEMENTATION, this.typeMapper);
        new ImplementationBodyCodegen(objectDeclaration, objectContext, (ClassBuilder)nameAndVisitor.getSecond(), this).generate();
        ConstructorDescriptor constructorDescriptor = closure.state.getBindingContext().get(BindingContext.CONSTRUCTOR, objectDeclaration);
        CallableMethod callableMethod = closure.state.getTypeMapper().mapToCallableMethod(constructorDescriptor, OwnerKind.IMPLEMENTATION, this.typeMapper.hasThis0(constructorDescriptor.getContainingDeclaration()));
        return new GeneratedAnonymousClassDescriptor((String)nameAndVisitor.first, callableMethod.getSignature().getAsmMethod(), objectContext.outerWasUsed, null);
    }

    public String createText() {
        StringBuilder answer = new StringBuilder();
        ClassFileFactory factory = this.getFactory();
        List<String> files = factory.files();
        for (String file : files) {
            answer.append("@").append(file).append('\n');
            answer.append(factory.asText(file));
        }
        return answer.toString();
    }

    @NotNull
    public String transformFileName(@NotNull String fileName) {
        return this.fileNameTransformer.transformFileName(fileName);
    }
}

