/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetMethodAnnotationWriter;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.JvmMethodSignature;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.StubCodegen;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.commons.Method;

public class FunctionCodegen {
    private final CodegenContext owner;
    private final ClassBuilder v;
    private final GenerationState state;
    private final JetTypeMapper typeMapper;

    public FunctionCodegen(CodegenContext owner, ClassBuilder v, GenerationState state) {
        this.owner = owner;
        this.v = v;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
    }

    public void gen(JetNamedFunction f) {
        SimpleFunctionDescriptor functionDescriptor = this.state.getBindingContext().get(BindingContext.FUNCTION, f);
        assert (functionDescriptor != null);
        JvmMethodSignature method = this.typeMapper.mapToCallableMethod(functionDescriptor, false, this.owner.getContextKind()).getSignature();
        this.generateMethod(f, method, true, null, functionDescriptor);
    }

    public void generateMethod(JetDeclarationWithBody f, JvmMethodSignature jvmMethod, boolean needJetAnnotations, @Nullable String propertyTypeSignature, FunctionDescriptor functionDescriptor) {
        CodegenContext.MethodContext funContext = this.owner.intoFunction(functionDescriptor);
        JetExpression bodyExpression = f.getBodyExpression();
        this.generatedMethod(bodyExpression, jvmMethod, needJetAnnotations, propertyTypeSignature, funContext, functionDescriptor, f);
    }

    private void generatedMethod(JetExpression bodyExpressions, JvmMethodSignature jvmSignature, boolean needJetAnnotations, @Nullable String propertyTypeSignature, CodegenContext.MethodContext context, FunctionDescriptor functionDescriptor, JetDeclarationWithBody fun) {
        OwnerKind kind;
        List<ValueParameterDescriptor> paramDescrs = functionDescriptor.getValueParameters();
        List<TypeParameterDescriptor> typeParameters = (functionDescriptor instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty() : functionDescriptor).getTypeParameters();
        int flags = 1;
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            flags |= 0x80;
        }
        if (functionDescriptor.getModality() == Modality.FINAL) {
            flags |= 0x10;
        }
        if ((kind = context.getContextKind()) == OwnerKind.TRAIT_IMPL) {
            needJetAnnotations = false;
        }
        ReceiverDescriptor expectedThisObject = functionDescriptor.getExpectedThisObject();
        ReceiverDescriptor receiverParameter = functionDescriptor.getReceiverParameter();
        if (kind != OwnerKind.TRAIT_IMPL || bodyExpressions != null) {
            boolean isAbstract;
            boolean isStatic;
            boolean bl = isStatic = kind == OwnerKind.NAMESPACE;
            if (isStatic || kind == OwnerKind.TRAIT_IMPL) {
                flags |= 8;
            }
            boolean bl2 = isAbstract = !isStatic && kind != OwnerKind.TRAIT_IMPL && (bodyExpressions == null || CodegenUtil.isInterface(functionDescriptor.getContainingDeclaration()));
            if (isAbstract) {
                flags |= 0x400;
            }
            MethodVisitor mv = this.v.newMethod(fun, flags, jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor(), jvmSignature.getGenericsSignature(), null);
            AnnotationCodegen.forMethod(mv).genAnnotations(functionDescriptor, this.state.getTypeMapper());
            if (this.v.generateCode() != ClassBuilder.Mode.SIGNATURES) {
                int start = 0;
                if (needJetAnnotations) {
                    if (functionDescriptor instanceof PropertyAccessorDescriptor) {
                        PropertyCodegen.generateJetPropertyAnnotation(mv, propertyTypeSignature, jvmSignature.getKotlinTypeParameter());
                    } else if (functionDescriptor instanceof SimpleFunctionDescriptor) {
                        if (propertyTypeSignature != null) {
                            throw new IllegalStateException();
                        }
                        JetMethodAnnotationWriter aw = JetMethodAnnotationWriter.visitAnnotation(mv);
                        aw.writeKind(0);
                        aw.writeNullableReturnType(functionDescriptor.getReturnType().isNullable());
                        aw.writeTypeParameters(jvmSignature.getKotlinTypeParameter());
                        aw.writeReturnType(jvmSignature.getKotlinReturnType());
                        aw.visitEnd();
                    } else {
                        throw new IllegalStateException();
                    }
                    if (receiverParameter.exists()) {
                        AnnotationVisitor av = mv.visitParameterAnnotation(start++, JvmStdlibNames.JET_VALUE_PARAMETER.getDescriptor(), true);
                        av.visit("name", (Object)"this$receiver");
                        if (receiverParameter.getType().isNullable()) {
                            av.visit("nullable", (Object)true);
                        }
                        av.visit("receiver", (Object)true);
                        if (jvmSignature.getKotlinParameterTypes() != null && jvmSignature.getKotlinParameterTypes().get(0) != null) {
                            av.visit("type", (Object)jvmSignature.getKotlinParameterTypes().get(0).getKotlinSignature());
                        }
                        av.visitEnd();
                    }
                    for (int i = 0; i != paramDescrs.size(); ++i) {
                        AnnotationVisitor av = mv.visitParameterAnnotation(i + start, JvmStdlibNames.JET_VALUE_PARAMETER.getDescriptor(), true);
                        ValueParameterDescriptor parameterDescriptor = paramDescrs.get(i);
                        av.visit("name", (Object)parameterDescriptor.getName());
                        if (parameterDescriptor.hasDefaultValue()) {
                            av.visit("hasDefaultValue", (Object)true);
                        }
                        if (parameterDescriptor.getType().isNullable()) {
                            av.visit("nullable", (Object)true);
                        }
                        if (jvmSignature.getKotlinParameterTypes() != null && jvmSignature.getKotlinParameterTypes().get(i) != null) {
                            av.visit("type", (Object)jvmSignature.getKotlinParameterTypes().get(i + start).getKotlinSignature());
                        }
                        av.visitEnd();
                    }
                }
            }
            if (!isAbstract && this.v.generateCode() == ClassBuilder.Mode.STUBS) {
                StubCodegen.generateStubCode(mv);
            }
            if (!isAbstract && this.v.generateCode() == ClassBuilder.Mode.FULL) {
                mv.visitCode();
                Label methodBegin = new Label();
                mv.visitLabel(methodBegin);
                FrameMap frameMap = context.prepareFrame(this.typeMapper);
                ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, jvmSignature.getAsmMethod().getReturnType(), context, this.state);
                Type[] argTypes = jvmSignature.getAsmMethod().getArgumentTypes();
                int add = 0;
                if (kind == OwnerKind.TRAIT_IMPL) {
                    ++add;
                }
                if (receiverParameter.exists()) {
                    ++add;
                }
                for (int i = 0; i < paramDescrs.size(); ++i) {
                    ValueParameterDescriptor parameter = paramDescrs.get(i);
                    frameMap.enter(parameter, argTypes[i + add].getSize());
                }
                if (kind instanceof OwnerKind.DelegateKind) {
                    OwnerKind.DelegateKind dk = (OwnerKind.DelegateKind)kind;
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    iv.load(0, JetTypeMapper.TYPE_OBJECT);
                    dk.getDelegate().put(JetTypeMapper.TYPE_OBJECT, iv);
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(i + 1, argType);
                    }
                    iv.invokeinterface(dk.getOwnerClass(), jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor());
                    iv.areturn(jvmSignature.getAsmMethod().getReturnType());
                } else {
                    for (ValueParameterDescriptor parameter : paramDescrs) {
                        Type sharedVarType = this.typeMapper.getSharedVarType(parameter);
                        if (sharedVarType == null) continue;
                        Type localVarType = this.typeMapper.mapType(parameter.getType());
                        int index = frameMap.getIndex(parameter);
                        mv.visitTypeInsn(187, sharedVarType.getInternalName());
                        mv.visitInsn(89);
                        mv.visitInsn(89);
                        mv.visitMethodInsn(183, sharedVarType.getInternalName(), "<init>", "()V");
                        mv.visitVarInsn(localVarType.getOpcode(21), index);
                        mv.visitFieldInsn(181, sharedVarType.getInternalName(), "ref", StackValue.refType(localVarType).getDescriptor());
                        mv.visitVarInsn(sharedVarType.getOpcode(54), index);
                    }
                    codegen.returnExpression(bodyExpressions);
                }
                Label methodEnd = new Label();
                mv.visitLabel(methodEnd);
                int k = 0;
                if (expectedThisObject.exists()) {
                    Type type = this.typeMapper.mapType(expectedThisObject.getType());
                    mv.visitLocalVariable("this", type.getDescriptor(), null, methodBegin, methodEnd, k++);
                }
                if (receiverParameter.exists()) {
                    Type type = this.typeMapper.mapType(receiverParameter.getType());
                    mv.visitLocalVariable("this$receiver", type.getDescriptor(), null, methodBegin, methodEnd, k);
                    k += type.getSize();
                }
                for (ValueParameterDescriptor parameter : paramDescrs) {
                    Type type = this.typeMapper.mapType(parameter.getType());
                    mv.visitLocalVariable(parameter.getName(), type.getDescriptor(), null, methodBegin, methodEnd, k);
                    k += type.getSize();
                }
                FunctionCodegen.endVisit(mv, null, fun);
                mv.visitEnd();
                FunctionCodegen.generateBridgeIfNeeded(this.owner, this.state, this.v, jvmSignature.getAsmMethod(), functionDescriptor, kind);
            }
        }
        FunctionCodegen.generateDefaultIfNeeded(context, this.state, this.v, jvmSignature.getAsmMethod(), functionDescriptor, kind);
    }

    public static void endVisit(MethodVisitor mv, String description, PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
        }
        catch (Throwable t) {
            throw new CompilationException("wrong code generated" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage(), t, method);
        }
        mv.visitEnd();
    }

    static void generateBridgeIfNeeded(CodegenContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, FunctionDescriptor functionDescriptor, OwnerKind kind) {
        Set<? extends FunctionDescriptor> overriddenFunctions = functionDescriptor.getOverriddenDescriptors();
        if (kind != OwnerKind.TRAIT_IMPL) {
            for (FunctionDescriptor functionDescriptor2 : overriddenFunctions) {
                FunctionCodegen.checkOverride(owner, state, v, jvmSignature, functionDescriptor, functionDescriptor2.getOriginal());
            }
            FunctionCodegen.checkOverride(owner, state, v, jvmSignature, functionDescriptor, functionDescriptor.getOriginal());
        }
    }

    static void generateDefaultIfNeeded(CodegenContext.MethodContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, @Nullable FunctionDescriptor functionDescriptor, OwnerKind kind) {
        JetClass element;
        PsiElement psiElement;
        DeclarationDescriptor contextClass = owner.getContextDescriptor().getContainingDeclaration();
        if (kind != OwnerKind.TRAIT_IMPL && contextClass instanceof ClassDescriptor && (psiElement = state.getBindingContext().get(BindingContext.DESCRIPTOR_TO_DECLARATION, contextClass)) instanceof JetClass && (element = (JetClass)psiElement).isTrait()) {
            return;
        }
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.hasDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        if (needed) {
            boolean isStatic;
            ReceiverDescriptor receiverParameter = functionDescriptor.getReceiverParameter();
            boolean hasReceiver = receiverParameter.exists();
            boolean bl = isStatic = kind == OwnerKind.NAMESPACE;
            if (kind == OwnerKind.TRAIT_IMPL) {
                String correctedDescr = "(" + jvmSignature.getDescriptor().substring(jvmSignature.getDescriptor().indexOf(";") + 1);
                jvmSignature = new Method(jvmSignature.getName(), correctedDescr);
            }
            int flags = 1;
            String ownerInternalName = contextClass instanceof NamespaceDescriptor ? NamespaceCodegen.getJVMClassName(DescriptorUtils.getFQName(contextClass), true) : state.getTypeMapper().mapType(((ClassDescriptor)contextClass).getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName();
            String descriptor = jvmSignature.getDescriptor().replace(")", "I)");
            boolean isConstructor = "<init>".equals(jvmSignature.getName());
            if (!isStatic && !isConstructor) {
                descriptor = descriptor.replace("(", "(L" + ownerInternalName + ";");
            }
            MethodVisitor mv = v.newMethod(null, flags | (isConstructor ? 0 : 8), isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor, null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            if (v.generateCode() == ClassBuilder.Mode.STUBS) {
                StubCodegen.generateStubCode(mv);
            } else if (v.generateCode() == ClassBuilder.Mode.FULL) {
                Type receiverType;
                mv.visitCode();
                FrameMap frameMap = owner.prepareFrame(state.getTypeMapper());
                ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, jvmSignature.getReturnType(), owner, state);
                int var = 0;
                if (!isStatic) {
                    ++var;
                }
                Type type = receiverType = receiverParameter.exists() ? state.getTypeMapper().mapType(receiverParameter.getType()) : Type.DOUBLE_TYPE;
                if (hasReceiver) {
                    var += receiverType.getSize();
                }
                Type[] argTypes = jvmSignature.getArgumentTypes();
                List<ValueParameterDescriptor> paramDescrs = functionDescriptor.getValueParameters();
                for (int i = 0; i < paramDescrs.size(); ++i) {
                    int size = argTypes[i + (hasReceiver ? 1 : 0)].getSize();
                    var += size;
                }
                int maskIndex = var;
                var = 0;
                if (!isStatic) {
                    mv.visitVarInsn(25, var++);
                }
                if (hasReceiver) {
                    iv.load(var, receiverType);
                    var += receiverType.getSize();
                }
                int extra = hasReceiver ? 1 : 0;
                Type[] argumentTypes = jvmSignature.getArgumentTypes();
                for (int index = 0; index < paramDescrs.size(); ++index) {
                    ValueParameterDescriptor parameterDescriptor = paramDescrs.get(index);
                    Type t = argumentTypes[extra + index];
                    Label endArg = null;
                    if (parameterDescriptor.hasDefaultValue()) {
                        iv.load(maskIndex, Type.INT_TYPE);
                        iv.iconst(1 << index);
                        iv.and(Type.INT_TYPE);
                        Label loadArg = new Label();
                        iv.ifeq(loadArg);
                        JetParameter jetParameter = (JetParameter)state.getBindingContext().get(BindingContext.DESCRIPTOR_TO_DECLARATION, parameterDescriptor);
                        assert (jetParameter != null);
                        codegen.gen(jetParameter.getDefaultValue(), t);
                        endArg = new Label();
                        iv.goTo(endArg);
                        iv.mark(loadArg);
                    }
                    iv.load(var, t);
                    var += t.getSize();
                    if (!parameterDescriptor.hasDefaultValue()) continue;
                    iv.mark(endArg);
                }
                if (!isStatic) {
                    if (kind == OwnerKind.TRAIT_IMPL) {
                        iv.invokeinterface(ownerInternalName, jvmSignature.getName(), jvmSignature.getDescriptor());
                    } else if (!isConstructor) {
                        iv.invokevirtual(ownerInternalName, jvmSignature.getName(), jvmSignature.getDescriptor());
                    } else {
                        iv.invokespecial(ownerInternalName, jvmSignature.getName(), jvmSignature.getDescriptor());
                    }
                } else {
                    iv.invokestatic(ownerInternalName, jvmSignature.getName(), jvmSignature.getDescriptor());
                }
                iv.areturn(jvmSignature.getReturnType());
                FunctionCodegen.endVisit(mv, "default method", state.getBindingContext().get(BindingContext.DESCRIPTOR_TO_DECLARATION, functionDescriptor));
                mv.visitEnd();
            }
        }
    }

    private static boolean differentMethods(Method method, Method overriden) {
        Type[] overridenArgumentTypes;
        if (!method.getReturnType().equals((Object)overriden.getReturnType())) {
            return true;
        }
        Type[] methodArgumentTypes = method.getArgumentTypes();
        if (methodArgumentTypes.length != (overridenArgumentTypes = overriden.getArgumentTypes()).length) {
            return true;
        }
        for (int i = 0; i != methodArgumentTypes.length; ++i) {
            if (methodArgumentTypes[i].equals((Object)overridenArgumentTypes[i])) continue;
            return true;
        }
        return false;
    }

    private static void checkOverride(CodegenContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenFunction) {
        Method method = state.getTypeMapper().mapSignature(functionDescriptor.getName(), functionDescriptor).getAsmMethod();
        Method overriden = state.getTypeMapper().mapSignature(overriddenFunction.getName(), overriddenFunction.getOriginal()).getAsmMethod();
        if (overriddenFunction.getModality() == Modality.ABSTRACT) {
            Set<? extends FunctionDescriptor> overriddenFunctions = overriddenFunction.getOverriddenDescriptors();
            for (FunctionDescriptor functionDescriptor2 : overriddenFunctions) {
                FunctionCodegen.checkOverride(owner, state, v, jvmSignature, overriddenFunction, functionDescriptor2.getOriginal());
            }
        }
        if (FunctionCodegen.differentMethods(method, overriden)) {
            int flags = 65;
            MethodVisitor mv = v.newMethod(null, flags, jvmSignature.getName(), overriden.getDescriptor(), null, null);
            if (v.generateCode() == ClassBuilder.Mode.STUBS) {
                StubCodegen.generateStubCode(mv);
            } else if (v.generateCode() == ClassBuilder.Mode.FULL) {
                mv.visitCode();
                Type[] typeArray = overriden.getArgumentTypes();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, JetTypeMapper.TYPE_OBJECT);
                int reg = 1;
                for (int i = 0; i < typeArray.length; ++i) {
                    Type argType = typeArray[i];
                    iv.load(reg, argType);
                    if (argType.getSort() == 10) {
                        StackValue.onStack(JetTypeMapper.TYPE_OBJECT).put(method.getArgumentTypes()[i], iv);
                    }
                    reg += argType.getSize();
                }
                iv.invokevirtual(state.getTypeMapper().mapType(((ClassDescriptor)owner.getContextDescriptor()).getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName(), jvmSignature.getName(), jvmSignature.getDescriptor());
                if (JetTypeMapper.isPrimitive(jvmSignature.getReturnType()) && !JetTypeMapper.isPrimitive(overriden.getReturnType())) {
                    StackValue.valueOf(iv, jvmSignature.getReturnType());
                }
                if (jvmSignature.getReturnType() == Type.VOID_TYPE) {
                    iv.aconst(null);
                }
                iv.areturn(overriden.getReturnType());
                FunctionCodegen.endVisit(mv, "bridge method", state.getBindingContext().get(BindingContext.DESCRIPTOR_TO_DECLARATION, functionDescriptor));
            }
        }
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, CallableMemberDescriptor overriddenDescriptor, StackValue field) {
        JvmMethodSignature jvmMethodSignature = this.state.getTypeMapper().mapSignature(functionDescriptor.getName(), functionDescriptor);
        this.genDelegate(functionDescriptor, overriddenDescriptor, field, jvmMethodSignature);
    }

    public void genDelegate(CallableMemberDescriptor functionDescriptor, CallableMemberDescriptor overriddenDescriptor, StackValue field, JvmMethodSignature jvmMethodSignature) {
        Method method = jvmMethodSignature.getAsmMethod();
        int flags = 4097;
        MethodVisitor mv = this.v.newMethod(null, flags, method.getName(), method.getDescriptor(), null, null);
        if (this.v.generateCode() == ClassBuilder.Mode.STUBS) {
            StubCodegen.generateStubCode(mv);
        } else if (this.v.generateCode() == ClassBuilder.Mode.FULL) {
            mv.visitCode();
            Type[] argTypes = method.getArgumentTypes();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, JetTypeMapper.TYPE_OBJECT);
            int reg = 1;
            for (int i = 0; i < argTypes.length; ++i) {
                Type argType = argTypes[i];
                iv.load(reg, argType);
                if (argType.getSort() == 10) {
                    StackValue.onStack(JetTypeMapper.TYPE_OBJECT).put(method.getArgumentTypes()[i], iv);
                }
                reg += argType.getSize();
            }
            iv.load(0, JetTypeMapper.TYPE_OBJECT);
            field.put(field.type, iv);
            ClassDescriptor classDescriptor = (ClassDescriptor)overriddenDescriptor.getContainingDeclaration();
            String internalName = this.state.getTypeMapper().mapType(classDescriptor.getDefaultType()).getInternalName();
            if (classDescriptor.getKind() == ClassKind.TRAIT) {
                iv.invokeinterface(internalName, method.getName(), method.getDescriptor());
            } else {
                iv.invokevirtual(internalName, method.getName(), method.getDescriptor());
            }
            iv.areturn(method.getReturnType());
            FunctionCodegen.endVisit(mv, "delegate method", this.state.getBindingContext().get(BindingContext.DESCRIPTOR_TO_DECLARATION, functionDescriptor));
        }
    }
}

