/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.ArrayList;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;

public class FrameMap {
    private final TObjectIntHashMap<DeclarationDescriptor> myVarIndex = new TObjectIntHashMap();
    private final TObjectIntHashMap<DeclarationDescriptor> myVarSizes = new TObjectIntHashMap();
    private int myMaxIndex = 0;

    public void enter(DeclarationDescriptor descriptor, int size) {
        this.myVarIndex.put((Object)descriptor, this.myMaxIndex);
        this.myMaxIndex += size;
        this.myVarSizes.put((Object)descriptor, size);
    }

    public int leave(DeclarationDescriptor descriptor) {
        int size = this.myVarSizes.get((Object)descriptor);
        this.myMaxIndex -= size;
        this.myVarSizes.remove((Object)descriptor);
        return this.myVarIndex.remove((Object)descriptor);
    }

    public int enterTemp() {
        return this.myMaxIndex++;
    }

    public int enterTemp(int size) {
        int result = this.myMaxIndex;
        this.myMaxIndex += size;
        return result;
    }

    public void leaveTemp() {
        --this.myMaxIndex;
    }

    public void leaveTemp(int size) {
        this.myMaxIndex -= size;
    }

    public int getIndex(DeclarationDescriptor descriptor) {
        return this.myVarIndex.contains((Object)descriptor) ? this.myVarIndex.get((Object)descriptor) : -1;
    }

    public Mark mark() {
        return new Mark(this.myMaxIndex);
    }

    public class Mark {
        private final int myIndex;

        public Mark(int index) {
            this.myIndex = index;
        }

        public void dropTo() {
            ArrayList<Object> descriptorsToDrop = new ArrayList<Object>();
            TObjectIntIterator iterator = FrameMap.this.myVarIndex.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                if (iterator.value() < this.myIndex) continue;
                descriptorsToDrop.add(iterator.key());
            }
            for (DeclarationDescriptor declarationDescriptor : descriptorsToDrop) {
                FrameMap.this.myVarIndex.remove((Object)declarationDescriptor);
                FrameMap.this.myVarSizes.remove((Object)declarationDescriptor);
            }
            FrameMap.this.myMaxIndex = this.myIndex;
        }
    }
}

