/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.Callable;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.EnclosedValueDescriptor;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.GeneratedAnonymousClassDescriptor;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.JvmPropertyAccessorSignature;
import org.jetbrains.jet.codegen.ObjectOrClosureCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableAsFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBindingPattern;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionPattern;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetPredicateExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTupleExpression;
import org.jetbrains.jet.lang.psi.JetTuplePattern;
import org.jetbrains.jet.lang.psi.JetTuplePatternEntry;
import org.jetbrains.jet.lang.psi.JetTypePattern;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.JetWildcardPattern;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.AutoCastReceiver;
import org.jetbrains.jet.lang.resolve.calls.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.commons.Method;

public class ExpressionCodegen
extends JetVisitor<StackValue, StackValue> {
    private static final String CLASS_NO_PATTERN_MATCHED_EXCEPTION = "jet/NoPatternMatchedException";
    private static final String CLASS_TYPE_CAST_EXCEPTION = "jet/TypeCastException";
    private int myLastLineNumber = -1;
    final InstructionAdapter v;
    final FrameMap myFrameMap;
    final JetTypeMapper typeMapper;
    private final GenerationState state;
    private final Type returnType;
    private final BindingContext bindingContext;
    private final Map<TypeParameterDescriptor, StackValue> typeParameterExpressions = new HashMap<TypeParameterDescriptor, StackValue>();
    private final CodegenContext context;
    private final IntrinsicMethods intrinsics;
    private final Stack<BlockStackElement> blockStackElements = new Stack();
    private Label continueLabel;

    public ExpressionCodegen(MethodVisitor v, FrameMap myMap, Type returnType, CodegenContext context, GenerationState state) {
        this.myFrameMap = myMap;
        this.typeMapper = state.getTypeMapper();
        this.returnType = returnType;
        this.state = state;
        this.v = new InstructionAdapter(v);
        this.bindingContext = state.getBindingContext();
        this.context = context;
        this.intrinsics = state.getIntrinsics();
    }

    StackValue castToRequiredTypeOfInterfaceIfNeeded(StackValue inner, DeclarationDescriptor provided, @Nullable ClassDescriptor required) {
        if (required == null) {
            return inner;
        }
        if (provided instanceof CallableDescriptor) {
            provided = ((CallableDescriptor)provided).getReceiverParameter().getType().getConstructor().getDeclarationDescriptor();
        }
        assert (provided instanceof ClassDescriptor);
        if (!CodegenUtil.isInterface(provided) && CodegenUtil.isInterface(required)) {
            this.v.checkcast(this.asmType(required.getDefaultType()));
        }
        return inner;
    }

    public GenerationState getState() {
        return this.state;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public JetTypeMapper getTypeMapper() {
        return this.state.getTypeMapper();
    }

    public void addTypeParameter(TypeParameterDescriptor typeParameter, StackValue expression) {
        this.typeParameterExpressions.put(typeParameter, expression);
    }

    public StackValue genQualified(StackValue receiver, JetElement selector) {
        this.markLineNumber(selector);
        try {
            return selector.accept(this, receiver);
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Throwable error) {
            throw new CompilationException(error.getMessage(), error, (PsiElement)selector);
        }
    }

    public StackValue gen(JetElement expr) {
        return this.genQualified(StackValue.none(), expr);
    }

    public void gen(JetElement expr, Type type) {
        StackValue value = this.gen(expr);
        value.put(type, this.v);
    }

    public void genToJVMStack(JetExpression expr) {
        this.gen(expr, this.expressionType(expr));
    }

    @Override
    public StackValue visitExpression(JetExpression expression, StackValue receiver) {
        throw new UnsupportedOperationException("Codegen for " + (Object)((Object)expression) + " is not yet implemented");
    }

    @Override
    public StackValue visitSuperExpression(JetSuperExpression expression, StackValue data) {
        DeclarationDescriptor descriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        if (descriptor instanceof ClassDescriptor) {
            return this.generateThisOrOuter((ClassDescriptor)descriptor);
        }
        JetType type = this.context.getThisDescriptor().getDefaultType();
        return StackValue.local(0, this.asmType(type));
    }

    private Type asmType(JetType type) {
        return this.typeMapper.mapType(type);
    }

    @Override
    public StackValue visitParenthesizedExpression(JetParenthesizedExpression expression, StackValue receiver) {
        return this.genQualified(receiver, expression.getExpression());
    }

    @Override
    public StackValue visitAnnotatedExpression(JetAnnotatedExpression expression, StackValue receiver) {
        return this.genQualified(receiver, expression.getBaseExpression());
    }

    private static boolean isEmptyExpression(JetElement expr) {
        JetBlockExpression blockExpression;
        List<JetElement> statements;
        if (expr == null) {
            return true;
        }
        return expr instanceof JetBlockExpression && ((statements = (blockExpression = (JetBlockExpression)expr).getStatements()).size() == 0 || statements.size() == 1 && ExpressionCodegen.isEmptyExpression(statements.get(0)));
    }

    @Override
    public StackValue visitIfExpression(JetIfExpression expression, StackValue receiver) {
        Label end;
        Type asmType = this.expressionType(expression);
        StackValue condition = this.gen(expression.getCondition());
        JetExpression thenExpression = expression.getThen();
        JetExpression elseExpression = expression.getElse();
        if (thenExpression == null && elseExpression == null) {
            throw new CompilationException("Both brunches of if/else are null", null, (PsiElement)expression);
        }
        if (ExpressionCodegen.isEmptyExpression(thenExpression)) {
            if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
                condition.put(asmType, this.v);
                return StackValue.onStack(asmType);
            }
            return this.generateSingleBranchIf(condition, elseExpression, false);
        }
        if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
            return this.generateSingleBranchIf(condition, thenExpression, true);
        }
        Label elseLabel = new Label();
        condition.condJump(elseLabel, true, this.v);
        Label label = end = this.continueLabel == null ? new Label() : this.continueLabel;
        if (this.continueLabel != null) {
            asmType = Type.VOID_TYPE;
        }
        this.gen(thenExpression, asmType);
        this.v.goTo(end);
        this.v.mark(elseLabel);
        this.gen(elseExpression, asmType);
        if (end != this.continueLabel) {
            this.v.mark(end);
        } else {
            this.v.goTo(end);
        }
        return StackValue.onStack(asmType);
    }

    @Override
    public StackValue visitWhileExpression(JetWhileExpression expression, StackValue receiver) {
        Label condition = new Label();
        this.v.mark(condition);
        Label end = this.continueLabel != null ? this.continueLabel : new Label();
        this.blockStackElements.push(new LoopBlockStackElement(end, condition, this.targetLabel(expression)));
        Label savedContinueLabel = this.continueLabel;
        this.continueLabel = condition;
        StackValue conditionValue = this.gen(expression.getCondition());
        conditionValue.condJump(end, true, this.v);
        this.gen(expression.getBody(), Type.VOID_TYPE);
        this.v.goTo(condition);
        this.continueLabel = savedContinueLabel;
        if (end != this.continueLabel) {
            this.v.mark(end);
        }
        this.blockStackElements.pop();
        return StackValue.onStack(Type.VOID_TYPE);
    }

    @Override
    public StackValue visitDoWhileExpression(JetDoWhileExpression expression, StackValue receiver) {
        Label condition = new Label();
        this.v.mark(condition);
        Label end = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(end, condition, this.targetLabel(expression)));
        this.gen(expression.getBody(), Type.VOID_TYPE);
        StackValue conditionValue = this.gen(expression.getCondition());
        conditionValue.condJump(condition, false, this.v);
        this.v.mark(end);
        this.blockStackElements.pop();
        return StackValue.onStack(Type.VOID_TYPE);
    }

    @Override
    public StackValue visitForExpression(JetForExpression expression, StackValue receiver) {
        JetExpression loopRange = expression.getLoopRange();
        JetType expressionType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, loopRange);
        Type loopRangeType = this.asmType(expressionType);
        if (loopRangeType.getSort() == 9) {
            new ForInArrayLoopGenerator(expression, loopRangeType).invoke();
            return StackValue.none();
        }
        assert (expressionType != null);
        ClassifierDescriptor descriptor = expressionType.getConstructor().getDeclarationDescriptor();
        if (ExpressionCodegen.isClass(descriptor, "IntRange")) {
            new ForInRangeLoopGenerator(expression, loopRangeType).invoke();
            return StackValue.none();
        }
        this.generateForInIterable(expression, loopRangeType);
        return StackValue.none();
    }

    private void generateForInIterable(JetForExpression expression, Type loopRangeType) {
        JetExpression loopRange = expression.getLoopRange();
        FunctionDescriptor iteratorDescriptor = this.bindingContext.get(BindingContext.LOOP_RANGE_ITERATOR, loopRange);
        FunctionDescriptor nextDescriptor = this.bindingContext.get(BindingContext.LOOP_RANGE_NEXT, loopRange);
        DeclarationDescriptor hasNextDescriptor = this.bindingContext.get(BindingContext.LOOP_RANGE_HAS_NEXT, loopRange);
        if (iteratorDescriptor == null) {
            throw new IllegalStateException("No iterator() method " + DiagnosticUtils.atLocation((PsiElement)loopRange));
        }
        if (nextDescriptor == null) {
            throw new IllegalStateException("No next() method " + DiagnosticUtils.atLocation((PsiElement)loopRange));
        }
        if (hasNextDescriptor == null) {
            throw new IllegalStateException("No hasNext method or property" + DiagnosticUtils.atLocation((PsiElement)loopRange));
        }
        JetParameter loopParameter = expression.getLoopParameter();
        VariableDescriptor parameterDescriptor = this.bindingContext.get(BindingContext.VALUE_PARAMETER, loopParameter);
        JetType iteratorType = iteratorDescriptor.getReturnType();
        Type asmIterType = JetTypeMapper.boxType(this.asmType(iteratorType));
        JetType paramType = parameterDescriptor.getType();
        Type asmParamType = this.asmType(paramType);
        int iteratorVar = this.myFrameMap.enterTemp();
        this.gen(expression.getLoopRange(), JetTypeMapper.boxType(loopRangeType));
        this.invokeFunctionNoParams(iteratorDescriptor, asmIterType, this.v);
        this.v.store(iteratorVar, asmIterType);
        Label end = new Label();
        if (iteratorType.isNullable()) {
            this.v.load(iteratorVar, JetTypeMapper.TYPE_OBJECT);
            this.v.ifnull(end);
        }
        Label begin = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(end, begin, this.targetLabel(expression)));
        this.v.mark(begin);
        this.v.load(iteratorVar, asmIterType);
        if (hasNextDescriptor instanceof FunctionDescriptor) {
            FunctionDescriptor hND = (FunctionDescriptor)hasNextDescriptor;
            this.invokeFunctionNoParams(hND, Type.BOOLEAN_TYPE, this.v);
        } else {
            this.intermediateValueForProperty((PropertyDescriptor)hasNextDescriptor, false, null).put(Type.BOOLEAN_TYPE, this.v);
        }
        this.v.ifeq(end);
        this.myFrameMap.enter(parameterDescriptor, asmParamType.getSize());
        this.v.load(iteratorVar, asmIterType);
        this.invokeFunctionNoParams(nextDescriptor, asmParamType, this.v);
        if (asmParamType.getSort() == 10 && !"java.lang.Object".equals(asmParamType.getClassName())) {
            this.v.checkcast(asmParamType);
        }
        this.v.store(this.lookupLocal(parameterDescriptor), asmParamType);
        this.gen(expression.getBody(), Type.VOID_TYPE);
        this.v.goTo(begin);
        this.v.mark(end);
        int paramIndex = this.myFrameMap.leave(parameterDescriptor);
        this.v.visitLocalVariable(loopParameter.getName(), asmParamType.getDescriptor(), null, begin, end, paramIndex);
        this.myFrameMap.leaveTemp();
        this.blockStackElements.pop();
    }

    private OwnerKind contextKind() {
        return this.context.getContextKind();
    }

    @Override
    public StackValue visitBreakExpression(JetBreakExpression expression, StackValue receiver) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        for (int i = this.blockStackElements.size() - 1; i >= 0; --i) {
            BlockStackElement stackElement = (BlockStackElement)this.blockStackElements.get(i);
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                JetTryExpression jetTryExpression = finallyBlockStackElement.expression;
                this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
                continue;
            }
            if (stackElement instanceof LoopBlockStackElement) {
                LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement;
                if (labelElement != null && (loopBlockStackElement.targetLabel == null || !labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName()))) continue;
                this.v.goTo(loopBlockStackElement.breakLabel);
                return StackValue.none();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public StackValue visitContinueExpression(JetContinueExpression expression, StackValue receiver) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        for (int i = this.blockStackElements.size() - 1; i >= 0; --i) {
            BlockStackElement stackElement = (BlockStackElement)this.blockStackElements.get(i);
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                JetTryExpression jetTryExpression = finallyBlockStackElement.expression;
                this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
                continue;
            }
            if (stackElement instanceof LoopBlockStackElement) {
                LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement;
                if (labelElement != null && (loopBlockStackElement.targetLabel == null || !labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName()))) continue;
                this.v.goTo(loopBlockStackElement.continueLabel);
                return StackValue.none();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    private StackValue generateSingleBranchIf(StackValue condition, JetExpression expression, boolean inverse) {
        Label end = this.continueLabel != null ? this.continueLabel : new Label();
        condition.condJump(end, inverse, this.v);
        this.gen(expression, Type.VOID_TYPE);
        if (this.continueLabel != end) {
            this.v.mark(end);
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitConstantExpression(JetConstantExpression expression, StackValue receiver) {
        CompileTimeConstant<?> compileTimeValue = this.bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression);
        assert (compileTimeValue != null);
        return StackValue.constant(compileTimeValue.getValue(), this.expressionType(expression));
    }

    @Override
    public StackValue visitStringTemplateExpression(JetStringTemplateExpression expression, StackValue receiver) {
        StringBuilder constantValue = new StringBuilder("");
        for (JetStringTemplateEntry entry : expression.getEntries()) {
            if (entry instanceof JetLiteralStringTemplateEntry) {
                constantValue.append(entry.getText());
                continue;
            }
            if (entry instanceof JetEscapeStringTemplateEntry) {
                constantValue.append(((JetEscapeStringTemplateEntry)entry).getUnescapedValue());
                continue;
            }
            constantValue = null;
            break;
        }
        if (constantValue != null) {
            Type type = this.expressionType(expression);
            return StackValue.constant(constantValue.toString(), type);
        }
        this.generateStringBuilderConstructor();
        for (JetStringTemplateEntry entry : expression.getEntries()) {
            if (entry instanceof JetStringTemplateEntryWithExpression) {
                this.invokeAppend(entry.getExpression());
                continue;
            }
            String text = entry instanceof JetEscapeStringTemplateEntry ? ((JetEscapeStringTemplateEntry)entry).getUnescapedValue() : entry.getText();
            this.v.aconst((Object)text);
            this.invokeAppendMethod(JetTypeMapper.JL_STRING_TYPE);
        }
        this.v.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        return StackValue.onStack(this.expressionType(expression));
    }

    @Override
    public StackValue visitBlockExpression(JetBlockExpression expression, StackValue receiver) {
        List<JetElement> statements = expression.getStatements();
        return this.generateBlock(statements);
    }

    @Override
    public StackValue visitNamedFunction(JetNamedFunction function, StackValue data) {
        assert (data == StackValue.none());
        StackValue closure = this.genClosure(function);
        DeclarationDescriptor descriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
        int index = this.myFrameMap.getIndex(descriptor);
        closure.put(JetTypeMapper.TYPE_OBJECT, this.v);
        this.v.store(index, JetTypeMapper.TYPE_OBJECT);
        return StackValue.none();
    }

    @Override
    public StackValue visitFunctionLiteralExpression(JetFunctionLiteralExpression expression, StackValue receiver) {
        if (this.bindingContext.get(BindingContext.BLOCK, expression).booleanValue()) {
            return this.generateBlock(expression.getFunctionLiteral().getBodyExpression().getStatements());
        }
        return this.genClosure(expression);
    }

    private StackValue genClosure(JetExpression expression) {
        ClosureCodegen closureCodegen = new ClosureCodegen(this.state, this, this.context);
        GeneratedAnonymousClassDescriptor closure = closureCodegen.gen(expression);
        if (closureCodegen.isConst()) {
            this.v.invokestatic(closure.getClassname(), "$getInstance", "()L" + closure.getClassname() + ";");
        } else {
            this.v.anew(Type.getObjectType((String)closure.getClassname()));
            this.v.dup();
            Method cons = closure.getConstructor();
            int k = 0;
            if (closure.isCaptureThis()) {
                ++k;
                this.v.load(0, JetTypeMapper.TYPE_OBJECT);
            }
            if (closure.isCaptureReceiver() != null) {
                ++k;
                this.v.load(this.context.getContextDescriptor().getContainingDeclaration() instanceof NamespaceDescriptor ? 0 : 1, closure.isCaptureReceiver());
            }
            for (int i = 0; i < closure.getArgs().size(); ++i) {
                StackValue arg = closure.getArgs().get(i);
                arg.put(cons.getArgumentTypes()[i + k], this.v);
            }
            this.v.invokespecial(closure.getClassname(), "<init>", cons.getDescriptor());
        }
        return StackValue.onStack(Type.getObjectType((String)closure.getClassname()));
    }

    @Override
    public StackValue visitObjectLiteralExpression(JetObjectLiteralExpression expression, StackValue receiver) {
        ObjectOrClosureCodegen closureCodegen = new ObjectOrClosureCodegen(this, this.context, this.state);
        GeneratedAnonymousClassDescriptor closure = this.state.generateObjectLiteral(expression, closureCodegen);
        Type type = Type.getObjectType((String)closure.getClassname());
        this.v.anew(type);
        this.v.dup();
        LinkedList<Type> consArgTypes = new LinkedList<Type>(Arrays.asList(closure.getConstructor().getArgumentTypes()));
        if (consArgTypes.size() > 0) {
            this.v.load(0, JetTypeMapper.TYPE_OBJECT);
        }
        if (closureCodegen.captureReceiver != null) {
            this.v.load(this.context.isStatic() ? 0 : 1, closureCodegen.captureReceiver);
            consArgTypes.add(closureCodegen.captureReceiver);
        }
        for (Map.Entry<DeclarationDescriptor, EnclosedValueDescriptor> entry : closureCodegen.closure.entrySet()) {
            if (!(entry.getKey() instanceof VariableDescriptor) || entry.getKey() instanceof PropertyDescriptor) continue;
            Type sharedVarType = this.typeMapper.getSharedVarType(entry.getKey());
            if (sharedVarType == null) {
                sharedVarType = this.state.getTypeMapper().mapType(((VariableDescriptor)entry.getKey()).getType());
            }
            consArgTypes.add(sharedVarType);
            entry.getValue().getOuterValue().put(sharedVarType, this.v);
        }
        if (closureCodegen.superCall != null) {
            ConstructorDescriptor superConstructor = (ConstructorDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, closureCodegen.superCall.getCalleeExpression().getConstructorReferenceExpression());
            CallableMethod superCallable = this.typeMapper.mapToCallableMethod(superConstructor, OwnerKind.IMPLEMENTATION, this.typeMapper.hasThis0(superConstructor.getContainingDeclaration()));
            Type[] argumentTypes = superCallable.getSignature().getAsmMethod().getArgumentTypes();
            Collections.addAll(consArgTypes, argumentTypes);
            ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, closureCodegen.superCall.getCalleeExpression());
            this.pushMethodArguments(resolvedCall, Arrays.asList(argumentTypes));
        }
        Method cons = new Method("<init>", Type.VOID_TYPE, consArgTypes.toArray(new Type[consArgTypes.size()]));
        this.v.invokespecial(closure.getClassname(), "<init>", cons.getDescriptor());
        return StackValue.onStack(Type.getObjectType((String)closure.getClassname()));
    }

    private StackValue generateBlock(List<JetElement> statements) {
        Label blockStart = new Label();
        this.v.mark(blockStart);
        for (JetElement statement : statements) {
            if (statement instanceof JetProperty) {
                VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, statement);
                assert (variableDescriptor != null);
                Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
                Type type = sharedVarType != null ? sharedVarType : this.asmType(variableDescriptor.getType());
                this.myFrameMap.enter(variableDescriptor, type.getSize());
            }
            if (!(statement instanceof JetNamedFunction)) continue;
            DeclarationDescriptor descriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement);
            this.myFrameMap.enter(descriptor, 1);
        }
        StackValue answer = StackValue.none();
        Label savedContinueLabel = this.continueLabel;
        this.continueLabel = null;
        int statementsSize = statements.size();
        for (int i = 0; i < statementsSize; ++i) {
            JetElement statement = statements.get(i);
            if (i == statements.size() - 1) {
                this.continueLabel = savedContinueLabel;
                answer = this.gen(statement);
                continue;
            }
            this.gen(statement, Type.VOID_TYPE);
        }
        Label blockEnd = new Label();
        this.v.mark(blockEnd);
        for (JetElement statement : statements) {
            Type type;
            if (statement instanceof JetNamedFunction) {
                DeclarationDescriptor descriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement);
                this.myFrameMap.leave(descriptor);
            }
            if (!(statement instanceof JetProperty)) continue;
            JetProperty var = (JetProperty)statement;
            VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, var);
            assert (variableDescriptor != null);
            int index = this.myFrameMap.leave(variableDescriptor);
            Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
            Type type2 = type = sharedVarType != null ? sharedVarType : this.asmType(variableDescriptor.getType());
            if (sharedVarType != null) {
                this.v.aconst(null);
                this.v.store(index, JetTypeMapper.TYPE_OBJECT);
            }
            this.v.visitLocalVariable(var.getName(), type.getDescriptor(), null, blockStart, blockEnd, index);
        }
        return answer;
    }

    private void markLineNumber(JetElement statement) {
        Document document = statement.getContainingFile().getViewProvider().getDocument();
        if (document != null) {
            int lineNumber = document.getLineNumber(statement.getTextRange().getStartOffset());
            if (lineNumber == this.myLastLineNumber) {
                return;
            }
            this.myLastLineNumber = lineNumber;
            Label label = new Label();
            this.v.visitLabel(label);
            this.v.visitLineNumber(lineNumber + 1, label);
        }
    }

    private void doFinallyOnReturnOrThrow() {
        BlockStackElement stackElement;
        for (int i = this.blockStackElements.size() - 1; i >= 0 && (stackElement = (BlockStackElement)this.blockStackElements.get(i)) instanceof FinallyBlockStackElement; --i) {
            FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
            JetTryExpression jetTryExpression = finallyBlockStackElement.expression;
            this.blockStackElements.pop();
            this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
            this.blockStackElements.push(finallyBlockStackElement);
        }
    }

    @Override
    public StackValue visitReturnExpression(JetReturnExpression expression, StackValue receiver) {
        JetExpression returnedExpression = expression.getReturnedExpression();
        if (returnedExpression != null) {
            this.gen(returnedExpression, this.returnType);
            this.doFinallyOnReturnOrThrow();
            this.v.areturn(this.returnType);
        } else {
            this.v.visitInsn(177);
        }
        return StackValue.none();
    }

    public void returnExpression(JetExpression expr) {
        StackValue lastValue = this.gen(expr);
        if (lastValue.type != Type.VOID_TYPE) {
            lastValue.put(this.returnType, this.v);
            this.v.areturn(this.returnType);
        } else if (!ExpressionCodegen.endsWithReturn(expr)) {
            this.v.areturn(this.returnType);
        }
    }

    private static boolean endsWithReturn(JetElement bodyExpression) {
        if (bodyExpression instanceof JetBlockExpression) {
            List<JetElement> statements = ((JetBlockExpression)bodyExpression).getStatements();
            return statements.size() > 0 && statements.get(statements.size() - 1) instanceof JetReturnExpression;
        }
        return bodyExpression instanceof JetReturnExpression;
    }

    @Override
    public StackValue visitSimpleNameExpression(JetSimpleNameExpression expression, StackValue receiver) {
        IntrinsicMethod intrinsic;
        DeclarationDescriptor descriptor;
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression);
        if (resolvedCall == null) {
            descriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        } else {
            receiver = StackValue.receiver(resolvedCall, receiver, this, null);
            descriptor = resolvedCall.getResultingDescriptor();
        }
        if (descriptor instanceof VariableAsFunctionDescriptor) {
            descriptor = ((VariableAsFunctionDescriptor)descriptor).getVariableDescriptor();
        }
        if ((intrinsic = this.intrinsics.getIntrinsic(descriptor)) != null) {
            Type expectedType = this.expressionType(expression);
            return intrinsic.generate(this, this.v, expectedType, (PsiElement)expression, Collections.<JetExpression>emptyList(), receiver);
        }
        assert (descriptor != null);
        DeclarationDescriptor container = descriptor.getContainingDeclaration();
        int index = this.lookupLocal(descriptor);
        if (index >= 0) {
            if (descriptor instanceof VariableDescriptor) {
                Type sharedVarType = this.typeMapper.getSharedVarType(descriptor);
                JetType outType = ((VariableDescriptor)descriptor).getType();
                if (sharedVarType != null) {
                    return StackValue.shared(index, this.asmType(outType));
                }
                return StackValue.local(index, this.asmType(outType));
            }
            return StackValue.local(index, JetTypeMapper.TYPE_OBJECT);
        }
        if (descriptor instanceof PropertyDescriptor) {
            DeclarationDescriptor enclosed;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            if (propertyDescriptor.isObjectDeclaration()) {
                ClassDescriptor classDescriptor = (ClassDescriptor)propertyDescriptor.getReturnType().getConstructor().getDeclarationDescriptor();
                if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
                    ClassDescriptor containing = (ClassDescriptor)classDescriptor.getContainingDeclaration().getContainingDeclaration();
                    Type type = this.typeMapper.mapType(containing.getDefaultType(), OwnerKind.IMPLEMENTATION);
                    StackValue.field(type, type.getInternalName(), classDescriptor.getName(), true).put(JetTypeMapper.TYPE_OBJECT, this.v);
                    type = this.typeMapper.mapType(classDescriptor.getDefaultType(), OwnerKind.IMPLEMENTATION);
                    return StackValue.onStack(type);
                }
                Type type = this.typeMapper.mapType(classDescriptor.getDefaultType(), OwnerKind.IMPLEMENTATION);
                return StackValue.field(type, type.getInternalName(), "$instance", true);
            }
            boolean isStatic = container instanceof NamespaceDescriptor;
            boolean directToField = expression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER && this.contextKind() != OwnerKind.TRAIT_IMPL;
            JetExpression r = ExpressionCodegen.getReceiverForSelector((PsiElement)expression);
            boolean isSuper = r instanceof JetSuperExpression;
            if (propertyDescriptor.getVisibility() == Visibility.PRIVATE && !CodegenUtil.isClassObject(propertyDescriptor.getContainingDeclaration()) && this.context.getClassOrNamespaceDescriptor() != propertyDescriptor.getContainingDeclaration() && (enclosed = propertyDescriptor.getContainingDeclaration()) != null && enclosed != this.context.getThisDescriptor()) {
                CodegenContext c = this.context;
                while (c.getContextDescriptor() != enclosed) {
                    c = c.getParentContext();
                }
                propertyDescriptor = (PropertyDescriptor)c.getAccessor(propertyDescriptor);
            }
            StackValue.Property iValue = this.intermediateValueForProperty(propertyDescriptor, directToField, isSuper ? (JetSuperExpression)r : null);
            if (!directToField && resolvedCall != null && !isSuper) {
                receiver.put(propertyDescriptor.getReceiverParameter().exists() || isStatic ? receiver.type : Type.getObjectType((String)iValue.methodOwner), this.v);
            } else if (!isStatic) {
                ClassDescriptor propReceiverDescriptor;
                JetType receiverType;
                if (receiver == StackValue.none()) {
                    receiver = resolvedCall == null ? this.generateThisOrOuter((ClassDescriptor)propertyDescriptor.getContainingDeclaration()) : (resolvedCall.getThisObject() instanceof ExtensionReceiver ? this.generateReceiver(((ExtensionReceiver)resolvedCall.getThisObject()).getDeclarationDescriptor()) : this.generateThisOrOuter((ClassDescriptor)propertyDescriptor.getContainingDeclaration()));
                }
                receiver.put((receiverType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, r)) != null && !isSuper ? this.asmType(receiverType) : JetTypeMapper.TYPE_OBJECT, this.v);
                if (receiverType != null && !CodegenUtil.isInterface(propReceiverDescriptor = (ClassDescriptor)propertyDescriptor.getContainingDeclaration()) && CodegenUtil.isInterface(receiverType.getConstructor().getDeclarationDescriptor())) {
                    assert (propReceiverDescriptor != null);
                    this.v.checkcast(this.asmType(propReceiverDescriptor.getDefaultType()));
                }
            }
            return iValue;
        }
        if (descriptor instanceof ClassDescriptor) {
            PsiElement declaration = this.bindingContext.get(BindingContext.DESCRIPTOR_TO_DECLARATION, descriptor);
            if (declaration instanceof JetClass) {
                JetClassObject classObject = ((JetClass)declaration).getClassObject();
                if (classObject == null) {
                    throw new UnsupportedOperationException("trying to reference a class which doesn't have a class object");
                }
                ClassDescriptor descriptor1 = this.bindingContext.get(BindingContext.CLASS, classObject.getObjectDeclaration());
                assert (descriptor1 != null);
                String type = this.typeMapper.mapType(descriptor1.getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName();
                return StackValue.field(Type.getObjectType((String)type), this.typeMapper.mapType(((ClassDescriptor)descriptor).getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName(), "$classobj", true);
            }
            return StackValue.none();
        }
        if (descriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor;
            this.v.invokevirtual("jet/TypeInfo", "getClassObject", "()Ljava/lang/Object;");
            this.v.checkcast(this.asmType(typeParameterDescriptor.getClassObjectType()));
            return StackValue.onStack(JetTypeMapper.TYPE_OBJECT);
        }
        StackValue value = this.context.lookupInContext(descriptor, this.v, StackValue.local(0, JetTypeMapper.TYPE_OBJECT));
        if (value == null) {
            throw new UnsupportedOperationException("don't know how to generate reference " + descriptor);
        }
        if (value instanceof StackValue.Composed) {
            StackValue.Composed composed = (StackValue.Composed)value;
            composed.prefix.put(JetTypeMapper.TYPE_OBJECT, this.v);
            value = composed.suffix;
        }
        if (value instanceof StackValue.FieldForSharedVar) {
            StackValue.FieldForSharedVar fieldForSharedVar = (StackValue.FieldForSharedVar)value;
            Type sharedType = StackValue.sharedTypeForType(value.type);
            this.v.visitFieldInsn(180, fieldForSharedVar.owner, fieldForSharedVar.name, sharedType.getDescriptor());
        }
        return value;
    }

    public int lookupLocal(DeclarationDescriptor descriptor) {
        return this.myFrameMap.getIndex(descriptor);
    }

    public void invokeFunctionNoParams(FunctionDescriptor functionDescriptor, Type type, InstructionAdapter v) {
        boolean isInterface;
        String owner;
        boolean isInsideClass;
        DeclarationDescriptor containingDeclaration = functionDescriptor.getOriginal().getContainingDeclaration();
        boolean isStatic = containingDeclaration instanceof NamespaceDescriptor;
        IntrinsicMethod intrinsic = this.intrinsics.getIntrinsic(functionDescriptor = functionDescriptor.getOriginal());
        if (intrinsic != null) {
            intrinsic.generate(this, v, type, null, null, StackValue.onStack(JetTypeMapper.TYPE_OBJECT));
            return;
        }
        boolean bl = isInsideClass = containingDeclaration == this.context.getThisDescriptor();
        if (isInsideClass || isStatic) {
            owner = this.typeMapper.getOwner(functionDescriptor, this.contextKind());
            isInterface = false;
        } else {
            owner = this.typeMapper.getOwner(functionDescriptor, OwnerKind.IMPLEMENTATION);
            isInterface = CodegenUtil.isInterface(containingDeclaration);
        }
        v.visitMethodInsn(isStatic ? 184 : (isInterface ? 185 : 182), owner, functionDescriptor.getName(), this.typeMapper.mapSignature(functionDescriptor.getName(), functionDescriptor).getAsmMethod().getDescriptor());
        StackValue.onStack(this.asmType(functionDescriptor.getReturnType())).coerce(type, v);
    }

    public StackValue.Property intermediateValueForProperty(PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable JetSuperExpression superExpression) {
        int invokeOpcode;
        boolean isInterface;
        String owner;
        String ownerParam;
        Method setter;
        Method getter;
        boolean isInsideClass;
        boolean isSuper = superExpression != null;
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        assert (containingDeclaration != null);
        containingDeclaration = containingDeclaration.getOriginal();
        boolean isStatic = containingDeclaration instanceof NamespaceDescriptor;
        propertyDescriptor = propertyDescriptor.getOriginal();
        boolean bl = isInsideClass = (containingDeclaration == this.context.getThisDescriptor() || this.context.getParentContext() instanceof CodegenContext.NamespaceContext && this.context.getParentContext().getContextDescriptor() == containingDeclaration) && this.contextKind() != OwnerKind.TRAIT_IMPL;
        if (forceField) {
            getter = null;
            setter = null;
        } else {
            if (isInsideClass && (propertyDescriptor.getGetter() == null || propertyDescriptor.getGetter().isDefault() && propertyDescriptor.getGetter().getModality() == Modality.FINAL)) {
                getter = null;
            } else {
                if (isSuper) {
                    PsiElement enclosingElement = this.bindingContext.get(BindingContext.LABEL_TARGET, superExpression.getTargetLabel());
                    ClassDescriptor enclosed = (ClassDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, enclosingElement);
                    if (!CodegenUtil.isInterface(containingDeclaration) && enclosed != null && enclosed != this.context.getThisDescriptor()) {
                        CodegenContext c = this.context;
                        while (c.getContextDescriptor() != enclosed) {
                            c = c.getParentContext();
                        }
                        propertyDescriptor = (PropertyDescriptor)c.getAccessor(propertyDescriptor);
                        isSuper = false;
                    }
                }
                getter = this.typeMapper.mapGetterSignature(propertyDescriptor, OwnerKind.IMPLEMENTATION).getJvmMethodSignature().getAsmMethod();
                if (propertyDescriptor.getGetter() == null) {
                    getter = null;
                }
                if (getter == null && propertyDescriptor.getReceiverParameter().exists()) {
                    throw new IllegalStateException();
                }
            }
            if (isInsideClass && (propertyDescriptor.getSetter() == null || propertyDescriptor.getSetter().isDefault() && propertyDescriptor.getSetter().getModality() == Modality.FINAL)) {
                setter = null;
            } else {
                JvmPropertyAccessorSignature jvmMethodSignature = this.typeMapper.mapSetterSignature(propertyDescriptor, OwnerKind.IMPLEMENTATION);
                Method method = setter = jvmMethodSignature != null ? jvmMethodSignature.getJvmMethodSignature().getAsmMethod() : null;
                if (propertyDescriptor.getSetter() == null) {
                    setter = null;
                }
                if (setter == null && propertyDescriptor.isVar() && propertyDescriptor.getReceiverParameter().exists()) {
                    throw new IllegalStateException();
                }
            }
        }
        if (isInsideClass || isStatic || propertyDescriptor.getGetter() == null) {
            owner = ownerParam = this.typeMapper.getOwner(propertyDescriptor, this.contextKind());
            isInterface = false;
            invokeOpcode = isStatic ? 184 : 182;
        } else {
            isInterface = CodegenUtil.isInterface(containingDeclaration);
            CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(propertyDescriptor.getGetter(), isSuper, this.contextKind());
            invokeOpcode = callableMethod.getInvokeOpcode();
            owner = callableMethod.getOwner();
            ownerParam = callableMethod.getDefaultImplParam();
        }
        return StackValue.property(propertyDescriptor.getName(), owner, ownerParam, this.asmType(propertyDescriptor.getType()), isStatic, isInterface, isSuper, getter, setter, invokeOpcode);
    }

    @Override
    public StackValue visitCallExpression(JetCallExpression expression, StackValue receiver) {
        JetExpression callee = expression.getCalleeExpression();
        assert (callee != null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, callee);
        if (resolvedCall == null) {
            throw new CompilationException("Cannot resolve: " + callee.getText(), null, expression);
        }
        CallableDescriptor funDescriptor = resolvedCall.getResultingDescriptor();
        if (funDescriptor instanceof ConstructorDescriptor) {
            receiver = StackValue.receiver(resolvedCall, receiver, this, null);
            return this.generateConstructorCall(expression, (JetSimpleNameExpression)callee, receiver);
        }
        if (funDescriptor instanceof FunctionDescriptor) {
            FunctionDescriptor fd = (FunctionDescriptor)funDescriptor;
            return this.invokeFunction(expression, fd, receiver);
        }
        throw new UnsupportedOperationException("unknown type of callee descriptor: " + funDescriptor);
    }

    private StackValue invokeFunction(JetCallExpression expression, DeclarationDescriptor fd, StackValue receiver) {
        Callable callable;
        JetExpression receiverExpression;
        boolean superCall = false;
        if (expression.getParent() instanceof JetQualifiedExpression && (receiverExpression = ((JetQualifiedExpression)expression.getParent()).getReceiverExpression()) instanceof JetSuperExpression) {
            superCall = true;
            receiver = StackValue.thisOrOuter(this, this.context.getThisDescriptor());
            JetSuperExpression superExpression = (JetSuperExpression)receiverExpression;
            PsiElement enclosingElement = this.bindingContext.get(BindingContext.LABEL_TARGET, superExpression.getTargetLabel());
            ClassDescriptor enclosed = (ClassDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, enclosingElement);
            if (!CodegenUtil.isInterface(fd.getContainingDeclaration()) && enclosed != null && enclosed != this.context.getThisDescriptor()) {
                CodegenContext c = this.context;
                while (c.getContextDescriptor() != enclosed) {
                    c = c.getParentContext();
                }
                fd = c.getAccessor(fd);
                superCall = false;
                receiver = StackValue.thisOrOuter(this, enclosed);
            }
        }
        if ((callable = this.resolveToCallable(fd, superCall)) instanceof CallableMethod) {
            CallableMethod callableMethod = (CallableMethod)callable;
            this.invokeMethodWithArguments(callableMethod, expression, receiver);
            Type callReturnType = callableMethod.getSignature().getAsmMethod().getReturnType();
            return this.returnValueAsStackValue((FunctionDescriptor)fd, callReturnType);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
        assert (resolvedCall != null);
        receiver = StackValue.receiver(resolvedCall, receiver, this, null);
        IntrinsicMethod intrinsic = (IntrinsicMethod)callable;
        ArrayList<JetExpression> args = new ArrayList<JetExpression>();
        for (ValueArgument valueArgument : expression.getValueArguments()) {
            args.add(valueArgument.getArgumentExpression());
        }
        return intrinsic.generate(this, this.v, this.expressionType(expression), expression, args, receiver);
    }

    private StackValue returnValueAsStackValue(FunctionDescriptor fd, Type callReturnType) {
        if (callReturnType != Type.VOID_TYPE) {
            Type retType = this.typeMapper.mapReturnType(fd.getReturnType());
            StackValue.onStack(callReturnType).upcast(retType, this.v);
            return StackValue.onStack(retType);
        }
        return StackValue.none();
    }

    Callable resolveToCallable(DeclarationDescriptor fd, boolean superCall) {
        CallableMethod callableMethod;
        IntrinsicMethod intrinsic = this.intrinsics.getIntrinsic(fd);
        if (intrinsic != null) {
            return intrinsic;
        }
        if (fd instanceof VariableAsFunctionDescriptor) {
            assert (!superCall);
            callableMethod = ClosureCodegen.asCallableMethod((FunctionDescriptor)fd);
        } else if (fd instanceof ExpressionAsFunctionDescriptor || fd instanceof SimpleFunctionDescriptor && fd.getContainingDeclaration() instanceof FunctionDescriptor) {
            SimpleFunctionDescriptor invoke = CodegenUtil.createInvoke((FunctionDescriptor)fd);
            callableMethod = ClosureCodegen.asCallableMethod(invoke);
        } else if (fd instanceof FunctionDescriptor) {
            callableMethod = this.typeMapper.mapToCallableMethod((FunctionDescriptor)fd, superCall, OwnerKind.IMPLEMENTATION);
        } else {
            throw new UnsupportedOperationException("can't resolve declaration to callable: " + fd);
        }
        return callableMethod;
    }

    public void invokeMethodWithArguments(CallableMethod callableMethod, JetCallElement expression, StackValue receiver) {
        int mask;
        Type calleeType = callableMethod.getGenerateCalleeType();
        if (calleeType != null && expression instanceof JetCallExpression) {
            assert (!callableMethod.isNeedsThis());
            this.gen(expression.getCalleeExpression(), calleeType);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
        assert (resolvedCall != null);
        if (!(resolvedCall.getResultingDescriptor() instanceof ConstructorDescriptor)) {
            receiver = StackValue.receiver(resolvedCall, receiver, this, callableMethod);
            receiver.put(receiver.type, this.v);
            if (calleeType != null) {
                StackValue.onStack(receiver.type).put(JetTypeMapper.boxType(receiver.type), this.v);
            }
        }
        if ((mask = this.pushMethodArguments(expression, callableMethod.getValueParameterTypes())) == 0) {
            callableMethod.invoke(this.v);
        } else {
            callableMethod.invokeWithDefault(this.v, mask);
        }
    }

    private void genThisAndReceiverFromResolvedCall(StackValue receiver, ResolvedCall<? extends CallableDescriptor> resolvedCall, CallableMethod callableMethod) {
        receiver = StackValue.receiver(resolvedCall, receiver, this, callableMethod);
        receiver.put(receiver.type, this.v);
    }

    public void generateFromResolvedCall(ReceiverDescriptor descriptor, Type type) {
        if (descriptor instanceof ClassReceiver) {
            Type exprType = this.asmType(descriptor.getType());
            ClassReceiver classReceiver = (ClassReceiver)descriptor;
            ClassDescriptor classReceiverDeclarationDescriptor = (ClassDescriptor)classReceiver.getDeclarationDescriptor();
            if (CodegenUtil.isClassObject(classReceiverDeclarationDescriptor)) {
                ClassDescriptor containingDeclaration = (ClassDescriptor)classReceiverDeclarationDescriptor.getContainingDeclaration();
                Type classObjType = this.typeMapper.mapType(containingDeclaration.getDefaultType());
                this.v.getstatic(classObjType.getInternalName(), "$classobj", exprType.getDescriptor());
            } else {
                this.generateThisOrOuter(classReceiverDeclarationDescriptor).put(exprType, this.v);
            }
            if (type != null) {
                StackValue.onStack(exprType).put(type, this.v);
            }
        } else if (descriptor instanceof ExtensionReceiver) {
            Type exprType = this.asmType(descriptor.getType());
            ExtensionReceiver extensionReceiver = (ExtensionReceiver)descriptor;
            this.generateReceiver(extensionReceiver.getDeclarationDescriptor()).put(exprType, this.v);
            if (type != null) {
                StackValue.onStack(exprType).put(type, this.v);
            }
        } else if (descriptor instanceof ExpressionReceiver) {
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)descriptor;
            JetExpression expr = expressionReceiver.getExpression();
            Type exprType = this.expressionType(expr);
            this.gen(expr, exprType);
            if (type != null) {
                StackValue.onStack(exprType).put(type, this.v);
            }
        } else if (descriptor instanceof AutoCastReceiver) {
            AutoCastReceiver autoCastReceiver = (AutoCastReceiver)descriptor;
            Type intermediateType = this.asmType(autoCastReceiver.getType());
            this.generateFromResolvedCall(autoCastReceiver.getOriginal(), intermediateType);
            StackValue.onStack(intermediateType).put(type, this.v);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static JetExpression getReceiverForSelector(PsiElement expression) {
        if (expression.getParent() instanceof JetDotQualifiedExpression && !ExpressionCodegen.isReceiver(expression)) {
            JetDotQualifiedExpression parent = (JetDotQualifiedExpression)expression.getParent();
            return parent.getReceiverExpression();
        }
        return null;
    }

    private StackValue generateReceiver(DeclarationDescriptor provided) {
        assert (this.context instanceof CodegenContext.ReceiverContext);
        CodegenContext.ReceiverContext cur = (CodegenContext.ReceiverContext)this.context;
        if (cur.getReceiverDescriptor() == provided) {
            StackValue result = cur.getReceiverExpression(this.typeMapper);
            return this.castToRequiredTypeOfInterfaceIfNeeded(result, provided, null);
        }
        StackValue result = this.context.lookupInContext(provided, this.v, StackValue.local(0, JetTypeMapper.TYPE_OBJECT));
        return this.castToRequiredTypeOfInterfaceIfNeeded(result, provided, null);
    }

    public StackValue generateThisOrOuter(ClassDescriptor calleeContainingClass) {
        CodegenContext cur = this.context;
        PsiElement psiElement = this.bindingContext.get(BindingContext.DESCRIPTOR_TO_DECLARATION, calleeContainingClass);
        boolean isObject = psiElement instanceof JetClassOrObject && CodegenUtil.isNonLiteralObject((JetClassOrObject)psiElement);
        StackValue result = StackValue.local(0, JetTypeMapper.TYPE_OBJECT);
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (cur instanceof CodegenContext.MethodContext && !(cur instanceof CodegenContext.ConstructorContext)) {
                cur = cur.getParentContext();
            }
            if (CodegenUtil.isSubclass(cur.getThisDescriptor(), calleeContainingClass)) {
                Type type = this.asmType(calleeContainingClass.getDefaultType());
                if (!isObject || cur.getThisDescriptor() == calleeContainingClass) {
                    result.put(JetTypeMapper.TYPE_OBJECT, this.v);
                    return this.castToRequiredTypeOfInterfaceIfNeeded(StackValue.onStack(type), cur.getThisDescriptor(), calleeContainingClass);
                }
                this.v.getstatic(type.getInternalName(), "$instance", type.getDescriptor());
            }
            result = cur.getOuterExpression(result);
            if (!(cur instanceof CodegenContext.ConstructorContext)) continue;
            cur = cur.getParentContext();
        }
        throw new UnsupportedOperationException();
    }

    private static boolean isReceiver(PsiElement expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof JetQualifiedExpression) {
            JetExpression receiverExpression = ((JetQualifiedExpression)parent).getReceiverExpression();
            return expression == receiverExpression;
        }
        return false;
    }

    private int pushMethodArguments(@NotNull ResolvedCall resolvedCall, List<Type> valueParameterTypes) {
        List<ResolvedValueArgument> valueArguments = resolvedCall.getValueArgumentsByIndex();
        Object fd = resolvedCall.getResultingDescriptor();
        if (fd.getValueParameters().size() != valueArguments.size()) {
            throw new IllegalStateException();
        }
        int index = 0;
        int mask = 0;
        for (ValueParameterDescriptor valueParameterDescriptor : fd.getValueParameters()) {
            ResolvedValueArgument valueArgument;
            ResolvedValueArgument resolvedValueArgument = valueArguments.get(valueParameterDescriptor.getIndex());
            if (resolvedValueArgument instanceof ExpressionValueArgument) {
                valueArgument = (ExpressionValueArgument)resolvedValueArgument;
                this.gen(((ExpressionValueArgument)valueArgument).getExpression(), valueParameterTypes.get(index));
            } else if (resolvedValueArgument instanceof DefaultValueArgument) {
                Type type = valueParameterTypes.get(index);
                if (type.getSort() == 10 || type.getSort() == 9) {
                    this.v.aconst(null);
                } else if (type.getSort() == 6) {
                    this.v.aconst((Object)Float.valueOf(0.0f));
                } else if (type.getSort() == 8) {
                    this.v.aconst((Object)0.0);
                } else if (type.getSort() == 7) {
                    this.v.aconst((Object)0L);
                } else {
                    this.v.iconst(0);
                }
                mask |= 1 << index;
            } else if (resolvedValueArgument instanceof VarargValueArgument) {
                valueArgument = (VarargValueArgument)resolvedValueArgument;
                JetType outType = valueParameterDescriptor.getType();
                Type type = this.asmType(outType);
                assert (type.getSort() == 9);
                Type elementType = JetTypeMapper.correctElementType(type);
                int size = ((VarargValueArgument)valueArgument).getArgumentExpressions().size();
                this.v.iconst(((VarargValueArgument)valueArgument).getArgumentExpressions().size());
                this.v.newarray(elementType);
                for (int i = 0; i != size; ++i) {
                    this.v.dup();
                    this.v.iconst(i);
                    this.gen(((VarargValueArgument)valueArgument).getArgumentExpressions().get(i), elementType);
                    StackValue.arrayElement(elementType, false).store(this.v);
                }
            } else {
                throw new UnsupportedOperationException();
            }
            ++index;
        }
        return mask;
    }

    public int pushMethodArguments(JetCallElement expression, List<Type> valueParameterTypes) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
        if (resolvedCall != null) {
            return this.pushMethodArguments(resolvedCall, valueParameterTypes);
        }
        List<? extends ValueArgument> args = expression.getValueArguments();
        int argsSize = args.size();
        for (int i = 0; i < argsSize; ++i) {
            ValueArgument arg = args.get(i);
            this.gen(arg.getArgumentExpression(), valueParameterTypes.get(i));
        }
        return 0;
    }

    public Type expressionType(JetExpression expr) {
        JetType type = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expr);
        return type == null ? Type.VOID_TYPE : this.asmType(type);
    }

    public int indexOfLocal(JetReferenceExpression lhs) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, lhs);
        return this.lookupLocal(declarationDescriptor);
    }

    @Override
    public StackValue visitDotQualifiedExpression(JetDotQualifiedExpression expression, StackValue receiver) {
        return this.genQualified(StackValue.none(), expression.getSelectorExpression());
    }

    @Override
    public StackValue visitSafeQualifiedExpression(JetSafeQualifiedExpression expression, StackValue receiver) {
        JetExpression expr = expression.getReceiverExpression();
        JetType receiverJetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression.getReceiverExpression());
        Type receiverType = this.asmType(receiverJetType);
        this.gen(expr, receiverType);
        assert (receiverJetType != null);
        if (!receiverJetType.isNullable()) {
            StackValue propValue = this.genQualified(StackValue.onStack(receiverType), expression.getSelectorExpression());
            Type type = propValue.type;
            propValue.put(type, this.v);
            if (JetTypeMapper.isPrimitive(type) && !type.equals((Object)Type.VOID_TYPE)) {
                StackValue.valueOf(this.v, type);
                type = JetTypeMapper.boxType(type);
            }
            return StackValue.onStack(type);
        }
        Label ifnull = new Label();
        Label end = new Label();
        this.v.dup();
        this.v.ifnull(ifnull);
        StackValue propValue = this.genQualified(StackValue.onStack(receiverType), expression.getSelectorExpression());
        Type type = propValue.type;
        propValue.put(type, this.v);
        if (JetTypeMapper.isPrimitive(type) && !type.equals((Object)Type.VOID_TYPE)) {
            StackValue.valueOf(this.v, type);
            type = JetTypeMapper.boxType(type);
        }
        this.v.goTo(end);
        this.v.mark(ifnull);
        this.v.pop();
        if (!propValue.type.equals((Object)Type.VOID_TYPE)) {
            this.v.aconst(null);
        }
        this.v.mark(end);
        return StackValue.onStack(type);
    }

    @Override
    public StackValue visitPredicateExpression(JetPredicateExpression expression, StackValue receiver) {
        JetExpression expr = expression.getReceiverExpression();
        StackValue value = this.gen(expr);
        Type receiverType = this.expressionType(expr);
        value.put(receiverType, this.v);
        Label ifFalse = new Label();
        Label end = new Label();
        this.v.dup();
        StackValue result = this.genQualified(StackValue.onStack(receiverType), expression.getSelectorExpression());
        result.condJump(ifFalse, true, this.v);
        this.v.goTo(end);
        this.v.mark(ifFalse);
        this.v.pop();
        this.v.aconst(null);
        this.v.mark(end);
        return StackValue.onStack(this.expressionType(expression));
    }

    @Override
    public StackValue visitBinaryExpression(JetBinaryExpression expression, StackValue receiver) {
        IElementType opToken = expression.getOperationReference().getReferencedNameElementType();
        if (opToken == JetTokens.EQ) {
            return this.generateAssignmentExpression(expression);
        }
        if (JetTokens.AUGMENTED_ASSIGNMENTS.contains(opToken)) {
            return this.generateAugmentedAssignment(expression);
        }
        if (opToken == JetTokens.ANDAND) {
            return this.generateBooleanAnd(expression);
        }
        if (opToken == JetTokens.OROR) {
            return this.generateBooleanOr(expression);
        }
        if (opToken == JetTokens.EQEQ || opToken == JetTokens.EXCLEQ || opToken == JetTokens.EQEQEQ || opToken == JetTokens.EXCLEQEQEQ) {
            return this.generateEquals(expression.getLeft(), expression.getRight(), opToken);
        }
        if (opToken == JetTokens.LT || opToken == JetTokens.LTEQ || opToken == JetTokens.GT || opToken == JetTokens.GTEQ) {
            return this.generateCompareOp(expression.getLeft(), expression.getRight(), opToken, this.expressionType(expression.getLeft()));
        }
        if (opToken == JetTokens.ELVIS) {
            return this.generateElvis(expression);
        }
        if (opToken == JetTokens.IN_KEYWORD || opToken == JetTokens.NOT_IN) {
            return this.generateIn(expression);
        }
        DeclarationDescriptor op = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        Callable callable = this.resolveToCallable(op, false);
        if (callable instanceof IntrinsicMethod) {
            IntrinsicMethod intrinsic = (IntrinsicMethod)callable;
            return intrinsic.generate(this, this.v, this.expressionType(expression), (PsiElement)expression, Arrays.asList(expression.getLeft(), expression.getRight()), receiver);
        }
        return this.invokeOperation(expression, (FunctionDescriptor)op, (CallableMethod)callable);
    }

    private StackValue generateIn(JetBinaryExpression expression) {
        JetExpression expr = expression.getLeft();
        if (this.isIntRangeExpr(expression.getRight())) {
            StackValue leftValue = StackValue.expression(Type.INT_TYPE, expression.getLeft(), this);
            JetBinaryExpression rangeExpression = (JetBinaryExpression)expression.getRight();
            boolean inverted = expression.getOperationReference().getReferencedNameElementType() == JetTokens.NOT_IN;
            this.getInIntRange(leftValue, rangeExpression, inverted);
        } else {
            StackValue leftValue = this.gen(expr);
            FunctionDescriptor op = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
            assert (op != null);
            leftValue.put(this.asmType(op.getValueParameters().get(0).getType()), this.v);
            this.genToJVMStack(expression.getRight());
            this.v.swap();
            this.invokeFunctionNoParams(op, Type.BOOLEAN_TYPE, this.v);
        }
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private void getInIntRange(StackValue leftValue, JetBinaryExpression rangeExpression, boolean inverted) {
        this.v.iconst(1);
        leftValue.put(Type.INT_TYPE, this.v);
        this.v.dup2();
        this.gen(rangeExpression.getLeft(), Type.INT_TYPE);
        Label lok = new Label();
        this.v.ificmpge(lok);
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(lok);
        this.v.dupX2();
        this.v.pop();
        this.gen(rangeExpression.getRight(), Type.INT_TYPE);
        Label rok = new Label();
        this.v.ificmple(rok);
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(rok);
        this.v.and(Type.INT_TYPE);
        if (inverted) {
            this.v.iconst(1);
            this.v.xor(Type.INT_TYPE);
        }
    }

    private StackValue generateBooleanAnd(JetBinaryExpression expression) {
        this.gen(expression.getLeft(), Type.BOOLEAN_TYPE);
        Label ifFalse = new Label();
        this.v.ifeq(ifFalse);
        this.gen(expression.getRight(), Type.BOOLEAN_TYPE);
        Label end = new Label();
        this.v.goTo(end);
        this.v.mark(ifFalse);
        this.v.iconst(0);
        this.v.mark(end);
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private StackValue generateBooleanOr(JetBinaryExpression expression) {
        this.gen(expression.getLeft(), Type.BOOLEAN_TYPE);
        Label ifTrue = new Label();
        this.v.ifne(ifTrue);
        this.gen(expression.getRight(), Type.BOOLEAN_TYPE);
        Label end = new Label();
        this.v.goTo(end);
        this.v.mark(ifTrue);
        this.v.iconst(1);
        this.v.mark(end);
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private StackValue generateEquals(JetExpression left, JetExpression right, IElementType opToken) {
        JetType leftJetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, left);
        Type leftType = this.asmType(leftJetType);
        JetType rightJetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, right);
        Type rightType = this.asmType(rightJetType);
        if (leftType == JetTypeMapper.TYPE_NOTHING) {
            return this.genCmpWithNull(right, rightType, opToken);
        }
        if (rightType == JetTypeMapper.TYPE_NOTHING) {
            return this.genCmpWithNull(left, leftType, opToken);
        }
        if (JetTypeMapper.isPrimitive(leftType) != JetTypeMapper.isPrimitive(rightType)) {
            this.gen(left, leftType);
            StackValue.valueOf(this.v, leftType);
            leftType = JetTypeMapper.boxType(leftType);
            this.gen(right, rightType);
            StackValue.valueOf(this.v, rightType);
            rightType = JetTypeMapper.boxType(rightType);
        } else {
            this.gen(left, leftType);
            this.gen(right, rightType);
        }
        if (JetTypeMapper.isPrimitive(leftType)) {
            return this.generateEqualsForExpressionsOnStack(opToken, leftType, rightType, false, false);
        }
        assert (leftJetType != null);
        assert (rightJetType != null);
        return this.generateEqualsForExpressionsOnStack(opToken, leftType, rightType, leftJetType.isNullable(), rightJetType.isNullable());
    }

    private StackValue genCmpWithNull(JetExpression exp, Type expType, IElementType opToken) {
        this.v.iconst(1);
        this.gen(exp, JetTypeMapper.boxType(expType));
        Label ok = new Label();
        if (JetTokens.EQEQ == opToken || JetTokens.EQEQEQ == opToken) {
            this.v.ifnull(ok);
        } else {
            this.v.ifnonnull(ok);
        }
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(ok);
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    public StackValue generateEqualsForExpressionsOnStack(IElementType opToken, Type leftType, Type rightType, boolean leftNullable, boolean rightNullable) {
        if ((ExpressionCodegen.isNumberPrimitive(leftType) || leftType.getSort() == 1) && leftType == rightType) {
            return this.compareExpressionsOnStack(opToken, leftType);
        }
        if (opToken == JetTokens.EQEQEQ || opToken == JetTokens.EXCLEQEQEQ) {
            return StackValue.cmp(opToken, leftType);
        }
        return this.generateNullSafeEquals(opToken, leftNullable, rightNullable);
    }

    private StackValue generateNullSafeEquals(IElementType opToken, boolean leftNullable, boolean rightNullable) {
        if (!leftNullable) {
            this.v.invokevirtual("java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
            if (opToken == JetTokens.EXCLEQ) {
                this.v.iconst(1);
                this.v.xor(Type.INT_TYPE);
            }
        } else if (rightNullable) {
            this.v.dup2();
            Label rightNull = new Label();
            this.v.ifnull(rightNull);
            Label leftNull = new Label();
            this.v.ifnull(leftNull);
            this.v.invokevirtual("java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
            if (opToken == JetTokens.EXCLEQ || opToken == JetTokens.EXCLEQEQEQ) {
                this.v.iconst(1);
                this.v.xor(Type.INT_TYPE);
            }
            Label end = new Label();
            this.v.goTo(end);
            this.v.mark(rightNull);
            Label bothNull = new Label();
            this.v.ifnull(bothNull);
            this.v.mark(leftNull);
            this.v.pop2();
            this.v.iconst(opToken == JetTokens.EXCLEQ || opToken == JetTokens.EXCLEQEQEQ ? 1 : 0);
            this.v.goTo(end);
            this.v.mark(bothNull);
            this.v.pop2();
            this.v.iconst(opToken == JetTokens.EXCLEQ || opToken == JetTokens.EXCLEQEQEQ ? 0 : 1);
            this.v.mark(end);
        } else {
            this.v.dup2();
            this.v.pop();
            Label leftNull = new Label();
            this.v.ifnull(leftNull);
            this.v.invokevirtual("java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
            if (opToken == JetTokens.EXCLEQ || opToken == JetTokens.EXCLEQEQEQ) {
                this.v.iconst(1);
                this.v.xor(Type.INT_TYPE);
            }
            Label end = new Label();
            this.v.goTo(end);
            this.v.mark(leftNull);
            this.v.pop2();
            this.v.iconst(opToken == JetTokens.EXCLEQ ? 1 : 0);
            this.v.mark(end);
        }
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private StackValue generateElvis(JetBinaryExpression expression) {
        Type exprType = this.expressionType(expression);
        JetType type = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression.getLeft());
        assert (type != null);
        Type leftType = this.asmType(type);
        if (type.isNullable()) {
            this.gen(expression.getLeft(), leftType);
            this.v.dup();
            Label end = new Label();
            Label ifNull = new Label();
            this.v.ifnull(ifNull);
            StackValue.onStack(leftType).put(exprType, this.v);
            this.v.goTo(end);
            this.v.mark(ifNull);
            this.v.pop();
            this.gen(expression.getRight(), exprType);
            this.v.mark(end);
        } else {
            this.gen(expression.getLeft(), leftType);
            StackValue.onStack(leftType).put(exprType, this.v);
        }
        return StackValue.onStack(exprType);
    }

    private static boolean isNumberPrimitive(DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof ClassDescriptor)) {
            return false;
        }
        String className = descriptor.getName();
        return className.equals("Int") || className.equals("Long") || className.equals("Short") || className.equals("Byte") || className.equals("Char") || className.equals("Float") || className.equals("Double");
    }

    private static boolean isClass(DeclarationDescriptor descriptor, String name) {
        if (!(descriptor instanceof ClassDescriptor)) {
            return false;
        }
        String className = descriptor.getName();
        return className.equals(name);
    }

    private static boolean isNumberPrimitive(Type type) {
        return JetTypeMapper.isIntPrimitive(type) || type == Type.FLOAT_TYPE || type == Type.DOUBLE_TYPE || type == Type.LONG_TYPE;
    }

    private StackValue generateCompareOp(JetExpression left, JetExpression right, IElementType opToken, Type operandType) {
        this.gen(left, operandType);
        this.gen(right, operandType);
        return this.compareExpressionsOnStack(opToken, operandType);
    }

    private StackValue compareExpressionsOnStack(IElementType opToken, Type operandType) {
        if (operandType.getSort() == 10) {
            this.v.invokeinterface("java/lang/Comparable", "compareTo", "(Ljava/lang/Object;)I");
            this.v.iconst(0);
            operandType = Type.INT_TYPE;
        }
        return StackValue.cmp(opToken, operandType);
    }

    private StackValue generateAssignmentExpression(JetBinaryExpression expression) {
        StackValue stackValue = this.gen(expression.getLeft());
        this.gen(expression.getRight(), stackValue.type);
        stackValue.store(this.v);
        return StackValue.none();
    }

    private StackValue generateAugmentedAssignment(JetBinaryExpression expression) {
        DeclarationDescriptor op = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        Callable callable = this.resolveToCallable(op, false);
        JetExpression lhs = expression.getLeft();
        Type lhsType = this.expressionType(lhs);
        if (this.bindingContext.get(BindingContext.VARIABLE_REASSIGNMENT, expression).booleanValue()) {
            if (callable instanceof IntrinsicMethod) {
                StackValue value = this.gen(lhs);
                value.dupReceiver(this.v);
                value.put(lhsType, this.v);
                IntrinsicMethod intrinsic = (IntrinsicMethod)callable;
                intrinsic.generate(this, this.v, lhsType, (PsiElement)expression, Arrays.asList(expression.getRight()), StackValue.onStack(lhsType));
                value.store(this.v);
            } else {
                this.callAugAssignMethod(expression, (CallableMethod)callable, lhsType, true);
            }
        } else {
            assert (op != null);
            boolean keepReturnValue = !((Object)((FunctionDescriptor)op).getReturnType()).equals(JetStandardClasses.getUnitType());
            this.callAugAssignMethod(expression, (CallableMethod)callable, lhsType, keepReturnValue);
        }
        return StackValue.none();
    }

    private void callAugAssignMethod(JetBinaryExpression expression, CallableMethod callable, Type lhsType, boolean keepReturnValue) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getOperationReference());
        assert (resolvedCall != null);
        StackValue value = this.gen(expression.getLeft());
        if (keepReturnValue) {
            value.dupReceiver(this.v);
        }
        value.put(lhsType, this.v);
        StackValue receiver = StackValue.onStack(lhsType);
        if (!(resolvedCall.getResultingDescriptor() instanceof ConstructorDescriptor)) {
            receiver = StackValue.receiver(resolvedCall, receiver, this, callable);
            receiver.put(receiver.type, this.v);
        }
        this.pushMethodArguments(resolvedCall, callable.getValueParameterTypes());
        callable.invoke(this.v);
        if (keepReturnValue) {
            value.store(this.v);
        }
    }

    public void generateStringBuilderConstructor() {
        Type type = JetTypeMapper.JL_STRING_BUILDER;
        this.v.anew(type);
        this.v.dup();
        Method method = new Method("<init>", Type.VOID_TYPE, new Type[0]);
        this.v.invokespecial("java/lang/StringBuilder", method.getName(), method.getDescriptor());
    }

    public void invokeAppend(JetExpression expr) {
        JetBinaryExpression binaryExpression;
        if (expr instanceof JetBinaryExpression && (binaryExpression = (JetBinaryExpression)expr).getOperationToken() == JetTokens.PLUS) {
            JetExpression left = binaryExpression.getLeft();
            JetExpression right = binaryExpression.getRight();
            Type leftType = this.expressionType(left);
            Type rightType = this.expressionType(right);
            if (leftType.equals((Object)JetTypeMapper.JL_STRING_TYPE) && rightType.equals((Object)JetTypeMapper.JL_STRING_TYPE)) {
                this.invokeAppend(left);
                this.invokeAppend(right);
                return;
            }
        }
        Type exprType = this.expressionType(expr);
        this.gen(expr, exprType);
        this.invokeAppendMethod(exprType.getSort() == 9 ? JetTypeMapper.TYPE_OBJECT : exprType);
    }

    public void invokeAppendMethod(Type exprType) {
        Method appendDescriptor = new Method("append", JetTypeMapper.JL_STRING_BUILDER, new Type[]{exprType.getSort() == 10 ? JetTypeMapper.TYPE_OBJECT : exprType});
        this.v.invokevirtual("java/lang/StringBuilder", "append", appendDescriptor.getDescriptor());
    }

    private JetSimpleNameExpression targetLabel(JetExpression expression) {
        JetPrefixExpression parent;
        JetSimpleNameExpression operationSign;
        if (expression.getParent() instanceof JetPrefixExpression && JetTokens.LABELS.contains((operationSign = (parent = (JetPrefixExpression)expression.getParent()).getOperationReference()).getReferencedNameElementType())) {
            return operationSign;
        }
        return null;
    }

    @Override
    public StackValue visitPrefixExpression(JetPrefixExpression expression, StackValue receiver) {
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        if (JetTokens.LABELS.contains(operationSign.getReferencedNameElementType())) {
            return this.genQualified(receiver, expression.getBaseExpression());
        }
        DeclarationDescriptor op = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        Callable callable = this.resolveToCallable(op, false);
        if (callable instanceof IntrinsicMethod) {
            IntrinsicMethod intrinsic = (IntrinsicMethod)callable;
            return intrinsic.generate(this, this.v, this.expressionType(expression), (PsiElement)expression, Arrays.asList(expression.getBaseExpression()), receiver);
        }
        DeclarationDescriptor cls = op.getContainingDeclaration();
        if (ExpressionCodegen.isNumberPrimitive(cls) || !op.getName().equals("inc") && !op.getName().equals("dec")) {
            return this.invokeOperation(expression, (FunctionDescriptor)op, (CallableMethod)callable);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getOperationReference());
        assert (resolvedCall != null);
        StackValue value = this.gen(expression.getBaseExpression());
        value.dupReceiver(this.v);
        value.dupReceiver(this.v);
        Type type = this.expressionType(expression.getBaseExpression());
        value.put(type, this.v);
        ((CallableMethod)callable).invoke(this.v);
        value.store(this.v);
        value.put(type, this.v);
        return StackValue.onStack(type);
    }

    private StackValue invokeOperation(JetOperationExpression expression, FunctionDescriptor op, CallableMethod callable) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getOperationReference());
        assert (resolvedCall != null);
        this.genThisAndReceiverFromResolvedCall(StackValue.none(), resolvedCall, callable);
        this.pushMethodArguments(resolvedCall, callable.getValueParameterTypes());
        callable.invoke(this.v);
        return this.returnValueAsStackValue(op, callable.getSignature().getAsmMethod().getReturnType());
    }

    @Override
    public StackValue visitPostfixExpression(JetPostfixExpression expression, StackValue receiver) {
        DeclarationDescriptor op = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        if (op instanceof FunctionDescriptor) {
            Type asmType = this.expressionType(expression);
            DeclarationDescriptor cls = op.getContainingDeclaration();
            if (op.getName().equals("inc") || op.getName().equals("dec")) {
                if (ExpressionCodegen.isNumberPrimitive(cls)) {
                    int index;
                    receiver.put(receiver.type, this.v);
                    JetExpression operand = expression.getBaseExpression();
                    if (operand instanceof JetReferenceExpression && (index = this.indexOfLocal((JetReferenceExpression)operand)) >= 0 && JetTypeMapper.isIntPrimitive(asmType)) {
                        int increment = op.getName().equals("inc") ? 1 : -1;
                        return StackValue.postIncrement(index, increment);
                    }
                    this.gen(operand, asmType);
                    this.generateIncrement(op, asmType, operand, receiver);
                    return StackValue.onStack(asmType);
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getOperationReference());
                assert (resolvedCall != null);
                Callable callable = this.resolveToCallable(op, false);
                StackValue value = this.gen(expression.getBaseExpression());
                value.dupReceiver(this.v);
                Type type = this.expressionType(expression.getBaseExpression());
                value.put(type, this.v);
                switch (value.receiverSize()) {
                    case 0: {
                        if (type.getSize() == 2) {
                            this.v.dup2();
                            break;
                        }
                        this.v.dup();
                        break;
                    }
                    case 1: {
                        if (type.getSize() == 2) {
                            this.v.dup2X1();
                            break;
                        }
                        this.v.dupX1();
                        break;
                    }
                    case 2: {
                        if (type.getSize() == 2) {
                            this.v.dup2X2();
                            break;
                        }
                        this.v.dupX2();
                        break;
                    }
                    case -1: {
                        throw new UnsupportedOperationException();
                    }
                }
                CallableMethod callableMethod = (CallableMethod)callable;
                callableMethod.invoke(this.v);
                StackValue.onStack(callableMethod.getSignature().getAsmMethod().getReturnType()).put(value.type, this.v);
                value.store(this.v);
                return StackValue.onStack(type);
            }
        }
        throw new UnsupportedOperationException("Don't know how to generate this prefix expression");
    }

    private void generateIncrement(DeclarationDescriptor op, Type asmType, JetExpression operand, StackValue receiver) {
        int index;
        int increment;
        int n = increment = op.getName().equals("inc") ? 1 : -1;
        if (operand instanceof JetReferenceExpression && (index = this.indexOfLocal((JetReferenceExpression)operand)) >= 0 && JetTypeMapper.isIntPrimitive(asmType)) {
            this.v.iinc(index, increment);
            return;
        }
        StackValue value = this.genQualified(receiver, operand);
        value.dupReceiver(this.v);
        value.put(asmType, this.v);
        if (asmType == Type.LONG_TYPE) {
            this.v.lconst((long)increment);
        } else if (asmType == Type.FLOAT_TYPE) {
            this.v.fconst((float)increment);
        } else if (asmType == Type.DOUBLE_TYPE) {
            this.v.dconst((double)increment);
        } else {
            this.v.iconst(increment);
        }
        this.v.add(asmType);
        value.store(this.v);
    }

    @Override
    public StackValue visitProperty(JetProperty property, StackValue receiver) {
        JetExpression initializer;
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property);
        int index = this.lookupLocal(variableDescriptor);
        assert (index >= 0);
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        assert (variableDescriptor != null);
        Type varType = this.asmType(variableDescriptor.getType());
        if (sharedVarType != null) {
            this.v.anew(sharedVarType);
            this.v.dup();
            this.v.invokespecial(sharedVarType.getInternalName(), "<init>", "()V");
            this.v.store(index, JetTypeMapper.TYPE_OBJECT);
        }
        if ((initializer = property.getInitializer()) != null) {
            if (sharedVarType == null) {
                this.gen(initializer, varType);
                this.v.store(index, varType);
            } else {
                this.v.load(index, JetTypeMapper.TYPE_OBJECT);
                this.gen(initializer, varType);
                this.v.putfield(sharedVarType.getInternalName(), "ref", sharedVarType == JetTypeMapper.TYPE_SHARED_VAR ? "Ljava/lang/Object;" : varType.getDescriptor());
            }
        }
        return StackValue.none();
    }

    private StackValue generateConstructorCall(JetCallExpression expression, JetSimpleNameExpression constructorReference, StackValue receiver) {
        Type type;
        DeclarationDescriptor constructorDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, constructorReference);
        PsiElement declaration = this.bindingContext.get(BindingContext.DESCRIPTOR_TO_DECLARATION, constructorDescriptor);
        if (declaration instanceof PsiMethod) {
            type = this.generateJavaConstructorCall(expression);
        } else if (constructorDescriptor instanceof ConstructorDescriptor) {
            JetType expressionType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression);
            assert (expressionType != null);
            type = this.typeMapper.mapType(expressionType, OwnerKind.IMPLEMENTATION);
            if (type.getSort() == 9) {
                this.generateNewArray(expression, expressionType);
            } else {
                ClassDescriptor classDecl = (ClassDescriptor)constructorDescriptor.getContainingDeclaration();
                this.v.anew(type);
                this.v.dup();
                if (!receiver.type.equals((Object)Type.VOID_TYPE)) {
                    receiver.put(receiver.type, this.v);
                }
                CallableMethod method = this.typeMapper.mapToCallableMethod((ConstructorDescriptor)constructorDescriptor, OwnerKind.IMPLEMENTATION, this.typeMapper.hasThis0(((ConstructorDescriptor)constructorDescriptor).getContainingDeclaration()));
                this.invokeMethodWithArguments(method, expression, StackValue.none());
            }
        } else {
            throw new UnsupportedOperationException("don't know how to generate this new expression");
        }
        return StackValue.onStack(type);
    }

    private Type generateJavaConstructorCall(JetCallExpression expression) {
        JetExpression callee = expression.getCalleeExpression();
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, callee);
        if (resolvedCall == null) {
            assert (callee != null);
            throw new CompilationException("Cannot resolve: " + callee.getText(), null, expression);
        }
        FunctionDescriptor descriptor = (FunctionDescriptor)resolvedCall.getResultingDescriptor();
        ClassDescriptor javaClass = (ClassDescriptor)descriptor.getContainingDeclaration();
        Type type = this.asmType(javaClass.getDefaultType());
        this.v.anew(type);
        this.v.dup();
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(descriptor, false, OwnerKind.IMPLEMENTATION);
        this.invokeMethodWithArguments(callableMethod, expression, StackValue.none());
        return type;
    }

    public void generateNewArray(JetCallExpression expression, JetType arrayType) {
        ArrayList<JetExpression> args = new ArrayList<JetExpression>();
        for (ValueArgument valueArgument : expression.getValueArguments()) {
            args.add(valueArgument.getArgumentExpression());
        }
        args.addAll(expression.getFunctionLiteralArguments());
        boolean isArray = this.state.getStandardLibrary().getArray().equals(arrayType.getConstructor().getDeclarationDescriptor());
        if (!isArray && args.size() != 1) {
            throw new CompilationException("primitive array constructor requires one argument", null, expression);
        }
        if (isArray) {
            this.gen((JetElement)((Object)args.get(0)), Type.INT_TYPE);
            this.v.newarray(JetTypeMapper.boxType(this.asmType(arrayType.getArguments().get(0).getType())));
        } else {
            Type type = this.typeMapper.mapType(arrayType, OwnerKind.IMPLEMENTATION);
            this.gen((JetElement)((Object)args.get(0)), Type.INT_TYPE);
            this.v.newarray(JetTypeMapper.correctElementType(type));
        }
        if (args.size() == 2) {
            int n = this.myFrameMap.enterTemp(2);
            int indexIndex = n + 1;
            this.v.dup();
            this.v.arraylength();
            this.v.store(n, Type.INT_TYPE);
            this.v.iconst(0);
            this.v.store(indexIndex, Type.INT_TYPE);
            this.gen((JetElement)((Object)args.get(1)), JetTypeMapper.TYPE_FUNCTION1);
            Label begin = new Label();
            Label end = new Label();
            this.v.visitLabel(begin);
            this.v.load(indexIndex, Type.INT_TYPE);
            this.v.load(n, Type.INT_TYPE);
            this.v.ificmpge(end);
            this.v.dup2();
            this.v.load(indexIndex, Type.INT_TYPE);
            this.v.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            this.v.invokevirtual("jet/Function1", "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
            this.v.load(indexIndex, Type.INT_TYPE);
            this.v.iinc(indexIndex, 1);
            this.v.swap();
            this.v.astore(JetTypeMapper.TYPE_OBJECT);
            this.v.goTo(begin);
            this.v.visitLabel(end);
            this.v.pop();
            this.myFrameMap.leaveTemp(2);
        }
    }

    @Override
    public StackValue visitArrayAccessExpression(JetArrayAccessExpression expression, StackValue receiver) {
        Type asmType;
        Callable callable;
        JetExpression array = expression.getArrayExpression();
        JetType type = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, array);
        Type arrayType = type == null ? Type.VOID_TYPE : this.asmType(type);
        List<JetExpression> indices = expression.getIndexExpressions();
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        assert (operationDescriptor != null);
        if (arrayType.getSort() == 9 && indices.size() == 1 && ((Object)operationDescriptor.getValueParameters().get(0).getType()).equals(this.state.getStandardLibrary().getIntType())) {
            this.gen(array, arrayType);
            for (JetExpression index : indices) {
                this.gen(index, Type.INT_TYPE);
            }
            assert (type != null);
            if (this.state.getStandardLibrary().getArray().equals(type.getConstructor().getDeclarationDescriptor())) {
                JetType elementType = type.getArguments().get(0).getType();
                Type notBoxed = this.asmType(elementType);
                return StackValue.arrayElement(notBoxed, true);
            }
            return StackValue.arrayElement(JetTypeMapper.correctElementType(arrayType), false);
        }
        CallableMethod accessor = this.typeMapper.mapToCallableMethod(operationDescriptor, false, OwnerKind.IMPLEMENTATION);
        boolean isGetter = accessor.getSignature().getAsmMethod().getName().equals("get");
        ResolvedCall<FunctionDescriptor> resolvedSetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression);
        ResolvedCall<FunctionDescriptor> resolvedGetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression);
        FunctionDescriptor setterDescriptor = resolvedSetCall == null ? null : resolvedSetCall.getResultingDescriptor();
        FunctionDescriptor getterDescriptor = resolvedGetCall == null ? null : resolvedGetCall.getResultingDescriptor();
        Type[] argumentTypes = accessor.getSignature().getAsmMethod().getArgumentTypes();
        int index = 0;
        if (isGetter) {
            callable = this.resolveToCallable(getterDescriptor, false);
            if (callable instanceof CallableMethod) {
                this.genThisAndReceiverFromResolvedCall(receiver, resolvedGetCall, (CallableMethod)callable);
            } else {
                assert (getterDescriptor != null);
                this.gen(array, this.asmType(((ClassDescriptor)getterDescriptor.getContainingDeclaration()).getDefaultType()));
            }
            assert (getterDescriptor != null);
            if (getterDescriptor.getReceiverParameter().exists()) {
                ++index;
            }
            asmType = accessor.getSignature().getAsmMethod().getReturnType();
        } else {
            assert (resolvedSetCall != null);
            callable = this.resolveToCallable(resolvedSetCall.getResultingDescriptor(), false);
            if (callable instanceof CallableMethod) {
                this.genThisAndReceiverFromResolvedCall(receiver, resolvedSetCall, (CallableMethod)callable);
            } else {
                this.gen(array, arrayType);
            }
            if (setterDescriptor.getReceiverParameter().exists()) {
                ++index;
            }
            asmType = argumentTypes[argumentTypes.length - 1];
        }
        for (JetExpression jetExpression : expression.getIndexExpressions()) {
            this.gen(jetExpression, argumentTypes[index]);
            ++index;
        }
        return StackValue.collectionElement(asmType, resolvedGetCall, resolvedSetCall, this);
    }

    @Override
    public StackValue visitThrowExpression(JetThrowExpression expression, StackValue receiver) {
        this.gen(expression.getThrownExpression(), JetTypeMapper.TYPE_THROWABLE);
        this.doFinallyOnReturnOrThrow();
        this.v.athrow();
        return StackValue.none();
    }

    @Override
    public StackValue visitThisExpression(JetThisExpression expression, StackValue receiver) {
        DeclarationDescriptor descriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        if (descriptor instanceof ClassDescriptor) {
            return this.generateThisOrOuter((ClassDescriptor)descriptor);
        }
        if (descriptor instanceof FunctionDescriptor || descriptor instanceof PropertyDescriptor) {
            return this.generateReceiver(descriptor);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public StackValue visitTryExpression(JetTryExpression expression, StackValue receiver) {
        Label savedContinueLabel = this.continueLabel;
        this.continueLabel = null;
        JetFinallySection finallyBlock = expression.getFinallyBlock();
        if (finallyBlock != null) {
            this.blockStackElements.push(new FinallyBlockStackElement(expression));
        }
        JetType jetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression);
        Type expectedAsmType = this.asmType(jetType);
        Label tryStart = new Label();
        this.v.mark(tryStart);
        this.v.nop();
        if (finallyBlock == null) {
            this.gen(expression.getTryBlock(), expectedAsmType);
        } else {
            this.gen(expression.getTryBlock(), Type.VOID_TYPE);
        }
        Label tryEnd = new Label();
        this.v.mark(tryEnd);
        if (finallyBlock != null) {
            this.gen(finallyBlock.getFinalExpression(), expectedAsmType);
        }
        Label end = new Label();
        this.v.goTo(end);
        for (JetCatchClause clause : expression.getCatchClauses()) {
            Label clauseStart = new Label();
            this.v.mark(clauseStart);
            VariableDescriptor descriptor = this.bindingContext.get(BindingContext.VALUE_PARAMETER, clause.getCatchParameter());
            assert (descriptor != null);
            Type descriptorType = this.asmType(descriptor.getType());
            this.myFrameMap.enter(descriptor, 1);
            int index = this.lookupLocal(descriptor);
            this.v.store(index, descriptorType);
            this.gen(clause.getCatchBody(), finallyBlock != null ? Type.VOID_TYPE : expectedAsmType);
            this.myFrameMap.leave(descriptor);
            if (finallyBlock != null) {
                this.gen(finallyBlock.getFinalExpression(), expectedAsmType);
            }
            this.v.goTo(end);
            this.v.visitTryCatchBlock(tryStart, tryEnd, clauseStart, descriptorType.getInternalName());
        }
        if (finallyBlock != null) {
            Label finallyStart = new Label();
            this.v.mark(finallyStart);
            this.gen(finallyBlock.getFinalExpression(), Type.VOID_TYPE);
            this.v.athrow();
            this.v.visitTryCatchBlock(tryStart, tryEnd, finallyStart, null);
        }
        this.v.mark(end);
        this.v.nop();
        if (finallyBlock != null) {
            this.blockStackElements.pop();
        }
        this.continueLabel = savedContinueLabel;
        return StackValue.onStack(expectedAsmType);
    }

    @Override
    public StackValue visitBinaryWithTypeRHSExpression(JetBinaryExpressionWithTypeRHS expression, StackValue receiver) {
        JetSimpleNameExpression operationSign = expression.getOperationSign();
        IElementType opToken = operationSign.getReferencedNameElementType();
        if (opToken == JetTokens.COLON) {
            return this.gen(expression.getLeft());
        }
        JetTypeReference typeReference = expression.getRight();
        JetType jetType = this.bindingContext.get(BindingContext.TYPE, typeReference);
        assert (jetType != null);
        ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
        if (descriptor instanceof ClassDescriptor || descriptor instanceof TypeParameterDescriptor) {
            Type type = JetTypeMapper.boxType(this.asmType(jetType));
            this.generateInstanceOf(StackValue.expression(JetTypeMapper.TYPE_OBJECT, expression.getLeft(), this), jetType, true);
            Label isInstance = new Label();
            this.v.ifne(isInstance);
            this.v.pop();
            if (opToken == JetTokens.AS_SAFE) {
                this.v.aconst(null);
            } else {
                this.throwNewException(CLASS_TYPE_CAST_EXCEPTION);
            }
            this.v.mark(isInstance);
            this.v.checkcast(type);
            return StackValue.onStack(type);
        }
        throw new UnsupportedOperationException("don't know how to handle non-class types in as/as?");
    }

    @Override
    public StackValue visitIsExpression(JetIsExpression expression, StackValue receiver) {
        StackValue match = StackValue.expression(JetTypeMapper.TYPE_OBJECT, expression.getLeftHandSide(), this);
        return this.generatePatternMatch(expression.getPattern(), expression.isNegated(), match, null);
    }

    private StackValue generatePatternMatch(JetPattern pattern, boolean negated, StackValue expressionToMatch, @Nullable Label nextEntry) {
        if (pattern instanceof JetTypePattern) {
            JetTypeReference typeReference = ((JetTypePattern)pattern).getTypeReference();
            JetType jetType = this.bindingContext.get(BindingContext.TYPE, typeReference);
            expressionToMatch.dupReceiver(this.v);
            this.generateInstanceOf(expressionToMatch, jetType, false);
            StackValue value = StackValue.onStack(Type.BOOLEAN_TYPE);
            return negated ? StackValue.not(value) : value;
        }
        if (pattern instanceof JetTuplePattern) {
            return this.generateTuplePatternMatch((JetTuplePattern)pattern, negated, expressionToMatch, nextEntry);
        }
        if (pattern instanceof JetExpressionPattern) {
            if (expressionToMatch != null) {
                Type subjectType = expressionToMatch.type;
                expressionToMatch.dupReceiver(this.v);
                expressionToMatch.put(subjectType, this.v);
                JetExpression condExpression = ((JetExpressionPattern)pattern).getExpression();
                Type condType = ExpressionCodegen.isNumberPrimitive(subjectType) ? this.expressionType(condExpression) : JetTypeMapper.TYPE_OBJECT;
                this.gen(condExpression, condType);
                return this.generateEqualsForExpressionsOnStack(JetTokens.EQEQ, subjectType, condType, false, false);
            }
            JetExpression condExpression = ((JetExpressionPattern)pattern).getExpression();
            return this.gen(condExpression);
        }
        if (pattern instanceof JetWildcardPattern) {
            return StackValue.constant(!negated, Type.BOOLEAN_TYPE);
        }
        if (pattern instanceof JetBindingPattern) {
            JetProperty var = ((JetBindingPattern)pattern).getVariableDeclaration();
            VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, var);
            assert (variableDescriptor != null);
            Type varType = this.asmType(variableDescriptor.getType());
            this.myFrameMap.enter(variableDescriptor, varType.getSize());
            expressionToMatch.dupReceiver(this.v);
            expressionToMatch.put(varType, this.v);
            int varIndex = this.myFrameMap.getIndex(variableDescriptor);
            this.v.store(varIndex, varType);
            return this.generateWhenCondition(varType, varIndex, ((JetBindingPattern)pattern).getCondition(), null);
        }
        throw new UnsupportedOperationException("Unsupported pattern type: " + (Object)((Object)pattern));
    }

    private StackValue generateTuplePatternMatch(JetTuplePattern pattern, boolean negated, StackValue expressionToMatch, @Nullable Label nextEntry) {
        List<JetTuplePatternEntry> entries = pattern.getEntries();
        Label lblFail = new Label();
        Label lblDone = new Label();
        expressionToMatch.dupReceiver(this.v);
        expressionToMatch.put(JetTypeMapper.TYPE_OBJECT, this.v);
        this.v.dup();
        String tupleClassName = "jet/Tuple" + entries.size();
        Type tupleType = Type.getObjectType((String)tupleClassName);
        this.v.instanceOf(tupleType);
        Label lblCheck = new Label();
        this.v.ifne(lblCheck);
        Label lblPopAndFail = new Label();
        this.v.mark(lblPopAndFail);
        this.v.pop();
        this.v.goTo(lblFail);
        this.v.mark(lblCheck);
        for (int i = 0; i < entries.size(); ++i) {
            StackValue tupleField = StackValue.field(JetTypeMapper.TYPE_OBJECT, tupleClassName, "_" + (i + 1), false);
            StackValue stackValue = this.generatePatternMatch(entries.get(i).getPattern(), false, tupleField, nextEntry);
            stackValue.condJump(lblPopAndFail, true, this.v);
        }
        this.v.pop();
        if (negated && nextEntry != null) {
            this.v.goTo(nextEntry);
        } else {
            this.v.iconst(!negated ? 1 : 0);
        }
        this.v.goTo(lblDone);
        this.v.mark(lblFail);
        if (!negated && nextEntry != null) {
            this.v.goTo(nextEntry);
        } else {
            this.v.iconst(negated ? 1 : 0);
        }
        this.v.mark(lblDone);
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private void generateInstanceOf(StackValue expressionToGen, JetType jetType, boolean leaveExpressionOnStack) {
        expressionToGen.put(JetTypeMapper.TYPE_OBJECT, this.v);
        if (leaveExpressionOnStack) {
            this.v.dup();
        }
        Type type = JetTypeMapper.boxType(this.asmType(jetType));
        if (jetType.isNullable()) {
            Label nope = new Label();
            Label end = new Label();
            this.v.dup();
            this.v.ifnull(nope);
            this.v.instanceOf(type);
            this.v.goTo(end);
            this.v.mark(nope);
            this.v.pop();
            this.v.iconst(1);
            this.v.mark(end);
        } else {
            this.v.instanceOf(type);
        }
    }

    @Override
    public StackValue visitWhenExpression(JetWhenExpression expression, StackValue receiver) {
        int subjectLocal;
        JetExpression expr = expression.getSubjectExpression();
        Type subjectType = this.expressionType(expr);
        Type resultType = this.expressionType(expression);
        int n = subjectLocal = expr != null ? this.myFrameMap.enterTemp(subjectType.getSize()) : -1;
        if (subjectLocal != -1) {
            this.gen(expr, subjectType);
            this.v.store(subjectLocal, subjectType);
        }
        Label end = new Label();
        boolean hasElse = false;
        for (JetWhenEntry whenEntry : expression.getEntries()) {
            if (!whenEntry.isElse()) continue;
            hasElse = true;
            break;
        }
        Label nextCondition = null;
        for (JetWhenEntry whenEntry : expression.getEntries()) {
            if (nextCondition != null) {
                this.v.mark(nextCondition);
            }
            nextCondition = new Label();
            FrameMap.Mark mark = this.myFrameMap.mark();
            Label thisEntry = new Label();
            if (!whenEntry.isElse()) {
                JetWhenCondition[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    StackValue conditionValue = this.generateWhenCondition(subjectType, subjectLocal, conditions[i], nextCondition);
                    conditionValue.condJump(nextCondition, true, this.v);
                    if (i >= conditions.length - 1) continue;
                    this.v.goTo(thisEntry);
                    this.v.mark(nextCondition);
                    nextCondition = new Label();
                }
            }
            this.v.visitLabel(thisEntry);
            this.gen(whenEntry.getExpression(), resultType);
            mark.dropTo();
            if (whenEntry.isElse()) continue;
            this.v.goTo(end);
        }
        if (!hasElse && nextCondition != null) {
            this.v.mark(nextCondition);
            this.throwNewException(CLASS_NO_PATTERN_MATCHED_EXCEPTION);
        }
        this.v.mark(end);
        this.myFrameMap.leaveTemp(subjectType.getSize());
        return StackValue.onStack(resultType);
    }

    private StackValue generateWhenCondition(Type subjectType, int subjectLocal, JetWhenCondition condition, @Nullable Label nextEntry) {
        boolean isNegated;
        JetPattern pattern;
        if (condition instanceof JetWhenConditionInRange) {
            JetWhenConditionInRange conditionInRange = (JetWhenConditionInRange)condition;
            JetExpression rangeExpression = conditionInRange.getRangeExpression();
            if (this.isIntRangeExpr(rangeExpression)) {
                this.getInIntRange(new StackValue.Local(subjectLocal, subjectType), (JetBinaryExpression)rangeExpression, conditionInRange.getOperationReference().getReferencedNameElementType() == JetTokens.NOT_IN);
            } else {
                FunctionDescriptor op = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, conditionInRange.getOperationReference());
                this.genToJVMStack(rangeExpression);
                new StackValue.Local(subjectLocal, subjectType).put(JetTypeMapper.TYPE_OBJECT, this.v);
                this.invokeFunctionNoParams(op, Type.BOOLEAN_TYPE, this.v);
            }
            return StackValue.onStack(Type.BOOLEAN_TYPE);
        }
        if (condition instanceof JetWhenConditionIsPattern) {
            JetWhenConditionIsPattern patternCondition = (JetWhenConditionIsPattern)condition;
            pattern = patternCondition.getPattern();
            isNegated = patternCondition.isNegated();
        } else if (condition instanceof JetWhenConditionWithExpression) {
            pattern = ((JetWhenConditionWithExpression)condition).getPattern();
            isNegated = false;
        } else {
            throw new UnsupportedOperationException("unsupported kind of when condition");
        }
        return this.generatePatternMatch(pattern, isNegated, subjectLocal == -1 ? null : StackValue.local(subjectLocal, subjectType), nextEntry);
    }

    private boolean isIntRangeExpr(JetExpression rangeExpression) {
        JetBinaryExpression binaryExpression;
        if (rangeExpression instanceof JetBinaryExpression && (binaryExpression = (JetBinaryExpression)rangeExpression).getOperationReference().getReferencedNameElementType() == JetTokens.RANGE) {
            JetType jetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, rangeExpression);
            assert (jetType != null);
            ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
            if (ExpressionCodegen.isClass(descriptor, "IntRange") || ExpressionCodegen.isClass(descriptor, "CharRange") || ExpressionCodegen.isClass(descriptor, "ByteRange") || ExpressionCodegen.isClass(descriptor, "LongRange") || ExpressionCodegen.isClass(descriptor, "ShortRange")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public StackValue visitTupleExpression(JetTupleExpression expression, StackValue receiver) {
        List<JetExpression> entries = expression.getEntries();
        if (entries.size() > 22) {
            throw new UnsupportedOperationException("tuple too large");
        }
        if (entries.size() == 0) {
            this.v.visitFieldInsn(178, "jet/Tuple0", "INSTANCE", "Ljet/Tuple0;");
            return StackValue.onStack(Type.getObjectType((String)"jet/Tuple0"));
        }
        String className = "jet/Tuple" + entries.size();
        Type tupleType = Type.getObjectType((String)className);
        StringBuilder signature = new StringBuilder("(");
        for (int i = 0; i != entries.size(); ++i) {
            signature.append("Ljava/lang/Object;");
        }
        signature.append(")V");
        this.v.anew(tupleType);
        this.v.dup();
        for (JetExpression entry : entries) {
            this.gen(entry, JetTypeMapper.TYPE_OBJECT);
        }
        this.v.invokespecial(className, "<init>", signature.toString());
        return StackValue.onStack(tupleType);
    }

    private void throwNewException(String className) {
        this.v.anew(Type.getObjectType((String)className));
        this.v.dup();
        this.v.invokespecial(className, "<init>", "()V");
        this.v.athrow();
    }

    public String toString() {
        return this.context.getContextDescriptor().toString();
    }

    private class ForInRangeLoopGenerator
    extends ForLoopGenerator {
        private int myCountVar;
        private int myDeltaVar;
        private int myIndexVar;

        public ForInRangeLoopGenerator(JetForExpression expression, Type loopRangeType) {
            super(expression, loopRangeType);
        }

        @Override
        protected void generatePrologue() {
            this.myIndexVar = ExpressionCodegen.this.lookupLocal(this.parameterDescriptor);
            this.myCountVar = ExpressionCodegen.this.myFrameMap.enterTemp();
            this.myDeltaVar = ExpressionCodegen.this.myFrameMap.enterTemp();
            if (ExpressionCodegen.this.isIntRangeExpr(this.expression.getLoopRange())) {
                JetBinaryExpression rangeExpression = (JetBinaryExpression)this.expression.getLoopRange();
                ExpressionCodegen.this.gen(rangeExpression.getLeft(), Type.INT_TYPE);
                ExpressionCodegen.this.v.store(this.myIndexVar, Type.INT_TYPE);
                ExpressionCodegen.this.gen(rangeExpression.getRight(), Type.INT_TYPE);
                ExpressionCodegen.this.v.store(this.myCountVar, Type.INT_TYPE);
                ExpressionCodegen.this.v.load(this.myCountVar, Type.INT_TYPE);
                ExpressionCodegen.this.v.load(this.myIndexVar, Type.INT_TYPE);
                ExpressionCodegen.this.v.sub(Type.INT_TYPE);
                ExpressionCodegen.this.v.iconst(1);
                ExpressionCodegen.this.v.add(Type.INT_TYPE);
                ExpressionCodegen.this.v.store(this.myCountVar, Type.INT_TYPE);
                ExpressionCodegen.this.v.load(this.myCountVar, Type.INT_TYPE);
                ExpressionCodegen.this.v.iflt(this.end);
                ExpressionCodegen.this.v.iconst(1);
                ExpressionCodegen.this.v.store(this.myDeltaVar, Type.INT_TYPE);
            } else {
                ExpressionCodegen.this.gen(this.expression.getLoopRange(), this.loopRangeType);
                ExpressionCodegen.this.v.dup();
                ExpressionCodegen.this.v.dup();
                ExpressionCodegen.this.v.invokevirtual("jet/IntRange", "getStart", "()I");
                ExpressionCodegen.this.v.store(this.myIndexVar, Type.INT_TYPE);
                ExpressionCodegen.this.v.invokevirtual("jet/IntRange", "getSize", "()I");
                ExpressionCodegen.this.v.store(this.myCountVar, Type.INT_TYPE);
                ExpressionCodegen.this.v.invokevirtual("jet/IntRange", "getIsReversed", "()Z");
                Label down = new Label();
                ExpressionCodegen.this.v.ifne(down);
                ExpressionCodegen.this.v.iconst(1);
                Label initEnd = new Label();
                ExpressionCodegen.this.v.goTo(initEnd);
                ExpressionCodegen.this.v.mark(down);
                ExpressionCodegen.this.v.iconst(-1);
                ExpressionCodegen.this.v.mark(initEnd);
                ExpressionCodegen.this.v.store(this.myDeltaVar, Type.INT_TYPE);
            }
        }

        @Override
        protected void generateCondition(Type asmParamType, Label end) {
            ExpressionCodegen.this.v.load(this.myCountVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.ifeq(end);
        }

        @Override
        protected void generateIncrement() {
            ExpressionCodegen.this.v.load(this.myIndexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.load(this.myDeltaVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.add(Type.INT_TYPE);
            ExpressionCodegen.this.v.store(this.myIndexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.iinc(this.myCountVar, -1);
        }

        @Override
        protected void cleanupTemp() {
            ExpressionCodegen.this.myFrameMap.leaveTemp();
            ExpressionCodegen.this.myFrameMap.leaveTemp();
        }
    }

    private class ForInArrayLoopGenerator
    extends ForLoopGenerator {
        private int myIndexVar;
        private int myArrayVar;
        private boolean localArrayVar;

        public ForInArrayLoopGenerator(JetForExpression expression, Type loopRangeType) {
            super(expression, loopRangeType);
        }

        @Override
        protected void generatePrologue() {
            this.myIndexVar = ExpressionCodegen.this.myFrameMap.enterTemp();
            StackValue value = ExpressionCodegen.this.gen(this.expression.getLoopRange());
            if (value instanceof StackValue.Local) {
                this.myArrayVar = ((StackValue.Local)value).index;
                this.localArrayVar = true;
            } else {
                this.myArrayVar = ExpressionCodegen.this.myFrameMap.enterTemp();
                value.put(this.loopRangeType, ExpressionCodegen.this.v);
                ExpressionCodegen.this.v.store(this.myArrayVar, JetTypeMapper.TYPE_OBJECT);
            }
            if (this.expressionType.isNullable()) {
                ExpressionCodegen.this.v.load(this.myArrayVar, JetTypeMapper.TYPE_OBJECT);
                ExpressionCodegen.this.v.ifnull(this.end);
            }
            ExpressionCodegen.this.v.iconst(0);
            ExpressionCodegen.this.v.store(this.myIndexVar, Type.INT_TYPE);
        }

        @Override
        protected void generateCondition(Type asmParamType, Label end) {
            Type arrayElParamType = ExpressionCodegen.this.state.getStandardLibrary().getArray().equals(this.expressionType.getConstructor().getDeclarationDescriptor()) ? JetTypeMapper.boxType(asmParamType) : asmParamType;
            ExpressionCodegen.this.v.load(this.myIndexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.load(this.myArrayVar, JetTypeMapper.TYPE_OBJECT);
            ExpressionCodegen.this.v.arraylength();
            ExpressionCodegen.this.v.ificmpge(end);
            ExpressionCodegen.this.v.load(this.myArrayVar, JetTypeMapper.TYPE_OBJECT);
            ExpressionCodegen.this.v.load(this.myIndexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.aload(arrayElParamType);
            StackValue.onStack(arrayElParamType).put(asmParamType, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.store(ExpressionCodegen.this.lookupLocal(this.parameterDescriptor), asmParamType);
        }

        @Override
        protected void generateIncrement() {
            ExpressionCodegen.this.v.iinc(this.myIndexVar, 1);
        }

        @Override
        protected void cleanupTemp() {
            ExpressionCodegen.this.myFrameMap.leaveTemp(this.localArrayVar ? 1 : 2);
        }
    }

    private abstract class ForLoopGenerator {
        protected JetForExpression expression;
        protected Type loopRangeType;
        protected JetType expressionType;
        protected VariableDescriptor parameterDescriptor;
        Label end = new Label();

        public ForLoopGenerator(JetForExpression expression, Type loopRangeType) {
            this.expression = expression;
            this.loopRangeType = loopRangeType;
            JetParameter loopParameter = expression.getLoopParameter();
            this.parameterDescriptor = ExpressionCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER, loopParameter);
            this.expressionType = ExpressionCodegen.this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression.getLoopRange());
        }

        public void invoke() {
            JetType paramType = this.parameterDescriptor.getType();
            Type asmParamType = ExpressionCodegen.this.asmType(paramType);
            ExpressionCodegen.this.myFrameMap.enter(this.parameterDescriptor, asmParamType.getSize());
            this.generatePrologue();
            Label condition = new Label();
            Label increment = new Label();
            ExpressionCodegen.this.v.mark(condition);
            ExpressionCodegen.this.blockStackElements.push(new LoopBlockStackElement(this.end, increment, ExpressionCodegen.this.targetLabel(this.expression)));
            this.generateCondition(asmParamType, this.end);
            ExpressionCodegen.this.gen(this.expression.getBody(), Type.VOID_TYPE);
            ExpressionCodegen.this.v.mark(increment);
            this.generateIncrement();
            ExpressionCodegen.this.v.goTo(condition);
            ExpressionCodegen.this.v.mark(this.end);
            this.cleanupTemp();
            int paramIndex = ExpressionCodegen.this.myFrameMap.leave(this.parameterDescriptor);
            ExpressionCodegen.this.v.visitLocalVariable(this.expression.getLoopParameter().getName(), asmParamType.getDescriptor(), null, condition, this.end, paramIndex);
            ExpressionCodegen.this.blockStackElements.pop();
        }

        protected void generatePrologue() {
        }

        protected abstract void generateCondition(Type var1, Label var2);

        protected abstract void generateIncrement();

        protected void cleanupTemp() {
        }
    }

    static class FinallyBlockStackElement
    extends BlockStackElement {
        final JetTryExpression expression;

        FinallyBlockStackElement(JetTryExpression expression) {
            this.expression = expression;
        }
    }

    static class LoopBlockStackElement
    extends BlockStackElement {
        final Label continueLabel;
        final Label breakLabel;
        public JetSimpleNameExpression targetLabel;

        LoopBlockStackElement(Label breakLabel, Label continueLabel, JetSimpleNameExpression targetLabel) {
            this.breakLabel = breakLabel;
            this.continueLabel = continueLabel;
            this.targetLabel = targetLabel;
        }
    }

    static class BlockStackElement {
        BlockStackElement() {
        }
    }
}

