/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class CompilationException
extends RuntimeException {
    private PsiElement element;

    CompilationException(String message, Throwable cause, PsiElement element) {
        super(message, cause);
        this.element = element;
    }

    public PsiElement getElement() {
        return this.element;
    }

    @Override
    public String toString() {
        int col;
        int line;
        PsiFile psiFile = this.element.getContainingFile();
        TextRange textRange = this.element.getTextRange();
        Document document = psiFile.getViewProvider().getDocument();
        if (document != null) {
            line = document.getLineNumber(textRange.getStartOffset());
            col = textRange.getStartOffset() - document.getLineStartOffset(line) + 1;
        } else {
            line = -1;
            col = -1;
        }
        String s2 = "";
        Throwable cause = this.getCause();
        if (cause != null) {
            s2 = cause.getMessage() != null ? cause.getMessage() : cause.toString();
        }
        return "Internal error: (" + (line + 1) + "," + col + ") " + s2 + "\n@" + this.where();
    }

    private String where() {
        Throwable cause = this.getCause();
        if (cause != null && cause.getStackTrace().length > 0) {
            return cause.getStackTrace()[0].getFileName() + ":" + cause.getStackTrace()[0].getLineNumber();
        }
        return "far away in cyberspace";
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

