/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;

public class CodegenUtil {
    private CodegenUtil() {
    }

    public static boolean isInterface(DeclarationDescriptor descriptor) {
        return descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() == ClassKind.TRAIT;
    }

    public static boolean isInterface(JetType type) {
        return CodegenUtil.isInterface(type.getConstructor().getDeclarationDescriptor());
    }

    public static boolean isClassObject(DeclarationDescriptor descriptor) {
        ClassDescriptor classDescriptor;
        if (descriptor instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)descriptor).getKind() == ClassKind.OBJECT && classDescriptor.getContainingDeclaration() instanceof ClassDescriptor) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)classDescriptor.getContainingDeclaration();
            if (((Object)classDescriptor.getDefaultType()).equals(containingDeclaration.getClassObjectType())) {
                return true;
            }
        }
        return false;
    }

    public static SimpleFunctionDescriptor createInvoke(FunctionDescriptor fd) {
        int arity = fd.getValueParameters().size();
        SimpleFunctionDescriptorImpl invokeDescriptor = new SimpleFunctionDescriptorImpl(fd.getExpectedThisObject().exists() ? JetStandardClasses.getReceiverFunction(arity) : JetStandardClasses.getFunction(arity), Collections.<AnnotationDescriptor>emptyList(), "invoke", CallableMemberDescriptor.Kind.DECLARATION);
        invokeDescriptor.initialize(fd.getReceiverParameter().exists() ? fd.getReceiverParameter().getType() : null, fd.getExpectedThisObject(), Collections.<TypeParameterDescriptor>emptyList(), fd.getValueParameters(), fd.getReturnType(), Modality.FINAL, Visibility.PUBLIC);
        return invokeDescriptor;
    }

    public static boolean isSubclass(ClassDescriptor subClass, ClassDescriptor superClass) {
        THashSet allSuperTypes = new THashSet();
        CodegenUtil.addSuperTypes(subClass.getDefaultType(), (Set<JetType>)allSuperTypes);
        DeclarationDescriptor superOriginal = superClass.getOriginal();
        for (JetType superType : allSuperTypes) {
            ClassifierDescriptor descriptor = superType.getConstructor().getDeclarationDescriptor();
            if (descriptor == null || !superOriginal.equals(descriptor.getOriginal())) continue;
            return true;
        }
        return false;
    }

    public static void addSuperTypes(JetType type, Set<JetType> set) {
        set.add(type);
        for (JetType jetType : type.getConstructor().getSupertypes()) {
            CodegenUtil.addSuperTypes(jetType, set);
        }
    }

    public static boolean isNonLiteralObject(JetClassOrObject myClass) {
        return myClass instanceof JetObjectDeclaration && !((JetObjectDeclaration)myClass).isObjectLiteral() && !(myClass.getParent() instanceof JetClassObject);
    }

    public static boolean isNamedFun(DeclarationDescriptor fd, BindingContext bindingContext) {
        PsiElement psiElement = bindingContext.get(BindingContext.DESCRIPTOR_TO_DECLARATION, fd);
        return psiElement instanceof JetNamedFunction;
    }
}

