/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.ObjectOrClosureCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public abstract class CodegenContext {
    public static final CodegenContext STATIC = new CodegenContext(null, OwnerKind.NAMESPACE, null, null){

        @Override
        protected ClassDescriptor getThisDescriptor() {
            return null;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        public String toString() {
            return "ROOT";
        }
    };
    protected static final StackValue local0 = StackValue.local(0, JetTypeMapper.TYPE_OBJECT);
    protected static final StackValue local1 = StackValue.local(1, JetTypeMapper.TYPE_OBJECT);
    private final DeclarationDescriptor contextType;
    private final OwnerKind contextKind;
    @Nullable
    private final CodegenContext parentContext;
    public final ObjectOrClosureCodegen closure;
    HashMap<JetType, Integer> typeInfoConstants;
    HashMap<Integer, JetType> reverseTypeInfoConstants;
    int typeInfoConstantsCount;
    HashMap<DeclarationDescriptor, DeclarationDescriptor> accessors;
    protected StackValue outerExpression;
    protected Type outerWasUsed;

    public CodegenContext(DeclarationDescriptor contextType, OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable ObjectOrClosureCodegen closureCodegen) {
        this.contextType = contextType;
        this.contextKind = contextKind;
        this.parentContext = parentContext;
        this.closure = closureCodegen;
    }

    protected abstract ClassDescriptor getThisDescriptor();

    public DeclarationDescriptor getClassOrNamespaceDescriptor() {
        DeclarationDescriptor contextDescriptor;
        CodegenContext c = this;
        while (!((contextDescriptor = c.getContextDescriptor()) instanceof ClassDescriptor) && !(contextDescriptor instanceof NamespaceDescriptor)) {
            c = c.getParentContext();
        }
        return contextDescriptor;
    }

    protected CallableDescriptor getReceiverDescriptor() {
        return null;
    }

    protected StackValue getOuterExpression(@Nullable StackValue prefix) {
        if (this.outerExpression == null) {
            throw new UnsupportedOperationException();
        }
        this.outerWasUsed = this.outerExpression.type;
        return prefix != null ? StackValue.composed(prefix, this.outerExpression) : this.outerExpression;
    }

    public DeclarationDescriptor getContextDescriptor() {
        return this.contextType;
    }

    public String getNamespaceClassName() {
        DeclarationDescriptor descriptor = this.contextType;
        while (!(descriptor instanceof NamespaceDescriptor)) {
            descriptor = descriptor.getContainingDeclaration();
        }
        return NamespaceCodegen.getJVMClassName(DescriptorUtils.getFQName(descriptor), true);
    }

    public OwnerKind getContextKind() {
        return this.contextKind;
    }

    public CodegenContext intoNamespace(NamespaceDescriptor descriptor) {
        return new NamespaceContext(descriptor, this);
    }

    public CodegenContext intoClass(ClassDescriptor descriptor, OwnerKind kind, JetTypeMapper typeMapper) {
        return new ClassContext(descriptor, kind, this, typeMapper);
    }

    public CodegenContext intoAnonymousClass(@NotNull ObjectOrClosureCodegen closure, ClassDescriptor descriptor, OwnerKind kind, JetTypeMapper typeMapper) {
        return new AnonymousClassContext(descriptor, kind, this, closure, typeMapper);
    }

    public MethodContext intoFunction(FunctionDescriptor descriptor) {
        return new MethodContext(descriptor, this.getContextKind(), this);
    }

    public ConstructorContext intoConstructor(ConstructorDescriptor descriptor, JetTypeMapper typeMapper) {
        if (descriptor == null) {
            descriptor = new ConstructorDescriptorImpl(this.getThisDescriptor(), Collections.<AnnotationDescriptor>emptyList(), true).initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibility.PUBLIC);
        }
        return new ConstructorContext(descriptor, this.getContextKind(), this, typeMapper);
    }

    public ClosureContext intoClosure(FunctionDescriptor funDescriptor, ClassDescriptor classDescriptor, String internalClassName, ClosureCodegen closureCodegen, JetTypeMapper typeMapper) {
        return new ClosureContext(funDescriptor, classDescriptor, this, closureCodegen, internalClassName, typeMapper);
    }

    public FrameMap prepareFrame(JetTypeMapper mapper) {
        CallableDescriptor receiverDescriptor;
        FrameMap frameMap = new FrameMap();
        if (this.getContextKind() != OwnerKind.NAMESPACE) {
            frameMap.enterTemp();
        }
        if ((receiverDescriptor = this.getReceiverDescriptor()) != null) {
            Type type = mapper.mapType(receiverDescriptor.getReceiverParameter().getType());
            frameMap.enterTemp(type.getSize());
        }
        return frameMap;
    }

    @Nullable
    public CodegenContext getParentContext() {
        return this.parentContext;
    }

    public Type jvmType(JetTypeMapper mapper) {
        if (this.contextType instanceof ClassDescriptor) {
            return mapper.mapType(((ClassDescriptor)this.contextType).getDefaultType(), this.contextKind);
        }
        if (this.closure != null) {
            return Type.getObjectType((String)this.closure.name);
        }
        return this.parentContext != null ? this.parentContext.jvmType(mapper) : JetTypeMapper.TYPE_OBJECT;
    }

    public StackValue lookupInContext(DeclarationDescriptor d, InstructionAdapter v, StackValue result) {
        ObjectOrClosureCodegen top = this.closure;
        if (top != null) {
            StackValue answer = top.lookupInContext(d, result);
            if (answer != null) {
                return result == null ? answer : StackValue.composed(result, answer);
            }
            StackValue outer = this.getOuterExpression(null);
            result = result == null ? outer : StackValue.composed(result, outer);
        }
        return this.parentContext != null ? this.parentContext.lookupInContext(d, v, result) : null;
    }

    public Type enclosingClassType(JetTypeMapper typeMapper) {
        CodegenContext cur;
        for (cur = this.getParentContext(); cur != null && !(cur.getContextDescriptor() instanceof ClassDescriptor); cur = cur.getParentContext()) {
        }
        return cur == null ? null : typeMapper.mapType(((ClassDescriptor)cur.getContextDescriptor()).getDefaultType());
    }

    public int getTypeInfoConstantIndex(JetType type) {
        Integer index;
        if (this.parentContext != STATIC) {
            return this.parentContext.getTypeInfoConstantIndex(type);
        }
        if (this.typeInfoConstants == null) {
            this.typeInfoConstants = new LinkedHashMap<JetType, Integer>();
            this.reverseTypeInfoConstants = new LinkedHashMap<Integer, JetType>();
        }
        if ((index = this.typeInfoConstants.get(type)) == null) {
            index = this.typeInfoConstantsCount++;
            this.typeInfoConstants.put(type, index);
            this.reverseTypeInfoConstants.put(index, type);
        }
        return index;
    }

    DeclarationDescriptor getAccessor(DeclarationDescriptor descriptor) {
        DeclarationDescriptor accessor;
        if (this.accessors == null) {
            this.accessors = new HashMap();
        }
        if ((accessor = this.accessors.get(descriptor = descriptor.getOriginal())) != null) {
            return accessor;
        }
        if (descriptor instanceof SimpleFunctionDescriptor) {
            SimpleFunctionDescriptorImpl myAccessor = new SimpleFunctionDescriptorImpl(this.contextType, Collections.<AnnotationDescriptor>emptyList(), descriptor.getName() + "$bridge$" + this.accessors.size(), CallableMemberDescriptor.Kind.DECLARATION);
            SimpleFunctionDescriptor fd = (SimpleFunctionDescriptor)descriptor;
            myAccessor.initialize(fd.getReceiverParameter().exists() ? fd.getReceiverParameter().getType() : null, fd.getExpectedThisObject(), fd.getTypeParameters(), fd.getValueParameters(), fd.getReturnType(), fd.getModality(), fd.getVisibility());
            accessor = myAccessor;
        } else if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)descriptor;
            PropertyDescriptor myAccessor = new PropertyDescriptor(this.contextType, Collections.<AnnotationDescriptor>emptyList(), pd.getModality(), pd.getVisibility(), pd.isVar(), pd.isObjectDeclaration(), pd.getName() + "$bridge$" + this.accessors.size(), CallableMemberDescriptor.Kind.DECLARATION);
            JetType receiverType = pd.getReceiverParameter().exists() ? pd.getReceiverParameter().getType() : null;
            myAccessor.setType(pd.getType(), Collections.<TypeParameterDescriptor>emptyList(), pd.getExpectedThisObject(), receiverType);
            PropertyGetterDescriptor pgd = new PropertyGetterDescriptor(myAccessor, Collections.<AnnotationDescriptor>emptyList(), myAccessor.getModality(), myAccessor.getVisibility(), false, false, CallableMemberDescriptor.Kind.DECLARATION);
            pgd.initialize(myAccessor.getType());
            PropertySetterDescriptor psd = new PropertySetterDescriptor(myAccessor, Collections.<AnnotationDescriptor>emptyList(), myAccessor.getModality(), myAccessor.getVisibility(), false, false, CallableMemberDescriptor.Kind.DECLARATION);
            myAccessor.initialize(pgd, psd);
            accessor = myAccessor;
        } else {
            throw new UnsupportedOperationException();
        }
        this.accessors.put(descriptor, accessor);
        return accessor;
    }

    public StackValue getReceiverExpression(JetTypeMapper typeMapper) {
        assert (this.getReceiverDescriptor() != null);
        Type asmType = typeMapper.mapType(this.getReceiverDescriptor().getReceiverParameter().getType());
        return this.getThisDescriptor() != null ? StackValue.local(1, asmType) : StackValue.local(0, asmType);
    }

    public abstract boolean isStatic();

    public void copyAccessors(HashMap<DeclarationDescriptor, DeclarationDescriptor> accessors) {
        if (accessors != null) {
            if (this.accessors == null) {
                this.accessors = new HashMap();
            }
            this.accessors.putAll(accessors);
        }
    }

    public static class NamespaceContext
    extends CodegenContext {
        public NamespaceContext(NamespaceDescriptor contextType, CodegenContext parent) {
            super(contextType, OwnerKind.NAMESPACE, parent, null);
        }

        @Override
        protected ClassDescriptor getThisDescriptor() {
            return null;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        public String toString() {
            return "Namespace: " + this.getContextDescriptor().getName();
        }
    }

    public static class ClosureContext
    extends ReceiverContext {
        private ClassDescriptor classDescriptor;

        public ClosureContext(FunctionDescriptor contextType, ClassDescriptor classDescriptor, CodegenContext parentContext, @NotNull ObjectOrClosureCodegen closureCodegen, String internalClassName, JetTypeMapper typeMapper) {
            super(contextType, OwnerKind.IMPLEMENTATION, parentContext, closureCodegen);
            this.classDescriptor = classDescriptor;
            Type type = this.enclosingClassType(typeMapper);
            this.outerExpression = type != null ? StackValue.field(type, internalClassName, "this$0", false) : null;
        }

        @Override
        protected ClassDescriptor getThisDescriptor() {
            return this.classDescriptor;
        }

        @Override
        public DeclarationDescriptor getContextDescriptor() {
            return this.classDescriptor;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        public String toString() {
            return "Closure: " + this.classDescriptor;
        }
    }

    public static class AnonymousClassContext
    extends CodegenContext {
        public AnonymousClassContext(ClassDescriptor contextType, OwnerKind contextKind, CodegenContext parentContext, @NotNull ObjectOrClosureCodegen closure, JetTypeMapper typeMapper) {
            super(contextType, contextKind, parentContext, closure);
            Type type = this.enclosingClassType(typeMapper);
            this.outerExpression = type != null ? StackValue.field(type, closure.state.getTypeMapper().mapType(contextType.getDefaultType(), OwnerKind.IMPLEMENTATION).getInternalName(), "this$0", false) : null;
        }

        @Override
        protected ClassDescriptor getThisDescriptor() {
            return (ClassDescriptor)this.getContextDescriptor();
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        public String toString() {
            return "Anonymous: " + this.getThisDescriptor();
        }
    }

    public static class ClassContext
    extends CodegenContext {
        public ClassContext(ClassDescriptor contextType, OwnerKind contextKind, CodegenContext parentContext, JetTypeMapper typeMapper) {
            super(contextType, contextKind, parentContext, null);
            Type type = this.enclosingClassType(typeMapper);
            this.outerExpression = type != null ? StackValue.field(type, typeMapper.getFQName(contextType), "this$0", false) : null;
        }

        @Override
        protected ClassDescriptor getThisDescriptor() {
            return (ClassDescriptor)this.getContextDescriptor();
        }

        @Override
        public boolean isStatic() {
            return false;
        }
    }

    public static class ConstructorContext
    extends MethodContext {
        public ConstructorContext(ConstructorDescriptor contextType, OwnerKind kind, CodegenContext parent, JetTypeMapper typeMapper) {
            super(contextType, kind, parent);
            Type type = this.enclosingClassType(typeMapper);
            this.outerExpression = type != null ? local1 : null;
        }

        @Override
        protected StackValue getOuterExpression(StackValue prefix) {
            return this.outerExpression;
        }

        @Override
        public String toString() {
            return "Constructor: " + this.getContextDescriptor().getName();
        }
    }

    public static class MethodContext
    extends ReceiverContext {
        public MethodContext(FunctionDescriptor contextType, OwnerKind contextKind, CodegenContext parentContext) {
            super(contextType instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)contextType).getCorrespondingProperty() : contextType, contextKind, parentContext, null);
        }

        @Override
        protected ClassDescriptor getThisDescriptor() {
            return this.getParentContext().getThisDescriptor();
        }

        @Override
        public StackValue lookupInContext(DeclarationDescriptor d, InstructionAdapter v, StackValue result) {
            return this.getParentContext().lookupInContext(d, v, result);
        }

        @Override
        public Type enclosingClassType(JetTypeMapper typeMapper) {
            return this.getParentContext().enclosingClassType(typeMapper);
        }

        @Override
        public boolean isStatic() {
            return this.getParentContext().isStatic();
        }

        @Override
        protected StackValue getOuterExpression(StackValue prefix) {
            return this.getParentContext().getOuterExpression(prefix);
        }

        public String toString() {
            return "Method: " + this.getContextDescriptor();
        }
    }

    public static abstract class ReceiverContext
    extends CodegenContext {
        final CallableDescriptor receiverDescriptor;

        public ReceiverContext(CallableDescriptor contextType, OwnerKind contextKind, CodegenContext parentContext, @Nullable ObjectOrClosureCodegen closureCodegen) {
            super(contextType, contextKind, parentContext, closureCodegen);
            this.receiverDescriptor = contextType.getReceiverParameter().exists() ? contextType : null;
        }

        @Override
        protected CallableDescriptor getReceiverDescriptor() {
            return this.receiverDescriptor;
        }
    }
}

