/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jet.codegen.BothSignatureWriter;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.EnclosedValueDescriptor;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GeneratedAnonymousClassDescriptor;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.JvmMethodSignature;
import org.jetbrains.jet.codegen.ObjectOrClosureCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.StubCodegen;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.signature.SignatureWriter;

public class ClosureCodegen
extends ObjectOrClosureCodegen {
    private final BindingContext bindingContext;

    public ClosureCodegen(GenerationState state, ExpressionCodegen exprContext, CodegenContext context) {
        super(exprContext, context, state);
        this.bindingContext = state.getBindingContext();
    }

    public static JvmMethodSignature erasedInvokeSignature(FunctionDescriptor fd) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        signatureWriter.writeFormalTypeParametersStart();
        signatureWriter.writeFormalTypeParametersEnd();
        boolean isExtensionFunction = fd.getReceiverParameter().exists();
        int paramCount = fd.getValueParameters().size();
        if (isExtensionFunction) {
            ++paramCount;
        }
        signatureWriter.writeParametersStart();
        for (int i = 0; i < paramCount; ++i) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            signatureWriter.writeAsmType(JetTypeMapper.TYPE_OBJECT, true);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeReturnType();
        signatureWriter.writeAsmType(JetTypeMapper.TYPE_OBJECT, true);
        signatureWriter.writeReturnTypeEnd();
        return signatureWriter.makeJvmMethodSignature("invoke");
    }

    public static CallableMethod asCallableMethod(FunctionDescriptor fd) {
        JvmMethodSignature descriptor = ClosureCodegen.erasedInvokeSignature(fd);
        String owner = ClosureCodegen.getInternalClassName(fd);
        CallableMethod result = new CallableMethod(owner, "", "", descriptor, 182);
        if (fd.getReceiverParameter().exists()) {
            result.setNeedsReceiver(fd);
        }
        result.setNeedsThis(ClosureCodegen.getInternalType(fd));
        result.requestGenerateCallee(Type.getObjectType((String)ClosureCodegen.getInternalClassName(fd)));
        return result;
    }

    public JvmMethodSignature invokeSignature(FunctionDescriptor fd) {
        return this.state.getTypeMapper().mapSignature("invoke", fd);
    }

    public GeneratedAnonymousClassDescriptor gen(JetExpression fun) {
        Type enclosingType;
        Pair<String, ClassBuilder> nameAndVisitor = this.state.forAnonymousSubclass(fun);
        FunctionDescriptor funDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, fun);
        this.cv = (ClassBuilder)nameAndVisitor.getSecond();
        this.name = (String)nameAndVisitor.getFirst();
        SignatureWriter signatureWriter = new SignatureWriter();
        List<ValueParameterDescriptor> parameters = funDescriptor.getValueParameters();
        String funClass = ClosureCodegen.getInternalClassName(funDescriptor);
        signatureWriter.visitClassType(funClass);
        for (ValueParameterDescriptor parameter : parameters) {
            this.appendType(signatureWriter, parameter.getType(), '=');
        }
        this.appendType(signatureWriter, funDescriptor.getReturnType(), '=');
        signatureWriter.visitEnd();
        this.cv.defineClass((PsiElement)fun, 50, 1, this.name, null, funClass, new String[0]);
        this.cv.visitSource(this.state.transformFileName(fun.getContainingFile().getName()), null);
        this.generateBridge(this.name, funDescriptor, fun, this.cv);
        this.captureThis = this.generateBody(funDescriptor, this.cv, (JetDeclarationWithBody)((Object)fun));
        ClassDescriptor thisDescriptor = this.context.getThisDescriptor();
        Type type = enclosingType = thisDescriptor == null ? null : this.state.getTypeMapper().mapType(thisDescriptor.getDefaultType());
        if (enclosingType == null) {
            this.captureThis = null;
        }
        Method constructor = this.generateConstructor(funClass, (PsiElement)fun);
        if (this.captureThis != null) {
            this.cv.newField((PsiElement)fun, 16, "this$0", enclosingType.getDescriptor(), null, null);
        }
        if (this.isConst()) {
            this.generateConstInstance((PsiElement)fun);
        }
        this.cv.done();
        GeneratedAnonymousClassDescriptor answer = new GeneratedAnonymousClassDescriptor(this.name, constructor, this.captureThis, this.captureReceiver);
        for (DeclarationDescriptor descriptor : this.closure.keySet()) {
            EnclosedValueDescriptor valueDescriptor;
            if (descriptor instanceof VariableDescriptor) {
                valueDescriptor = (EnclosedValueDescriptor)this.closure.get(descriptor);
                answer.addArg(valueDescriptor.getOuterValue());
                continue;
            }
            if (!CodegenUtil.isNamedFun(descriptor, this.state.getBindingContext()) || !(descriptor.getContainingDeclaration() instanceof FunctionDescriptor)) continue;
            valueDescriptor = (EnclosedValueDescriptor)this.closure.get(descriptor);
            answer.addArg(valueDescriptor.getOuterValue());
        }
        return answer;
    }

    private void generateConstInstance(PsiElement fun) {
        String classDescr = "L" + this.name + ";";
        this.cv.newField(fun, 26, "$instance", classDescr, null, null);
        MethodVisitor mv = this.cv.newMethod(fun, 9, "$getInstance", "()" + classDescr, null, new String[0]);
        if (this.cv.generateCode() == ClassBuilder.Mode.STUBS) {
            StubCodegen.generateStubCode(mv);
        } else if (this.cv.generateCode() == ClassBuilder.Mode.FULL) {
            mv.visitCode();
            mv.visitFieldInsn(178, this.name, "$instance", classDescr);
            mv.visitInsn(89);
            Label ret = new Label();
            mv.visitJumpInsn(199, ret);
            mv.visitInsn(87);
            mv.visitTypeInsn(187, this.name);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, this.name, "<init>", "()V");
            mv.visitInsn(89);
            mv.visitFieldInsn(179, this.name, "$instance", classDescr);
            mv.visitLabel(ret);
            mv.visitInsn(176);
            FunctionCodegen.endVisit(mv, "$getInstance", fun);
        }
    }

    private Type generateBody(FunctionDescriptor funDescriptor, ClassBuilder cv, JetDeclarationWithBody body) {
        ClassDescriptor function = this.state.getTypeMapper().getClosureAnnotator().classDescriptorForFunctionDescriptor(funDescriptor, this.name);
        CodegenContext.ClosureContext closureContext = this.context.intoClosure(funDescriptor, function, this.name, this, this.state.getTypeMapper());
        FunctionCodegen fc = new FunctionCodegen(closureContext, cv, this.state);
        JvmMethodSignature jvmMethodSignature = this.invokeSignature(funDescriptor);
        fc.generateMethod(body, jvmMethodSignature, false, null, funDescriptor);
        return closureContext.outerWasUsed;
    }

    private void generateBridge(String className, FunctionDescriptor funDescriptor, JetExpression fun, ClassBuilder cv) {
        JvmMethodSignature bridge = ClosureCodegen.erasedInvokeSignature(funDescriptor);
        Method delegate = this.invokeSignature(funDescriptor).getAsmMethod();
        if (bridge.getAsmMethod().getDescriptor().equals(delegate.getDescriptor())) {
            return;
        }
        MethodVisitor mv = cv.newMethod((PsiElement)fun, 1, "invoke", bridge.getAsmMethod().getDescriptor(), null, new String[0]);
        if (cv.generateCode() == ClassBuilder.Mode.STUBS) {
            StubCodegen.generateStubCode(mv);
        }
        if (cv.generateCode() == ClassBuilder.Mode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, Type.getObjectType((String)className));
            ReceiverDescriptor receiver = funDescriptor.getReceiverParameter();
            int count = 1;
            if (receiver.exists()) {
                StackValue.local(count, JetTypeMapper.TYPE_OBJECT).put(JetTypeMapper.TYPE_OBJECT, iv);
                StackValue.onStack(JetTypeMapper.TYPE_OBJECT).upcast(this.state.getTypeMapper().mapType(receiver.getType()), iv);
                ++count;
            }
            List<ValueParameterDescriptor> params = funDescriptor.getValueParameters();
            for (ValueParameterDescriptor param : params) {
                StackValue.local(count, JetTypeMapper.TYPE_OBJECT).put(JetTypeMapper.TYPE_OBJECT, iv);
                StackValue.onStack(JetTypeMapper.TYPE_OBJECT).upcast(this.state.getTypeMapper().mapType(param.getType()), iv);
                ++count;
            }
            iv.invokespecial(className, "invoke", delegate.getDescriptor());
            StackValue.onStack(delegate.getReturnType()).put(JetTypeMapper.TYPE_OBJECT, iv);
            iv.areturn(JetTypeMapper.TYPE_OBJECT);
            FunctionCodegen.endVisit(mv, "bridge", (PsiElement)fun);
        }
    }

    private Method generateConstructor(String funClass, PsiElement fun) {
        int argCount = this.captureThis != null ? 1 : 0;
        argCount += this.captureReceiver != null ? 1 : 0;
        ArrayList<DeclarationDescriptor> variableDescriptors = new ArrayList<DeclarationDescriptor>();
        for (DeclarationDescriptor descriptor : this.closure.keySet()) {
            if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
                ++argCount;
                variableDescriptors.add(descriptor);
                continue;
            }
            if (CodegenUtil.isNamedFun(descriptor, this.state.getBindingContext()) && descriptor.getContainingDeclaration() instanceof FunctionDescriptor) {
                ++argCount;
                variableDescriptors.add(descriptor);
                continue;
            }
            if (descriptor instanceof FunctionDescriptor) assert (this.captureReceiver != null);
        }
        Type[] argTypes = new Type[argCount];
        int i = 0;
        if (this.captureThis != null) {
            argTypes[i++] = this.state.getTypeMapper().mapType(this.context.getThisDescriptor().getDefaultType());
        }
        if (this.captureReceiver != null) {
            argTypes[i++] = this.captureReceiver;
        }
        for (DeclarationDescriptor descriptor : this.closure.keySet()) {
            if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = this.exprContext.getTypeMapper().getSharedVarType(descriptor);
                Type type = sharedVarType != null ? sharedVarType : this.state.getTypeMapper().mapType(((VariableDescriptor)descriptor).getType());
                argTypes[i++] = type;
                continue;
            }
            if (!CodegenUtil.isNamedFun(descriptor, this.state.getBindingContext()) || !(descriptor.getContainingDeclaration() instanceof FunctionDescriptor)) continue;
            Type type = Type.getObjectType((String)this.state.getTypeMapper().getClosureAnnotator().classNameForAnonymousClass((JetElement)this.bindingContext.get(BindingContext.DESCRIPTOR_TO_DECLARATION, descriptor)));
            argTypes[i++] = type;
        }
        Method constructor = new Method("<init>", Type.VOID_TYPE, argTypes);
        MethodVisitor mv = this.cv.newMethod(fun, 1, "<init>", constructor.getDescriptor(), null, new String[0]);
        if (this.cv.generateCode() == ClassBuilder.Mode.STUBS) {
            StubCodegen.generateStubCode(mv);
        } else if (this.cv.generateCode() == ClassBuilder.Mode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, Type.getObjectType((String)funClass));
            iv.invokespecial(funClass, "<init>", "()V");
            i = 1;
            for (Type type : argTypes) {
                String fieldName;
                StackValue.local(0, JetTypeMapper.TYPE_OBJECT).put(JetTypeMapper.TYPE_OBJECT, iv);
                StackValue.local(i, type).put(type, iv);
                if (this.captureThis != null && i == 1) {
                    fieldName = "this$0";
                } else if (this.captureReceiver != null && (this.captureThis != null && i == 2 || this.captureThis == null && i == 1)) {
                    fieldName = "receiver$0";
                } else {
                    DeclarationDescriptor removed = (DeclarationDescriptor)variableDescriptors.remove(0);
                    fieldName = "$" + removed.getName();
                }
                i += type.getSize();
                StackValue.field(type, this.name, fieldName, false).store(iv);
            }
            iv.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)iv, "constructor", fun);
        }
        return constructor;
    }

    public static String getInternalClassName(FunctionDescriptor descriptor) {
        int paramCount = descriptor.getValueParameters().size();
        if (descriptor.getReceiverParameter().exists()) {
            return "jet/ExtensionFunction" + paramCount;
        }
        return "jet/Function" + paramCount;
    }

    public static ClassDescriptor getInternalType(FunctionDescriptor descriptor) {
        int paramCount = descriptor.getValueParameters().size();
        if (descriptor.getReceiverParameter().exists()) {
            return JetStandardClasses.getReceiverFunction(paramCount);
        }
        return JetStandardClasses.getFunction(paramCount);
    }

    private void appendType(SignatureWriter signatureWriter, JetType type, char variance) {
        signatureWriter.visitTypeArgument(variance);
        JetTypeMapper typeMapper = this.state.getTypeMapper();
        Type rawRetType = JetTypeMapper.boxType(typeMapper.mapType(type));
        signatureWriter.visitClassType(rawRetType.getInternalName());
        signatureWriter.visitEnd();
    }
}

