/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetStandardClasses;

public class ClosureAnnotator {
    private final Map<JetElement, String> classNamesForAnonymousClasses = new HashMap<JetElement, String>();
    private final Map<ClassDescriptor, String> classNamesForClassDescriptor = new HashMap<ClassDescriptor, String>();
    private final Map<String, Integer> anonymousSubclassesCount = new HashMap<String, Integer>();
    private final Map<FunctionDescriptor, ClassDescriptorImpl> classesForFunctions = new HashMap<FunctionDescriptor, ClassDescriptorImpl>();
    private final Map<DeclarationDescriptor, ClassDescriptor> enclosing = new HashMap<DeclarationDescriptor, ClassDescriptor>();
    private final MultiMap<String, JetFile> namespaceName2Files = MultiMap.create();
    private final BindingContext bindingContext;

    public ClosureAnnotator(BindingContext bindingContext, Collection<JetFile> files) {
        this.bindingContext = bindingContext;
        this.mapFilesToNamespaces(files);
        this.prepareAnonymousClasses();
    }

    public ClassDescriptor classDescriptorForFunctionDescriptor(FunctionDescriptor funDescriptor, String name) {
        ClassDescriptorImpl classDescriptor = this.classesForFunctions.get(funDescriptor);
        if (classDescriptor == null) {
            int arity = funDescriptor.getValueParameters().size();
            classDescriptor = new ClassDescriptorImpl(funDescriptor, Collections.<AnnotationDescriptor>emptyList(), name);
            classDescriptor.initialize(false, Collections.<TypeParameterDescriptor>emptyList(), Collections.singleton((funDescriptor.getReceiverParameter().exists() ? JetStandardClasses.getReceiverFunction(arity) : JetStandardClasses.getFunction(arity)).getDefaultType()), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null);
            this.classesForFunctions.put(funDescriptor, classDescriptor);
        }
        return classDescriptor;
    }

    private void mapFilesToNamespaces(Collection<JetFile> files) {
        for (JetFile file : files) {
            String fqName = JetPsiUtil.getFQName(file);
            this.namespaceName2Files.putValue((Object)fqName, (Object)file);
        }
    }

    private void prepareAnonymousClasses() {
        MyJetVisitorVoid visitor = new MyJetVisitorVoid();
        for (Map.Entry entry : this.namespaceName2Files.entrySet()) {
            for (JetFile jetFile : (Collection)entry.getValue()) {
                jetFile.accept(visitor);
            }
        }
    }

    public String classNameForAnonymousClass(JetElement expression) {
        if (expression instanceof JetObjectLiteralExpression) {
            JetObjectLiteralExpression jetObjectLiteralExpression = (JetObjectLiteralExpression)expression;
            expression = jetObjectLiteralExpression.getObjectDeclaration();
        }
        if (expression instanceof JetFunctionLiteralExpression) {
            JetFunctionLiteralExpression jetFunctionLiteralExpression = (JetFunctionLiteralExpression)expression;
            expression = jetFunctionLiteralExpression.getFunctionLiteral();
        }
        String name = this.classNamesForAnonymousClasses.get((Object)expression);
        assert (name != null);
        return name;
    }

    public ClassDescriptor getEclosingClassDescriptor(ClassDescriptor descriptor) {
        return this.enclosing.get(descriptor);
    }

    public boolean hasThis0(ClassDescriptor classDescriptor) {
        if (CodegenUtil.isClassObject(classDescriptor)) {
            return false;
        }
        ClassDescriptor other = this.enclosing.get(classDescriptor);
        return other != null;
    }

    public String classNameForClassDescriptor(ClassDescriptor classDescriptor) {
        String name = this.classNamesForClassDescriptor.get(classDescriptor);
        assert (name != null);
        return name;
    }

    private class MyJetVisitorVoid
    extends JetVisitorVoid {
        private LinkedList<ClassDescriptor> classStack = new LinkedList();
        private LinkedList<String> nameStack = new LinkedList();

        private MyJetVisitorVoid() {
        }

        private void recordEnclosing(ClassDescriptor classDescriptor) {
            if (this.classStack.size() > 0) {
                ClassDescriptor put = ClosureAnnotator.this.enclosing.put(classDescriptor, this.classStack.peek());
                assert (put == null);
            }
        }

        private String recordAnonymousClass(JetElement declaration) {
            String name = (String)ClosureAnnotator.this.classNamesForAnonymousClasses.get((Object)declaration);
            assert (name == null);
            String top = this.nameStack.peek();
            Integer cnt = (Integer)ClosureAnnotator.this.anonymousSubclassesCount.get(top);
            if (cnt == null) {
                cnt = 0;
            }
            name = top + "$" + (cnt + 1);
            ClosureAnnotator.this.classNamesForAnonymousClasses.put(declaration, name);
            ClosureAnnotator.this.anonymousSubclassesCount.put(top, cnt + 1);
            return name;
        }

        private String recordClassObject(JetClassObject declaration) {
            String name = (String)ClosureAnnotator.this.classNamesForAnonymousClasses.get(declaration.getObjectDeclaration());
            assert (name == null);
            name = this.nameStack.peek() + "$ClassObject$";
            ClosureAnnotator.this.classNamesForAnonymousClasses.put(declaration.getObjectDeclaration(), name);
            return name;
        }

        @Override
        public void visitJetElement(JetElement element) {
            super.visitJetElement(element);
            element.acceptChildren(this);
        }

        @Override
        public void visitJetFile(JetFile file) {
            this.nameStack.push(JetPsiUtil.getFQName(file).replace('.', '/'));
            file.acceptChildren(this);
            this.nameStack.pop();
        }

        @Override
        public void visitClassObject(JetClassObject classObject) {
            String name = this.recordClassObject(classObject);
            ClassDescriptor classDescriptor = ClosureAnnotator.this.bindingContext.get(BindingContext.CLASS, classObject.getObjectDeclaration());
            this.recordEnclosing(classDescriptor);
            this.recordName(classDescriptor, name);
            this.classStack.push(classDescriptor);
            this.nameStack.push(name);
            super.visitClassObject(classObject);
            this.nameStack.pop();
            this.classStack.pop();
        }

        @Override
        public void visitObjectDeclaration(JetObjectDeclaration declaration) {
            if (declaration.getParent() instanceof JetObjectLiteralExpression || declaration.getParent() instanceof JetClassObject) {
                super.visitObjectDeclaration(declaration);
            } else {
                ClassDescriptor classDescriptor = ClosureAnnotator.this.bindingContext.get(BindingContext.CLASS, declaration);
                this.recordEnclosing(classDescriptor);
                this.classStack.push(classDescriptor);
                String base = this.nameStack.peek();
                if (classDescriptor.getContainingDeclaration() instanceof NamespaceDescriptor) {
                    this.nameStack.push(base.isEmpty() ? classDescriptor.getName() : base + '/' + classDescriptor.getName());
                } else {
                    this.nameStack.push(base + '$' + classDescriptor.getName());
                }
                super.visitObjectDeclaration(declaration);
                this.nameStack.pop();
                this.classStack.pop();
            }
        }

        @Override
        public void visitClass(JetClass klass) {
            ClassDescriptor classDescriptor = ClosureAnnotator.this.bindingContext.get(BindingContext.CLASS, klass);
            this.recordEnclosing(classDescriptor);
            this.classStack.push(classDescriptor);
            String base = this.nameStack.peek();
            if (classDescriptor.getContainingDeclaration() instanceof NamespaceDescriptor) {
                this.nameStack.push(base.isEmpty() ? classDescriptor.getName() : base + '/' + classDescriptor.getName());
            } else {
                this.nameStack.push(base + '$' + classDescriptor.getName());
            }
            super.visitClass(klass);
            this.nameStack.pop();
            this.classStack.pop();
        }

        @Override
        public void visitObjectLiteralExpression(JetObjectLiteralExpression expression) {
            String name = this.recordAnonymousClass(expression.getObjectDeclaration());
            ClassDescriptor classDescriptor = ClosureAnnotator.this.bindingContext.get(BindingContext.CLASS, expression.getObjectDeclaration());
            this.recordName(classDescriptor, name);
            this.recordEnclosing(classDescriptor);
            this.classStack.push(classDescriptor);
            this.nameStack.push(ClosureAnnotator.this.classNameForClassDescriptor(classDescriptor));
            super.visitObjectLiteralExpression(expression);
            this.nameStack.pop();
            this.classStack.pop();
        }

        @Override
        public void visitFunctionLiteralExpression(JetFunctionLiteralExpression expression) {
            String name = this.recordAnonymousClass(expression.getFunctionLiteral());
            FunctionDescriptor declarationDescriptor = (FunctionDescriptor)ClosureAnnotator.this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression);
            ClassDescriptor classDescriptor = ClosureAnnotator.this.classDescriptorForFunctionDescriptor(declarationDescriptor, name);
            this.recordName(classDescriptor, name);
            this.recordEnclosing(classDescriptor);
            this.classStack.push(classDescriptor);
            this.nameStack.push(ClosureAnnotator.this.classNameForClassDescriptor(classDescriptor));
            super.visitFunctionLiteralExpression(expression);
            this.nameStack.pop();
            this.classStack.pop();
        }

        private void recordName(ClassDescriptor classDescriptor, String name) {
            String old = ClosureAnnotator.this.classNamesForClassDescriptor.put(classDescriptor, name);
            assert (old == null);
        }

        @Override
        public void visitProperty(JetProperty property) {
            this.nameStack.push(this.nameStack.peek() + '$' + property.getName());
            super.visitProperty(property);
            this.nameStack.pop();
        }

        @Override
        public void visitNamedFunction(JetNamedFunction function) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)ClosureAnnotator.this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
            DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
            if (containingDeclaration instanceof ClassDescriptor) {
                this.nameStack.push(this.nameStack.peek() + '$' + function.getName());
                super.visitNamedFunction(function);
                this.nameStack.pop();
            } else if (containingDeclaration instanceof NamespaceDescriptor) {
                String peek = this.nameStack.peek();
                peek = peek.isEmpty() ? "namespace" : peek + "/namespace";
                this.nameStack.push(peek + '$' + function.getName());
                super.visitNamedFunction(function);
                this.nameStack.pop();
            } else {
                String name = this.recordAnonymousClass(function);
                ClassDescriptor classDescriptor = ClosureAnnotator.this.classDescriptorForFunctionDescriptor(functionDescriptor, name);
                this.recordName(classDescriptor, name);
                this.recordEnclosing(classDescriptor);
                this.classStack.push(classDescriptor);
                this.nameStack.push(name);
                super.visitNamedFunction(function);
                this.nameStack.pop();
                this.classStack.pop();
            }
        }
    }
}

