/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;

public class ClassFileFactory {
    private final ClassBuilderFactory builderFactory;
    private final Map<String, NamespaceCodegen> ns2codegen = new HashMap<String, NamespaceCodegen>();
    private final Map<String, ClassBuilder> generators = new LinkedHashMap<String, ClassBuilder>();
    private boolean isDone = false;
    public final GenerationState state;

    public ClassFileFactory(ClassBuilderFactory builderFactory, GenerationState state) {
        this.builderFactory = builderFactory;
        this.state = state;
    }

    ClassBuilder newVisitor(String filePath) {
        ClassBuilder answer = this.builderFactory.newClassBuilder();
        this.generators.put(filePath, answer);
        return answer;
    }

    ClassBuilder forAnonymousSubclass(String className) {
        return this.newVisitor(className + ".class");
    }

    NamespaceCodegen forNamespace(JetFile file) {
        assert (!this.isDone) : "Already done!";
        String fqName = JetPsiUtil.getFQName(file);
        NamespaceCodegen codegen = this.ns2codegen.get(fqName);
        if (codegen == null) {
            ClassBuilder builder = this.newVisitor(NamespaceCodegen.getJVMClassName(fqName, true) + ".class");
            codegen = new NamespaceCodegen(builder, fqName, this.state, file.getContainingFile());
            this.ns2codegen.put(fqName, codegen);
        }
        return codegen;
    }

    private void done() {
        if (!this.isDone) {
            this.isDone = true;
            for (NamespaceCodegen codegen : this.ns2codegen.values()) {
                codegen.done();
            }
        }
    }

    public String asText(String file) {
        this.done();
        return this.builderFactory.asText(this.generators.get(file));
    }

    public byte[] asBytes(String file) {
        this.done();
        return this.builderFactory.asBytes(this.generators.get(file));
    }

    public List<String> files() {
        this.done();
        return new ArrayList<String>(this.generators.keySet());
    }
}

