/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassBuilderFactories {
    public static ClassBuilderFactory TEXT = new ClassBuilderFactory(){

        @Override
        public ClassBuilder newClassBuilder() {
            return new ClassBuilder.Concrete((ClassVisitor)new TraceClassVisitor(new PrintWriter(new StringWriter())), false);
        }

        @Override
        public String asText(ClassBuilder builder) {
            TraceClassVisitor visitor = (TraceClassVisitor)builder.getVisitor();
            StringWriter writer = new StringWriter();
            visitor.print(new PrintWriter(writer));
            return writer.toString();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            throw new UnsupportedOperationException("TEXT generator asked for bytes");
        }
    };

    public static ClassBuilderFactory binaries(final boolean stubs) {
        return new ClassBuilderFactory(){

            @Override
            public ClassBuilder newClassBuilder() {
                return new ClassBuilder.Concrete((ClassVisitor)new ClassWriter(3){

                    protected String getCommonSuperClass(String type1, String type2) {
                        try {
                            return super.getCommonSuperClass(type1, type2);
                        }
                        catch (Throwable t) {
                            return "java/lang/Object";
                        }
                    }
                }, stubs);
            }

            @Override
            public String asText(ClassBuilder builder) {
                throw new UnsupportedOperationException("BINARIES generator asked for text");
            }

            @Override
            public byte[] asBytes(ClassBuilder builder) {
                ClassWriter visitor = (ClassWriter)builder.getVisitor();
                return visitor.toByteArray();
            }
        };
    }
}

