/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.CodeChunk;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.InstructionAdapter;

public abstract class ClassBodyCodegen {
    protected final GenerationState state;
    protected final JetClassOrObject myClass;
    protected final OwnerKind kind;
    protected final ClassDescriptor descriptor;
    protected final ClassBuilder v;
    protected final CodegenContext context;
    protected final List<CodeChunk> staticInitializerChunks = new ArrayList<CodeChunk>();

    public ClassBodyCodegen(JetClassOrObject aClass, CodegenContext context, ClassBuilder v, GenerationState state) {
        this.state = state;
        this.descriptor = state.getBindingContext().get(BindingContext.CLASS, aClass);
        this.myClass = aClass;
        this.context = context;
        this.kind = context.getContextKind();
        this.v = v;
    }

    public final void generate() {
        this.generateDeclaration();
        this.generateClassBody();
        this.generateSyntheticParts();
        this.generateStaticInitializer();
    }

    protected abstract void generateDeclaration();

    protected void generateSyntheticParts() {
    }

    private void generateClassBody() {
        FunctionCodegen functionCodegen = new FunctionCodegen(this.context, this.v, this.state);
        PropertyCodegen propertyCodegen = new PropertyCodegen(this.context, this.v, functionCodegen, this.state);
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            this.generateDeclaration(propertyCodegen, declaration, functionCodegen);
        }
        this.generatePrimaryConstructorProperties(propertyCodegen, this.myClass);
    }

    protected void generateDeclaration(PropertyCodegen propertyCodegen, JetDeclaration declaration, FunctionCodegen functionCodegen) {
        if (declaration instanceof JetProperty) {
            propertyCodegen.gen((JetProperty)declaration);
        } else if (declaration instanceof JetNamedFunction) {
            try {
                this.genNamedFunction((JetNamedFunction)declaration, functionCodegen);
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating method " + this.myClass.getName() + "." + declaration.getName() + " in " + this.context, e);
            }
        }
    }

    protected void genNamedFunction(JetNamedFunction declaration, FunctionCodegen functionCodegen) {
        functionCodegen.gen(declaration);
    }

    private void generatePrimaryConstructorProperties(PropertyCodegen propertyCodegen, PsiElement origin) {
        OwnerKind kind = this.context.getContextKind();
        for (JetParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (p.getValOrVarNode() == null || (propertyDescriptor = this.state.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            propertyCodegen.generateDefaultGetter(propertyDescriptor, 1, p);
            if (propertyDescriptor.isVar()) {
                propertyCodegen.generateDefaultSetter(propertyDescriptor, 1, origin);
            }
            if (kind instanceof OwnerKind.DelegateKind || !this.state.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor).booleanValue()) continue;
            int modifiers = JetTypeMapper.getAccessModifiers(propertyDescriptor, 0);
            if (!propertyDescriptor.isVar()) {
                modifiers |= 0x10;
            }
            if (this.state.getStandardLibrary().isVolatile(propertyDescriptor)) {
                modifiers |= 0x40;
            }
            this.v.newField(p, modifiers, p.getName(), this.state.getTypeMapper().mapType(propertyDescriptor.getType()).getDescriptor(), null, null);
        }
    }

    protected List<JetParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof JetClass) {
            return ((JetClass)this.myClass).getPrimaryConstructorParameters();
        }
        return Collections.emptyList();
    }

    private void generateStaticInitializer() {
        if (this.staticInitializerChunks.size() > 0) {
            MethodVisitor mv = this.v.newMethod(null, 9, "<clinit>", "()V", null, null);
            if (this.v.generateCode() == ClassBuilder.Mode.FULL) {
                mv.visitCode();
                InstructionAdapter v = new InstructionAdapter(mv);
                for (CodeChunk chunk : this.staticInitializerChunks) {
                    chunk.generate(v);
                }
                mv.visitInsn(177);
                FunctionCodegen.endVisit((MethodVisitor)v, "static initializer", this.myClass);
            }
        }
    }
}

