/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.Callable;
import org.jetbrains.jet.codegen.JvmMethodSignature;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class CallableMethod
implements Callable {
    @NotNull
    private final String owner;
    @NotNull
    private final String defaultImplOwner;
    @NotNull
    private final String defaultImplParam;
    private final JvmMethodSignature signature;
    private final int invokeOpcode;
    private ClassDescriptor thisClass = null;
    private CallableDescriptor receiverFunction = null;
    private Type generateCalleeType = null;

    public CallableMethod(@NotNull String owner, @NotNull String defaultImplOwner, @NotNull String defaultImplParam, JvmMethodSignature signature, int invokeOpcode) {
        this.owner = owner;
        this.defaultImplOwner = defaultImplOwner;
        this.defaultImplParam = defaultImplParam;
        this.signature = signature;
        this.invokeOpcode = invokeOpcode;
    }

    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @NotNull
    public String getDefaultImplParam() {
        return this.defaultImplParam;
    }

    public JvmMethodSignature getSignature() {
        return this.signature;
    }

    public int getInvokeOpcode() {
        return this.invokeOpcode;
    }

    public List<Type> getValueParameterTypes() {
        return this.signature.getValueParameterTypes();
    }

    public void setNeedsReceiver(@Nullable CallableDescriptor receiverClass) {
        this.receiverFunction = receiverClass;
    }

    public JetType getThisType() {
        return this.thisClass.getDefaultType();
    }

    public JetType getReceiverClass() {
        return this.receiverFunction.getReceiverParameter().getType();
    }

    public void setNeedsThis(@Nullable ClassDescriptor receiverClass) {
        this.thisClass = receiverClass;
    }

    void invoke(InstructionAdapter v) {
        v.visitMethodInsn(this.getInvokeOpcode(), this.owner, this.getSignature().getAsmMethod().getName(), this.getSignature().getAsmMethod().getDescriptor());
    }

    public void requestGenerateCallee(Type objectType) {
        this.generateCalleeType = objectType;
    }

    public Type getGenerateCalleeType() {
        return this.generateCalleeType;
    }

    public void invokeWithDefault(InstructionAdapter v, int mask) {
        if (this.defaultImplOwner.length() == 0 || this.defaultImplParam.length() == 0) {
            throw new IllegalStateException();
        }
        v.iconst(mask);
        String desc = this.getSignature().getAsmMethod().getDescriptor().replace(")", "I)");
        if ("<init>".equals(this.getSignature().getAsmMethod().getName())) {
            v.visitMethodInsn(183, this.defaultImplOwner, "<init>", desc);
        } else {
            if (this.getInvokeOpcode() != 184) {
                desc = desc.replace("(", "(L" + this.defaultImplParam + ";");
            }
            v.visitMethodInsn(184, this.defaultImplOwner, this.getSignature().getAsmMethod().getName() + "$default", desc);
        }
    }

    public boolean isNeedsThis() {
        return this.thisClass != null && this.generateCalleeType == null;
    }

    public boolean isNeedsReceiver() {
        return this.receiverFunction != null;
    }
}

