/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.JvmMethodSignature;
import org.jetbrains.jet.lang.resolve.java.JetSignatureUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.rt.signature.JetSignatureAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureReader;
import org.jetbrains.jet.rt.signature.JetSignatureVariance;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;
import org.jetbrains.jet.rt.signature.JetSignatureWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.util.CheckSignatureAdapter;

public class BothSignatureWriter {
    private static final boolean DEBUG_SIGNATURE_WRITER = true;
    private final SignatureWriter signatureWriter = new SignatureWriter();
    private final SignatureVisitor signatureVisitor;
    private JetSignatureWriter jetSignatureWriter;
    private String kotlinClassParameters;
    private String kotlinClassSignature;
    private List<JvmMethodParameterSignature> kotlinParameterTypes = new ArrayList<JvmMethodParameterSignature>();
    private String kotlinReturnType;
    private int jvmCurrentTypeArrayLevel;
    private Type jvmCurrentType;
    private Type jvmReturnType;
    private JvmMethodParameterKind currentParameterKind;
    private final Mode mode;
    private final boolean needGenerics;
    private State state = State.START;
    private boolean generic = false;
    private Stack<SignatureVisitor> visitors = new Stack();

    public BothSignatureWriter(Mode mode, boolean needGenerics) {
        this.mode = mode;
        this.needGenerics = needGenerics;
        this.signatureVisitor = new CheckSignatureAdapter(mode.asmType, (SignatureVisitor)this.signatureWriter);
    }

    private void push(SignatureVisitor visitor) {
        this.visitors.push(visitor);
    }

    private void pop() {
        this.visitors.pop();
    }

    private SignatureVisitor signatureVisitor() {
        return !this.visitors.isEmpty() ? this.visitors.peek() : this.signatureVisitor;
    }

    private void checkTopLevel() {
        if (!this.visitors.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    private void checkMode(Mode mode) {
        if (mode != this.mode) {
            throw new IllegalStateException();
        }
    }

    private void checkState(State state) {
        if (state != this.state) {
            throw new IllegalStateException();
        }
        if (this.jetSignatureWriter != null) {
            throw new IllegalStateException();
        }
        this.checkTopLevel();
    }

    private void transitionState(State from, State to) {
        this.checkState(from);
        this.state = to;
    }

    public void writeAsmType(Type asmType, boolean nullable) {
        switch (asmType.getSort()) {
            case 10: {
                this.writeClassBegin(asmType.getInternalName(), nullable, false);
                this.writeClassEnd();
                return;
            }
            case 9: {
                this.writeArrayType(nullable);
                this.writeAsmType(asmType.getElementType(), false);
                this.writeArrayEnd();
                return;
            }
        }
        String descriptor = asmType.getDescriptor();
        if (descriptor.length() != 1) {
            throw new IllegalStateException();
        }
        this.writeBaseType(descriptor.charAt(0), nullable);
    }

    private void writeBaseType(char c, boolean nullable) {
        if (nullable) {
            throw new IllegalStateException();
        }
        this.signatureVisitor().visitBaseType(c);
        this.jetSignatureWriter.visitBaseType(c, nullable);
        this.writeAsmType0(Type.getType((String)String.valueOf(c)));
    }

    public void writeNothing(boolean nullable) {
        if (nullable) {
            this.signatureVisitor().visitClassType("java/lang/Object");
            this.signatureVisitor().visitEnd();
        } else {
            this.signatureVisitor().visitBaseType('V');
        }
        this.jetSignatureWriter.visitClassType("jet/Nothing", nullable, false);
        this.jetSignatureWriter.visitEnd();
        if (nullable) {
            this.writeAsmType0(JetTypeMapper.TYPE_OBJECT);
        } else {
            this.writeAsmType0(Type.VOID_TYPE);
        }
    }

    private String makeArrayPrefix() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.jvmCurrentTypeArrayLevel; ++i) {
            sb.append('[');
        }
        return sb.toString();
    }

    private void writeAsmType0(Type type) {
        if (this.jvmCurrentType == null) {
            this.jvmCurrentType = Type.getType((String)(this.makeArrayPrefix() + type.getDescriptor()));
        }
    }

    public void writeClassBegin(String internalName, boolean nullable, boolean real) {
        this.signatureVisitor().visitClassType(internalName);
        this.jetSignatureWriter.visitClassType(internalName, nullable, real);
        this.writeAsmType0(Type.getObjectType((String)internalName));
    }

    public void writeClassEnd() {
        this.signatureVisitor().visitEnd();
        this.jetSignatureWriter.visitEnd();
    }

    public void writeArrayType(boolean nullable) {
        this.push(this.signatureVisitor().visitArrayType());
        this.jetSignatureWriter.visitArrayType(nullable);
        if (this.jvmCurrentType == null) {
            ++this.jvmCurrentTypeArrayLevel;
        }
    }

    public void writeArrayEnd() {
        this.pop();
    }

    private static JetSignatureVariance toJetSignatureVariance(Variance variance) {
        switch (variance) {
            case INVARIANT: {
                return JetSignatureVariance.INVARIANT;
            }
            case IN_VARIANCE: {
                return JetSignatureVariance.IN;
            }
            case OUT_VARIANCE: {
                return JetSignatureVariance.OUT;
            }
        }
        throw new IllegalStateException();
    }

    public void writeTypeArgument(Variance variance) {
        JetSignatureVariance jsVariance = BothSignatureWriter.toJetSignatureVariance(variance);
        this.push(this.signatureVisitor().visitTypeArgument(jsVariance.getC()));
        this.jetSignatureWriter.visitTypeArgument(jsVariance);
        this.generic = true;
    }

    public void writeTypeArgumentEnd() {
        this.pop();
    }

    public void writeTypeVariable(String name, boolean nullable, Type asmType) {
        this.signatureVisitor().visitTypeVariable(name);
        this.jetSignatureWriter.visitTypeVariable(name, nullable);
        this.generic = true;
        this.writeAsmType0(asmType);
    }

    public void writeFormalTypeParameter(String name, Variance variance, boolean reified) {
        this.checkTopLevel();
        this.signatureVisitor().visitFormalTypeParameter(name);
        this.jetSignatureWriter.visitFormalTypeParameter(name, JetSignatureUtils.translateVariance(variance), reified);
        this.generic = true;
    }

    public void writeFormalTypeParameterEnd() {
        this.jetSignatureWriter.visitFormalTypeParameterEnd();
    }

    public void writeFormalTypeParametersStart() {
        this.checkTopLevel();
        this.transitionState(State.START, State.TYPE_PARAMETERS);
        this.jetSignatureWriter = new JetSignatureWriter();
    }

    public void writeFormalTypeParametersEnd() {
        this.jetSignatureWriter.visitSuperclass();
        this.kotlinClassParameters = this.jetSignatureWriter.toString();
        this.jetSignatureWriter = null;
        new JetSignatureReader(this.kotlinClassParameters).acceptFormalTypeParametersOnly((JetSignatureVisitor)new JetSignatureAdapter());
        this.checkState(State.TYPE_PARAMETERS);
    }

    public void writeClassBound() {
        this.push(this.signatureVisitor().visitClassBound());
        this.jetSignatureWriter.visitClassBound();
    }

    public void writeClassBoundEnd() {
        this.pop();
    }

    public void writeInterfaceBound() {
        this.push(this.signatureVisitor().visitInterfaceBound());
        this.jetSignatureWriter.visitInterfaceBound();
    }

    public void writeInterfaceBoundEnd() {
        this.pop();
    }

    public void writeParametersStart() {
        this.transitionState(State.TYPE_PARAMETERS, State.PARAMETERS);
        this.jvmCurrentType = null;
        this.jvmCurrentTypeArrayLevel = 0;
    }

    public void writeParametersEnd() {
        this.checkState(State.PARAMETERS);
    }

    public void writeParameterType(JvmMethodParameterKind parameterKind) {
        this.transitionState(State.PARAMETERS, State.PARAMETER);
        this.push(this.signatureVisitor().visitParameterType());
        this.jetSignatureWriter = new JetSignatureWriter();
        if (this.jvmCurrentType != null || this.jvmCurrentTypeArrayLevel != 0) {
            throw new IllegalStateException();
        }
        if (this.currentParameterKind != null) {
            throw new IllegalStateException();
        }
        this.currentParameterKind = parameterKind;
    }

    public void writeParameterTypeEnd() {
        this.pop();
        if (this.jvmCurrentType == null) {
            throw new IllegalStateException();
        }
        String signature = this.jetSignatureWriter.toString();
        this.kotlinParameterTypes.add(new JvmMethodParameterSignature(this.jvmCurrentType, signature, this.currentParameterKind));
        new JetSignatureReader(signature).acceptTypeOnly((JetSignatureVisitor)new JetSignatureAdapter());
        this.currentParameterKind = null;
        this.jvmCurrentType = null;
        this.jvmCurrentTypeArrayLevel = 0;
        this.jetSignatureWriter = null;
        this.transitionState(State.PARAMETER, State.PARAMETERS);
    }

    public void writeReturnType() {
        this.transitionState(State.PARAMETERS, State.RETURN_TYPE);
        this.jetSignatureWriter = new JetSignatureWriter();
        if (this.jvmCurrentType != null) {
            throw new IllegalStateException();
        }
        this.push(this.signatureVisitor().visitReturnType());
    }

    public void writeReturnTypeEnd() {
        this.pop();
        this.kotlinReturnType = this.jetSignatureWriter.toString();
        if (this.jvmCurrentType == null) {
            throw new IllegalStateException();
        }
        this.jvmReturnType = this.jvmCurrentType;
        this.jvmCurrentType = null;
        this.jvmCurrentTypeArrayLevel = 0;
        new JetSignatureReader(this.kotlinReturnType).acceptTypeOnly((JetSignatureVisitor)new JetSignatureAdapter());
        this.jetSignatureWriter = null;
        this.transitionState(State.RETURN_TYPE, State.METHOD_END);
    }

    public void writeVoidReturn() {
        this.writeReturnType();
        this.writeAsmType(Type.VOID_TYPE, false);
        this.writeReturnTypeEnd();
    }

    public void writeSupersStart() {
        this.transitionState(State.TYPE_PARAMETERS, State.SUPERS);
        this.jetSignatureWriter = new JetSignatureWriter();
    }

    public void writeSupersEnd() {
        this.kotlinClassSignature = this.jetSignatureWriter.toString();
        this.jetSignatureWriter = null;
        new JetSignatureReader(this.kotlinClassSignature).accept((JetSignatureVisitor)new JetSignatureAdapter());
        this.transitionState(State.SUPERS, State.CLASS_END);
    }

    public void writeSuperclass() {
        this.push(this.signatureVisitor().visitSuperclass());
        this.jetSignatureWriter.visitSuperclass();
    }

    public void writeSuperclassEnd() {
        this.pop();
        if (!this.visitors.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    public void writeInterface() {
        this.checkTopLevel();
        this.checkMode(Mode.CLASS);
        this.push(this.signatureVisitor().visitInterface());
        this.jetSignatureWriter.visitInterface();
    }

    public void writeInterfaceEnd() {
        this.pop();
        if (!this.visitors.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    @NotNull
    public Method makeAsmMethod(String name) {
        ArrayList<Type> jvmParameterTypes = new ArrayList<Type>(this.kotlinParameterTypes.size());
        for (JvmMethodParameterSignature p : this.kotlinParameterTypes) {
            jvmParameterTypes.add(p.getAsmType());
        }
        return new Method(name, this.jvmReturnType, jvmParameterTypes.toArray(new Type[0]));
    }

    @Nullable
    public String makeJavaString() {
        if (this.state != State.METHOD_END && this.state != State.CLASS_END) {
            throw new IllegalStateException();
        }
        this.checkTopLevel();
        return this.generic ? this.signatureWriter.toString() : null;
    }

    @NotNull
    public List<JvmMethodParameterSignature> makeKotlinParameterTypes() {
        this.checkState(State.METHOD_END);
        return this.kotlinParameterTypes;
    }

    @NotNull
    public String makeKotlinReturnTypeSignature() {
        this.checkState(State.METHOD_END);
        return this.kotlinReturnType;
    }

    public String makeKotlinMethodTypeParameters() {
        this.checkState(State.METHOD_END);
        return this.kotlinClassParameters;
    }

    @Nullable
    public String makeKotlinClassSignature() {
        this.checkState(State.CLASS_END);
        if (this.kotlinClassParameters == null) {
            throw new IllegalStateException();
        }
        if (this.kotlinClassSignature == null) {
            throw new IllegalStateException();
        }
        return this.kotlinClassParameters + this.kotlinClassSignature;
    }

    @NotNull
    public JvmMethodSignature makeJvmMethodSignature(String name) {
        if (this.needGenerics) {
            return new JvmMethodSignature(this.makeAsmMethod(name), this.makeJavaString(), this.makeKotlinMethodTypeParameters(), this.makeKotlinParameterTypes(), this.makeKotlinReturnTypeSignature());
        }
        return new JvmMethodSignature(this.makeAsmMethod(name), this.makeKotlinParameterTypes());
    }

    private static enum State {
        START,
        TYPE_PARAMETERS,
        PARAMETERS,
        PARAMETER,
        RETURN_TYPE,
        METHOD_END,
        SUPERS,
        CLASS_END;

    }

    static enum Mode {
        METHOD(1),
        CLASS(0);

        private final int asmType;

        private Mode(int asmType) {
            this.asmType = asmType;
        }
    }
}

