/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class AnnotationCodegen {
    public void genAnnotations(Annotated annotated, JetTypeMapper typeMapper) {
        if (annotated == null) {
            return;
        }
        List<AnnotationDescriptor> annotations = annotated.getAnnotations();
        if (annotations == null) {
            return;
        }
        for (AnnotationDescriptor annotationDescriptor : annotations) {
            List<CompileTimeConstant<?>> valueArguments = annotationDescriptor.getValueArguments();
            JetType type = annotationDescriptor.getType();
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            RetentionPolicy rp = AnnotationCodegen.getRetentionPolicy(classifierDescriptor, typeMapper);
            if (rp == RetentionPolicy.SOURCE) continue;
            String internalName = typeMapper.mapType(type).getDescriptor();
            AnnotationVisitor annotationVisitor = this.visitAnnotation(internalName, rp == RetentionPolicy.RUNTIME);
            if (!valueArguments.isEmpty()) {
                if (valueArguments.size() == 1 && "Intrinsic".equals(annotationDescriptor.getType().getConstructor().getDeclarationDescriptor().getName())) {
                    annotationVisitor.visit("value", valueArguments.get(0).getValue());
                } else {
                    throw new UnsupportedOperationException("Only annotations without values are supported by backend so far");
                }
            }
            annotationVisitor.visitEnd();
        }
    }

    private static RetentionPolicy getRetentionPolicy(ClassifierDescriptor descriptor, JetTypeMapper typeMapper) {
        RetentionPolicy rp = RetentionPolicy.RUNTIME;
        return rp;
    }

    abstract AnnotationVisitor visitAnnotation(String var1, boolean var2);

    public static AnnotationCodegen forClass(final ClassVisitor cv) {
        return new AnnotationCodegen(){

            @Override
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return cv.visitAnnotation(descr, visible);
            }
        };
    }

    public static AnnotationCodegen forMethod(final MethodVisitor mv) {
        return new AnnotationCodegen(){

            @Override
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return mv.visitAnnotation(descr, visible);
            }
        };
    }

    public static AnnotationCodegen forField(final FieldVisitor mv) {
        return new AnnotationCodegen(){

            @Override
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return mv.visitAnnotation(descr, visible);
            }
        };
    }
}

